<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.2 & 7.3
 * @ Decoder version: 1.0.6
 * @ Release: 10/08/2022
 */

/**
 * Mustache Cache filesystem implementation.
 *
 * A FilesystemCache instance caches Mustache Template classes from the filesystem by name:
 *
 *     $cache = new Mustache_Cache_FilesystemCache(dirname(__FILE__).'/cache');
 *     $cache->cache($className, $compiledSource);
 *
 * The FilesystemCache benefits from any opcode caching that may be setup in your environment. So do that, k?
 */
class Mustache_Cache_FilesystemCache extends Mustache_Cache_AbstractCache
{
    private $baseDir = NULL;
    private $fileMode = NULL;
    public function __construct($baseDir, $fileMode = NULL)
    {
        $this->baseDir = $baseDir;
        $this->fileMode = $fileMode;
    }
    public function load($key)
    {
        $fileName = $this->getCacheFilename($key);
        if (!is_file($fileName)) {
            return false;
        }
        require_once $fileName;
        return true;
    }
    public function cache($key, $value)
    {
        $fileName = $this->getCacheFilename($key);
        $this->log(Mustache_Logger::DEBUG, "Writing to template cache: \"{fileName}\"", ["fileName" => $fileName]);
        $this->writeFile($fileName, $value);
        $this->load($key);
    }
    protected function getCacheFilename($name)
    {
        return sprintf("%s/%s.php", $this->baseDir, $name);
    }
    private function buildDirectoryForFilename($fileName)
    {
        $dirName = dirname($fileName);
        if (!is_dir($dirName)) {
            $this->log(Mustache_Logger::INFO, "Creating Mustache template cache directory: \"{dirName}\"", ["dirName" => $dirName]);
            @mkdir($dirName, 511, true);
            if (!is_dir($dirName)) {
                throw new Mustache_Exception_RuntimeException(sprintf("Failed to create cache directory \"%s\".", $dirName));
            }
        }
        return $dirName;
    }
    private function writeFile($fileName, $value)
    {
        $dirName = $this->buildDirectoryForFilename($fileName);
        $this->log(Mustache_Logger::DEBUG, "Caching compiled template to \"{fileName}\"", ["fileName" => $fileName]);
        $tempFile = tempnam($dirName, basename($fileName));
        if (false !== @file_put_contents($tempFile, $value)) {
            if (@rename($tempFile, $fileName)) {
                $mode = isset($this->fileMode) ? $this->fileMode : 438 & ~umask();
                @chmod($fileName, $mode);
                return NULL;
            }
            $this->log(Mustache_Logger::ERROR, "Unable to rename Mustache temp cache file: \"{tempName}\" -> \"{fileName}\"", ["tempName" => $tempFile, "fileName" => $fileName]);
        }
        throw new Mustache_Exception_RuntimeException(sprintf("Failed to write cache file \"%s\".", $fileName));
    }
}

?>