<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.2 & 7.3
 * @ Decoder version: 1.0.6
 * @ Release: 10/08/2022
 */

$separator = "-";
echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\" dir=\"ltr\">\n<head>\n<title>Calendar - Set Date/Time</title>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />        \n<style>\nbody {font-size: 11px;}\ntable {font-size: 11px;}\ntd {font-size: 11px;}\na {display:block;  width:15px; background: transparent; color: #72705b; text-decoration: none; }\na:hover {display:block; width:15px; background: #ffcc33; color: #000000; text-decoration: none;  font-weight: bold;}\na.bottom {display:block;  width:24px; height:14px; background: transparent; color: #72705b; text-decoration: none; }\na.bottom:hover {display:block; width:24px; height:14px; background: #ffcc33; color: #000000; text-decoration: none;  font-weight: bold;}\n.selected {display:block; width:24px; background: #ff8822; font-color: #ffcc33; }\n.calendar {padding:0px; margin:0px;}\n</style>\n\n<script type=\"text/javascript\" language=\"javascript\">\n\n/**\n * Last modofied: 26/10/2007\n * Modify from controls when the \"NULL\" checkbox is selected\n *\n * @param   string   the MySQL field type\n * @param   string   the urlencoded field name\n * @param   string   the md5 hashed field name\n * @return  boolean  always true\n */\nfunction nullify(theType, urlField, md5Field, multi_edit)\n{\n    var rowForm = document.forms['insertForm'];\n\n    if (typeof(rowForm.elements['funcs' + multi_edit + '[' + urlField + ']']) != 'undefined') {\n        rowForm.elements['funcs' + multi_edit + '[' + urlField + ']'].selectedIndex = -1;\n    }\n\n    // \"SET\" field , \"ENUM\" field with more than 20 characters\n    // or foreign key field\n    if (theType == 1 || theType == 3 || theType == 4) {\n        rowForm.elements['field_' + md5Field + multi_edit + '[]'].selectedIndex = -1;\n    }\n    // Other \"ENUM\" field\n    else if (theType == 2) {\n        var elts     = rowForm.elements['field_' + md5Field + multi_edit + '[]'];\n        // when there is just one option in ENUM:\n        if (elts.checked) {\n            elts.checked = false;\n        } else {\n            var elts_cnt = elts.length;\n            for (var i = 0; i < elts_cnt; i++ ) {\n                elts[i].checked = false;\n            } // end for\n\n        } // end if\n    }\n    // Other field types\n    else /*if (theType == 5)*/ {\n        rowForm.elements['fields' + multi_edit + '[' + urlField + ']'].value = '';\n    } // end if... else if... else\n\n    return true;\n} // end of the 'nullify()' function\n\n\n/**\n * Unchecks the \"NULL\" control when a function has been selected or a value\n * entered\n *\n * @param   string   the urlencoded field name\n *\n * @return  boolean  always true\n */\nfunction unNullify(urlField, multi_edit)\n{\n    var rowForm = document.forms['insertForm'];\n\n    if (typeof(rowForm.elements['fields_null[multi_edit][' + multi_edit + '][' + urlField + ']']) != 'undefined') {\n        rowForm.elements['fields_null[multi_edit][' + multi_edit + '][' + urlField + ']'].checked = false\n    } // end if\n\n    if (typeof(rowForm.elements['insert_ignore_' + multi_edit]) != 'undefined') {\n        rowForm.elements['insert_ignore_' + multi_edit].checked = false\n    } // end if\n\n    return true;\n} // end of the 'unNullify()' function\n\nvar day;\nvar month;\nvar year;\nvar hour;\nvar minute;\nvar second;\nvar clock_set = 0;\n\n\n/**\n * Formats number to two digits.\n *\n * @param   int number to format.\n * @param   string type of number\n */\nfunction formatNum2(i, valtype) {\n    f = (i < 10 ? '0' : '') + i;\n    if (valtype && valtype != '') {\n        switch(valtype) {\n            case 'month':\n                f = (f > 12 ? 12 : f);\n                break;\n\n            case 'day':\n                f = (f > 31 ? 31 : f);\n                break;\n\n            case 'hour':\n                f = (f > 24 ? 24 : f);\n                break;\n\n            default:\n            case 'second':\n            case 'minute':\n                f = (f > 59 ? 59 : f);\n                break;\n        }\n    }\n\n    return f;\n}\n\n/**\n * Formats number to two digits.\n *\n * @param   int number to format.\n * @param   int default value\n * @param   string type of number\n */\nfunction formatNum2d(i, default_v, valtype) {\n    i = parseInt(i, 10);\n    if (isNaN(i)) return default_v;\n    return formatNum2(i, valtype)\n}\n\n/**\n * Formats number to four digits.\n *\n * @param   int number to format.\n */\nfunction formatNum4(i) {\n    i = parseInt(i, 10)\n    return (i < 1000 ? i < 100 ? i < 10 ? '000' : '00' : '0' : '') + i;\n}\n\n/**\n * Initializes calendar window.\n */\nfunction initCalendar() {\n\n    if (!year && !month && !day) {\n        /* Called for first time */\n        if (window.opener.dateField && window.opener.dateField.value) {\n            value = window.opener.dateField.value;\n            if (window.opener.dateType == 'datetimedmy' || window.opener.dateType == 'datetime'\n                || window.opener.dateType == 'date'     || window.opener.dateType == 'datedmy'\n                || window.opener.dateType == 'datemdy'){\n\n                if(window.opener.dateType == 'datetime' || window.opener.dateType == 'datetimedmy'){\n                    parts   = value.split(' ');\n                    value   = parts[0];\n                    if (parts[1]) {\n                        time    = parts[1].split(':');\n                        hour    = parseInt(time[0],10);\n                        minute  = parseInt(time[1],10);\n                        second  = parseInt(time[2],10);\n                    }\n                }\n                if(window.opener.dateType == 'datedmy' || window.opener.dateType == 'datetimedmy'){\n                    date        = value.split(\"";
echo $separator;
echo "\");\n                    day         = parseInt(date[0],10);\n                    month       = parseInt(date[1],10) - 1;\n                    year        = parseInt(date[2],10);\n                }else if(window.opener.dateType == 'datemdy'){\n                    date        = value.explode(\"";
echo $separator;
echo "\");\n                    day         = parseInt(date[1],10);\n                    month       = parseInt(date[0],10) - 1;\n                    year        = parseInt(date[2],10);\n                }else{\n                    date        = value.split(\"";
echo $separator;
echo "\");\n                    day         = parseInt(date[2],10);\n                    month       = parseInt(date[1],10) - 1;\n                    year        = parseInt(date[0],10);\n                }\n            }else if (window.opener.dateType == 'time'){\n                hour        = parseInt(value.substr(0,2),10);\n                minute      = parseInt(value.substr(3,2),10);\n                second      = parseInt(value.substr(6,2),10);\n            }else{\n                if(window.opener.dateType == 'datedmy' || window.opener.dateType == 'datetimedmy'){\n                    year        = parseInt(value.substr(4,4),10);\n                    month       = parseInt(value.substr(1,2),10) - 1;\n                    day         = parseInt(value.substr(0,2),10);\n                    hour        = parseInt(value.substr(8,2),10);\n                    minute      = parseInt(value.substr(10,2),10);\n                    second      = parseInt(value.substr(12,2),10);\n                }else{\n                    year        = parseInt(value.substr(0,4),10);\n                    month       = parseInt(value.substr(4,2),10) - 1;\n                    day         = parseInt(value.substr(6,2),10);\n                    hour        = parseInt(value.substr(8,2),10);\n                    minute      = parseInt(value.substr(10,2),10);\n                    second      = parseInt(value.substr(12,2),10);\n                }\n            }\n        }\n        if(isNaN(year) || isNaN(month) || isNaN(day) || day == 0){\n            dt      = new Date();\n            year    = dt.getFullYear();\n            month   = dt.getMonth();\n            day     = dt.getDate();\n        }\n        if(isNaN(hour) || isNaN(minute) || isNaN(second)){\n            dt      = new Date();\n            hour    = dt.getHours();\n            minute  = dt.getMinutes();\n            second  = dt.getSeconds();\n        }\n    }else{\n        /* Moving in calendar */\n        if(month > 11){\n            month = 0;\n            year++;\n        }\n        if(month < 0){\n            month = 11;\n            year--;\n        }\n    }\n\n    if(document.getElementById){\n        cnt = document.getElementById(\"calendar_data\");\n    }else if (document.all){\n        cnt = document.all[\"calendar_data\"];\n    }\n\n    cnt.innerHTML = \"\";\n\n    str = \"\"\n\n    //heading table\n    str += '<form method=\"NONE\" onsubmit=\"return 0\">';\n    str += '<table class=\"calendar\" align=\"center\" border=0><tr><th>';\n    str += '<a href=\"javascript:month--; initCalendar();\">&laquo;</a></th><th>';\n    str += '<select id=\"select_month\" name=\"monthsel\" onchange=\"month = parseInt(document.getElementById(\\'select_month\\').value); initCalendar();\">';\n    for (i =0; i < 12; i++) {\n        if (i == month) selected = ' selected=\"selected\"';\n        else selected = '';\n        str += '<option value=\"' + i + '\" ' + selected + '>' + month_names[i] + '</option>';\n    }\n    str += '</select></th><th valign=\"center\">';\n    str += '<a href=\"javascript:month++; initCalendar();\">&raquo;</a>';\n    str += '</th><th>';\n    str += '<a href=\"javascript:year--; initCalendar();\">&laquo;</a></th><th>';\n    str += '<select id=\"select_year\" name=\"yearsel\" onchange=\"year = parseInt(document.getElementById(\\'select_year\\').value); initCalendar();\">';\n    for (i = year - 65; i < year + 25; i++) {\n        if (i == year) selected = ' selected=\"selected\"';\n        else selected = '';\n        str += '<option value=\"' + i + '\" ' + selected + '>' + i + '</option>';\n    }\n    str += '</select></th><th>';\n    str += '<a href=\"javascript:year++; initCalendar();\">&raquo;</a>';\n    str += '</th></tr></table>';\n    str += '</form>';\n\n    str += '<table class=\"calendar\" border=\"0\" align=\"center\"><tr>';\n    for (i = 0; i < 7; i++) {\n        str += \"<th>\" + day_names[i] + \"</th>\";\n    }\n    str += \"</tr>\";\n\n    var firstDay = new Date(year, month, 1).getDay();\n    var lastDay = new Date(year, month + 1, 0).getDate();\n\n    str += \"<tr>\";\n\n    dayInWeek = 0;\n    for (i = 0; i < firstDay; i++) {\n        str += \"<td>&nbsp;</td>\";\n        dayInWeek++;\n    }\n\n\n    for (i = 1; i <= lastDay; i++) {\n        if (dayInWeek == 7) {\n            str += \"</tr><tr>\";\n            dayInWeek = 0;\n        }\n\n        dispmonth = 1 + month;\n        \n        if (window.opener.dateType == 'datetimedmy' || window.opener.dateType == 'datetime' || window.opener.dateType == 'date' || window.opener.dateType == 'datedmy' || window.opener.dateType == 'datemdy') {\n            if (window.opener.dateType == 'datedmy' || window.opener.dateType == 'datetimedmy') {\n                actVal = \"\" + formatNum2(i, 'day') + \"";
echo $separator;
echo "\" + formatNum2(dispmonth, 'month') + \"";
echo $separator;
echo "\" + formatNum4(year);\n            }else if (window.opener.dateType == 'datemdy') {\n                actVal = \"\" + formatNum2(dispmonth, 'month') + \"";
echo $separator;
echo "\" + formatNum2(i, 'day') + \"";
echo $separator;
echo "\" + formatNum4(year);\n            }else{\n                actVal = \"\" + formatNum4(year) + \"";
echo $separator;
echo "\" + formatNum2(dispmonth, 'month') + \"";
echo $separator;
echo "\" + formatNum2(i, 'day');\n            }        \n        }else{\n            if(window.opener.dateType == 'datedmy' || window.opener.dateType == 'datetimedmy') {\n                actVal = \"\" + formatNum2(i, 'day') + formatNum2(dispmonth, 'month') + formatNum4(year);\n            }else{\n                actVal = \"\" + formatNum4(year) + formatNum2(dispmonth, 'month') + formatNum2(i, 'day');\n            }\n        }\n\n        if (i == day) {\n            style = ' class=\"selected\"';\n            current_date = actVal;\n        } else {\n            style = '';\n        }\n        str += \"<td\" + style + \" align='center'><a class='bottom' href=\\\"javascript:returnDate('\" + actVal + \"');\\\">\" + i + \"</a></td>\"\n        dayInWeek++;\n    }\n    for (i = dayInWeek; i < 7; i++) {\n        str += \"<td>&nbsp;</td>\";\n    }\n\n    str += \"</tr></table>\";\n\n    if (window.opener.dateType != 'time') {\n        cnt.innerHTML = str;\n    }\n\n    // Should we handle time also?\n    if ((window.opener.dateType != 'datemdy' && window.opener.dateType != 'date' && window.opener.dateType != 'datedmy') && !clock_set) {\n\n        if (document.getElementById) {\n            cnt = document.getElementById(\"clock_data\");\n        } else if (document.all) {\n            cnt = document.all[\"clock_data\"];\n        }\n\n        str = '';\n        init_hour = hour;\n        init_minute = minute;\n        init_second = second;\n        str += '<form method=\"NONE\" class=\"clock\" onsubmit=\"returnDate(\\'' + current_date + '\\')\">';\n        str += '<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>';\n        str += '<td valign=\"middle\"><input id=\"hour\"    type=\"text\" size=\"2\" maxlength=\"2\" title=\"hour\" onblur=\"this.value=formatNum2d(this.value, init_hour, \\'hour\\'); init_hour = this.value;\" value=\"' + formatNum2(hour, 'hour') + '\" /></td><td valign=\"middle\">&nbsp;:&nbsp;</td>';\n        str += '<td valign=\"middle\"><input id=\"minute\"  type=\"text\" size=\"2\" maxlength=\"2\" title=\"minute\" onblur=\"this.value=formatNum2d(this.value, init_minute, \\'minute\\'); init_minute = this.value;\" value=\"' + formatNum2(minute, 'minute') + '\" /></td><td valign=\"middle\">&nbsp;:&nbsp;</td>';\n        str += '<td valign=\"middle\"><input id=\"second\"  type=\"text\" size=\"2\" maxlength=\"2\" title=\"second\" onblur=\"this.value=formatNum2d(this.value, init_second, \\'second\\'); init_second = this.value;\" value=\"' + formatNum2(second, 'second') + '\" /></td><td valign=\"middle\">&nbsp;</td>';\n        str += '<td valign=\"middle\"><input type=\"submit\" value=\"' + submit_text + '\"/></td>';\n        str += '</tr></table>';\n        str += '</form>';        \n\n        cnt.innerHTML = str;\n        clock_set = 1;\n    }\n\n}\n\n/** Returns date from calendar.  @param   string     date text */\nfunction returnDate(d) {\n    txt = d;\n    if (window.opener.dateType != 'date' && window.opener.dateType != 'datedmy' && window.opener.dateType != 'datemdy') {\n\n        // need to get time\n        h = parseInt(document.getElementById('hour').value,10);\n        m = parseInt(document.getElementById('minute').value,10);\n        s = parseInt(document.getElementById('second').value,10);\n        if (window.opener.dateType == 'datetime' || window.opener.dateType == 'datetimedmy') {\n            txt += ' ' + formatNum2(h, 'hour') + ':' + formatNum2(m, 'minute') + ':' + formatNum2(s, 'second');\n        } else if (window.opener.dateType == 'time') {\n            txt = formatNum2(h, 'hour') + ':' + formatNum2(m, 'minute') + ':' + formatNum2(s, 'second');\n        } else {\n            // timestamp\n            txt += formatNum2(h, 'hour') + formatNum2(m, 'minute') + formatNum2(s, 'second');\n        }\n    }\n    if(window.opener.dateField) window.opener.dateField.value = txt;\n    window.close();\n}\n\n</script>\n<script type=\"text/javascript\" language=\"javascript\">\n//<![CDATA[\n\nvar month_names = new Array(\"Jan\",\"Feb\",\"Mar\",\"Apr\",\"May\",\"Jun\",\"Jul\",\"Aug\",\"Sep\",\"Oct\",\"Nov\",\"Dec\");\nvar day_names = new Array(\"Sun\",\"Mon\",\"Tue\",\"Wed\",\"Thu\",\"Fri\",\"Sat\");\n//var month_names = new Array(\"Ene\",\"Feb\",\"Mar\",\"Abr\",\"May\",\"Jun\",\"Jul\",\"Ago\",\"Sep\",\"Oct\",\"Nov\",\"Dic\");\n//var day_names = new Array(\"Dom\",\"Lun\",\"Mar\",\"Mie\",\"Jue\",\"Vie\",\"Sab\");\nvar submit_text = \"OK\";\n\n\n//]]>\n</script>\n\n</head>\n<body onload=\"initCalendar();\">\n<div id=\"calendar_data\"></div>\n<div id=\"clock_data\"></div>\n</body>\n</html>\n";

?>