<?php

defined("DEFINE_MY_ACCESS") or die('<h1 style="color: #C00; text-align: center;"><strong>Restricted Access</strong></h1>');

function uddoktapay_config()
{
    $configarray = [
        'name' => [
            'Type' => 'System',
            'Value' => 'UddoktaPay',
        ],
        'api_key' => [
            'Name' => 'UddoktaPay API Key',
            'Type' => 'text',
            'Size' => '40',
        ],
        'api_url' => [
            'Name' => 'UddoktaPay API URL',
            'Type' => 'text',
            'Size' => '40',
        ],
        'exchange_rate' => [
            'Name' => 'Exchnage Rate',
            'Type' => 'text',
            'Size' => '40',
            'Description' => '1 USD = ? BDT',
        ],
    ];
    return $configarray;
}

function uddoktapay_link($params)
{
    global $lng_languag;

    $url = $params['systemurl'] . 'modules/gateways/callback/' . $params['paymentmethod'] . '.php';
    $invId = $params['invoiceid'];
    $payTxt = $lng_languag["invoicespaynow"];
    $errorMsg = uddoktapay_errormessage();

    return <<<HTML
    <form method="GET" action="$url">
    <input type="hidden" name="action" value="init" />
    <input type="hidden" name="id" value="$invId" />
    <input class="btn btn-primary" type="submit" value="$payTxt" />
</form>
$errorMsg
HTML;
}

function uddoktapay_errormessage()
{
    $errorMessage = [
        'cancelled' => 'Payment has cancelled',
        'sww' => 'Something went wrong',
    ];

    $code = isset($_REQUEST['errorCode']) ? $_REQUEST['errorCode'] : null;
    if (empty($code)) {
        return null;
    }

    $error = isset($errorMessage[$code]) ? $errorMessage[$code] : $code;

    return '<div class="text-danger" style="margin-top: 10px;" role="alert">' . $error . '</div>';
}
