<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.2 & 7.3
 * @ Decoder version: 1.0.6
 * @ Release: 10/08/2022
 */

define("K_PATH_MAIN", ROOTDIR . "/includes/");
define("K_PATH_FONTS", K_PATH_MAIN . "fonts/");
define("K_PATH_CACHE", K_PATH_MAIN . "cache/");
define("K_PATH_URL_CACHE", K_PATH_URL . "cache/");
define("K_PATH_IMAGES", K_PATH_MAIN . "images/");
define("K_BLANK_IMAGE", K_PATH_IMAGES . "_blank.png");
define("PDF_PAGE_FORMAT", "A4");
define("PDF_PAGE_ORIENTATION", "P");
define("PDF_HEADER_LOGO_WIDTH", 30);
define("PDF_UNIT", "mm");
define("PDF_MARGIN_HEADER", 5);
define("PDF_MARGIN_FOOTER", 10);
define("PDF_MARGIN_TOP", 27);
define("PDF_MARGIN_BOTTOM", 25);
define("PDF_MARGIN_LEFT", 15);
define("PDF_MARGIN_RIGHT", 15);
define("PDF_FONT_NAME_MAIN", "helvetica");
define("PDF_FONT_SIZE_MAIN", 10);
define("PDF_FONT_NAME_DATA", "helvetica");
define("PDF_FONT_SIZE_DATA", 8);
define("PDF_FONT_MONOSPACED", "courier");
define("PDF_IMAGE_SCALE_RATIO", 0);
define("HEAD_MAGNIFICATION", 0);
define("K_CELL_HEIGHT_RATIO", 0);
define("K_TITLE_MAGNIFICATION", 0);
define("K_SMALL_RATIO", 0);
require_once dirname(__FILE__) . "/unicode.php";
$webcolor = ["aliceblue" => "f0f8ff", "antiquewhite" => "faebd7", "aqua" => "00ffff", "aquamarine" => "7fffd4", "azure" => "f0ffff", "beige" => "f5f5dc", "bisque" => "ffe4c4", "black" => "000000", "blanchedalmond" => "ffebcd", "blue" => "0000ff", "blueviolet" => "8a2be2", "brown" => "a52a2a", "burlywood" => "deb887", "cadetblue" => "5f9ea0", "chartreuse" => "7fff00", "chocolate" => "d2691e", "coral" => "ff7f50", "cornflowerblue" => "6495ed", "cornsilk" => "fff8dc", "crimson" => "dc143c", "cyan" => "00ffff", "darkblue" => "00008b", "darkcyan" => "008b8b", "darkgoldenrod" => "b8860b", "darkgray" => "a9a9a9", "darkgrey" => "a9a9a9", "darkgreen" => "006400", "darkkhaki" => "bdb76b", "darkmagenta" => "8b008b", "darkolivegreen" => "556b2f", "darkorange" => "ff8c00", "darkorchid" => "9932cc", "darkred" => "8b0000", "darksalmon" => "e9967a", "darkseagreen" => "8fbc8f", "darkslateblue" => "483d8b", "darkslategray" => "2f4f4f", "darkslategrey" => "2f4f4f", "darkturquoise" => "00ced1", "darkviolet" => "9400d3", "deeppink" => "ff1493", "deepskyblue" => "00bfff", "dimgray" => "696969", "dimgrey" => "696969", "dodgerblue" => "1e90ff", "firebrick" => "b22222", "floralwhite" => "fffaf0", "forestgreen" => "228b22", "fuchsia" => "ff00ff", "gainsboro" => "dcdcdc", "ghostwhite" => "f8f8ff", "gold" => "ffd700", "goldenrod" => "daa520", "gray" => "808080", "grey" => "808080", "green" => "008000", "greenyellow" => "adff2f", "honeydew" => "f0fff0", "hotpink" => "ff69b4", "indianred " => "cd5c5c", "indigo " => "4b0082", "ivory" => "fffff0", "khaki" => "f0e68c", "lavender" => "e6e6fa", "lavenderblush" => "fff0f5", "lawngreen" => "7cfc00", "lemonchiffon" => "fffacd", "lightblue" => "add8e6", "lightcoral" => "f08080", "lightcyan" => "e0ffff", "lightgoldenrodyellow" => "fafad2", "lightgray" => "d3d3d3", "lightgrey" => "d3d3d3", "lightgreen" => "90ee90", "lightpink" => "ffb6c1", "lightsalmon" => "ffa07a", "lightseagreen" => "20b2aa", "lightskyblue" => "87cefa", "lightslategray" => "778899", "lightslategrey" => "778899", "lightsteelblue" => "b0c4de", "lightyellow" => "ffffe0", "lime" => "00ff00", "limegreen" => "32cd32", "linen" => "faf0e6", "magenta" => "ff00ff", "maroon" => "800000", "mediumaquamarine" => "66cdaa", "mediumblue" => "0000cd", "mediumorchid" => "ba55d3", "mediumpurple" => "9370d8", "mediumseagreen" => "3cb371", "mediumslateblue" => "7b68ee", "mediumspringgreen" => "00fa9a", "mediumturquoise" => "48d1cc", "mediumvioletred" => "c71585", "midnightblue" => "191970", "mintcream" => "f5fffa", "mistyrose" => "ffe4e1", "moccasin" => "ffe4b5", "navajowhite" => "ffdead", "navy" => "000080", "oldlace" => "fdf5e6", "olive" => "808000", "olivedrab" => "6b8e23", "orange" => "ffa500", "orangered" => "ff4500", "orchid" => "da70d6", "palegoldenrod" => "eee8aa", "palegreen" => "98fb98", "paleturquoise" => "afeeee", "palevioletred" => "d87093", "papayawhip" => "ffefd5", "peachpuff" => "ffdab9", "peru" => "cd853f", "pink" => "ffc0cb", "plum" => "dda0dd", "powderblue" => "b0e0e6", "purple" => "800080", "red" => "ff0000", "rosybrown" => "bc8f8f", "royalblue" => "4169e1", "saddlebrown" => "8b4513", "salmon" => "fa8072", "sandybrown" => "f4a460", "seagreen" => "2e8b57", "seashell" => "fff5ee", "sienna" => "a0522d", "silver" => "c0c0c0", "skyblue" => "87ceeb", "slateblue" => "6a5acd", "slategray" => "708090", "slategrey" => "708090", "snow" => "fffafa", "springgreen" => "00ff7f", "steelblue" => "4682b4", "tan" => "d2b48c", "teal" => "008080", "thistle" => "d8bfd8", "tomato" => "ff6347", "turquoise" => "40e0d0", "violet" => "ee82ee", "wheat" => "f5deb3", "white" => "ffffff", "whitesmoke" => "f5f5f5", "yellow" => "ffff00", "yellowgreen" => "9acd32"];
if (!class_exists("TCPDF")) {
    define("PDF_PRODUCER", "TCPDF 4.6.016_PHP4 (http://www.tcpdf.org)");
    /**
     * This is a PHP class for generating PDF documents without requiring external extensions.<br>
     * TCPDF project (http://www.tcpdf.org) has been originally derived in 2002 from the Public Domain FPDF class by Olivier Plathey (http://www.fpdf.org), but now is almost entirely rewritten.<br>
     * @name TCPDF
     * @package com.tecnick.tcpdf
     * @version 4.6.016_PHP4
     * @author Nicola Asuni - info@tecnick.com
     * @link http://www.tcpdf.org
     * @license http://www.gnu.org/copyleft/lesser.html LGPL
     */
    class TCPDF
    {
        /**
         * @var current page number
         * @access protected
         */
        public $page = NULL;
        /**
         * @var current object number
         * @access protected
         */
        public $n = NULL;
        /**
         * @var array of object offsets
         * @access protected
         */
        public $offsets = NULL;
        /**
         * @var buffer holding in-memory PDF
         * @access protected
         */
        public $buffer = NULL;
        /**
         * @var array containing pages
         * @access protected
         */
        public $pages = [];
        /**
         * @var current document state
         * @access protected
         */
        public $state = NULL;
        /**
         * @var compression flag
         * @access protected
         */
        public $compress = NULL;
        /**
         * @var current page orientation (P = Portrait, L = Landscape)
         * @access protected
         */
        public $CurOrientation = NULL;
        /**
         * @var array that stores page dimensions and graphic status.<ul><li>$this->pagedim[$this->page]['w'] => page_width_in_points</li><li>$this->pagedim[$this->page]['h'] => height in points</li><li>$this->pagedim[$this->page]['wk'] => page_width_in_points</li><li>$this->pagedim[$this->page]['hk'] => height</li><li>$this->pagedim[$this->page]['tm'] => top_margin</li><li>$this->pagedim[$this->page]['bm'] => bottom_margin</li><li>$this->pagedim[$this->page]['lm'] => left_margin</li><li>$this->pagedim[$this->page]['rm'] => right_margin</li><li>$this->pagedim[$this->page]['pb'] => auto_page_break</li><li>$this->pagedim[$this->page]['or'] => page_orientation</li><li>$this->pagedim[$this->page]['olm'] => original_left_margin</li><li>$this->pagedim[$this->page]['orm'] => original_right_margin</li></ul>
         * @access protected
         */
        public $pagedim = [];
        /**
         * @var scale factor (number of points in user unit)
         * @access protected
         */
        public $k = NULL;
        /**
         * @var width of page format in points
         * @access protected
         */
        public $fwPt = NULL;
        /**
         * @var height of page format in points
         * @access protected
         */
        public $fhPt = NULL;
        /**
         * @var current width of page in points
         * @access protected
         */
        public $wPt = NULL;
        /**
         * @var current height of page in points
         * @access protected
         */
        public $hPt = NULL;
        /**
         * @var current width of page in user unit
         * @access protected
         */
        public $w = NULL;
        /**
         * @var current height of page in user unit
         * @access protected
         */
        public $h = NULL;
        /**
         * @var left margin
         * @access protected
         */
        public $lMargin = NULL;
        /**
         * @var top margin
         * @access protected
         */
        public $tMargin = NULL;
        /**
         * @var right margin
         * @access protected
         */
        public $rMargin = NULL;
        /**
         * @var page break margin
         * @access protected
         */
        public $bMargin = NULL;
        /**
         * @var cell internal padding
         * @access protected
         */
        public $cMargin = NULL;
        /**
         * @var cell internal padding (previous value)
         * @access protected
         */
        public $oldcMargin = NULL;
        /**
         * @var current horizontal position in user unit for cell positioning
         * @access protected
         */
        public $x = NULL;
        /**
         * @var current vertical position in user unit for cell positioning
         * @access protected
         */
        public $y = NULL;
        /**
         * @var height of last cell printed
         * @access protected
         */
        public $lasth = NULL;
        /**
         * @var line width in user unit
         * @access protected
         */
        public $LineWidth = NULL;
        /**
         * @var array of standard font names
         * @access protected
         */
        public $CoreFonts = NULL;
        /**
         * @var array of used fonts
         * @access protected
         */
        public $fonts = [];
        /**
         * @var array of font files
         * @access protected
         */
        public $FontFiles = [];
        /**
         * @var array of encoding differences
         * @access protected
         */
        public $diffs = [];
        /**
         * @var array of used images
         * @access protected
         */
        public $images = [];
        /**
         * @var array of Annotations in pages
         * @access protected
         */
        public $PageAnnots = [];
        /**
         * @var array of internal links
         * @access protected
         */
        public $links = [];
        /**
         * @var current font family
         * @access protected
         */
        public $FontFamily = NULL;
        /**
         * @var current font style
         * @access protected
         */
        public $FontStyle = NULL;
        /**
         * @var current font ascent (distance between font top and baseline)
         * @access protected
         * @since 2.8.000 (2007-03-29)
         */
        public $FontAscent = NULL;
        /**
         * @var current font descent (distance between font bottom and baseline)
         * @access protected
         * @since 2.8.000 (2007-03-29)
         */
        public $FontDescent = NULL;
        /**
         * @var underlining flag
         * @access protected
         */
        public $underline = NULL;
        /**
         * @var current font info
         * @access protected
         */
        public $CurrentFont = NULL;
        /**
         * @var current font size in points
         * @access protected
         */
        public $FontSizePt = NULL;
        /**
         * @var current font size in user unit
         * @access protected
         */
        public $FontSize = NULL;
        /**
         * @var commands for drawing color
         * @access protected
         */
        public $DrawColor = NULL;
        /**
         * @var commands for filling color
         * @access protected
         */
        public $FillColor = NULL;
        /**
         * @var commands for text color
         * @access protected
         */
        public $TextColor = NULL;
        /**
         * @var indicates whether fill and text colors are different
         * @access protected
         */
        public $ColorFlag = NULL;
        /**
         * @var automatic page breaking
         * @access protected
         */
        public $AutoPageBreak = NULL;
        /**
         * @var threshold used to trigger page breaks
         * @access protected
         */
        public $PageBreakTrigger = NULL;
        /**
         * @var flag set when processing footer
         * @access protected
         */
        public $InFooter = false;
        /**
         * @var zoom display mode
         * @access protected
         */
        public $ZoomMode = NULL;
        /**
         * @var layout display mode
         * @access protected
         */
        public $LayoutMode = NULL;
        /**
         * @var title
         * @access protected
         */
        public $title = "";
        /**
         * @var subject
         * @access protected
         */
        public $subject = "";
        /**
         * @var author
         * @access protected
         */
        public $author = "";
        /**
         * @var keywords
         * @access protected
         */
        public $keywords = "";
        /**
         * @var creator
         * @access protected
         */
        public $creator = "";
        /**
         * @var alias for total number of pages
         * @access protected
         */
        public $AliasNbPages = "{nb}";
        /**
         * @var alias for page number
         * @access protected
         */
        public $AliasNumPage = "{pnb}";
        /**
         * @var right-bottom corner X coordinate of inserted image
         * @since 2002-07-31
         * @author Nicola Asuni
         * @access protected
         */
        public $img_rb_x = NULL;
        /**
         * @var right-bottom corner Y coordinate of inserted image
         * @since 2002-07-31
         * @author Nicola Asuni
         * @access protected
         */
        public $img_rb_y = NULL;
        /**
         * @var adjusting factor to convert pixels to user units.
         * @since 2004-06-14
         * @author Nicola Asuni
         * @access protected
         */
        public $imgscale = 1;
        /**
         * @var boolean set to true when the input text is unicode (require unicode fonts)
         * @since 2005-01-02
         * @author Nicola Asuni
         * @access protected
         */
        public $isunicode = false;
        /**
         * @var PDF version
         * @since 1.5.3
         * @access protected
         */
        public $PDFVersion = "1.7";
        /**
         * @var Minimum distance between header and top page margin.
         * @access protected
         */
        public $header_margin = NULL;
        /**
         * @var Minimum distance between footer and bottom page margin.
         * @access protected
         */
        public $footer_margin = NULL;
        /**
         * @var original left margin value
         * @access protected
         * @since 1.53.0.TC013
         */
        public $original_lMargin = NULL;
        /**
         * @var original right margin value
         * @access protected
         * @since 1.53.0.TC013
         */
        public $original_rMargin = NULL;
        /**
         * @var Header font.
         * @access protected
         */
        public $header_font = NULL;
        /**
         * @var Footer font.
         * @access protected
         */
        public $footer_font = NULL;
        /**
         * @var Language templates.
         * @access protected
         */
        public $l = NULL;
        /**
         * @var Barcode to print on page footer (only if set).
         * @access protected
         */
        public $barcode = false;
        /**
         * @var If true prints header
         * @access protected
         */
        public $print_header = true;
        /**
         * @var If true prints footer.
         * @access protected
         */
        public $print_footer = true;
        /**
         * @var Header image logo.
         * @access protected
         */
        public $header_logo = "";
        /**
         * @var Header image logo width in mm.
         * @access protected
         */
        public $header_logo_width = 30;
        /**
         * @var String to print as title on document header.
         * @access protected
         */
        public $header_title = "";
        /**
         * @var String to print on document header.
         * @access protected
         */
        public $header_string = "";
        /**
         * @var Default number of columns for html table.
         * @access protected
         */
        public $default_table_columns = 4;
        /**
         * @var HTML PARSER: array to store current link and rendering styles.
         * @access protected
         */
        public $HREF = [];
        /**
         * @var store a list of available fonts on filesystem.
         * @access protected
         */
        public $fontlist = [];
        /**
         * @var current foreground color
         * @access protected
         */
        public $fgcolor = NULL;
        /**
         * @var HTML PARSER: array of boolean values, true in case of ordered list (OL), false otherwise.
         * @access protected
         */
        public $listordered = [];
        /**
         * @var HTML PARSER: array count list items on nested lists.
         * @access protected
         */
        public $listcount = [];
        /**
         * @var HTML PARSER: current list nesting level.
         * @access protected
         */
        public $listnum = 0;
        /**
         * @var HTML PARSER: indent amount for lists.
         * @access protected
         */
        public $listindent = NULL;
        /**
         * @var current background color
         * @access protected
         */
        public $bgcolor = NULL;
        /**
         * @var Store temporary font size in points.
         * @access protected
         */
        public $tempfontsize = 10;
        /**
         * @var spacer for LI tags.
         * @access protected
         */
        public $lispacer = "";
        /**
         * @var default encoding
         * @access protected
         * @since 1.53.0.TC010
         */
        public $encoding = "UTF-8";
        /**
         * @var PHP internal encoding
         * @access protected
         * @since 1.53.0.TC016
         */
        public $internal_encoding = NULL;
        /**
         * @var indicates if the document language is Right-To-Left
         * @access protected
         * @since 2.0.000
         */
        public $rtl = false;
        /**
         * @var used to force RTL or LTR string inversion
         * @access protected
         * @since 2.0.000
         */
        public $tmprtl = false;
        /**
         * Indicates whether document is protected
         * @access protected
         * @since 2.0.000 (2008-01-02)
         */
        public $encrypted = NULL;
        /**
         * U entry in pdf document
         * @access protected
         * @since 2.0.000 (2008-01-02)
         */
        public $Uvalue = NULL;
        /**
         * O entry in pdf document
         * @access protected
         * @since 2.0.000 (2008-01-02)
         */
        public $Ovalue = NULL;
        /**
         * P entry in pdf document
         * @access protected
         * @since 2.0.000 (2008-01-02)
         */
        public $Pvalue = NULL;
        /**
         * encryption object id
         * @access protected
         * @since 2.0.000 (2008-01-02)
         */
        public $enc_obj_id = NULL;
        /**
         * last RC4 key encrypted (cached for optimisation)
         * @access protected
         * @since 2.0.000 (2008-01-02)
         */
        public $last_rc4_key = NULL;
        /**
         * last RC4 computed key
         * @access protected
         * @since 2.0.000 (2008-01-02)
         */
        public $last_rc4_key_c = NULL;
        /**
         * RC4 padding
         * @access protected
         */
        public $padding = "(�N^Nu�Ad\0NV��\1\10..\0��h>�/\f��dSiz";
        /**
         * RC4 encryption key
         * @access protected
         */
        public $encryption_key = NULL;
        /**
         * Outlines for bookmark
         * @access protected
         * @since 2.1.002 (2008-02-12)
         */
        public $outlines = [];
        /**
         * Outline root for bookmark
         * @access protected
         * @since 2.1.002 (2008-02-12)
         */
        public $OutlineRoot = NULL;
        /**
         * javascript code
         * @access protected
         * @since 2.1.002 (2008-02-12)
         */
        public $javascript = "";
        /**
         * javascript counter
         * @access protected
         * @since 2.1.002 (2008-02-12)
         */
        public $n_js = NULL;
        /**
         * line trough state
         * @access protected
         * @since 2.8.000 (2008-03-19)
         */
        public $linethrough = NULL;
        /**
         * If true enables user's rights on PDF reader
         * @access protected
         * @since 2.9.000 (2008-03-26)
         */
        public $ur = NULL;
        /**
         * Names specifying additional document-wide usage rights for the document.
         * @access protected
         * @since 2.9.000 (2008-03-26)
         */
        public $ur_document = NULL;
        /**
         * Names specifying additional annotation-related usage rights for the document.
         * @access protected
         * @since 2.9.000 (2008-03-26)
         */
        public $ur_annots = NULL;
        /**
         * Names specifying additional form-field-related usage rights for the document.
         * @access protected
         * @since 2.9.000 (2008-03-26)
         */
        public $ur_form = NULL;
        /**
         * Names specifying additional signature-related usage rights for the document.
         * @access protected
         * @since 2.9.000 (2008-03-26)
         */
        public $ur_signature = NULL;
        /**
         * Dot Per Inch Document Resolution (do not change)
         * @access protected
         * @since 3.0.000 (2008-03-27)
         */
        public $dpi = 72;
        /**
         * Array of page numbers were a new page group was started
         * @access protected
         * @since 3.0.000 (2008-03-27)
         */
        public $newpagegroup = [];
        /**
         * Contains the number of pages of the groups
         * @access protected
         * @since 3.0.000 (2008-03-27)
         */
        public $pagegroups = NULL;
        /**
         * Contains the alias of the current page group
         * @access protected
         * @since 3.0.000 (2008-03-27)
         */
        public $currpagegroup = NULL;
        /**
         * Restrict the rendering of some elements to screen or printout.
         * @access protected
         * @since 3.0.000 (2008-03-27)
         */
        public $visibility = "all";
        /**
         * Print visibility.
         * @access protected
         * @since 3.0.000 (2008-03-27)
         */
        public $n_ocg_print = NULL;
        /**
         * View visibility.
         * @access protected
         * @since 3.0.000 (2008-03-27)
         */
        public $n_ocg_view = NULL;
        /**
         * Array of transparency objects and parameters.
         * @access protected
         * @since 3.0.000 (2008-03-27)
         */
        public $extgstates = NULL;
        /**
         * Set the default JPEG compression quality (1-100)
         * @access protected
         * @since 3.0.000 (2008-03-27)
         */
        public $jpeg_quality = NULL;
        /**
         * Default cell height ratio.
         * @access protected
         * @since 3.0.014 (2008-05-23)
         */
        public $cell_height_ratio = K_CELL_HEIGHT_RATIO;
        /**
         * PDF viewer preferences.
         * @access protected
         * @since 3.1.000 (2008-06-09)
         */
        public $viewer_preferences = NULL;
        /**
         * A name object specifying how the document should be displayed when opened.
         * @access protected
         * @since 3.1.000 (2008-06-09)
         */
        public $PageMode = NULL;
        /**
         * Array for storing gradient information.
         * @access protected
         * @since 3.1.000 (2008-06-09)
         */
        public $gradients = [];
        /**
         * Array used to store positions inside the pages buffer.
         * keys are the page numbers
         * @access protected
         * @since 3.2.000 (2008-06-26)
         */
        public $intmrk = [];
        /**
         * Array used to store footer positions of each page.
         * @access protected
         * @since 3.2.000 (2008-07-01)
         */
        public $footerpos = [];
        /**
         * Array used to store footer lenght of each page.
         * @access protected
         * @since 4.0.014 (2008-07-29)
         */
        public $footerlen = [];
        /**
         * True if a newline is created.
         * @access protected
         * @since 3.2.000 (2008-07-01)
         */
        public $newline = true;
        /**
         * End position of the latest inserted line
         * @access protected
         * @since 3.2.000 (2008-07-01)
         */
        public $endlinex = 0;
        /**
         * PDF string for last line width
         * @access protected
         * @since 4.0.006 (2008-07-16)
         */
        public $linestyleWidth = "";
        /**
         * PDF string for last line width
         * @access protected
         * @since 4.0.006 (2008-07-16)
         */
        public $linestyleCap = "0 J";
        /**
         * PDF string for last line width
         * @access protected
         * @since 4.0.006 (2008-07-16)
         */
        public $linestyleJoin = "0 j";
        /**
         * PDF string for last line width
         * @access protected
         * @since 4.0.006 (2008-07-16)
         */
        public $linestyleDash = "[] 0 d";
        /**
         * True if marked-content sequence is open
         * @access protected
         * @since 4.0.013 (2008-07-28)
         */
        public $openMarkedContent = false;
        /**
         * Count the latest inserted vertical spaces on HTML
         * @access protected
         * @since 4.0.021 (2008-08-24)
         */
        public $htmlvspace = 0;
        /**
         * Array of Spot colors
         * @access protected
         * @since 4.0.024 (2008-09-12)
         */
        public $spot_colors = [];
        /**
         * Symbol used for HTML unordered list items
         * @access protected
         * @since 4.0.028 (2008-09-26)
         */
        public $lisymbol = "";
        /**
         * String used to mark the beginning and end of EPS image blocks
         * @access protected
         * @since 4.1.000 (2008-10-18)
         */
        public $epsmarker = "x#!#EPS#!#x";
        /**
         * Array of transformation matrix
         * @access protected
         * @since 4.2.000 (2008-10-29)
         */
        public $transfmatrix = [];
        /**
         * Booklet mode for double-sided pages
         * @access protected
         * @since 4.2.000 (2008-10-29)
         */
        public $booklet = false;
        /**
         * Epsilon value used for float calculations
         * @access protected
         * @since 4.2.000 (2008-10-29)
         */
        public $feps = 0.001;
        /**
         * Array used for custom vertical spaces for HTML tags
         * @access protected
         * @since 4.2.001 (2008-10-30)
         */
        public $tagvspaces = [];
        /**
         * @var HTML PARSER: custom indent amount for lists.
         * Negative value means disabled.
         * @access protected
         * @since 4.2.007 (2008-11-12)
         */
        public $customlistindent = -1;
        /**
         * @var if true keeps the border open for the cell sides that cross the page.
         * @access protected
         * @since 4.2.010 (2008-11-14)
         */
        public $opencell = true;
        /**
         * @var array of files to embedd
         * @access protected
         * @since 4.4.000 (2008-12-07)
         */
        public $embeddedfiles = [];
        /**
         * @var boolean true when inside html pre tag
         * @access protected
         * @since 4.4.001 (2008-12-08)
         */
        public $premode = false;
        /**
         * Array used to store positions of graphics transformation blocks inside the page buffer.
         * keys are the page numbers
         * @access protected
         * @since 4.4.002 (2008-12-09)
         */
        public $transfmrk = [];
        /**
         * Default color for html links
         * @access protected
         * @since 4.4.003 (2008-12-09)
         */
        public $htmlLinkColorArray = [0, 0, 255];
        /**
         * Default font style to add to html links
         * @access protected
         * @since 4.4.003 (2008-12-09)
         */
        public $htmlLinkFontStyle = "U";
        /**
         * Counts the number of pages.
         * @access protected
         * @since 4.5.000 (2008-12-31)
         */
        public $numpages = 0;
        /**
         * Array containing page lenghts in bytes.
         * @access protected
         * @since 4.5.000 (2008-12-31)
         */
        public $pagelen = [];
        /**
         * Counts the number of pages.
         * @access protected
         * @since 4.5.000 (2008-12-31)
         */
        public $numimages = 0;
        /**
         * Store the image keys.
         * @access protected
         * @since 4.5.000 (2008-12-31)
         */
        public $imagekeys = [];
        /**
         * Lenght of the buffer in bytes.
         * @access protected
         * @since 4.5.000 (2008-12-31)
         */
        public $bufferlen = 0;
        /**
         * If true enables disk caching.
         * @access protected
         * @since 4.5.000 (2008-12-31)
         */
        public $diskcache = false;
        /**
         * Counts the number of fonts.
         * @access protected
         * @since 4.5.000 (2009-01-02)
         */
        public $numfonts = 0;
        /**
         * Store the font keys.
         * @access protected
         * @since 4.5.000 (2009-01-02)
         */
        public $fontkeys = [];
        /**
         * Store the fage status (true when opened, false when closed).
         * @access protected
         * @since 4.5.000 (2009-01-02)
         */
        public $pageopen = [];
        /**
         * Default monospaced font
         * @access protected
         * @since 4.5.025 (2009-03-10)
         */
        public $default_monospaced_font = "courier";
        /**
         * Used to store a cloned copy of the current class object
         * @access protected
         * @since 4.5.029 (2009-03-19)
         */
        public $objcopy = NULL;
        /**
         * Array used to store the lenghts of cache files
         * @access protected
         * @since 4.5.029 (2009-03-19)
         */
        public $cache_file_lenght = [];
        /**
         * Table header content to be repeated on each new page
         * @access protected
         * @since 4.5.030 (2009-03-20)
         */
        public $thead = "";
        /**
         * Margins used for table header.
         * @access protected
         * @since 4.5.030 (2009-03-20)
         */
        public $theadMargins = [];
        /**
         * Cache array for UTF8StringToArray() method.
         * @access protected
         * @since 4.5.037 (2009-04-07)
         */
        public $cache_UTF8StringToArray = [];
        /**
         * Maximum size of cache array used for UTF8StringToArray() method.
         * @access protected
         * @since 4.5.037 (2009-04-07)
         */
        public $cache_maxsize_UTF8StringToArray = 8;
        /**
         * Current size of cache array used for UTF8StringToArray() method.
         * @access protected
         * @since 4.5.037 (2009-04-07)
         */
        public $cache_size_UTF8StringToArray = 0;
        /**
         * If true enables document signing
         * @access protected
         * @since 4.6.005 (2009-04-24)
         */
        public $sign = false;
        /**
         * Signature data
         * @access protected
         * @since 4.6.005 (2009-04-24)
         */
        public $signature_data = [];
        /**
         * Signature max lenght
         * @access protected
         * @since 4.6.005 (2009-04-24)
         */
        public $signature_max_lenght = 5120;
        /**
         * Regular expression used to find blank characters used for word-wrapping.
         * @access protected
         * @since 4.6.006 (2009-04-28)
         */
        public $re_spaces = "/[\\s]/";
        public function TCPDF($orientation = "P", $unit = "mm", $format = "A4", $unicode = true, $encoding = "UTF-8", $diskcache = false)
        {
            if (function_exists("mb_internal_encoding") && mb_internal_encoding()) {
                $this->internal_encoding = mb_internal_encoding();
                mb_internal_encoding("ASCII");
            }
            $this->diskcache = $diskcache ? true : false;
            $this->rtl = $this->l["a_meta_dir"] == "rtl" ? true : false;
            $this->tmprtl = false;
            $this->_dochecks();
            $this->isunicode = $unicode;
            $this->page = 0;
            $this->transfmrk[0] = [];
            $this->pagedim = [];
            $this->n = 2;
            $this->buffer = "";
            $this->pages = [];
            $this->state = 0;
            $this->fonts = [];
            $this->FontFiles = [];
            $this->diffs = [];
            $this->images = [];
            $this->links = [];
            $this->gradients = [];
            $this->InFooter = false;
            $this->lasth = 0;
            $this->FontFamily = "helvetica";
            $this->FontStyle = "";
            $this->FontSizePt = 12;
            $this->underline = false;
            $this->linethrough = false;
            $this->DrawColor = "0 G";
            $this->FillColor = "0 g";
            $this->TextColor = "0 g";
            $this->ColorFlag = false;
            $this->encrypted = false;
            $this->last_rc4_key = "";
            $this->padding = "(�N^Nu�Ad\0NV��\1\10..\0��h>�/\f��dSiz";
            $this->CoreFonts = ["courier" => "Courier", "courierB" => "Courier-Bold", "courierI" => "Courier-Oblique", "courierBI" => "Courier-BoldOblique", "helvetica" => "Helvetica", "helveticaB" => "Helvetica-Bold", "helveticaI" => "Helvetica-Oblique", "helveticaBI" => "Helvetica-BoldOblique", "times" => "Times-Roman", "timesB" => "Times-Bold", "timesI" => "Times-Italic", "timesBI" => "Times-BoldItalic", "symbol" => "Symbol", "zapfdingbats" => "ZapfDingbats"];
            $this->setPageUnit($unit);
            $this->setPageFormat($format, $orientation);
            $margin = 0 / $this->k;
            $this->SetMargins($margin, $margin);
            $this->cMargin = $margin / 10;
            $this->LineWidth = 0 / $this->k;
            $this->linestyleWidth = sprintf("%.2F w", $this->LineWidth * $this->k);
            $this->linestyleCap = "0 J";
            $this->linestyleJoin = "0 j";
            $this->linestyleDash = "[] 0 d";
            $this->SetAutoPageBreak(true, 2 * $margin);
            $this->SetDisplayMode("fullwidth");
            $this->SetCompression(true);
            $this->PDFVersion = "1.7";
            $this->encoding = $encoding;
            $this->HREF = [];
            $this->getFontsList();
            $this->fgcolor = ["R" => 0, "G" => 0, "B" => 0];
            $this->bgcolor = ["R" => 255, "G" => 255, "B" => 255];
            $this->extgstates = [];
            $this->sign = false;
            $this->ur = false;
            $this->ur_document = "/FullSave";
            $this->ur_annots = "/Create/Delete/Modify/Copy/Import/Export";
            $this->ur_form = "/Add/Delete/FillIn/Import/Export/SubmitStandalone/SpawnTemplate";
            $this->ur_signature = "/Modify";
            $this->jpeg_quality = 75;
            $this->utf8Bidi([""], "");
            $this->SetFont($this->FontFamily, $this->FontStyle, $this->FontSizePt);
            if ($this->isunicode && preg_match("/\\pL/u", "a") == 1) {
                $this->re_spaces = "/[\\s\\p{Z}]/";
            } else {
                $this->re_spaces = "/[\\s]/";
            }
        }
        public function TCPDFDestruct()
        {
            if (isset($this->internal_encoding) && !empty($this->internal_encoding)) {
                mb_internal_encoding($this->internal_encoding);
            }
            $this->_destroy(true);
        }
        public function setPageUnit($unit)
        {
            strtolower($unit);
            switch (strtolower($unit)) {
                case "px":
                case "pt":
                    $this->k = 1;
                    break;
                case "mm":
                    $this->k = $this->dpi / 0;
                    break;
                case "cm":
                    $this->k = $this->dpi / 0;
                    break;
                case "in":
                    $this->k = $this->dpi;
                    break;
                default:
                    $this->Error("Incorrect unit: " . $unit);
                    if (isset($this->CurOrientation)) {
                        $this->setPageOrientation($this->CurOrientation);
                    }
            }
        }
        public function setPageFormat($format, $orientation = "P")
        {
            while (is_string($format)) {
                $this->fwPt = $format[0] * $this->k;
                $this->fhPt = $format[1] * $this->k;
                strtoupper($format);
                switch (strtoupper($format)) {
                    case "4A0":
                        $format = [4767.87, 6740.79];
                        break;
                    case "2A0":
                        $format = [3370.39, 4767.87];
                        break;
                    case "A0":
                        $format = [2383.94, 3370.39];
                        break;
                    case "A1":
                        $format = [1683.78, 2383.94];
                        break;
                    case "A2":
                        $format = [1190.55, 1683.78];
                        break;
                    case "A3":
                        $format = [841.89, 1190.55];
                        break;
                    case "A4":
                    case "A5":
                        $format = [419.53, 595.28];
                        break;
                    case "A6":
                        $format = [297.64, 419.53];
                        break;
                    case "A7":
                        $format = [209.76, 297.64];
                        break;
                    case "A8":
                        $format = [147.4, 209.76];
                        break;
                    case "A9":
                        $format = [104.88, 147.4];
                        break;
                    case "A10":
                        $format = [73.7, 104.88];
                        break;
                    case "B0":
                        $format = [2834.65, 4008.19];
                        break;
                    case "B1":
                        $format = [2004.09, 2834.65];
                        break;
                    case "B2":
                        $format = [1417.32, 2004.09];
                        break;
                    case "B3":
                        $format = [1000.63, 1417.32];
                        break;
                    case "B4":
                        $format = [708.66, 1000.63];
                        break;
                    case "B5":
                        $format = [498.9, 708.66];
                        break;
                    case "B6":
                        $format = [354.33, 498.9];
                        break;
                    case "B7":
                        $format = [249.45, 354.33];
                        break;
                    case "B8":
                        $format = [175.75, 249.45];
                        break;
                    case "B9":
                        $format = [124.72, 175.75];
                        break;
                    case "B10":
                        $format = [87.87, 124.72];
                        break;
                    case "C0":
                        $format = [2599.37, 3676.54];
                        break;
                    case "C1":
                        $format = [1836.85, 2599.37];
                        break;
                    case "C2":
                        $format = [1298.27, 1836.85];
                        break;
                    case "C3":
                        $format = [918.4299999999999, 1298.27];
                        break;
                    case "C4":
                        $format = [649.13, 918.4299999999999];
                        break;
                    case "C5":
                        $format = [459.21, 649.13];
                        break;
                    case "C6":
                        $format = [323.15, 459.21];
                        break;
                    case "C7":
                        $format = [229.61, 323.15];
                        break;
                    case "C8":
                        $format = [161.57, 229.61];
                        break;
                    case "C9":
                        $format = [113.39, 161.57];
                        break;
                    case "C10":
                        $format = [79.37, 113.39];
                        break;
                    case "RA0":
                        $format = [2437.8, 3458.27];
                        break;
                    case "RA1":
                        $format = [1729.13, 2437.8];
                        break;
                    case "RA2":
                        $format = [1218.9, 1729.13];
                        break;
                    case "RA3":
                        $format = [864.5700000000001, 1218.9];
                        break;
                    case "RA4":
                        $format = [609.45, 864.5700000000001];
                        break;
                    case "SRA0":
                        $format = [2551.18, 3628.35];
                        break;
                    case "SRA1":
                        $format = [1814.17, 2551.18];
                        break;
                    case "SRA2":
                        $format = [1275.59, 1814.17];
                        break;
                    case "SRA3":
                        $format = [907.09, 1275.59];
                        break;
                    case "SRA4":
                        $format = [637.8, 907.09];
                        break;
                    case "LETTER":
                        $format = [612, 792];
                        break;
                    case "LEGAL":
                        $format = [612, 1008];
                        break;
                    case "EXECUTIVE":
                        $format = [521.86, 756];
                        break;
                    case "FOLIO":
                        $format = [612, 936];
                        break;
                    default:
                        $format = [595.28, 841.89];
                        list($this->fwPt, $this->fhPt) = $format;
                }
            }
            $this->setPageOrientation($orientation);
        }
        public function setPageOrientation($orientation, $autopagebreak = "", $bottommargin = "")
        {
            $orientation = strtoupper($orientation);
            if ($orientation == "P" || $orientation == "PORTRAIT") {
                $this->CurOrientation = "P";
                $this->wPt = $this->fwPt;
                $this->hPt = $this->fhPt;
            } else {
                if ($orientation == "L" || $orientation == "LANDSCAPE") {
                    $this->CurOrientation = "L";
                    $this->wPt = $this->fhPt;
                    $this->hPt = $this->fwPt;
                } else {
                    $this->Error("Incorrect orientation: " . $orientation);
                }
            }
            $this->w = $this->wPt / $this->k;
            $this->h = $this->hPt / $this->k;
            if ($this->empty_string($autopagebreak)) {
                if (isset($this->AutoPageBreak)) {
                    $autopagebreak = $this->AutoPageBreak;
                } else {
                    $autopagebreak = true;
                }
            }
            if ($this->empty_string($bottommargin)) {
                if (isset($this->bMargin)) {
                    $bottommargin = $this->bMargin;
                } else {
                    $bottommargin = 0 / $this->k;
                }
            }
            $this->SetAutoPageBreak($autopagebreak, $bottommargin);
            $this->pagedim[$this->page] = ["w" => $this->wPt, "h" => $this->hPt, "wk" => $this->w, "hk" => $this->h, "tm" => $this->tMargin, "bm" => $bottommargin, "lm" => $this->lMargin, "rm" => $this->rMargin, "pb" => $autopagebreak, "or" => $this->CurOrientation, "olm" => $this->original_lMargin, "orm" => $this->original_rMargin];
        }
        public function setSpacesRE($re = "/[\\s]/")
        {
            $this->re_spaces = $re;
        }
        public function setRTL($enable)
        {
            $this->rtl = $enable ? true : false;
            $this->tmprtl = false;
        }
        public function getRTL()
        {
            return $this->rtl;
        }
        public function setTempRTL($mode)
        {
            switch ($mode) {
                case false:
                case "L":
                case "R":
                    $this->tmprtl = $mode;
                    break;
            }
        }
        public function setLastH($h)
        {
            $this->lasth = $h;
        }
        public function getLastH()
        {
            return $this->lasth;
        }
        public function setImageScale($scale)
        {
            $this->imgscale = $scale;
        }
        public function getImageScale()
        {
            return $this->imgscale;
        }
        public function getPageDimensions($pagenum = "")
        {
            if (empty($pagenum)) {
                $pagenum = $this->page;
            }
            return $this->pagedim[$pagenum];
        }
        public function getPageWidth($pagenum = "")
        {
            if (empty($pagenum)) {
                return $this->w;
            }
            return $this->pagedim[$pagenum]["w"];
        }
        public function getPageHeight($pagenum = "")
        {
            if (empty($pagenum)) {
                return $this->h;
            }
            return $this->pagedim[$pagenum]["h"];
        }
        public function getBreakMargin($pagenum = "")
        {
            if (empty($pagenum)) {
                return $this->bMargin;
            }
            return $this->pagedim[$pagenum]["bm"];
        }
        public function getScaleFactor()
        {
            return $this->k;
        }
        public function SetMargins($left, $top, $right = -1)
        {
            $this->lMargin = $left;
            $this->tMargin = $top;
            if ($right == -1) {
                $right = $left;
            }
            $this->rMargin = $right;
        }
        public function SetLeftMargin($margin)
        {
            $this->lMargin = $margin;
            if (0 < $this->page && $this->x < $margin) {
                $this->x = $margin;
            }
        }
        public function SetTopMargin($margin)
        {
            $this->tMargin = $margin;
            if (0 < $this->page && $this->y < $margin) {
                $this->y = $margin;
            }
        }
        public function SetRightMargin($margin)
        {
            $this->rMargin = $margin;
            if (0 < $this->page && $this->w - $margin < $this->x) {
                $this->x = $this->w - $margin;
            }
        }
        public function SetCellPadding($pad)
        {
            $this->cMargin = $pad;
        }
        public function SetAutoPageBreak($auto, $margin = 0)
        {
            $this->AutoPageBreak = $auto;
            $this->bMargin = $margin;
            $this->PageBreakTrigger = $this->h - $margin;
        }
        public function SetDisplayMode($zoom, $layout = "SinglePage", $mode = "UseNone")
        {
            while ($zoom == "fullpage" || $zoom == "fullwidth" || $zoom == "real" || $zoom == "default" || !is_string($zoom)) {
                $this->Error("Incorrect zoom display mode: " . $zoom);
                $this->ZoomMode = $zoom;
            }
            switch ($layout) {
                case "default":
                case "single":
                case "SinglePage":
                    $this->LayoutMode = "SinglePage";
                    break;
                case "continuous":
                case "OneColumn":
                    $this->LayoutMode = "OneColumn";
                    break;
                case "two":
                case "TwoColumnLeft":
                    $this->LayoutMode = "TwoColumnLeft";
                    break;
                case "TwoColumnRight":
                    $this->LayoutMode = "TwoColumnRight";
                    break;
                case "TwoPageLeft":
                    $this->LayoutMode = "TwoPageLeft";
                    break;
                case "TwoPageRight":
                    $this->LayoutMode = "TwoPageRight";
                    break;
                default:
                    $this->LayoutMode = "SinglePage";
                    switch ($mode) {
                        case "UseNone":
                            $this->PageMode = "UseNone";
                            break;
                        case "UseOutlines":
                            $this->PageMode = "UseOutlines";
                            break;
                        case "UseThumbs":
                            $this->PageMode = "UseThumbs";
                            break;
                        case "FullScreen":
                            $this->PageMode = "FullScreen";
                            break;
                        case "UseOC":
                            $this->PageMode = "UseOC";
                            break;
                        case "":
                            $this->PageMode = "UseAttachments";
                            break;
                        default:
                            $this->PageMode = "UseNone";
                    }
            }
        }
        public function SetCompression($compress)
        {
            if (function_exists("gzcompress")) {
                $this->compress = $compress;
            } else {
                $this->compress = false;
            }
        }
        public function SetTitle($title)
        {
            $this->title = $title;
        }
        public function SetSubject($subject)
        {
            $this->subject = $subject;
        }
        public function SetAuthor($author)
        {
            $this->author = $author;
        }
        public function SetKeywords($keywords)
        {
            $this->keywords = $keywords;
        }
        public function SetCreator($creator)
        {
            $this->creator = $creator;
        }
        public function Error($msg)
        {
            $this->_destroy(true);
            exit("<strong>TCPDF ERROR: </strong>" . $msg);
        }
        public function Open()
        {
            $this->state = 1;
        }
        public function Close()
        {
            if ($this->state == 3) {
                return NULL;
            }
            if ($this->page == 0) {
                $this->AddPage();
            }
            $this->endPage();
            $this->_enddoc();
            $this->_destroy(false);
        }
        public function setPage($pnum, $resetmargins = false)
        {
            if ($pnum == $this->page) {
                return NULL;
            }
            if (0 < $pnum && $pnum <= $this->numpages) {
                $this->state = 2;
                $oldpage = $this->page;
                $this->page = $pnum;
                $this->wPt = $this->pagedim[$this->page]["w"];
                $this->hPt = $this->pagedim[$this->page]["h"];
                $this->w = $this->wPt / $this->k;
                $this->h = $this->hPt / $this->k;
                $this->tMargin = $this->pagedim[$this->page]["tm"];
                $this->bMargin = $this->pagedim[$this->page]["bm"];
                $this->original_lMargin = $this->pagedim[$this->page]["olm"];
                $this->original_rMargin = $this->pagedim[$this->page]["orm"];
                $this->AutoPageBreak = $this->pagedim[$this->page]["pb"];
                $this->CurOrientation = $this->pagedim[$this->page]["or"];
                $this->SetAutoPageBreak($this->AutoPageBreak, $this->bMargin);
                if ($resetmargins) {
                    $this->lMargin = $this->pagedim[$this->page]["olm"];
                    $this->rMargin = $this->pagedim[$this->page]["orm"];
                    $this->SetY($this->tMargin);
                } else {
                    if ($this->pagedim[$this->page]["olm"] != $this->pagedim[$oldpage]["olm"]) {
                        $deltam = $this->pagedim[$this->page]["olm"] - $this->pagedim[$this->page]["orm"];
                        $this->lMargin += $deltam;
                        $this->rMargin -= $deltam;
                    }
                }
            } else {
                $this->Error("Wrong page number on setPage() function.");
            }
        }
        public function lastPage($resetmargins = false)
        {
            $this->setPage($this->getNumPages(), $resetmargins);
        }
        public function getPage()
        {
            return $this->page;
        }
        public function getNumPages()
        {
            return $this->numpages;
        }
        public function AddPage($orientation = "", $format = "")
        {
            if (!isset($this->original_lMargin)) {
                $this->original_lMargin = $this->lMargin;
            }
            if (!isset($this->original_rMargin)) {
                $this->original_rMargin = $this->rMargin;
            }
            $this->endPage();
            $this->startPage($orientation, $format);
        }
        public function endPage()
        {
            if ($this->page == 0 || $this->page < $this->numpages || !$this->pageopen[$this->page]) {
                return NULL;
            }
            $this->InFooter = true;
            $this->setFooter();
            $this->_endpage();
            $this->pageopen[$this->page] = false;
            $this->InFooter = false;
        }
        public function startPage($orientation = "", $format = "")
        {
            if ($this->page < $this->numpages) {
                $this->setPage($this->page + 1);
                $this->SetY($this->tMargin);
            } else {
                if ($this->state == 0) {
                    $this->Open();
                }
                $this->numpages++;
                $this->swapMargins($this->booklet);
                $gvars = $this->getGraphicVars();
                $this->_beginpage($orientation, $format);
                $this->pageopen[$this->page] = true;
                $this->setGraphicVars($gvars);
                $this->setPageMark();
                $this->setHeader();
                $this->setGraphicVars($gvars);
                $this->setPageMark();
                $this->setTableHeader();
            }
        }
        public function setPageMark()
        {
            $this->intmrk[$this->page] = $this->pagelen[$this->page];
        }
        public function setHeaderData($ln = "", $lw = 0, $ht = "", $hs = "")
        {
            $this->header_logo = $ln;
            $this->header_logo_width = $lw;
            $this->header_title = $ht;
            $this->header_string = $hs;
        }
        public function getHeaderData()
        {
            $ret = [];
            $ret["logo"] = $this->header_logo;
            $ret["logo_width"] = $this->header_logo_width;
            $ret["title"] = $this->header_title;
            $ret["string"] = $this->header_string;
            return $ret;
        }
        public function setHeaderMargin($hm = 10)
        {
            $this->header_margin = $hm;
        }
        public function getHeaderMargin()
        {
            return $this->header_margin;
        }
        public function setFooterMargin($fm = 10)
        {
            $this->footer_margin = $fm;
        }
        public function getFooterMargin()
        {
            return $this->footer_margin;
        }
        public function setPrintHeader($val = true)
        {
            $this->print_header = $val;
        }
        public function setPrintFooter($val = true)
        {
            $this->print_footer = $val;
        }
        public function getImageRBX()
        {
            return $this->img_rb_x;
        }
        public function getImageRBY()
        {
            return $this->img_rb_y;
        }
        public function Header()
        {
            $ormargins = $this->getOriginalMargins();
            $headerfont = $this->getHeaderFont();
            $headerdata = $this->getHeaderData();
            if ($headerdata["logo"] && $headerdata["logo"] != K_BLANK_IMAGE) {
                $this->Image(K_PATH_IMAGES . $headerdata["logo"], $this->GetX(), $this->getHeaderMargin(), $headerdata["logo_width"]);
                $imgy = $this->getImageRBY();
            } else {
                $imgy = $this->GetY();
            }
            $cell_height = round($this->getCellHeightRatio() * $headerfont[2] / $this->getScaleFactor(), 2);
            if ($this->getRTL()) {
                $header_x = $ormargins["right"] + $headerdata["logo_width"] * 0;
            } else {
                $header_x = $ormargins["left"] + $headerdata["logo_width"] * 0;
            }
            $this->SetTextColor(0, 0, 0);
            $this->SetFont($headerfont[0], "B", $headerfont[2] + 1);
            $this->SetX($header_x);
            $this->Cell(0, $cell_height, $headerdata["title"], 0, 1, "", 0, "", 0);
            $this->SetFont($headerfont[0], $headerfont[1], $headerfont[2]);
            $this->SetX($header_x);
            $this->MultiCell(0, $cell_height, $headerdata["string"], 0, "", 0, 1, "", "", true, 0, false);
            $this->SetLineStyle(["width" => 0 / $this->getScaleFactor(), "cap" => "butt", "join" => "miter", "dash" => 0, "color" => [0, 0, 0]]);
            $this->SetY(0 / $this->getScaleFactor() + max($imgy, $this->GetY()));
            if ($this->getRTL()) {
                $this->SetX($ormargins["right"]);
            } else {
                $this->SetX($ormargins["left"]);
            }
            $this->Cell(0, 0, "", "T", 0, "C");
        }
        public function Footer()
        {
            $cur_y = $this->GetY();
            $ormargins = $this->getOriginalMargins();
            $this->SetTextColor(0, 0, 0);
            $line_width = 0 / $this->getScaleFactor();
            $this->SetLineStyle(["width" => $line_width, "cap" => "butt", "join" => "miter", "dash" => 0, "color" => [0, 0, 0]]);
            $barcode = $this->getBarcode();
            if (!empty($barcode)) {
                $this->Ln($line_width);
                $barcode_width = round(($this->getPageWidth() - $ormargins["left"] - $ormargins["right"]) / 3);
                $this->write1DBarcode($barcode, "C128B", $this->GetX(), $cur_y + $line_width, $barcode_width, $this->getFooterMargin() / 3 - $line_width, 0, "", "");
            }
            if (empty($this->pagegroups)) {
                $pagenumtxt = $this->l["w_page"] . " " . $this->getAliasNumPage() . " / " . $this->getAliasNbPages();
            } else {
                $pagenumtxt = $this->l["w_page"] . " " . $this->getPageNumGroupAlias() . " / " . $this->getPageGroupAlias();
            }
            $this->SetY($cur_y);
            if ($this->getRTL()) {
                $this->SetX($ormargins["right"]);
                $this->Cell(0, 0, $pagenumtxt, "T", 0, "L");
            } else {
                $this->SetX($ormargins["left"]);
                $this->Cell(0, 0, $pagenumtxt, "T", 0, "R");
            }
        }
        public function setHeader()
        {
            if ($this->print_header) {
                $lasth = $this->lasth;
                $this->_out("q");
                $this->rMargin = $this->original_rMargin;
                $this->lMargin = $this->original_lMargin;
                $this->cMargin = 0;
                if ($this->rtl) {
                    $this->SetXY($this->original_rMargin, $this->header_margin);
                } else {
                    $this->SetXY($this->original_lMargin, $this->header_margin);
                }
                $this->SetFont($this->header_font[0], $this->header_font[1], $this->header_font[2]);
                $this->Header();
                if ($this->rtl) {
                    $this->SetXY($this->original_rMargin, $this->tMargin);
                } else {
                    $this->SetXY($this->original_lMargin, $this->tMargin);
                }
                $this->_out("Q");
                $this->lasth = $lasth;
            }
        }
        public function setFooter()
        {
            $gvars = $this->getGraphicVars();
            $this->footerpos[$this->page] = $this->pagelen[$this->page];
            $this->_out("\n");
            if ($this->print_footer) {
                $lasth = $this->lasth;
                $this->_out("q");
                $this->rMargin = $this->original_rMargin;
                $this->lMargin = $this->original_lMargin;
                $this->cMargin = 0;
                $footer_y = $this->h - $this->footer_margin;
                if ($this->rtl) {
                    $this->SetXY($this->original_rMargin, $footer_y);
                } else {
                    $this->SetXY($this->original_lMargin, $footer_y);
                }
                $this->SetFont($this->footer_font[0], $this->footer_font[1], $this->footer_font[2]);
                $this->Footer();
                if ($this->rtl) {
                    $this->SetXY($this->original_rMargin, $this->tMargin);
                } else {
                    $this->SetXY($this->original_lMargin, $this->tMargin);
                }
                $this->_out("Q");
                $this->lasth = $lasth;
            }
            $this->setGraphicVars($gvars);
            $this->footerlen[$this->page] = $this->pagelen[$this->page] - $this->footerpos[$this->page] + 1;
        }
        public function setTableHeader()
        {
            if (isset($this->theadMargins["top"])) {
                $this->tMargin = $this->theadMargins["top"];
                $this->pagedim[$this->page]["tm"] = $this->tMargin;
                $this->y = $this->tMargin;
            }
            if (!$this->empty_string($this->thead)) {
                $this->lMargin = $this->pagedim[$this->page]["olm"];
                $this->rMargin = $this->pagedim[$this->page]["orm"];
                $this->cMargin = $this->theadMargins["cmargin"];
                $this->writeHTML($this->thead, false, false, false, false, "");
                if (!isset($this->theadMargins["top"])) {
                    $this->theadMargins["top"] = $this->tMargin;
                }
                $this->tMargin = $this->y;
                $this->pagedim[$this->page]["tm"] = $this->tMargin;
                $this->lasth = 0;
            }
        }
        public function PageNo()
        {
            return $this->page;
        }
        public function AddSpotColor($name, $c, $m, $y, $k)
        {
            if (!isset($this->spot_colors[$name])) {
                $i = 1 + count($this->spot_colors);
                $this->spot_colors[$name] = ["i" => $i, "c" => $c, "m" => $m, "y" => $y, "k" => $k];
            }
        }
        public function SetDrawColorArray($color)
        {
            if (isset($color)) {
                $color = array_values($color);
                $r = isset($color[0]) ? $color[0] : -1;
                $g = isset($color[1]) ? $color[1] : -1;
                $b = isset($color[2]) ? $color[2] : -1;
                $k = isset($color[3]) ? $color[3] : -1;
                if (0 <= $r) {
                    $this->SetDrawColor($r, $g, $b, $k);
                }
            }
        }
        public function SetDrawColor($col1 = 0, $col2 = -1, $col3 = -1, $col4 = -1)
        {
            if (!is_numeric($col1)) {
                $col1 = 0;
            }
            if (!is_numeric($col2)) {
                $col2 = -1;
            }
            if (!is_numeric($col3)) {
                $col3 = -1;
            }
            if (!is_numeric($col4)) {
                $col4 = -1;
            }
            if ($col2 == -1 && $col3 == -1 && $col4 == -1) {
                $this->DrawColor = sprintf("%.3F G", $col1 / 255);
            } else {
                if ($col4 == -1) {
                    $this->DrawColor = sprintf("%.3F %.3F %.3F RG", $col1 / 255, $col2 / 255, $col3 / 255);
                } else {
                    $this->DrawColor = sprintf("%.3F %.3F %.3F %.3F K", $col1 / 100, $col2 / 100, $col3 / 100, $col4 / 100);
                }
            }
            if (0 < $this->page) {
                $this->_out($this->DrawColor);
            }
        }
        public function SetDrawSpotColor($name, $tint = 100)
        {
            if (!isset($this->spot_colors[$name])) {
                $this->Error("Undefined spot color: " . $name);
            }
            $this->DrawColor = sprintf("/CS%d CS %.3F SCN", $this->spot_colors[$name]["i"], $tint / 100);
            if (0 < $this->page) {
                $this->_out($this->DrawColor);
            }
        }
        public function SetFillColorArray($color)
        {
            if (isset($color)) {
                $color = array_values($color);
                $r = isset($color[0]) ? $color[0] : -1;
                $g = isset($color[1]) ? $color[1] : -1;
                $b = isset($color[2]) ? $color[2] : -1;
                $k = isset($color[3]) ? $color[3] : -1;
                if (0 <= $r) {
                    $this->SetFillColor($r, $g, $b, $k);
                }
            }
        }
        public function SetFillColor($col1 = 0, $col2 = -1, $col3 = -1, $col4 = -1)
        {
            if (!is_numeric($col1)) {
                $col1 = 0;
            }
            if (!is_numeric($col2)) {
                $col2 = -1;
            }
            if (!is_numeric($col3)) {
                $col3 = -1;
            }
            if (!is_numeric($col4)) {
                $col4 = -1;
            }
            if ($col2 == -1 && $col3 == -1 && $col4 == -1) {
                $this->FillColor = sprintf("%.3F g", $col1 / 255);
                $this->bgcolor = ["G" => $col1];
            } else {
                if ($col4 == -1) {
                    $this->FillColor = sprintf("%.3F %.3F %.3F rg", $col1 / 255, $col2 / 255, $col3 / 255);
                    $this->bgcolor = ["R" => $col1, "G" => $col2, "B" => $col3];
                } else {
                    $this->FillColor = sprintf("%.3F %.3F %.3F %.3F k", $col1 / 100, $col2 / 100, $col3 / 100, $col4 / 100);
                    $this->bgcolor = ["C" => $col1, "M" => $col2, "Y" => $col3, "K" => $col4];
                }
            }
            $this->ColorFlag = $this->FillColor != $this->TextColor;
            if (0 < $this->page) {
                $this->_out($this->FillColor);
            }
        }
        public function SetFillSpotColor($name, $tint = 100)
        {
            if (!isset($this->spot_colors[$name])) {
                $this->Error("Undefined spot color: " . $name);
            }
            $this->FillColor = sprintf("/CS%d cs %.3F scn", $this->spot_colors[$name]["i"], $tint / 100);
            $this->ColorFlag = $this->FillColor != $this->TextColor;
            if (0 < $this->page) {
                $this->_out($this->FillColor);
            }
        }
        public function SetTextColorArray($color)
        {
            if (isset($color)) {
                $color = array_values($color);
                $r = isset($color[0]) ? $color[0] : -1;
                $g = isset($color[1]) ? $color[1] : -1;
                $b = isset($color[2]) ? $color[2] : -1;
                $k = isset($color[3]) ? $color[3] : -1;
                if (0 <= $r) {
                    $this->SetTextColor($r, $g, $b, $k);
                }
            }
        }
        public function SetTextColor($col1 = 0, $col2 = -1, $col3 = -1, $col4 = -1)
        {
            if (!is_numeric($col1)) {
                $col1 = 0;
            }
            if (!is_numeric($col2)) {
                $col2 = -1;
            }
            if (!is_numeric($col3)) {
                $col3 = -1;
            }
            if (!is_numeric($col4)) {
                $col4 = -1;
            }
            if ($col2 == -1 && $col3 == -1 && $col4 == -1) {
                $this->TextColor = sprintf("%.3F g", $col1 / 255);
                $this->fgcolor = ["G" => $col1];
            } else {
                if ($col4 == -1) {
                    $this->TextColor = sprintf("%.3F %.3F %.3F rg", $col1 / 255, $col2 / 255, $col3 / 255);
                    $this->fgcolor = ["R" => $col1, "G" => $col2, "B" => $col3];
                } else {
                    $this->TextColor = sprintf("%.3F %.3F %.3F %.3F k", $col1 / 100, $col2 / 100, $col3 / 100, $col4 / 100);
                    $this->fgcolor = ["C" => $col1, "M" => $col2, "Y" => $col3, "K" => $col4];
                }
            }
            $this->ColorFlag = $this->FillColor != $this->TextColor;
        }
        public function SetTextSpotColor($name, $tint = 100)
        {
            if (!isset($this->spot_colors[$name])) {
                $this->Error("Undefined spot color: " . $name);
            }
            $this->TextColor = sprintf("/CS%d cs %.3F scn", $this->spot_colors[$name]["i"], $tint / 100);
            $this->ColorFlag = $this->FillColor != $this->TextColor;
            if (0 < $this->page) {
                $this->_out($this->TextColor);
            }
        }
        public function GetStringWidth($s, $fontname = "", $fontstyle = "", $fontsize = 0)
        {
            return $this->GetArrStringWidth($this->utf8Bidi($this->UTF8StringToArray($s), $s, $this->tmprtl), $fontname, $fontstyle, $fontsize);
        }
        public function GetArrStringWidth($sa, $fontname = "", $fontstyle = "", $fontsize = 0)
        {
            if (!$this->empty_string($fontname)) {
                $prev_FontFamily = $this->FontFamily;
                $prev_FontStyle = $this->FontStyle;
                $prev_FontSizePt = $this->FontSizePt;
                $this->SetFont($fontname, $fontstyle, $fontsize);
            }
            $w = 0;
            foreach ($sa as $char) {
                $w += $this->GetCharWidth($char);
            }
            if (!$this->empty_string($fontname)) {
                $this->SetFont($prev_FontFamily, $prev_FontStyle, $prev_FontSizePt);
            }
            return $w;
        }
        public function GetCharWidth($char)
        {
            if ($char == 173) {
                return 0;
            }
            $cw =& $this->CurrentFont["cw"];
            if (isset($cw[$char])) {
                $w = $cw[$char];
            } else {
                if (isset($this->CurrentFont["dw"])) {
                    $w = $this->CurrentFont["dw"];
                } else {
                    if (isset($cw[32])) {
                        $dw = $cw[32];
                    } else {
                        $w = 600;
                    }
                }
            }
            return $w * $this->FontSize / 1000;
        }
        public function GetNumChars($s)
        {
            if ($this->CurrentFont["type"] == "TrueTypeUnicode" || $this->CurrentFont["type"] == "cidfont0") {
                return count($this->UTF8StringToArray($s));
            }
            return strlen($s);
        }
        public function getFontsList()
        {
            $fontsdir = opendir($this->_getfontpath());
            while (($file = readdir($fontsdir)) !== false) {
                if (substr($file, -4) == ".php") {
                    array_push($this->fontlist, strtolower(basename($file, ".php")));
                }
            }
            closedir($fontsdir);
        }
        public function AddFont($family, $style = "", $fontfile = "")
        {
            if ($this->empty_string($family)) {
                if (!$this->empty_string($this->FontFamily)) {
                    $family = $this->FontFamily;
                } else {
                    $this->Error("Empty font family");
                }
            }
            $family = strtolower($family);
            if (!$this->isunicode && $family == "arial") {
                $family = "helvetica";
            }
            if ($family == "symbol" || $family == "zapfdingbats") {
                $style = "";
            }
            $tempstyle = strtoupper($style);
            $style = "";
            if (strpos($tempstyle, "U") !== false) {
                $this->underline = true;
            } else {
                $this->underline = false;
            }
            if (strpos($tempstyle, "D") !== false) {
                $this->linethrough = true;
            } else {
                $this->linethrough = false;
            }
            if (strpos($tempstyle, "B") !== false) {
                $style .= "B";
            }
            if (strpos($tempstyle, "I") !== false) {
                $style .= "I";
            }
            $bistyle = $style;
            $fontkey = $family . $style;
            $font_style = $style . ($this->underline ? "U" : "") . ($this->linethrough ? "D" : "");
            $fontdata = ["fontkey" => $fontkey, "family" => $family, "style" => $font_style];
            if ($this->getFontBuffer($fontkey) !== false) {
                return $fontdata;
            }
            if (isset($type)) {
                unset($type);
            }
            if (isset($cw)) {
                unset($cw);
            }
            $fontdir = "";
            if (!$this->empty_string($fontfile)) {
                $fontdir = dirname($fontfile);
                if ($this->empty_string($fontdir) || $fontdir == ".") {
                    $fontdir = "";
                } else {
                    $fontdir .= "/";
                }
            }
            if ($this->empty_string($fontfile) || !file_exists($fontfile)) {
                $fontfile1 = str_replace(" ", "", $family) . strtolower($style) . ".php";
                $fontfile2 = str_replace(" ", "", $family) . ".php";
                if (file_exists($fontdir . $fontfile1)) {
                    $fontfile = $fontdir . $fontfile1;
                } else {
                    if (file_exists($this->_getfontpath() . $fontfile1)) {
                        $fontfile = $this->_getfontpath() . $fontfile1;
                    } else {
                        if (file_exists($fontfile1)) {
                            $fontfile = $fontfile1;
                        } else {
                            if (file_exists($fontdir . $fontfile2)) {
                                $fontfile = $fontdir . $fontfile2;
                            } else {
                                if (file_exists($this->_getfontpath() . $fontfile2)) {
                                    $fontfile = $this->_getfontpath() . $fontfile2;
                                } else {
                                    $fontfile = $fontfile2;
                                }
                            }
                        }
                    }
                }
            }
            if (file_exists($fontfile)) {
                include $fontfile;
            } else {
                $this->Error("Could not include font definition file: " . $family . "");
            }
            if (!isset($type) || !isset($cw)) {
                $this->Error("The font definition file has a bad format: " . $fontfile . "");
            }
            if (!isset($file)) {
                $file = "";
            }
            if (!isset($enc)) {
                $enc = "";
            }
            if (!isset($dw) || $this->empty_string($dw)) {
                if (isset($desc["MissingWidth"]) && 0 < $desc["MissingWidth"]) {
                    $dw = $desc["MissingWidth"];
                } else {
                    if (isset($cw[32])) {
                        $dw = $cw[32];
                    } else {
                        $dw = 600;
                    }
                }
            }
            $this->numfonts++;
            if ($type == "cidfont0") {
                $file = "";
                $styles = ["" => "", "B" => ",Bold", "I" => ",Italic", "BI" => ",BoldItalic"];
                $sname = $name . $styles[$bistyle];
                if (strpos($bistyle, "B") !== false && isset($desc["StemV"]) && $desc["StemV"] == 70) {
                    $desc["StemV"] = 120;
                }
                $this->setFontBuffer($fontkey, ["i" => $this->numfonts, "type" => $type, "name" => $sname, "desc" => $desc, "cidinfo" => $cidinfo, "up" => $up, "ut" => $ut, "cw" => $cw, "dw" => $dw, "enc" => $enc]);
            } else {
                if ($type == "core") {
                    $this->setFontBuffer($fontkey, ["i" => $this->numfonts, "type" => "core", "name" => $this->CoreFonts[$fontkey], "up" => -100, "ut" => 50, "cw" => $cw, "dw" => $dw]);
                } else {
                    if ($type == "TrueType" || $type == "Type1") {
                        $this->setFontBuffer($fontkey, ["i" => $this->numfonts, "type" => $type, "name" => $name, "up" => $up, "ut" => $ut, "cw" => $cw, "dw" => $dw, "file" => $file, "enc" => $enc, "desc" => $desc]);
                    } else {
                        if ($type == "TrueTypeUnicode") {
                            $this->setFontBuffer($fontkey, ["i" => $this->numfonts, "type" => $type, "name" => $name, "desc" => $desc, "up" => $up, "ut" => $ut, "cw" => $cw, "dw" => $dw, "enc" => $enc, "file" => $file, "ctg" => $ctg]);
                        } else {
                            $this->Error("Unknow font type: " . $type . "");
                        }
                    }
                }
            }
            if (isset($diff) && !empty($diff)) {
                $d = 0;
                $nb = count($this->diffs);
                $i = 1;
                while ($i <= $nb) {
                    if ($this->diffs[$i] == $diff) {
                        $d = $i;
                    } else {
                        $i++;
                    }
                }
                if ($d == 0) {
                    $d = $nb + 1;
                    $this->diffs[$d] = $diff;
                }
                $this->setFontSubBuffer($fontkey, "diff", $d);
            }
            if (!$this->empty_string($file)) {
                if (strcasecmp($type, "TrueType") == 0 || strcasecmp($type, "TrueTypeUnicode") == 0) {
                    $this->FontFiles[$file] = ["length1" => $originalsize, "fontdir" => $fontdir];
                } else {
                    if ($type != "core") {
                        $this->FontFiles[$file] = ["length1" => $size1, "length2" => $size2, "fontdir" => $fontdir];
                    }
                }
            }
            return $fontdata;
        }
        public function SetFont($family, $style = "", $size = 0, $fontfile = "")
        {
            global $CONFIG;
            $family = strtolower($CONFIG["Charset"]) == "utf-8" ? "freesans" : "helvetica";
            if ($size == 0) {
                $size = $this->FontSizePt;
            }
            $fontdata = $this->AddFont($family, $style, $fontfile);
            $this->FontFamily = $fontdata["family"];
            $this->FontStyle = $fontdata["style"];
            $this->CurrentFont = $this->getFontBuffer($fontdata["fontkey"]);
            $this->SetFontSize($size);
        }
        public function SetFontSize($size)
        {
            $this->FontSizePt = $size;
            $this->FontSize = $size / $this->k;
            if (isset($this->CurrentFont["desc"]["Ascent"]) && 0 < $this->CurrentFont["desc"]["Ascent"]) {
                $this->FontAscent = $this->CurrentFont["desc"]["Ascent"] * $this->FontSize / 1000;
            } else {
                $this->FontAscent = 0 * $this->FontSize;
            }
            if (isset($this->CurrentFont["desc"]["Descent"]) && 0 < $this->CurrentFont["desc"]["Descent"]) {
                $this->FontDescent = -1 * $this->CurrentFont["desc"]["Descent"] * $this->FontSize / 1000;
            } else {
                $this->FontDescent = 0 * $this->FontSize;
            }
            if (0 < $this->page && isset($this->CurrentFont["i"])) {
                $this->_out(sprintf("BT /F%d %.2F Tf ET", $this->CurrentFont["i"], $this->FontSizePt));
            }
        }
        public function SetDefaultMonospacedFont($font)
        {
            $this->default_monospaced_font = $font;
        }
        public function AddLink()
        {
            $n = count($this->links) + 1;
            $this->links[$n] = [0, 0];
            return $n;
        }
        public function SetLink($link, $y = 0, $page = -1)
        {
            if ($y == -1) {
                $y = $this->y;
            }
            if ($page == -1) {
                $page = $this->page;
            }
            $this->links[$link] = [$page, $y];
        }
        public function Link($x, $y, $w, $h, $link, $spaces = 0)
        {
            $this->Annotation($x, $y, $w, $h, $link, ["Subtype" => "Link"], $spaces);
        }
        public function Annotation($x, $y, $w, $h, $text, $opt = ["Subtype" => "Text"], $spaces = 0)
        {
            if (isset($this->transfmatrix)) {
                $maxid = count($this->transfmatrix) - 1;
                for ($i = $maxid; 0 <= $i; $i--) {
                    $ctm = $this->transfmatrix[$i];
                    if (isset($ctm["a"])) {
                        $x = $x * $this->k;
                        $y = ($this->h - $y) * $this->k;
                        $w = $w * $this->k;
                        $h = $h * $this->k;
                        $xt = $x;
                        $yt = $y;
                        $x1 = $ctm["a"] * $xt + $ctm["c"] * $yt + $ctm["e"];
                        $y1 = $ctm["b"] * $xt + $ctm["d"] * $yt + $ctm["f"];
                        $xt = $x + $w;
                        $yt = $y;
                        $x2 = $ctm["a"] * $xt + $ctm["c"] * $yt + $ctm["e"];
                        $y2 = $ctm["b"] * $xt + $ctm["d"] * $yt + $ctm["f"];
                        $xt = $x;
                        $yt = $y - $h;
                        $x3 = $ctm["a"] * $xt + $ctm["c"] * $yt + $ctm["e"];
                        $y3 = $ctm["b"] * $xt + $ctm["d"] * $yt + $ctm["f"];
                        $xt = $x + $w;
                        $yt = $y - $h;
                        $x4 = $ctm["a"] * $xt + $ctm["c"] * $yt + $ctm["e"];
                        $y4 = $ctm["b"] * $xt + $ctm["d"] * $yt + $ctm["f"];
                        $x = min($x1, $x2, $x3, $x4);
                        $y = max($y1, $y2, $y3, $y4);
                        $w = (max($x1, $x2, $x3, $x4) - $x) / $this->k;
                        $h = ($y - min($y1, $y2, $y3, $y4)) / $this->k;
                        $x = $x / $this->k;
                        $y = $this->h - $y / $this->k;
                    }
                }
            }
            $this->PageAnnots[$this->page][] = ["x" => $x, "y" => $y, "w" => $w, "h" => $h, "txt" => $text, "opt" => $opt, "numspaces" => $spaces];
            if ($opt["Subtype"] == "FileAttachment" && !$this->empty_string($opt["FS"]) && file_exists($opt["FS"]) && !isset($this->embeddedfiles[basename($opt["FS"])])) {
                $this->embeddedfiles[basename($opt["FS"])] = ["file" => $opt["FS"], "n" => count($this->embeddedfiles) + 100000];
            }
        }
        public function _putEmbeddedFiles()
        {
            reset($this->embeddedfiles);
            foreach ($this->embeddedfiles as $filename => $filedata) {
                $data = file_get_contents($filedata["file"]);
                $filter = "";
                if ($this->compress) {
                    $data = gzcompress($data);
                    $filter = " /Filter /FlateDecode";
                }
                $this->offsets[$filedata["n"]] = $this->bufferlen;
                $this->_out($filedata["n"] . " 0 obj");
                $this->_out("<</Type /EmbeddedFile" . $filter . " /Length " . strlen($data) . " >>");
                $this->_putstream($data);
                $this->_out("endobj");
            }
        }
        public function Text($x, $y, $txt, $stroke = 0, $clip = false)
        {
            if ($this->rtl) {
                $s = $this->utf8Bidi($this->UTF8StringToArray($txt), $txt, $this->tmprtl);
                $l = $this->GetArrStringWidth($s);
                $xr = $this->w - $x - $this->GetArrStringWidth($s);
            } else {
                $xr = $x;
            }
            $opt = "";
            if (0 < $stroke && !$clip) {
                $opt .= "1 Tr " . intval($stroke) . " w ";
            } else {
                if (0 < $stroke && $clip) {
                    $opt .= "5 Tr " . intval($stroke) . " w ";
                } else {
                    if ($clip) {
                        $opt .= "7 Tr ";
                    }
                }
            }
            $s = sprintf("BT %.2F %.2F Td %s(%s) Tj ET 0 Tr", $xr * $this->k, ($this->h - $y) * $this->k, $opt, $this->_escapetext($txt));
            if ($this->underline && $txt != "") {
                $s .= " " . $this->_dounderline($xr, $y, $txt);
            }
            if ($this->linethrough && $txt != "") {
                $s .= " " . $this->_dolinethrough($xr, $y, $txt);
            }
            if ($this->ColorFlag && !$clip) {
                $s = "q " . $this->TextColor . " " . $s . " Q";
            }
            $this->_out($s);
        }
        public function AcceptPageBreak()
        {
            return $this->AutoPageBreak;
        }
        public function checkPageBreak($h = 0, $y = "")
        {
            if ($this->empty_string($y)) {
                $y = $this->y;
            }
            if ($this->PageBreakTrigger < $y + $h && !$this->InFooter && $this->AcceptPageBreak()) {
                $x = $this->x;
                $this->AddPage($this->CurOrientation);
                $this->y = $this->tMargin;
                $oldpage = $this->page - 1;
                if ($this->rtl) {
                    if ($this->pagedim[$this->page]["orm"] != $this->pagedim[$oldpage]["orm"]) {
                        $this->x = $x - ($this->pagedim[$this->page]["orm"] - $this->pagedim[$oldpage]["orm"]);
                    } else {
                        $this->x = $x;
                    }
                } else {
                    if ($this->pagedim[$this->page]["olm"] != $this->pagedim[$oldpage]["olm"]) {
                        $this->x = $x + $this->pagedim[$this->page]["olm"] - $this->pagedim[$oldpage]["olm"];
                    } else {
                        $this->x = $x;
                    }
                }
                return true;
            }
            return false;
        }
        public function Cell($w, $h = 0, $txt = "", $border = 0, $ln = 0, $align = "", $fill = 0, $link = "", $stretch = 0, $ignore_min_height = false)
        {
            $min_cell_height = $this->FontSize * $this->cell_height_ratio;
            if ($h < $min_cell_height) {
                $h = $min_cell_height;
            }
            $this->checkPageBreak($h);
            $this->_out($this->getCellCode($w, $h, $txt, $border, $ln, $align, $fill, $link, $stretch, $ignore_min_height));
        }
        public function removeSHY($txt = "")
        {
            $txt = preg_replace("/([\\xc2]{1}[\\xad]{1})/", "", $txt);
            if (!$this->isunicode) {
                $txt = preg_replace("/([\\xad]{1})/", "", $txt);
            }
            return $txt;
        }
        public function getCellCode($w, $h = 0, $txt = "", $border = 0, $ln = 0, $align = "", $fill = 0, $link = "", $stretch = 0, $ignore_min_height = false)
        {
            $txt = $this->removeSHY($txt);
            $rs = "";
            if (!$ignore_min_height) {
                $min_cell_height = $this->FontSize * $this->cell_height_ratio;
                if ($h < $min_cell_height) {
                    $h = $min_cell_height;
                }
            }
            $k = $this->k;
            if ($this->empty_string($w) || $w <= 0) {
                if ($this->rtl) {
                    $w = $this->x - $this->lMargin;
                } else {
                    $w = $this->w - $this->rMargin - $this->x;
                }
            }
            $s = "";
            if ($fill == 1 || $border == 1) {
                if ($fill == 1) {
                    $op = $border == 1 ? "B" : "f";
                } else {
                    $op = "S";
                }
                if ($this->rtl) {
                    $xk = ($this->x - $w) * $k;
                } else {
                    $xk = $this->x * $k;
                }
                $s .= sprintf("%.2F %.2F %.2F %.2F re %s ", $xk, ($this->h - $this->y) * $k, $w * $k, -1 * $h * $k, $op);
            }
            if (is_string($border)) {
                $lm = $this->LineWidth / 2;
                $x = $this->x;
                $y = $this->y;
                if (strpos($border, "L") !== false) {
                    if ($this->rtl) {
                        $xk = ($x - $w) * $k;
                    } else {
                        $xk = $x * $k;
                    }
                    $s .= sprintf("%.2F %.2F m %.2F %.2F l S ", $xk, ($this->h - $y + $lm) * $k, $xk, ($this->h - ($y + $h + $lm)) * $k);
                }
                if (strpos($border, "T") !== false) {
                    if ($this->rtl) {
                        $xk = ($x - $w + $lm) * $k;
                        $xwk = ($x - $lm) * $k;
                    } else {
                        $xk = ($x - $lm) * $k;
                        $xwk = ($x + $w + $lm) * $k;
                    }
                    $s .= sprintf("%.2F %.2F m %.2F %.2F l S ", $xk, ($this->h - $y) * $k, $xwk, ($this->h - $y) * $k);
                }
                if (strpos($border, "R") !== false) {
                    if ($this->rtl) {
                        $xk = $x * $k;
                    } else {
                        $xk = ($x + $w) * $k;
                    }
                    $s .= sprintf("%.2F %.2F m %.2F %.2F l S ", $xk, ($this->h - $y + $lm) * $k, $xk, ($this->h - ($y + $h + $lm)) * $k);
                }
                if (strpos($border, "B") !== false) {
                    if ($this->rtl) {
                        $xk = ($x - $w + $lm) * $k;
                        $xwk = ($x - $lm) * $k;
                    } else {
                        $xk = ($x - $lm) * $k;
                        $xwk = ($x + $w + $lm) * $k;
                    }
                    $s .= sprintf("%.2F %.2F m %.2F %.2F l S ", $xk, ($this->h - ($y + $h)) * $k, $xwk, ($this->h - ($y + $h)) * $k);
                }
            }
            if ($txt != "") {
                $width = $this->GetStringWidth($txt);
                $ratio = ($w - 2 * $this->cMargin) / $width;
                if (0 < $stretch && ($ratio < 1 || 1 < $ratio && $stretch % 2 == 0)) {
                    if (2 < $stretch) {
                        $char_space = ($w - $width - 2 * $this->cMargin) * $this->k / max($this->GetNumChars($txt) - 1, 1);
                        $rs .= sprintf("BT %.2F Tc ET ", $char_space);
                    } else {
                        $horiz_scale = $ratio * 0;
                        $rs .= sprintf("BT %.2F Tz ET ", $horiz_scale);
                    }
                    $align = "";
                    $width = $w - 2 * $this->cMargin;
                } else {
                    $stretch == 0;
                }
                if ($align == "L") {
                    if ($this->rtl) {
                        $dx = $w - $width - $this->cMargin;
                    } else {
                        $dx = $this->cMargin;
                    }
                } else {
                    if ($align == "R") {
                        if ($this->rtl) {
                            $dx = $this->cMargin;
                        } else {
                            $dx = $w - $width - $this->cMargin;
                        }
                    } else {
                        if ($align == "C") {
                            $dx = ($w - $width) / 2;
                        } else {
                            if ($align == "J") {
                                if ($this->rtl) {
                                    $dx = $w - $width - $this->cMargin;
                                } else {
                                    $dx = $this->cMargin;
                                }
                            } else {
                                $dx = $this->cMargin;
                            }
                        }
                    }
                }
                if ($this->ColorFlag) {
                    $s .= "q " . $this->TextColor . " ";
                }
                $txt2 = $this->_escapetext($txt);
                if ($this->rtl) {
                    $xdk = ($this->x - $dx - $width) * $k;
                } else {
                    $xdk = ($this->x + $dx) * $k;
                }
                if ($align == "J") {
                    $ns = substr_count($txt, " ");
                    if ($this->CurrentFont["type"] == "TrueTypeUnicode" || $this->CurrentFont["type"] == "cidfont0") {
                        $width = $this->GetStringWidth(str_replace(" ", "", $txt));
                        $spacewidth = ($w - $width - 2 * $this->cMargin) / ($ns ? $ns : 1) / $this->FontSize / $this->k;
                        $txt2 = str_replace(chr(0) . " ", ") " . -2830 * $spacewidth . " (", $txt2);
                    } else {
                        $width = $this->GetStringWidth($txt);
                        $spacewidth = ($w - $width - 2 * $this->cMargin) / ($ns ? $ns : 1) * $this->k;
                        $rs .= sprintf("BT %.3F Tw ET ", $spacewidth);
                    }
                }
                $basefonty = $this->y + $h / 2 + $this->FontSize / 3;
                $s .= sprintf("BT %.2F %.2F Td [(%s)] TJ ET", $xdk, ($this->h - $basefonty) * $k, $txt2);
                if ($this->rtl) {
                    $xdx = $this->x - $dx - $width;
                } else {
                    $xdx = $this->x + $dx;
                }
                if ($this->underline) {
                    $s .= " " . $this->_dounderline($xdx, $basefonty, $txt);
                }
                if ($this->linethrough) {
                    $s .= " " . $this->_dolinethrough($xdx, $basefonty, $txt);
                }
                if ($this->ColorFlag) {
                    $s .= " Q";
                }
                if ($link) {
                    $this->Link($xdx, $this->y + ($h - $this->FontSize) / 2, $width, $this->FontSize, $link, substr_count($txt, chr(32)));
                }
            }
            if ($s) {
                $rs .= $s;
                if (2 < $stretch) {
                    $rs .= " BT 0 Tc ET";
                } else {
                    if (0 < $stretch) {
                        $rs .= " BT 100 Tz ET";
                    }
                }
            }
            if (!($this->CurrentFont["type"] == "TrueTypeUnicode" || $this->CurrentFont["type"] == "cidfont0") && $align == "J") {
                $rs .= " BT 0 Tw ET";
            }
            $this->lasth = $h;
            if (0 < $ln) {
                $this->y += $h;
                if ($ln == 1) {
                    if ($this->rtl) {
                        $this->x = $this->w - $this->rMargin;
                    } else {
                        $this->x = $this->lMargin;
                    }
                }
            } else {
                if ($this->rtl) {
                    $this->x -= $w;
                } else {
                    $this->x += $w;
                }
            }
            $gstyles = "" . $this->linestyleWidth . " " . $this->linestyleCap . " " . $this->linestyleJoin . " " . $this->linestyleDash . " " . $this->DrawColor . " " . $this->FillColor . "\n";
            $rs = $gstyles . $rs;
            return $rs;
        }
        public function MultiCell($w, $h, $txt, $border = 0, $align = "J", $fill = 0, $ln = 1, $x = "", $y = "", $reseth = true, $stretch = 0, $ishtml = false, $autopadding = true, $maxh = 0)
        {
            if ($this->empty_string($this->lasth) || $reseth) {
                $this->lasth = $this->FontSize * $this->cell_height_ratio;
            }
            if (!$this->empty_string($y)) {
                $this->SetY($y);
            } else {
                $y = $this->GetY();
            }
            $this->checkPageBreak($h);
            $y = $this->GetY();
            $startpage = $this->page;
            if (!$this->empty_string($x)) {
                $this->SetX($x);
            } else {
                $x = $this->GetX();
            }
            if ($this->empty_string($w) || $w <= 0) {
                if ($this->rtl) {
                    $w = $this->x - $this->lMargin;
                } else {
                    $w = $this->w - $this->rMargin - $this->x;
                }
            }
            $lMargin = $this->lMargin;
            $rMargin = $this->rMargin;
            if ($this->rtl) {
                $this->SetRightMargin($this->w - $this->x);
                $this->SetLeftMargin($this->x - $w);
            } else {
                $this->SetLeftMargin($this->x);
                $this->SetRightMargin($this->w - $this->x - $w);
            }
            $starty = $this->y;
            if ($autopadding) {
                if ($this->cMargin < $this->LineWidth / 2) {
                    $this->cMargin = $this->LineWidth / 2;
                }
                if ($this->lasth - $this->FontSize < $this->LineWidth) {
                    $this->y += $this->LineWidth / 2;
                }
                $this->y += $this->cMargin;
            }
            if ($ishtml) {
                $this->writeHTML($txt, true, 0, $reseth, true, $align);
                $nl = 1;
            } else {
                $nl = $this->Write($this->lasth, $txt, "", 0, $align, true, $stretch, false, false, $maxh);
            }
            if ($autopadding) {
                $this->y += $this->cMargin;
                if ($this->lasth - $this->FontSize < $this->LineWidth) {
                    $this->y += $this->LineWidth / 2;
                }
            }
            $currentY = $this->y;
            $endpage = $this->page;
            if ($startpage < $endpage) {
                for ($page = $startpage; $page <= $endpage; $page++) {
                    $this->setPage($page);
                    if ($page == $startpage) {
                        $this->y = $starty;
                        $h = $this->getPageHeight() - $starty - $this->getBreakMargin();
                        $cborder = $this->getBorderMode($border, $position = "start");
                    } else {
                        if ($page == $endpage) {
                            $this->y = $this->tMargin;
                            $h = $currentY - $this->tMargin;
                            $cborder = $this->getBorderMode($border, $position = "end");
                        } else {
                            $this->y = $this->tMargin;
                            $h = $this->getPageHeight() - $this->tMargin - $this->getBreakMargin();
                            $cborder = $this->getBorderMode($border, $position = "middle");
                        }
                    }
                    $nx = $x;
                    if ($startpage < $page) {
                        if ($this->rtl && $this->pagedim[$page]["orm"] != $this->pagedim[$startpage]["orm"]) {
                            $nx = $x + $this->pagedim[$page]["orm"] - $this->pagedim[$startpage]["orm"];
                        } else {
                            if (!$this->rtl && $this->pagedim[$page]["olm"] != $this->pagedim[$startpage]["olm"]) {
                                $nx = $x + $this->pagedim[$page]["olm"] - $this->pagedim[$startpage]["olm"];
                            }
                        }
                    }
                    $this->SetX($nx);
                    $ccode = $this->getCellCode($w, $h, "", $cborder, 1, "", $fill, "", 0, false);
                    if ($cborder || $fill) {
                        $pagebuff = $this->getPageBuffer($this->page);
                        $pstart = substr($pagebuff, 0, $this->intmrk[$this->page]);
                        $pend = substr($pagebuff, $this->intmrk[$this->page]);
                        $this->setPageBuffer($this->page, $pstart . $ccode . "\n" . $pend);
                        $this->intmrk[$this->page] += strlen($ccode . "\n");
                    }
                }
            } else {
                $h = max($h, $currentY - $y);
                $this->SetY($y);
                $this->SetX($x);
                $ccode = $this->getCellCode($w, $h, "", $border, 1, "", $fill, "", 0, true);
                if ($border || $fill) {
                    if (end($this->transfmrk[$this->page]) !== false) {
                        $pagemarkkey = key($this->transfmrk[$this->page]);
                        $pagemark =& $this->transfmrk[$this->page][$pagemarkkey];
                    } else {
                        if ($this->InFooter) {
                            $pagemark =& $this->footerpos[$this->page];
                        } else {
                            $pagemark =& $this->intmrk[$this->page];
                        }
                    }
                    $pagebuff = $this->getPageBuffer($this->page);
                    $pstart = substr($pagebuff, 0, $pagemark);
                    $pend = substr($pagebuff, $pagemark);
                    $this->setPageBuffer($this->page, $pstart . $ccode . "\n" . $pend);
                    $pagemark += strlen($ccode . "\n");
                }
            }
            $currentY = $this->GetY();
            $this->SetLeftMargin($lMargin);
            $this->SetRightMargin($rMargin);
            if (0 < $ln) {
                $this->SetY($currentY);
                if ($ln == 2) {
                    $this->SetX($x + $w);
                }
            } else {
                $this->setPage($startpage);
                $this->y = $y;
                $this->SetX($x + $w);
            }
            return $nl;
        }
        public function getBorderMode($border, $position = "start")
        {
            while (!$this->opencell && $border == 1) {
                $cborder = "";
                switch ($position) {
                    case "start":
                        if ($border == 1) {
                            $cborder = "LTR";
                        } else {
                            if (false !== strpos($border, "L")) {
                                $cborder .= "L";
                            }
                            if (false !== strpos($border, "T")) {
                                $cborder .= "T";
                            }
                            if (false !== strpos($border, "R")) {
                                $cborder .= "R";
                            }
                            if (!$this->opencell && false !== strpos($border, "B")) {
                                $cborder .= "B";
                            }
                        }
                        break;
                    case "middle":
                        if ($border == 1) {
                            $cborder = "LR";
                        } else {
                            if (false !== strpos($border, "L")) {
                                $cborder .= "L";
                            }
                            if (!$this->opencell && false !== strpos($border, "T")) {
                                $cborder .= "T";
                            }
                            if (false !== strpos($border, "R")) {
                                $cborder .= "R";
                            }
                            if (!$this->opencell && false !== strpos($border, "B")) {
                                $cborder .= "B";
                            }
                        }
                        break;
                    case "end":
                        if ($border == 1) {
                            $cborder = "LRB";
                        } else {
                            if (false !== strpos($border, "L")) {
                                $cborder .= "L";
                            }
                            if (!$this->opencell && false !== strpos($border, "T")) {
                                $cborder .= "T";
                            }
                            if (false !== strpos($border, "R")) {
                                $cborder .= "R";
                            }
                            if (false !== strpos($border, "B")) {
                                $cborder .= "B";
                            }
                        }
                        break;
                    default:
                        $cborder = $border;
                        return $cborder;
                }
            }
            return 1;
        }
        public function getNumLines($txt, $w = 0)
        {
            $lines = 0;
            if ($this->empty_string($w) || $w <= 0) {
                if ($this->rtl) {
                    $w = $this->x - $this->lMargin;
                } else {
                    $w = $this->w - $this->rMargin - $this->x;
                }
            }
            $wmax = $w - 2 * $this->cMargin;
            $txt = str_replace("\r", "", $txt);
            if (substr($txt, -1) == "\n") {
                $txt = substr($txt, 0, -1);
            }
            $txtblocks = explode("\n", $txt);
            foreach ($txtblocks as $block) {
                $lines += $this->empty_string($block) ? 1 : ceil($this->GetStringWidth($block) / $wmax);
            }
            return $lines;
        }
        public function Write($h, $txt, $link = "", $fill = 0, $align = "", $ln = false, $stretch = 0, $firstline = false, $firstblock = false, $maxh = 0)
        {
            while (strlen($txt) == 0) {
                $txt = " ";
            }
            $s = str_replace("\r", "", $txt);
            if (preg_match(K_RE_PATTERN_ARABIC, $s)) {
                $arabic = true;
            } else {
                $arabic = false;
            }
            if ($arabic || $this->tmprtl || preg_match(K_RE_PATTERN_RTL, $txt)) {
                $rtlmode = true;
            } else {
                $rtlmode = false;
            }
            $chrwidth = $this->GetCharWidth(".");
            $chars = $this->UTF8StringToArray($s);
            $uchars = $this->UTF8ArrayToUniArray($chars);
            $nb = count($chars);
            $shy_replacement = 45;
            $shy_replacement_char = $this->unichr($shy_replacement);
            $shy_replacement_width = $this->GetCharWidth($shy_replacement);
            $prevx = $this->x;
            $prevy = $this->y;
            $maxy = $this->y + $maxh - $h - 2 * $this->cMargin;
            if ($this->rtl) {
                $w = $this->x - $this->lMargin;
            } else {
                $w = $this->w - $this->rMargin - $this->x;
            }
            $wmax = $w - 2 * $this->cMargin;
            if ($wmax < $chrwidth || $wmax < $this->GetCharWidth($chars[0])) {
                return "";
            }
            $i = 0;
            $j = 0;
            $sep = -1;
            $shy = false;
            $l = 0;
            $nl = 0;
            for ($linebreak = false; $i < $nb; $i++) {
                if (0 < $maxh && $maxy <= $this->y) {
                    $firstline = true;
                }
                $c = $chars[$i];
                if ($c == 10) {
                    if ($align == "J") {
                        if ($this->rtl) {
                            $talign = "R";
                        } else {
                            $talign = "L";
                        }
                    } else {
                        $talign = $align;
                    }
                    $tmpstr = $this->UniArrSubString($uchars, $j, $i);
                    if ($firstline) {
                        $startx = $this->x;
                        $tmparr = array_slice($chars, $j, $i);
                        if ($rtlmode) {
                            $tmparr = $this->utf8Bidi($tmparr, $tmpstr, $this->tmprtl);
                        }
                        $linew = $this->GetArrStringWidth($tmparr);
                        unset($tmparr);
                        if ($this->rtl) {
                            $this->endlinex = $startx - $linew;
                        } else {
                            $this->endlinex = $startx + $linew;
                        }
                        $w = $linew;
                        $tmpcmargin = $this->cMargin;
                        if ($maxh == 0) {
                            $this->cMargin = 0;
                        }
                    }
                    $this->Cell($w, $h, $tmpstr, 0, 1, $talign, $fill, $link, $stretch);
                    unset($tmpstr);
                    if ($firstline) {
                        $this->cMargin = $tmpcmargin;
                        return $this->UniArrSubString($uchars, $i);
                    }
                    $nl++;
                    $j = $i + 1;
                    $l = 0;
                    $sep = -1;
                    $shy = false;
                    if ($this->PageBreakTrigger < $this->y + $this->lasth && !$this->InFooter) {
                        $this->AcceptPageBreak();
                    }
                    $w = $this->getRemainingWidth();
                    $wmax = $w - 2 * $this->cMargin;
                } else {
                    if ($c != 160 && ($c == 173 || preg_match($this->re_spaces, $this->unichr($c)))) {
                        $sep = $i;
                        if ($c == 173) {
                            $shy = true;
                        } else {
                            $shy = false;
                        }
                    }
                    if (($this->CurrentFont["type"] == "TrueTypeUnicode" || $this->CurrentFont["type"] == "cidfont0") && $arabic) {
                        $l = $this->GetArrStringWidth($this->utf8Bidi(array_slice($chars, $j, $i - $j + 1), "", $this->tmprtl));
                    } else {
                        $l += $this->GetCharWidth($c);
                    }
                    if ($wmax < $l || $shy && $wmax < $l + $shy_replacement_width) {
                        if ($sep == -1) {
                            if ($this->rtl && $this->x <= $this->w - $this->rMargin - $chrwidth || !$this->rtl && $this->lMargin + $chrwidth <= $this->x) {
                                $this->Cell($w, $h, "", 0, 1);
                                $linebreak = true;
                                if ($firstline) {
                                    return $this->UniArrSubString($uchars, $j);
                                }
                            } else {
                                $tmpstr = $this->UniArrSubString($uchars, $j, $i);
                                if ($firstline) {
                                    $startx = $this->x;
                                    $tmparr = array_slice($chars, $j, $i);
                                    if ($rtlmode) {
                                        $tmparr = $this->utf8Bidi($tmparr, $tmpstr, $this->tmprtl);
                                    }
                                    $linew = $this->GetArrStringWidth($tmparr);
                                    unset($tmparr);
                                    if ($this->rtl) {
                                        $this->endlinex = $startx - $linew;
                                    } else {
                                        $this->endlinex = $startx + $linew;
                                    }
                                    $w = $linew;
                                    $tmpcmargin = $this->cMargin;
                                    if ($maxh == 0) {
                                        $this->cMargin = 0;
                                    }
                                }
                                $this->Cell($w, $h, $tmpstr, 0, 1, $align, $fill, $link, $stretch);
                                unset($tmpstr);
                                if ($firstline) {
                                    $this->cMargin = $tmpcmargin;
                                    return $this->UniArrSubString($uchars, $i);
                                }
                                $j = $i;
                                --$i;
                            }
                        } else {
                            if ($this->rtl && !$firstblock) {
                                $endspace = 1;
                            } else {
                                $endspace = 0;
                            }
                            if ($shy) {
                                $shy_width = $shy_replacement_width;
                                if ($this->rtl) {
                                    $shy_char_left = $shy_replacement_char;
                                    $shy_char_right = "";
                                } else {
                                    $shy_char_left = "";
                                    $shy_char_right = $shy_replacement_char;
                                }
                            } else {
                                $shy_width = 0;
                                $shy_char_left = "";
                                $shy_char_right = "";
                            }
                            $tmpstr = $this->UniArrSubString($uchars, $j, $sep + $endspace);
                            if ($firstline) {
                                $startx = $this->x;
                                $tmparr = array_slice($chars, $j, $sep + $endspace);
                                if ($rtlmode) {
                                    $tmparr = $this->utf8Bidi($tmparr, $tmpstr, $this->tmprtl);
                                }
                                $linew = $this->GetArrStringWidth($tmparr);
                                unset($tmparr);
                                if ($this->rtl) {
                                    $this->endlinex = $startx - $linew - $shy_width;
                                } else {
                                    $this->endlinex = $startx + $linew + $shy_width;
                                }
                                $w = $linew;
                                $tmpcmargin = $this->cMargin;
                                if ($maxh == 0) {
                                    $this->cMargin = 0;
                                }
                            }
                            $this->Cell($w, $h, $shy_char_left . $tmpstr . $shy_char_right, 0, 1, $align, $fill, $link, $stretch);
                            unset($tmpstr);
                            if ($firstline) {
                                $this->cMargin = $tmpcmargin;
                                return $this->UniArrSubString($uchars, $sep + $endspace);
                            }
                            $i = $sep;
                            $sep = -1;
                            $shy = false;
                            $j = $i + 1;
                        }
                        if ($this->PageBreakTrigger < $this->y + $this->lasth && !$this->InFooter) {
                            $this->AcceptPageBreak();
                        }
                        $w = $this->getRemainingWidth();
                        $wmax = $w - 2 * $this->cMargin;
                        if ($linebreak) {
                            $linebreak = false;
                        } else {
                            $nl++;
                            $l = 0;
                        }
                    }
                }
            }
            if (0 < $l) {
                switch ($align) {
                    case "J":
                    case "C":
                        $w = $w;
                        break;
                    case "L":
                        if ($this->rtl) {
                            $w = $w;
                        } else {
                            $w = $l;
                        }
                        break;
                    case "R":
                        if ($this->rtl) {
                            $w = $l;
                        } else {
                            $w = $w;
                        }
                        break;
                    default:
                        $w = $l;
                        $tmpstr = $this->UniArrSubString($uchars, $j, $nb);
                        if ($firstline) {
                            $startx = $this->x;
                            $tmparr = array_slice($chars, $j, $nb);
                            if ($rtlmode) {
                                $tmparr = $this->utf8Bidi($tmparr, $tmpstr, $this->tmprtl);
                            }
                            $linew = $this->GetArrStringWidth($tmparr);
                            unset($tmparr);
                            if ($this->rtl) {
                                $this->endlinex = $startx - $linew;
                            } else {
                                $this->endlinex = $startx + $linew;
                            }
                            $w = $linew;
                            $tmpcmargin = $this->cMargin;
                            if ($maxh == 0) {
                                $this->cMargin = 0;
                            }
                        }
                        $this->Cell($w, $h, $tmpstr, 0, $ln, $align, $fill, $link, $stretch);
                        unset($tmpstr);
                        if ($firstline) {
                            $this->cMargin = $tmpcmargin;
                            return $this->UniArrSubString($uchars, $nb);
                        }
                        $nl++;
                }
            }
            if ($firstline) {
                return "";
            }
            return $nl;
        }
        public function getRemainingWidth()
        {
            if ($this->rtl) {
                return $this->x - $this->lMargin;
            }
            return $this->w - $this->rMargin - $this->x;
        }
        public function UTF8ArrSubString($strarr, $start = "", $end = "")
        {
            if (strlen($start) == 0) {
                $start = 0;
            }
            if (strlen($end) == 0) {
                $end = count($strarr);
            }
            $string = "";
            for ($i = $start; $i < $end; $i++) {
                $string .= $this->unichr($strarr[$i]);
            }
            return $string;
        }
        public function UniArrSubString($uniarr, $start = "", $end = "")
        {
            if (strlen($start) == 0) {
                $start = 0;
            }
            if (strlen($end) == 0) {
                $end = count($uniarr);
            }
            $string = "";
            for ($i = $start; $i < $end; $i++) {
                $string .= $uniarr[$i];
            }
            return $string;
        }
        public function UTF8ArrayToUniArray($ta)
        {
            return array_map([$this, "unichr"], $ta);
        }
        public function unichr($c)
        {
            if (!$this->isunicode) {
                return chr($c);
            }
            if ($c <= 127) {
                return chr($c);
            }
            if ($c <= 2047) {
                return chr(192 | $c >> 6) . chr(128 | $c & 63);
            }
            if ($c <= 65535) {
                return chr(224 | $c >> 12) . chr(128 | $c >> 6 & 63) . chr(128 | $c & 63);
            }
            if ($c <= 1114111) {
                return chr(240 | $c >> 18) . chr(128 | $c >> 12 & 63) . chr(128 | $c >> 6 & 63) . chr(128 | $c & 63);
            }
            return "";
        }
        public function Image($file, $x = "", $y = "", $w = 0, $h = 0, $type = "", $link = "", $align = "", $resize = false, $dpi = 300, $palign = "", $ismask = false, $imgmask = false, $border = 0, $fitbox = false)
        {
            while ($x === "") {
                $x = $this->x;
            }
            if ($y === "") {
                $y = $this->y;
            }
            $imsize = getimagesize($file);
            if ($imsize === false) {
                $file = str_replace(" ", "%20", $file);
                $imsize = getimagesize($file);
            }
            if ($imsize === false) {
                $this->Error("[Image] No such file or directory in " . $file);
            }
            list($pixw, $pixh) = $imsize;
            if ($w <= 0 && $h <= 0) {
                $w = $this->pixelsToUnits($pixw);
                $h = $this->pixelsToUnits($pixh);
            } else {
                if ($w <= 0) {
                    $w = $h * $pixw / $pixh;
                } else {
                    if ($h <= 0) {
                        $h = $w * $pixh / $pixw;
                    } else {
                        if ($fitbox && 0 < $w && 0 < $h) {
                            if ($w * $pixh / ($h * $pixw) < 1) {
                                $h = $w * $pixh / $pixw;
                            } else {
                                $w = $h * $pixw / $pixh;
                            }
                        }
                    }
                }
            }
            $neww = round($w * $this->k * $dpi / $this->dpi);
            $newh = round($h * $this->k * $dpi / $this->dpi);
            if ($pixw * $pixh <= $neww * $newh) {
                $resize = false;
            }
            if (!in_array($file, $this->imagekeys)) {
                if ($type == "") {
                    $fileinfo = pathinfo($file);
                    if (isset($fileinfo["extension"]) && !$this->empty_string($fileinfo["extension"])) {
                        $type = $fileinfo["extension"];
                    } else {
                        $this->Error("Image file has no extension and no type was specified: " . $file);
                    }
                }
                $type = strtolower($type);
                if ($type == "jpg") {
                    $type = "jpeg";
                }
                ini_set("magic_quotes_runtime", 0);
                $mtd = "_parse" . $type;
                $gdfunction = "imagecreatefrom" . $type;
                $info = false;
                if (method_exists($this, $mtd) && !($resize && function_exists($gdfunction))) {
                    $info = $this->{$mtd}($file);
                    if ($info == "pngalpha") {
                        return $this->ImagePngAlpha($file, $x, $y, $w, $h, "PNG", $link, $align, $resize, $dpi, $palign);
                    }
                }
                if (!$info) {
                    if (function_exists($gdfunction)) {
                        $img = $gdfunction($file);
                        if ($resize) {
                            $imgr = imagecreatetruecolor($neww, $newh);
                            imagecopyresampled($imgr, $img, 0, 0, 0, 0, $neww, $newh, $pixw, $pixh);
                            $info = $this->_toJPEG($imgr);
                        } else {
                            $info = $this->_toJPEG($img);
                        }
                    } else {
                        if (extension_loaded("imagick")) {
                            $img = new Imagick();
                            $img->readImage($file);
                            if ($resize) {
                                $img->resizeImage($neww, $newh, 10, 1, false);
                            }
                            $img->setCompressionQuality($this->jpeg_quality);
                            $img->setImageFormat("jpeg");
                            $tempname = tempnam(K_PATH_CACHE, "jpg_");
                            $img->writeImage($tempname);
                            $info = $this->_parsejpeg($tempname);
                            unlink($tempname);
                            $img->destroy();
                        } else {
                            return NULL;
                        }
                    }
                }
                if ($info === false) {
                    return NULL;
                }
                if ($ismask) {
                    $info["cs"] = "DeviceGray";
                }
                $info["i"] = $this->numimages + 1;
                if ($imgmask !== false) {
                    $info["masked"] = $imgmask;
                }
                $this->setImageBuffer($file, $info);
            } else {
                $info = $this->getImageBuffer($file);
            }
            if ($this->checkPageBreak($h, $y)) {
                $y = $this->GetY() + $this->cMargin;
            }
            $this->img_rb_y = $y + $h;
            if ($this->rtl) {
                if ($palign == "L") {
                    $ximg = $this->lMargin;
                    $this->img_rb_x = $ximg + $w;
                } else {
                    if ($palign == "C") {
                        $ximg = ($this->w - $x - $w) / 2;
                        $this->img_rb_x = $ximg + $w;
                    } else {
                        $ximg = $this->w - $x - $w;
                        $this->img_rb_x = $ximg;
                    }
                }
            } else {
                if ($palign == "R") {
                    $ximg = $this->w - $this->rMargin - $w;
                    $this->img_rb_x = $ximg;
                } else {
                    if ($palign == "C") {
                        $ximg = ($this->w - $x - $w) / 2;
                        $this->img_rb_x = $ximg + $w;
                    } else {
                        $ximg = $x;
                        $this->img_rb_x = $ximg + $w;
                    }
                }
            }
            if ($ismask) {
                $xkimg = $this->pagedim[$this->page]["w"] + 10;
            } else {
                $xkimg = $ximg * $this->k;
            }
            $this->_out(sprintf("q %.2F 0 0 %.2F %.2F %.2F cm /I%d Do Q", $w * $this->k, $h * $this->k, $xkimg, ($this->h - ($y + $h)) * $this->k, $info["i"]));
            if (!empty($border)) {
                $bx = $x;
                $by = $y;
                $this->x = $ximg;
                $this->y = $y;
                $this->Cell($w, $h, "", $border, 0, "", 0, "", 0);
                $this->x = $bx;
                $this->y = $by;
            }
            if ($link) {
                $this->Link($ximg, $y, $w, $h, $link, 0);
            }
            switch ($align) {
                case "T":
                    $this->y = $y;
                    $this->x = $this->img_rb_x;
                    break;
                case "M":
                    $this->y = $y + round($h / 2);
                    $this->x = $this->img_rb_x;
                    break;
                case "B":
                    $this->y = $this->img_rb_y;
                    $this->x = $this->img_rb_x;
                    break;
                case "N":
                    $this->SetY($this->img_rb_y);
                    break;
                default:
                    $this->endlinex = $this->img_rb_x;
                    return $info["i"];
            }
        }
        public function _toJPEG($image)
        {
            $tempname = tempnam(K_PATH_CACHE, "jpg_");
            imagejpeg($image, $tempname, $this->jpeg_quality);
            imagedestroy($image);
            $retvars = $this->_parsejpeg($tempname);
            unlink($tempname);
            return $retvars;
        }
        public function _parsejpeg($file)
        {
            $a = getimagesize($file);
            if (empty($a)) {
                $this->Error("Missing or incorrect image file: " . $file);
            }
            if ($a[2] != 2) {
                $this->Error("Not a JPEG file: " . $file);
            }
            if (!isset($a["channels"]) || $a["channels"] == 3) {
                $colspace = "DeviceRGB";
            } else {
                if ($a["channels"] == 4) {
                    $colspace = "DeviceCMYK";
                } else {
                    $colspace = "DeviceGray";
                }
            }
            $bpc = isset($a["bits"]) ? $a["bits"] : 8;
            $data = file_get_contents($file);
            return ["w" => $a[0], "h" => $a[1], "cs" => $colspace, "bpc" => $bpc, "f" => "DCTDecode", "data" => $data];
        }
        public function _parsepng($file)
        {
            $f = fopen($file, "rb");
            if ($f === false) {
                $this->Error("Can't open image file: " . $file);
            }
            if (fread($f, 8) != chr(137) . "PNG" . chr(13) . chr(10) . chr(26) . chr(10)) {
                $this->Error("Not a PNG file: " . $file);
            }
            fread($f, 4);
            if (fread($f, 4) != "IHDR") {
                $this->Error("Incorrect PNG file: " . $file);
            }
            $w = $this->_freadint($f);
            $h = $this->_freadint($f);
            $bpc = ord(fread($f, 1));
            if (8 < $bpc) {
                fclose($f);
                return false;
            }
            $ct = ord(fread($f, 1));
            if ($ct == 0) {
                $colspace = "DeviceGray";
            } else {
                if ($ct == 2) {
                    $colspace = "DeviceRGB";
                } else {
                    if ($ct == 3) {
                        $colspace = "Indexed";
                    } else {
                        fclose($f);
                        return "pngalpha";
                    }
                }
            }
            if (ord(fread($f, 1)) != 0) {
                fclose($f);
                return false;
            }
            if (ord(fread($f, 1)) != 0) {
                fclose($f);
                return false;
            }
            if (ord(fread($f, 1)) != 0) {
                fclose($f);
                return false;
            }
            fread($f, 4);
            $parms = "/DecodeParms <</Predictor 15 /Colors " . ($ct == 2 ? 3 : 1) . " /BitsPerComponent " . $bpc . " /Columns " . $w . ">>";
            $pal = "";
            $trns = "";
            do {
                $data = "";
                $n = $this->_freadint($f);
                $type = fread($f, 4);
                if ($type == "PLTE") {
                    $pal = $this->rfread($f, $n);
                    fread($f, 4);
                } else {
                    if ($type == "tRNS") {
                        $t = $this->rfread($f, $n);
                        if ($ct == 0) {
                            $trns = [ord(substr($t, 1, 1))];
                        } else {
                            if ($ct == 2) {
                                $trns = [ord(substr($t, 1, 1)), ord(substr($t, 3, 1)), ord(substr($t, 5, 1))];
                            } else {
                                $pos = strpos($t, chr(0));
                                if ($pos !== false) {
                                    $trns = [$pos];
                                }
                            }
                        }
                        fread($f, 4);
                    } else {
                        if ($type == "IDAT") {
                            $data .= $this->rfread($f, $n);
                            fread($f, 4);
                        } else {
                            if ($type != "IEND") {
                                $this->rfread($f, $n + 4);
                            }
                        }
                    }
                }
            } while (!$n);
            if ($colspace == "Indexed" && empty($pal)) {
                fclose($f);
                return false;
            }
            fclose($f);
            return ["w" => $w, "h" => $h, "cs" => $colspace, "bpc" => $bpc, "f" => "FlateDecode", "parms" => $parms, "pal" => $pal, "trns" => $trns, "data" => $data];
        }
        public function rfread($handle, $length)
        {
            $data = fread($handle, $length);
            if ($data === false) {
                return false;
            }
            $rest = $length - strlen($data);
            if (0 < $rest) {
                $data .= $this->rfread($handle, $rest);
            }
            return $data;
        }
        public function ImagePngAlpha($file, $x = "", $y = "", $w = 0, $h = 0, $type = "", $link = "", $align = "", $resize = false, $dpi = 300, $palign = "")
        {
            list($wpx, $hpx) = getimagesize($file);
            $img = imagecreatefrompng($file);
            $imgalpha = imagecreate($wpx, $hpx);
            for ($c = 0; $c < 256; $c++) {
                ImageColorAllocate($imgalpha, $c, $c, $c);
            }
            for ($xpx = 0; $xpx < $wpx; $xpx++) {
                for ($ypx = 0; $ypx < $hpx; $ypx++) {
                    $colorindex = imagecolorat($img, $xpx, $ypx);
                    $col = imagecolorsforindex($img, $colorindex);
                    imagesetpixel($imgalpha, $xpx, $ypx, $this->getGDgamma((127 - $col["alpha"]) * 255 / 127));
                }
            }
            $tempfile_alpha = tempnam(K_PATH_CACHE, "mska_");
            imagepng($imgalpha, $tempfile_alpha);
            imagedestroy($imgalpha);
            $imgplain = imagecreatetruecolor($wpx, $hpx);
            imagecopy($imgplain, $img, 0, 0, 0, 0, $wpx, $hpx);
            $tempfile_plain = tempnam(K_PATH_CACHE, "mskp_");
            imagepng($imgplain, $tempfile_plain);
            imagedestroy($imgplain);
            $imgmask = $this->Image($tempfile_alpha, $x, $y, $w, $h, "PNG", "", "", $resize, $dpi, "", true, false);
            $this->Image($tempfile_plain, $x, $y, $w, $h, $type, $link, $align, $resize, $dpi, $palign, false, $imgmask);
            unlink($tempfile_alpha);
            unlink($tempfile_plain);
        }
        public function getGDgamma($v)
        {
            return pow($v / 255, 0) * 255;
        }
        public function Ln($h = "", $cell = false)
        {
            if ($cell) {
                $cellmargin = $this->cMargin;
            } else {
                $cellmargin = 0;
            }
            if ($this->rtl) {
                $this->x = $this->w - $this->rMargin - $cellmargin;
            } else {
                $this->x = $this->lMargin + $cellmargin;
            }
            if (is_string($h)) {
                $this->y += $this->lasth;
            } else {
                $this->y += $h;
            }
            $this->newline = true;
        }
        public function GetX()
        {
            if ($this->rtl) {
                return $this->w - $this->x;
            }
            return $this->x;
        }
        public function GetAbsX()
        {
            return $this->x;
        }
        public function GetY()
        {
            return $this->y;
        }
        public function SetX($x)
        {
            if ($this->rtl) {
                if (0 <= $x) {
                    $this->x = $this->w - $x;
                } else {
                    $this->x = abs($x);
                }
            } else {
                if (0 <= $x) {
                    $this->x = $x;
                } else {
                    $this->x = $this->w + $x;
                }
            }
            if ($this->x < 0) {
                $this->x = 0;
            }
            if ($this->w < $this->x) {
                $this->x = $this->w;
            }
        }
        public function SetY($y, $resetx = true)
        {
            if ($resetx) {
                if ($this->rtl) {
                    $this->x = $this->w - $this->rMargin;
                } else {
                    $this->x = $this->lMargin;
                }
            }
            if (0 <= $y) {
                $this->y = $y;
            } else {
                $this->y = $this->h + $y;
            }
            if ($this->y < 0) {
                $this->y = 0;
            }
            if ($this->h < $this->y) {
                $this->y = $this->h;
            }
        }
        public function SetXY($x, $y)
        {
            $this->SetY($y);
            $this->SetX($x);
        }
        public function Output($name = "doc.pdf", $dest = "I")
        {
            while ($this->state < 3) {
                $this->Close();
            }
            if (is_bool($dest)) {
                $dest = $dest ? "D" : "F";
            }
            $dest = strtoupper($dest);
            if ($dest != "F") {
                $name = preg_replace("/[\\s]+/", "_", $name);
                $name = preg_replace("/[^a-zA-Z0-9_\\.-]/", "", $name);
            }
            if ($this->sign) {
                $pdfdoc = $this->getBuffer();
                $pdfdoc = substr($pdfdoc, 0, -1);
                if (isset($this->diskcache) && $this->diskcache) {
                    unlink($this->buffer);
                }
                unset($this->buffer);
                $tmppos = strpos($pdfdoc, "/ByteRange[0 ********** ********** **********]") + 58;
                $pdfdoc = substr($pdfdoc, 0, $tmppos) . substr($pdfdoc, $tmppos + $this->signature_max_lenght);
                $byte_range = [];
                $byte_range[0] = 0;
                $byte_range[1] = $tmppos - 1;
                $byte_range[2] = $byte_range[1] + $this->signature_max_lenght;
                $byte_range[3] = strlen($pdfdoc) - $byte_range[1];
                $byterange = sprintf("/ByteRange[0 %010u %010u %010u]", $byte_range[1], $byte_range[2], $byte_range[3]);
                $pdfdoc = str_replace("/ByteRange[0 ********** ********** **********]", $byterange, $pdfdoc);
                $tempdoc = tempnam(K_PATH_CACHE, "tmppdf_");
                $f = fopen($tempdoc, "wb");
                if (!$f) {
                    $this->Error("Unable to create temporary file: " . $tempdoc);
                }
                $pdfdoc_lenght = strlen($pdfdoc);
                fwrite($f, $pdfdoc, $pdfdoc_lenght);
                fclose($f);
                $tempsign = tempnam(K_PATH_CACHE, "tmpsig_");
                if (empty($this->signature_data["extracerts"])) {
                    openssl_pkcs7_sign($tempdoc, $tempsign, $this->signature_data["signcert"], [$this->signature_data["privkey"], $this->signature_data["password"]], [], PKCS7_BINARY | PKCS7_DETACHED);
                } else {
                    openssl_pkcs7_sign($tempdoc, $tempsign, $this->signature_data["signcert"], [$this->signature_data["privkey"], $this->signature_data["password"]], [], PKCS7_BINARY | PKCS7_DETACHED, $this->signature_data["extracerts"]);
                }
                unlink($tempdoc);
                $signature = file_get_contents($tempsign, false, NULL, $pdfdoc_lenght);
                unlink($tempsign);
                $signature = substr($signature, strpos($signature, "%%EOF\n\n------") + 13);
                $tmparr = explode("\n\n", $signature);
                $signature = $tmparr[1];
                unset($tmparr);
                $signature = base64_decode(trim($signature));
                $signature = current(unpack("H*", $signature));
                $signature = str_pad($signature, $this->signature_max_lenght, "0");
                $pdfdoc = substr($pdfdoc, 0, $byte_range[1]) . $signature . substr($pdfdoc, 0 - $byte_range[3]);
                $this->diskcache = false;
                $this->buffer =& $pdfdoc;
                $this->bufferlen = strlen($pdfdoc);
            }
            switch ($dest) {
                case "I":
                    if (ob_get_contents()) {
                        $this->Error("Some data has already been output, can't send PDF file");
                    }
                    if (php_sapi_name() != "cli") {
                        header("Content-Type: application/pdf");
                        if (headers_sent()) {
                            $this->Error("Some data has already been output to browser, can't send PDF file");
                        }
                        header("Cache-Control: public, must-revalidate, max-age=0");
                        header("Pragma: public");
                        header("Expires: Sat, 26 Jul 1997 05:00:00 GMT");
                        header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
                        header("Content-Length: " . $this->bufferlen);
                        header("Content-Disposition: inline; filename=\"" . basename($name) . "\";");
                    }
                    echo $this->getBuffer();
                    break;
                case "D":
                    if (ob_get_contents()) {
                        $this->Error("Some data has already been output, can't send PDF file");
                    }
                    header("Content-Description: File Transfer");
                    if (headers_sent()) {
                        $this->Error("Some data has already been output to browser, can't send PDF file");
                    }
                    header("Cache-Control: public, must-revalidate, max-age=0");
                    header("Pragma: public");
                    header("Expires: Sat, 26 Jul 1997 05:00:00 GMT");
                    header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
                    header("Content-Type: application/force-download");
                    header("Content-Type: application/octet-stream", false);
                    header("Content-Type: application/download", false);
                    header("Content-Type: application/pdf", false);
                    header("Content-Disposition: attachment; filename=\"" . basename($name) . "\";");
                    header("Content-Transfer-Encoding: binary");
                    header("Content-Length: " . $this->bufferlen);
                    echo $this->getBuffer();
                    break;
                case "F":
                    if ($this->diskcache) {
                        copy($this->buffer, $name);
                    } else {
                        $f = fopen($name, "wb");
                        if (!$f) {
                            $this->Error("Unable to create output file: " . $name);
                        }
                        fwrite($f, $this->getBuffer(), $this->bufferlen);
                        fclose($f);
                    }
                    break;
                case "S":
                    return $this->getBuffer();
                    break;
                default:
                    $this->Error("Incorrect output destination: " . $dest);
                    return "";
            }
        }
        public function _destroy($destroyall = false, $preserve_objcopy = false)
        {
            if ($destroyall && isset($this->diskcache) && $this->diskcache && !$preserve_objcopy && !$this->empty_string($this->buffer)) {
                unlink($this->buffer);
            }
            foreach (array_keys(get_object_vars($this)) as $val) {
                if (($destroyall || $val != "internal_encoding" && $val != "state" && $val != "bufferlen" && $val != "buffer" && $val != "diskcache" && $val != "sign" && $val != "signature_data" && $val != "signature_max_lenght") && (!$preserve_objcopy || $val != "objcopy")) {
                    unset($this->{$val});
                }
            }
        }
        public function _dochecks()
        {
            if (false) {
                $this->Error("Don't alter the locale before including class file");
            }
            if (sprintf("%.1F", 0) != "1.0") {
                setlocale(LC_NUMERIC, "C");
            }
        }
        public function _getfontpath()
        {
            if (!defined("K_PATH_FONTS") && is_dir(dirname(__FILE__) . "/fonts")) {
                define("K_PATH_FONTS", dirname(__FILE__) . "/fonts/");
            }
            return defined("K_PATH_FONTS") ? K_PATH_FONTS : "";
        }
        public function _putpages()
        {
            $nb = $this->numpages;
            if (!empty($this->AliasNbPages)) {
                $nbs = $this->formatPageNumber($nb);
                $nbu = $this->UTF8ToUTF16BE($nbs, false);
                $alias_a = $this->_escape($this->AliasNbPages);
                $alias_au = $this->_escape("{" . $this->AliasNbPages . "}");
                if ($this->isunicode) {
                    $alias_b = $this->_escape($this->UTF8ToLatin1($this->AliasNbPages));
                    $alias_bu = $this->_escape($this->UTF8ToLatin1("{" . $this->AliasNbPages . "}"));
                    $alias_c = $this->_escape($this->utf8StrRev($this->AliasNbPages, false, $this->tmprtl));
                    $alias_cu = $this->_escape($this->utf8StrRev("{" . $this->AliasNbPages . "}", false, $this->tmprtl));
                }
            }
            if (!empty($this->AliasNumPage)) {
                $alias_pa = $this->_escape($this->AliasNumPage);
                $alias_pau = $this->_escape("{" . $this->AliasNumPage . "}");
                if ($this->isunicode) {
                    $alias_pb = $this->_escape($this->UTF8ToLatin1($this->AliasNumPage));
                    $alias_pbu = $this->_escape($this->UTF8ToLatin1("{" . $this->AliasNumPage . "}"));
                    $alias_pc = $this->_escape($this->utf8StrRev($this->AliasNumPage, false, $this->tmprtl));
                    $alias_pcu = $this->_escape($this->utf8StrRev("{" . $this->AliasNumPage . "}", false, $this->tmprtl));
                }
            }
            $pagegroupnum = 0;
            $filter = $this->compress ? "/Filter /FlateDecode " : "";
            for ($n = 1; $n <= $nb; $n++) {
                $temppage = $this->getPageBuffer($n);
                if (!empty($this->pagegroups)) {
                    if (isset($this->newpagegroup[$n])) {
                        $pagegroupnum = 0;
                    }
                    $pagegroupnum++;
                    foreach ($this->pagegroups as $k => $v) {
                        $vs = $this->formatPageNumber($v);
                        $vu = $this->UTF8ToUTF16BE($vs, false);
                        $alias_ga = $this->_escape($k);
                        $alias_gau = $this->_escape("{" . $k . "}");
                        if ($this->isunicode) {
                            $alias_gb = $this->_escape($this->UTF8ToLatin1($k));
                            $alias_gbu = $this->_escape($this->UTF8ToLatin1("{" . $k . "}"));
                            $alias_gc = $this->_escape($this->utf8StrRev($k, false, $this->tmprtl));
                            $alias_gcu = $this->_escape($this->utf8StrRev("{" . $k . "}", false, $this->tmprtl));
                        }
                        $temppage = str_replace($alias_gau, $vu, $temppage);
                        if ($this->isunicode) {
                            $temppage = str_replace($alias_gbu, $vu, $temppage);
                            $temppage = str_replace($alias_gcu, $vu, $temppage);
                            $temppage = str_replace($alias_gb, $vs, $temppage);
                            $temppage = str_replace($alias_gc, $vs, $temppage);
                        }
                        $temppage = str_replace($alias_ga, $vs, $temppage);
                        $pvs = $this->formatPageNumber($pagegroupnum);
                        $pvu = $this->UTF8ToUTF16BE($pvs, false);
                        $pk = str_replace("{nb", "{pnb", $k);
                        $alias_pga = $this->_escape($pk);
                        $alias_pgau = $this->_escape("{" . $pk . "}");
                        if ($this->isunicode) {
                            $alias_pgb = $this->_escape($this->UTF8ToLatin1($pk));
                            $alias_pgbu = $this->_escape($this->UTF8ToLatin1("{" . $pk . "}"));
                            $alias_pgc = $this->_escape($this->utf8StrRev($pk, false, $this->tmprtl));
                            $alias_pgcu = $this->_escape($this->utf8StrRev("{" . $pk . "}", false, $this->tmprtl));
                        }
                        $temppage = str_replace($alias_pgau, $pvu, $temppage);
                        if ($this->isunicode) {
                            $temppage = str_replace($alias_pgbu, $pvu, $temppage);
                            $temppage = str_replace($alias_pgcu, $pvu, $temppage);
                            $temppage = str_replace($alias_pgb, $pvs, $temppage);
                            $temppage = str_replace($alias_pgc, $pvs, $temppage);
                        }
                        $temppage = str_replace($alias_pga, $pvs, $temppage);
                    }
                }
                if (!empty($this->AliasNbPages)) {
                    $temppage = str_replace($alias_au, $nbu, $temppage);
                    if ($this->isunicode) {
                        $temppage = str_replace($alias_bu, $nbu, $temppage);
                        $temppage = str_replace($alias_cu, $nbu, $temppage);
                        $temppage = str_replace($alias_b, $nbs, $temppage);
                        $temppage = str_replace($alias_c, $nbs, $temppage);
                    }
                    $temppage = str_replace($alias_a, $nbs, $temppage);
                }
                if (!empty($this->AliasNumPage)) {
                    $pnbs = $this->formatPageNumber($n);
                    $pnbu = $this->UTF8ToUTF16BE($pnbs, false);
                    $temppage = str_replace($alias_pau, $pnbu, $temppage);
                    if ($this->isunicode) {
                        $temppage = str_replace($alias_pbu, $pnbu, $temppage);
                        $temppage = str_replace($alias_pcu, $pnbu, $temppage);
                        $temppage = str_replace($alias_pb, $pnbs, $temppage);
                        $temppage = str_replace($alias_pc, $pnbs, $temppage);
                    }
                    $temppage = str_replace($alias_pa, $pnbs, $temppage);
                }
                $temppage = str_replace($this->epsmarker, "", $temppage);
                $this->_newobj();
                $this->_out("<</Type /Page");
                $this->_out("/Parent 1 0 R");
                $this->_out(sprintf("/MediaBox [0 0 %.2F %.2F]", $this->pagedim[$n]["w"], $this->pagedim[$n]["h"]));
                $this->_out("/Resources 2 0 R");
                $this->_putannots($n);
                $this->_out("/Contents " . ($this->n + 1) . " 0 R>>");
                $this->_out("endobj");
                $p = $this->compress ? gzcompress($temppage) : $temppage;
                $this->_newobj();
                $this->_out("<<" . $filter . "/Length " . strlen($p) . ">>");
                $this->_putstream($p);
                $this->_out("endobj");
                if ($this->diskcache) {
                    unlink($this->pages[$n]);
                }
            }
            $this->offsets[1] = $this->bufferlen;
            $this->_out("1 0 obj");
            $this->_out("<</Type /Pages");
            $kids = "/Kids [";
            for ($i = 0; $i < $nb; $i++) {
                $kids .= 3 + 2 * $i . " 0 R ";
            }
            $this->_out($kids . "]");
            $this->_out("/Count " . $nb);
            $this->_out(">>");
            $this->_out("endobj");
        }
        public function _putannots($n)
        {
            while (isset($this->PageAnnots[$n])) {
                $annots = "/Annots [";
                foreach ($this->PageAnnots[$n] as $key => $pl) {
                    $pl["opt"] = array_change_key_case($pl["opt"], CASE_LOWER);
                    $a = $pl["x"] * $this->k;
                    $b = $this->pagedim[$n]["h"] - $pl["y"] * $this->k;
                    $c = $pl["w"] * $this->k;
                    $d = $pl["h"] * $this->k;
                    $rect = sprintf("%.2F %.2F %.2F %.2F", $a, $b, $a + $c, $b - $d);
                    $annots .= "\n";
                    $annots .= "<</Type /Annot";
                    $annots .= " /Subtype /" . $pl["opt"]["subtype"];
                    $annots .= " /Rect [" . $rect . "]";
                    $annots .= " /Contents " . $this->_textstring($pl["txt"]);
                    $annots .= " /NM " . $this->_textstring(sprintf("%04u-%04u", $n, $key));
                    $annots .= " /M " . $this->_datastring("D:" . date("YmdHis"));
                    if (isset($pl["opt"]["f"])) {
                        $val = 0;
                        if (is_array($pl["opt"]["f"])) {
                            foreach ($pl["opt"]["f"] as $f) {
                                strtolower($f);
                                switch (strtolower($f)) {
                                    case "invisible":
                                        $val += 1;
                                        break;
                                    case "hidden":
                                        $val += 2;
                                        break;
                                    case "print":
                                        $val += 4;
                                        break;
                                    case "nozoom":
                                        $val += 8;
                                        break;
                                    case "norotate":
                                        $val += 16;
                                        break;
                                    case "noview":
                                        $val += 32;
                                        break;
                                    case "readonly":
                                        $val += 64;
                                        break;
                                    case "locked":
                                        $val += 256;
                                        break;
                                    case "togglenoview":
                                        $val += 512;
                                        break;
                                    case "lockedcontents":
                                        $val += 1024;
                                        break;
                                }
                            }
                        }
                        $annots .= " /F " . intval($val);
                    }
                    $annots .= " /Border [";
                    if (isset($pl["opt"]["border"]) && 3 <= count($pl["opt"]["border"])) {
                        $annots .= intval($pl["opt"]["border"][0]) . " ";
                        $annots .= intval($pl["opt"]["border"][1]) . " ";
                        $annots .= intval($pl["opt"]["border"][2]);
                        if (isset($pl["opt"]["border"][3]) && is_array($pl["opt"]["border"][3])) {
                            $annots .= " [";
                            foreach ($pl["opt"]["border"][3] as $dash) {
                                $annots .= intval($dash) . " ";
                            }
                            $annots .= "]";
                        }
                    } else {
                        $annots .= "0 0 0";
                    }
                    $annots .= "]";
                    if (isset($pl["opt"]["bs"]) && is_array($pl["opt"]["bs"])) {
                        $annots .= " /BS <<Type /Border";
                        if (isset($pl["opt"]["bs"]["w"])) {
                            $annots .= " /W " . sprintf("%.4F", floatval($pl["opt"]["bs"]["w"]));
                        }
                        $bstyles = ["S", "D", "B", "I", "U"];
                        if (isset($pl["opt"]["bs"]["s"]) && in_array($pl["opt"]["bs"]["s"], $bstyles)) {
                            $annots .= " /S /" . $pl["opt"]["bs"]["s"];
                        }
                        if (isset($pl["opt"]["bs"]["d"]) && is_array($pl["opt"]["bs"]["d"])) {
                            $annots .= " /D [";
                            foreach ($pl["opt"]["bs"]["d"] as $cord) {
                                $cord = floatval($cord);
                                $annots .= sprintf(" %.4F", $cord);
                            }
                            $annots .= "]";
                        }
                        $annots .= ">> ";
                    }
                    if (isset($pl["opt"]["be"]) && is_array($pl["opt"]["be"])) {
                        $annots .= " /BE <<";
                        $bstyles = ["S", "C"];
                        if (isset($pl["opt"]["be"]["s"]) && in_array($pl["opt"]["be"]["s"], $markups)) {
                            $annots .= " /S /" . $pl["opt"]["bs"]["s"];
                        } else {
                            $annots .= " /S /S";
                        }
                        if (isset($pl["opt"]["be"]["i"]) && 0 <= $pl["opt"]["be"]["i"] && $pl["opt"]["be"]["i"] <= 2) {
                            $annots .= " /I " . sprintf(" %.4F", $pl["opt"]["be"]["i"]);
                        }
                        $annots .= ">>";
                    }
                    $annots .= " /C [";
                    if (isset($pl["opt"]["c"]) && is_array($pl["opt"]["c"])) {
                        foreach ($pl["opt"]["c"] as $col) {
                            $col = intval($col);
                            $color = $col <= 0 ? 0 : (255 <= $col ? 1 : $col / 255);
                            $annots .= sprintf(" %.4F", $color);
                        }
                    }
                    $annots .= "]";
                    $markups = ["text", "freetext", "line", "square", "circle", "polygon", "polyline", "highlight", "underline", "squiggly", "strikeout", "stamp", "caret", "ink", "fileattachment", "sound"];
                    if (in_array(strtolower($pl["opt"]["subtype"]), $markups)) {
                        if (isset($pl["opt"]["t"]) && is_string($pl["opt"]["t"])) {
                            $annots .= " /T " . $this->_textstring($pl["opt"]["t"]);
                        }
                        if (isset($pl["opt"]["ca"])) {
                            $annots .= " /CA " . sprintf("%.4F", floatval($pl["opt"]["ca"]));
                        }
                        if (isset($pl["opt"]["rc"])) {
                            $annots .= " /RC " . $this->_textstring($pl["opt"]["rc"]);
                        }
                        $annots .= " /CreationDate " . $this->_datastring("D:" . date("YmdHis"));
                        if (isset($pl["opt"]["subj"])) {
                            $annots .= " /Subj " . $this->_textstring($pl["opt"]["subj"]);
                        }
                    }
                    strtolower($pl["opt"]["subtype"]);
                    switch (strtolower($pl["opt"]["subtype"])) {
                        case "text":
                            if (isset($pl["opt"]["open"])) {
                                $annots .= " /Open " . (strtolower($pl["opt"]["open"]) == "true" ? "true" : "false");
                            }
                            $iconsapp = ["Comment", "Help", "Insert", "Key", "NewParagraph", "Note", "Paragraph"];
                            if (isset($pl["opt"]["name"]) && in_array($pl["opt"]["name"], $iconsapp)) {
                                $annots .= " /Name /" . $pl["opt"]["name"];
                            } else {
                                $annots .= " /Name /Note";
                            }
                            $statemodels = ["Marked", "Review"];
                            if (isset($pl["opt"]["statemodel"]) && in_array($pl["opt"]["statemodel"], $statemodels)) {
                                $annots .= " /StateModel /" . $pl["opt"]["statemodel"];
                            } else {
                                $pl["opt"]["statemodel"] = "Marked";
                                $annots .= " /StateModel /" . $pl["opt"]["statemodel"];
                            }
                            if ($pl["opt"]["statemodel"] == "Marked") {
                                $states = ["Accepted", "Unmarked"];
                            } else {
                                $states = ["Accepted", "Rejected", "Cancelled", "Completed", "None"];
                            }
                            if (isset($pl["opt"]["state"]) && in_array($pl["opt"]["state"], $states)) {
                                $annots .= " /State /" . $pl["opt"]["state"];
                            } else {
                                if ($pl["opt"]["statemodel"] == "Marked") {
                                    $annots .= " /State /Unmarked";
                                } else {
                                    $annots .= " /State /None";
                                }
                            }
                            break;
                        case "link":
                            if (is_string($pl["txt"])) {
                                $annots .= " /A <</S /URI /URI " . $this->_datastring($pl["txt"]) . ">>";
                            } else {
                                $l = $this->links[$pl["txt"]];
                                $annots .= sprintf(" /Dest [%d 0 R /XYZ 0 %.2F null]", 1 + 2 * $l[0], $this->pagedim[$l[0]]["h"] - $l[1] * $this->k);
                            }
                            $hmodes = ["N", "I", "O", "P"];
                            if (isset($pl["opt"]["h"]) && in_array($pl["opt"]["h"], $hmodes)) {
                                $annots .= " /H /" . $pl["opt"]["h"];
                            } else {
                                $annots .= " /H /I";
                            }
                            break;
                        case "freetext":
                            $annots .= " /DA " . $this->_textstring($pl["txt"]);
                            if (isset($pl["opt"]["q"]) && 0 <= $pl["opt"]["q"] && $pl["opt"]["q"] <= 2) {
                                $annots .= " /Q " . intval($pl["opt"]["q"]);
                            }
                            if (isset($pl["opt"]["rc"])) {
                                $annots .= " /RC " . $this->_textstring($pl["opt"]["rc"]);
                            }
                            if (isset($pl["opt"]["ds"])) {
                                $annots .= " /DS " . $this->_textstring($pl["opt"]["ds"]);
                            }
                            if (isset($pl["opt"]["cl"]) && is_array($pl["opt"]["cl"])) {
                                $annots .= " /CL [";
                                foreach ($pl["opt"]["cl"] as $cl) {
                                    $annots .= sprintf("%.4F ", $cl * $this->k);
                                }
                                $annots .= "]";
                            }
                            $tfit = ["FreeTextCallout", "FreeTextTypeWriter"];
                            if (isset($pl["opt"]["it"]) && in_array($pl["opt"]["it"], $tfit)) {
                                $annots .= " /IT " . $pl["opt"]["it"];
                            }
                            if (isset($pl["opt"]["rd"]) && is_array($pl["opt"]["rd"])) {
                                $l = $pl["opt"]["rd"][0] * $this->k;
                                $r = $pl["opt"]["rd"][1] * $this->k;
                                $t = $pl["opt"]["rd"][2] * $this->k;
                                $b = $pl["opt"]["rd"][3] * $this->k;
                                $annots .= " /RD [" . sprintf("%.2F %.2F %.2F %.2F", $l, $r, $t, $b) . "]";
                            }
                            break;
                        case "line":
                        case "square":
                        case "circle":
                        case "polygon":
                        case "polyline":
                        case "highlight":
                        case "underline":
                        case "squiggly":
                        case "strikeout":
                        case "stamp":
                        case "caret":
                        case "ink":
                        case "popup":
                        case "fileattachment":
                            if (isset($pl["opt"]["fs"])) {
                                $filename = basename($pl["opt"]["fs"]);
                                if (isset($this->embeddedfiles[$filename]["n"])) {
                                    $annots .= " /FS <</Type /Filespec /F " . $this->_datastring($filename) . " /EF <</F " . $this->embeddedfiles[$filename]["n"] . " 0 R>> >>";
                                    $iconsapp = ["Graph", "Paperclip", "PushPin", "Tag"];
                                    if (isset($pl["opt"]["name"]) && in_array($pl["opt"]["name"], $iconsapp)) {
                                        $annots .= " /Name /" . $pl["opt"]["name"];
                                    } else {
                                        $annots .= " /Name /PushPin";
                                    }
                                }
                            }
                            break;
                        case "sound":
                            if (isset($pl["opt"]["sound"])) {
                                $filename = basename($pl["opt"]["sound"]);
                                if (isset($this->embeddedfiles[$filename]["n"])) {
                                    $iconsapp = ["Speaker", "Mic"];
                                    if (isset($pl["opt"]["name"]) && in_array($pl["opt"]["name"], $iconsapp)) {
                                        $annots .= " /Name /" . $pl["opt"]["name"];
                                    } else {
                                        $annots .= " /Name /Speaker";
                                    }
                                }
                            }
                            break;
                        case "movie":
                        case "widget":
                            if (isset($pl["opt"]["h"])) {
                                $annots .= " /H " . intval($pl["opt"]["h"]);
                            }
                            if (isset($pl["opt"]["mk"]) && is_array($pl["opt"]["mk"])) {
                                $annots .= " /MK <<";
                                $annots .= ">>";
                            }
                            break;
                        case "screen":
                        case "printermark":
                        case "trapnet":
                        case "watermark":
                        case "3d":
                        default:
                            $annots .= ">>";
                    }
                }
                $annots .= "\n]";
                $this->_out($annots);
            }
        }
        public function _putfonts()
        {
            $nf = $this->n;
            foreach ($this->diffs as $diff) {
                $this->_newobj();
                $this->_out("<</Type /Encoding /BaseEncoding /WinAnsiEncoding /Differences [" . $diff . "]>>");
                $this->_out("endobj");
            }
            ini_set("magic_quotes_runtime", 0);
            foreach ($this->FontFiles as $file => $info) {
                $fontdir = $info["fontdir"];
                $file = strtolower($file);
                $fontfile = "";
                if (file_exists($fontdir . $file)) {
                    $fontfile = $fontdir . $file;
                } else {
                    if (file_exists($this->_getfontpath() . $file)) {
                        $fontfile = $this->_getfontpath() . $file;
                    } else {
                        if (file_exists($file)) {
                            $fontfile = $file;
                        }
                    }
                }
                if (!$this->empty_string($fontfile)) {
                    $font = file_get_contents($fontfile);
                    $compressed = substr($file, -2) == ".z";
                    if (!$compressed && isset($info["length2"])) {
                        $header = ord($font[0]) == 128;
                        if ($header) {
                            $font = substr($font, 6);
                        }
                        if ($header && ord($font[$info["length1"]]) == 128) {
                            $font = substr($font, 0, $info["length1"]) . substr($font, $info["length1"] + 6);
                        }
                    }
                    $this->_newobj();
                    $this->FontFiles[$file]["n"] = $this->n;
                    $this->_out("<</Length " . strlen($font));
                    if ($compressed) {
                        $this->_out("/Filter /FlateDecode");
                    }
                    $this->_out("/Length1 " . $info["length1"]);
                    if (isset($info["length2"])) {
                        $this->_out("/Length2 " . $info["length2"] . " /Length3 0");
                    }
                    $this->_out(">>");
                    $this->_putstream($font);
                    $this->_out("endobj");
                }
            }
            foreach ($this->fontkeys as $k) {
                $this->setFontSubBuffer($k, "n", $this->n + 1);
                $font = $this->getFontBuffer($k);
                $type = $font["type"];
                $name = $font["name"];
                if ($type == "core") {
                    $this->_newobj();
                    $this->_out("<</Type /Font");
                    $this->_out("/BaseFont /" . $name);
                    $this->_out("/Subtype /Type1");
                    if ($name != "symbol" && $name != "zapfdingbats") {
                        $this->_out("/Encoding /WinAnsiEncoding");
                    }
                    $this->_out(">>");
                    $this->_out("endobj");
                } else {
                    if ($type == "Type1" || $type == "TrueType") {
                        $this->_newobj();
                        $this->_out("<</Type /Font");
                        $this->_out("/BaseFont /" . $name);
                        $this->_out("/Subtype /" . $type);
                        $this->_out("/FirstChar 32 /LastChar 255");
                        $this->_out("/Widths " . ($this->n + 1) . " 0 R");
                        $this->_out("/FontDescriptor " . ($this->n + 2) . " 0 R");
                        if ($font["enc"]) {
                            if (isset($font["diff"])) {
                                $this->_out("/Encoding " . ($nf + $font["diff"]) . " 0 R");
                            } else {
                                $this->_out("/Encoding /WinAnsiEncoding");
                            }
                        }
                        $this->_out(">>");
                        $this->_out("endobj");
                        $this->_newobj();
                        $cw =& $font["cw"];
                        $s = "[";
                        for ($i = 32; $i < 256; $i++) {
                            $s .= $cw[$i] . " ";
                        }
                        $this->_out($s . "]");
                        $this->_out("endobj");
                        $this->_newobj();
                        $s = "<</Type /FontDescriptor /FontName /" . $name;
                        foreach ($font["desc"] as $k => $v) {
                            $s .= " /" . $k . " " . $v . "";
                        }
                        if (!$this->empty_string($font["file"])) {
                            $s .= " /FontFile" . ($type == "Type1" ? "" : "2") . " " . $this->FontFiles[$font["file"]]["n"] . " 0 R";
                        }
                        $this->_out($s . ">>");
                        $this->_out("endobj");
                    } else {
                        $mtd = "_put" . strtolower($type);
                        if (!method_exists($this, $mtd)) {
                            $this->Error("Unsupported font type: " . $type);
                        }
                        $this->{$mtd}($font);
                    }
                }
            }
        }
        public function _putfontwidths($font, $cidoffset = 0)
        {
            ksort($font["cw"]);
            $rangeid = 0;
            $range = [];
            $prevcid = -2;
            $prevwidth = -1;
            $interval = false;
            foreach ($font["cw"] as $cid => $width) {
                $cid -= $cidoffset;
                if ($width != $font["dw"]) {
                    if ($cid == $prevcid + 1) {
                        if ($width == $prevwidth) {
                            if ($width == $range[$rangeid][0]) {
                                $range[$rangeid][] = $width;
                            } else {
                                array_pop($range[$rangeid]);
                                $rangeid = $prevcid;
                                $range[$rangeid] = [];
                                $range[$rangeid][] = $prevwidth;
                                $range[$rangeid][] = $width;
                            }
                            $interval = true;
                            $range[$rangeid]["interval"] = true;
                        } else {
                            if ($interval) {
                                $rangeid = $cid;
                                $range[$rangeid] = [];
                                $range[$rangeid][] = $width;
                            } else {
                                $range[$rangeid][] = $width;
                            }
                            $interval = false;
                        }
                    } else {
                        $rangeid = $cid;
                        $range[$rangeid] = [];
                        $range[$rangeid][] = $width;
                        $interval = false;
                    }
                    $prevcid = $cid;
                    $prevwidth = $width;
                }
            }
            $prevk = -1;
            $nextk = -1;
            $prevint = false;
            foreach ($range as $k => $ws) {
                $cws = count($ws);
                if ($k == $nextk && !$prevint && (!isset($ws["interval"]) || $cws < 4)) {
                    if (isset($range[$k]["interval"])) {
                        unset($range[$k]["interval"]);
                    }
                    $range[$prevk] = array_merge($range[$prevk], $range[$k]);
                    unset($range[$k]);
                } else {
                    $prevk = $k;
                }
                $nextk = $k + $cws;
                if (isset($ws["interval"])) {
                    if (3 < $cws) {
                        $prevint = true;
                    } else {
                        $prevint = false;
                    }
                    unset($range[$k]["interval"]);
                    --$nextk;
                } else {
                    $prevint = false;
                }
            }
            $w = "";
            foreach ($range as $k => $ws) {
                if (count(array_count_values($ws)) == 1) {
                    $w .= " " . $k . " " . ($k + count($ws) - 1) . " " . $ws[0];
                } else {
                    $w .= " " . $k . " [ " . implode(" ", $ws) . " ]";
                }
            }
            $this->_out("/W [" . $w . " ]");
        }
        public function _puttruetypeunicode($font)
        {
            $this->_newobj();
            $this->_out("<</Type /Font");
            $this->_out("/Subtype /Type0");
            $this->_out("/BaseFont /" . $font["name"] . "");
            $this->_out("/Encoding /Identity-H");
            $this->_out("/ToUnicode /Identity-H");
            $this->_out("/DescendantFonts [" . ($this->n + 1) . " 0 R]");
            $this->_out(">>");
            $this->_out("endobj");
            $this->_newobj();
            $this->_out("<</Type /Font");
            $this->_out("/Subtype /CIDFontType2");
            $this->_out("/BaseFont /" . $font["name"] . "");
            $cidinfo = "/Registry " . $this->_datastring("Adobe");
            $cidinfo .= " /Ordering " . $this->_datastring("Identity");
            $cidinfo .= " /Supplement 0";
            $this->_out("/CIDSystemInfo <<" . $cidinfo . ">>");
            $this->_out("/FontDescriptor " . ($this->n + 1) . " 0 R");
            $this->_out("/DW " . $font["dw"] . "");
            $this->_putfontwidths($font, 0);
            $this->_out("/CIDToGIDMap " . ($this->n + 2) . " 0 R");
            $this->_out(">>");
            $this->_out("endobj");
            $this->_newobj();
            $this->_out("<</Type /FontDescriptor");
            $this->_out("/FontName /" . $font["name"]);
            foreach ($font["desc"] as $key => $value) {
                $this->_out("/" . $key . " " . $value);
            }
            $fontdir = "";
            if (!$this->empty_string($font["file"])) {
                $this->_out("/FontFile2 " . $this->FontFiles[$font["file"]]["n"] . " 0 R");
                $fontdir = $this->FontFiles[$font["file"]]["fontdir"];
            }
            $this->_out(">>");
            $this->_out("endobj");
            $this->_newobj();
            if (isset($font["ctg"]) && !$this->empty_string($font["ctg"])) {
                $ctgfile = strtolower($font["ctg"]);
                $fontfile = "";
                if (file_exists($fontdir . $ctgfile)) {
                    $fontfile = $fontdir . $ctgfile;
                } else {
                    if (file_exists($this->_getfontpath() . $ctgfile)) {
                        $fontfile = $this->_getfontpath() . $ctgfile;
                    } else {
                        if (file_exists($ctgfile)) {
                            $fontfile = $ctgfile;
                        }
                    }
                }
                if ($this->empty_string($fontfile)) {
                    $this->Error("Font file not found: " . $ctgfile);
                }
                $size = filesize($fontfile);
                $this->_out("<</Length " . $size . "");
                if (substr($fontfile, -2) == ".z") {
                    $this->_out("/Filter /FlateDecode");
                }
                $this->_out(">>");
                $this->_putstream(file_get_contents($fontfile));
            }
            $this->_out("endobj");
        }
        public function _putcidfont0($font)
        {
            $cidoffset = 31;
            if (isset($font["cidinfo"]["uni2cid"])) {
                $uni2cid = $font["cidinfo"]["uni2cid"];
                $cw = [];
                foreach ($font["cw"] as $uni => $width) {
                    if (isset($uni2cid[$uni])) {
                        $cw[$uni2cid[$uni] + $cidoffset] = $width;
                    } else {
                        if ($uni < 256) {
                            $cw[$uni] = $width;
                        }
                    }
                }
                $font = array_merge($font, ["cw" => $cw]);
            }
            $name = $font["name"];
            $enc = $font["enc"];
            if ($enc) {
                $longname = $name . "-" . $enc;
            } else {
                $longname = $name;
            }
            $this->_newobj();
            $this->_out("<</Type /Font");
            $this->_out("/BaseFont /" . $longname);
            $this->_out("/Subtype /Type0");
            if ($enc) {
                $this->_out("/Encoding /" . $enc);
            }
            $this->_out("/DescendantFonts [" . ($this->n + 1) . " 0 R]");
            $this->_out(">>");
            $this->_out("endobj");
            $this->_newobj();
            $this->_out("<</Type /Font");
            $this->_out("/BaseFont /" . $name);
            $this->_out("/Subtype /CIDFontType0");
            $cidinfo = "/Registry " . $this->_datastring($font["cidinfo"]["Registry"]);
            $cidinfo .= " /Ordering " . $this->_datastring($font["cidinfo"]["Ordering"]);
            $cidinfo .= " /Supplement " . $font["cidinfo"]["Supplement"];
            $this->_out("/CIDSystemInfo <<" . $cidinfo . ">>");
            $this->_out("/FontDescriptor " . ($this->n + 1) . " 0 R");
            $this->_out("/DW " . $font["dw"]);
            $this->_putfontwidths($font, $cidoffset);
            $this->_out(">>");
            $this->_out("endobj");
            $this->_newobj();
            $s = "<</Type /FontDescriptor /FontName /" . $name;
            foreach ($font["desc"] as $k => $v) {
                if ($k != "Style") {
                    $s .= " /" . $k . " " . $v . "";
                }
            }
            $this->_out($s . ">>");
            $this->_out("endobj");
        }
        public function _putimages()
        {
            $filter = $this->compress ? "/Filter /FlateDecode " : "";
            foreach ($this->imagekeys as $file) {
                $info = $this->getImageBuffer($file);
                $this->_newobj();
                $this->setImageSubBuffer($file, "n", $this->n);
                $this->_out("<</Type /XObject");
                $this->_out("/Subtype /Image");
                $this->_out("/Width " . $info["w"]);
                $this->_out("/Height " . $info["h"]);
                if (isset($info["masked"])) {
                    $this->_out("/SMask " . ($this->n - 1) . " 0 R");
                }
                if ($info["cs"] == "Indexed") {
                    $this->_out("/ColorSpace [/Indexed /DeviceRGB " . (strlen($info["pal"]) / 3 - 1) . " " . ($this->n + 1) . " 0 R]");
                } else {
                    $this->_out("/ColorSpace /" . $info["cs"]);
                    if ($info["cs"] == "DeviceCMYK") {
                        $this->_out("/Decode [1 0 1 0 1 0 1 0]");
                    }
                }
                $this->_out("/BitsPerComponent " . $info["bpc"]);
                if (isset($info["f"])) {
                    $this->_out("/Filter /" . $info["f"]);
                }
                if (isset($info["parms"])) {
                    $this->_out($info["parms"]);
                }
                if (isset($info["trns"]) && is_array($info["trns"])) {
                    $trns = "";
                    $count_info = count($info["trns"]);
                    for ($i = 0; $i < $count_info; $i++) {
                        $trns .= $info["trns"][$i] . " " . $info["trns"][$i] . " ";
                    }
                    $this->_out("/Mask [" . $trns . "]");
                }
                $this->_out("/Length " . strlen($info["data"]) . ">>");
                $this->_putstream($info["data"]);
                $this->_out("endobj");
                if ($info["cs"] == "Indexed") {
                    $this->_newobj();
                    $pal = $this->compress ? gzcompress($info["pal"]) : $info["pal"];
                    $this->_out("<<" . $filter . "/Length " . strlen($pal) . ">>");
                    $this->_putstream($pal);
                    $this->_out("endobj");
                }
            }
        }
        public function _putspotcolors()
        {
            foreach ($this->spot_colors as $name => $color) {
                $this->_newobj();
                $this->spot_colors[$name]["n"] = $this->n;
                $this->_out("[/Separation /" . str_replace(" ", "#20", $name));
                $this->_out("/DeviceCMYK <<");
                $this->_out("/Range [0 1 0 1 0 1 0 1] /C0 [0 0 0 0] ");
                $this->_out(sprintf("/C1 [%.4F %.4F %.4F %.4F] ", $color["c"] / 100, $color["m"] / 100, $color["y"] / 100, $color["k"] / 100));
                $this->_out("/FunctionType 2 /Domain [0 1] /N 1>>]");
                $this->_out("endobj");
            }
        }
        public function _putxobjectdict()
        {
            foreach ($this->imagekeys as $file) {
                $info = $this->getImageBuffer($file);
                $this->_out("/I" . $info["i"] . " " . $info["n"] . " 0 R");
            }
        }
        public function _putresourcedict()
        {
            $this->_out("/ProcSet [/PDF /Text /ImageB /ImageC /ImageI]");
            $this->_out("/Font <<");
            foreach ($this->fontkeys as $fontkey) {
                $font = $this->getFontBuffer($fontkey);
                $this->_out("/F" . $font["i"] . " " . $font["n"] . " 0 R");
            }
            $this->_out(">>");
            $this->_out("/XObject <<");
            $this->_putxobjectdict();
            $this->_out(">>");
            $this->_out("/Properties <</OC1 " . $this->n_ocg_print . " 0 R /OC2 " . $this->n_ocg_view . " 0 R>>");
            $this->_out("/ExtGState <<");
            foreach ($this->extgstates as $k => $extgstate) {
                $this->_out("/GS" . $k . " " . $extgstate["n"] . " 0 R");
            }
            $this->_out(">>");
            if (isset($this->gradients) && 0 < count($this->gradients)) {
                $this->_out("/Shading <<");
                foreach ($this->gradients as $id => $grad) {
                    $this->_out("/Sh" . $id . " " . $grad["id"] . " 0 R");
                }
                $this->_out(">>");
            }
            if (isset($this->spot_colors) && 0 < count($this->spot_colors)) {
                $this->_out("/ColorSpace <<");
                foreach ($this->spot_colors as $color) {
                    $this->_out("/CS" . $color["i"] . " " . $color["n"] . " 0 R");
                }
                $this->_out(">>");
            }
        }
        public function _putresources()
        {
            $this->_putextgstates();
            $this->_putocg();
            $this->_putfonts();
            $this->_putimages();
            $this->_putspotcolors();
            $this->_putshaders();
            $this->offsets[2] = $this->bufferlen;
            $this->_out("2 0 obj");
            $this->_out("<<");
            $this->_putresourcedict();
            $this->_out(">>");
            $this->_out("endobj");
            $this->_putjavascript();
            $this->_putbookmarks();
            $this->_putEmbeddedFiles();
            if ($this->encrypted) {
                $this->_newobj();
                $this->enc_obj_id = $this->n;
                $this->_out("<<");
                $this->_putencryption();
                $this->_out(">>");
                $this->_out("endobj");
            }
        }
        public function _putinfo()
        {
            if ($this->empty_string($this->title)) {
                $this->title = "?";
            }
            $this->_out("/Title " . $this->_textstring($this->title));
            if ($this->empty_string($this->author)) {
                $this->author = "?";
            }
            $this->_out("/Author " . $this->_textstring($this->author));
            if ($this->empty_string($this->subject)) {
                $this->subject = "?";
            }
            $this->_out("/Subject " . $this->_textstring($this->subject));
            if ($this->empty_string($this->keywords)) {
                $this->keywords = "?";
            }
            $this->_out("/Keywords " . $this->_textstring($this->keywords));
            if ($this->empty_string($this->creator)) {
                $this->creator = "?";
            }
            $this->_out("/Creator " . $this->_textstring($this->creator));
            if (defined("PDF_PRODUCER")) {
                $this->_out("/Producer " . $this->_textstring(PDF_PRODUCER));
            } else {
                $this->_out("/Producer " . $this->_textstring("TCPDF"));
            }
            $this->_out("/CreationDate " . $this->_datastring("D:" . date("YmdHis")));
            $this->_out("/ModDate " . $this->_datastring("D:" . date("YmdHis")));
        }
        public function _putcatalog()
        {
            $this->_out("/Type /Catalog");
            $this->_out("/Pages 1 0 R");
            if ($this->ZoomMode == "fullpage") {
                $this->_out("/OpenAction [3 0 R /Fit]");
            } else {
                if ($this->ZoomMode == "fullwidth") {
                    $this->_out("/OpenAction [3 0 R /FitH null]");
                } else {
                    if ($this->ZoomMode == "real") {
                        $this->_out("/OpenAction [3 0 R /XYZ null null 1]");
                    } else {
                        if (!is_string($this->ZoomMode)) {
                            $this->_out("/OpenAction [3 0 R /XYZ null null " . $this->ZoomMode / 100 . "]");
                        }
                    }
                }
            }
            if (isset($this->LayoutMode) && !$this->empty_string($this->LayoutMode)) {
                $this->_out("/PageLayout /" . $this->LayoutMode . "");
            }
            if (isset($this->PageMode) && !$this->empty_string($this->PageMode)) {
                $this->_out("/PageMode /" . $this->PageMode);
            }
            if (isset($this->l["a_meta_language"])) {
                $this->_out("/Lang /" . $this->l["a_meta_language"]);
            }
            $this->_out("/Names <<");
            if (!$this->empty_string($this->javascript)) {
                $this->_out("/JavaScript " . $this->n_js . " 0 R");
            }
            $this->_out(">>");
            if (0 < count($this->outlines)) {
                $this->_out("/Outlines " . $this->OutlineRoot . " 0 R");
                $this->_out("/PageMode /UseOutlines");
            }
            $this->_putviewerpreferences();
            $p = $this->n_ocg_print . " 0 R";
            $v = $this->n_ocg_view . " 0 R";
            $as = "<</Event /Print /OCGs [" . $p . " " . $v . "] /Category [/Print]>> <</Event /View /OCGs [" . $p . " " . $v . "] /Category [/View]>>";
            $this->_out("/OCProperties <</OCGs [" . $p . " " . $v . "] /D <</ON [" . $p . "] /OFF [" . $v . "] /AS [" . $as . "]>>>>");
        }
        public function _putviewerpreferences()
        {
            $this->_out("/ViewerPreferences<<");
            if ($this->rtl) {
                $this->_out("/Direction /R2L");
            } else {
                $this->_out("/Direction /L2R");
            }
            if (isset($this->viewer_preferences["HideToolbar"]) && $this->viewer_preferences["HideToolbar"]) {
                $this->_out("/HideToolbar true");
            }
            if (isset($this->viewer_preferences["HideMenubar"]) && $this->viewer_preferences["HideMenubar"]) {
                $this->_out("/HideMenubar true");
            }
            if (isset($this->viewer_preferences["HideWindowUI"]) && $this->viewer_preferences["HideWindowUI"]) {
                $this->_out("/HideWindowUI true");
            }
            if (isset($this->viewer_preferences["FitWindow"]) && $this->viewer_preferences["FitWindow"]) {
                $this->_out("/FitWindow true");
            }
            if (isset($this->viewer_preferences["CenterWindow"]) && $this->viewer_preferences["CenterWindow"]) {
                $this->_out("/CenterWindow true");
            }
            if (isset($this->viewer_preferences["DisplayDocTitle"]) && $this->viewer_preferences["DisplayDocTitle"]) {
                $this->_out("/DisplayDocTitle true");
            }
            if (isset($this->viewer_preferences["NonFullScreenPageMode"])) {
                $this->_out("/NonFullScreenPageMode /" . $this->viewer_preferences["NonFullScreenPageMode"] . "");
            }
            if (isset($this->viewer_preferences["ViewArea"])) {
                $this->_out("/ViewArea /" . $this->viewer_preferences["ViewArea"]);
            }
            if (isset($this->viewer_preferences["ViewClip"])) {
                $this->_out("/ViewClip /" . $this->viewer_preferences["ViewClip"]);
            }
            if (isset($this->viewer_preferences["PrintArea"])) {
                $this->_out("/PrintArea /" . $this->viewer_preferences["PrintArea"]);
            }
            if (isset($this->viewer_preferences["PrintClip"])) {
                $this->_out("/PrintClip /" . $this->viewer_preferences["PrintClip"]);
            }
            if (isset($this->viewer_preferences["PrintScaling"])) {
                $this->_out("/PrintScaling /" . $this->viewer_preferences["PrintScaling"]);
            }
            if (isset($this->viewer_preferences["Duplex"]) && !$this->empty_string($this->viewer_preferences["Duplex"])) {
                $this->_out("/Duplex /" . $this->viewer_preferences["Duplex"]);
            }
            if (isset($this->viewer_preferences["PickTrayByPDFSize"])) {
                if ($this->viewer_preferences["PickTrayByPDFSize"]) {
                    $this->_out("/PickTrayByPDFSize true");
                } else {
                    $this->_out("/PickTrayByPDFSize false");
                }
            }
            if (isset($this->viewer_preferences["PrintPageRange"])) {
                $PrintPageRangeNum = "";
                foreach ($this->viewer_preferences["PrintPageRange"] as $k => $v) {
                    $PrintPageRangeNum .= " " . ($v - 1) . "";
                }
                $this->_out("/PrintPageRange [" . substr($PrintPageRangeNum, 1) . "]");
            }
            if (isset($this->viewer_preferences["NumCopies"])) {
                $this->_out("/NumCopies " . intval($this->viewer_preferences["NumCopies"]));
            }
            $this->_out(">>");
        }
        public function _puttrailer()
        {
            $this->_out("/Size " . ($this->n + 1));
            $this->_out("/Root " . $this->n . " 0 R");
            $this->_out("/Info " . ($this->n - 1) . " 0 R");
            if ($this->encrypted) {
                $this->_out("/Encrypt " . $this->enc_obj_id . " 0 R");
                $this->_out("/ID [()()]");
            }
        }
        public function _putheader()
        {
            $this->_out("%PDF-" . $this->PDFVersion);
        }
        public function _enddoc()
        {
            $this->state = 1;
            $this->_putheader();
            $this->_putpages();
            $this->_putresources();
            $this->_newobj();
            $this->_out("<<");
            $this->_putinfo();
            $this->_out(">>");
            $this->_out("endobj");
            $this->_newobj();
            $this->_out("<<");
            $this->_putcatalog();
            $this->_putcertification();
            $this->_putuserrights();
            $this->_out(">>");
            $this->_out("endobj");
            $o = $this->bufferlen;
            $this->_out("xref");
            $this->_out("0 " . ($this->n + 1));
            $this->_out("0000000000 65535 f ");
            for ($i = 1; $i <= $this->n; $i++) {
                $this->_out(sprintf("%010d 00000 n ", $this->offsets[$i]));
            }
            if (isset($this->embeddedfiles) && 0 < count($this->embeddedfiles)) {
                $this->_out("100000 " . count($this->embeddedfiles));
                foreach ($this->embeddedfiles as $filename => $filedata) {
                    $this->_out(sprintf("%010d 00000 n ", $this->offsets[$filedata["n"]]));
                }
            }
            $this->_out("trailer");
            $this->_out("<<");
            $this->_puttrailer();
            $this->_out(">>");
            $this->_out("startxref");
            $this->_out($o);
            $this->_out("%%EOF");
            $this->state = 3;
            if ($this->diskcache) {
                foreach ($this->imagekeys as $key) {
                    unlink($this->images[$key]);
                }
                foreach ($this->fontkeys as $key) {
                    unlink($this->fonts[$key]);
                }
            }
        }
        public function _beginpage($orientation = "", $format = "")
        {
            $this->page++;
            $this->setPageBuffer($this->page, "");
            $this->transfmrk[$this->page] = [];
            $this->state = 2;
            if ($this->empty_string($orientation)) {
                if (isset($this->CurOrientation)) {
                    $orientation = $this->CurOrientation;
                } else {
                    $orientation = "P";
                }
            }
            if ($this->empty_string($format)) {
                $this->setPageOrientation($orientation);
            } else {
                $this->setPageFormat($format, $orientation);
            }
            if ($this->rtl) {
                $this->x = $this->w - $this->rMargin;
            } else {
                $this->x = $this->lMargin;
            }
            $this->y = $this->tMargin;
            if (isset($this->newpagegroup[$this->page])) {
                $n = sizeof($this->pagegroups) + 1;
                $alias = "{nb" . $n . "}";
                $this->pagegroups[$alias] = 1;
                $this->currpagegroup = $alias;
            } else {
                if ($this->currpagegroup) {
                    $this->pagegroups[$this->currpagegroup]++;
                }
            }
        }
        public function _endpage()
        {
            $this->setVisibility("all");
            $this->state = 1;
        }
        public function _newobj()
        {
            $this->n++;
            $this->offsets[$this->n] = $this->bufferlen;
            $this->_out($this->n . " 0 obj");
        }
        public function _dounderline($x, $y, $txt)
        {
            $up = $this->CurrentFont["up"];
            $ut = $this->CurrentFont["ut"];
            $w = $this->GetStringWidth($txt);
            return sprintf("%.2F %.2F %.2F %.2F re f", $x * $this->k, ($this->h - ($y - $up / 1000 * $this->FontSize)) * $this->k, $w * $this->k, -1 * $ut / 1000 * $this->FontSizePt);
        }
        public function _dolinethrough($x, $y, $txt)
        {
            $up = $this->CurrentFont["up"];
            $ut = $this->CurrentFont["ut"];
            $w = $this->GetStringWidth($txt);
            return sprintf("%.2F %.2F %.2F %.2F re f", $x * $this->k, ($this->h - ($y - $this->FontSize / 2 - $up / 1000 * $this->FontSize)) * $this->k, $w * $this->k, -1 * $ut / 1000 * $this->FontSizePt);
        }
        public function _freadint($f)
        {
            $a = unpack("Ni", fread($f, 4));
            return $a["i"];
        }
        public function _escape($s)
        {
            return strtr($s, [")" => "\\)", "(" => "\\(", "\\" => "\\\\", chr(13) => "\\r"]);
        }
        public function _datastring($s)
        {
            if ($this->encrypted) {
                $s = $this->_RC4($this->_objectkey($this->n), $s);
            }
            return "(" . $this->_escape($s) . ")";
        }
        public function _textstring($s)
        {
            if ($this->isunicode) {
                $s = $this->UTF8ToUTF16BE($s, true);
            }
            return $this->_datastring($s);
        }
        public function _escapetext($s)
        {
            if ($this->isunicode) {
                if ($this->CurrentFont["type"] == "core" || $this->CurrentFont["type"] == "TrueType" || $this->CurrentFont["type"] == "Type1") {
                    $s = $this->UTF8ToLatin1($s);
                } else {
                    $s = $this->utf8StrRev($s, false, $this->tmprtl);
                }
            }
            return $this->_escape($s);
        }
        public function _putstream($s)
        {
            if ($this->encrypted) {
                $s = $this->_RC4($this->_objectkey($this->n), $s);
            }
            $this->_out("stream");
            $this->_out($s);
            $this->_out("endstream");
        }
        public function _out($s)
        {
            if ($this->state == 2) {
                if (!$this->InFooter && isset($this->footerlen[$this->page]) && 0 < $this->footerlen[$this->page]) {
                    $pagebuff = $this->getPageBuffer($this->page);
                    $page = substr($pagebuff, 0, -1 * $this->footerlen[$this->page]);
                    $footer = substr($pagebuff, -1 * $this->footerlen[$this->page]);
                    $this->setPageBuffer($this->page, $page . $s . "\n" . $footer);
                    $this->footerpos[$this->page] += strlen($s . "\n");
                } else {
                    $this->setPageBuffer($this->page, $s . "\n", true);
                }
            } else {
                $this->setBuffer($s . "\n");
            }
        }
        public function UTF8StringToArray($str)
        {
            if (isset($this->cache_UTF8StringToArray["_" . $str])) {
                return $this->cache_UTF8StringToArray["_" . $str];
            }
            if ($this->cache_maxsize_UTF8StringToArray <= $this->cache_size_UTF8StringToArray) {
                array_shift($this->cache_UTF8StringToArray);
            }
            $this->cache_size_UTF8StringToArray++;
            if (!$this->isunicode) {
                $strarr = [];
                $strlen = strlen($str);
                for ($i = 0; $i < $strlen; $i++) {
                    $strarr[] = ord($str[$i]);
                }
                $this->cache_UTF8StringToArray["_" . $str] = $strarr;
                return $strarr;
            }
            $unicode = [];
            $bytes = [];
            $numbytes = 1;
            $str .= "";
            $length = strlen($str);
            for ($i = 0; $i < $length; $i++) {
                $char = ord($str[$i]);
                if (count($bytes) == 0) {
                    if ($char <= 127) {
                        $unicode[] = $char;
                        $numbytes = 1;
                    } else {
                        if ($char >> 5 == 6) {
                            $bytes[] = $char - 192 << 6;
                            $numbytes = 2;
                        } else {
                            if ($char >> 4 == 14) {
                                $bytes[] = $char - 224 << 12;
                                $numbytes = 3;
                            } else {
                                if ($char >> 3 == 30) {
                                    $bytes[] = $char - 240 << 18;
                                    $numbytes = 4;
                                } else {
                                    $unicode[] = 65533;
                                    $bytes = [];
                                    $numbytes = 1;
                                }
                            }
                        }
                    }
                } else {
                    if ($char >> 6 == 2) {
                        $bytes[] = $char - 128;
                        if (count($bytes) == $numbytes) {
                            $char = $bytes[0];
                            for ($j = 1; $j < $numbytes; $j++) {
                                $char += $bytes[$j] << ($numbytes - $j - 1) * 6;
                            }
                            if (55296 <= $char && $char <= 57343 || 1114111 <= $char) {
                                $unicode[] = 65533;
                            } else {
                                $unicode[] = $char;
                            }
                            $bytes = [];
                            $numbytes = 1;
                        }
                    } else {
                        $unicode[] = 65533;
                        $bytes = [];
                        $numbytes = 1;
                    }
                }
            }
            $this->cache_UTF8StringToArray["_" . $str] = $unicode;
            return $unicode;
        }
        public function UTF8ToUTF16BE($str, $setbom = true)
        {
            if (!$this->isunicode) {
                return $str;
            }
            $unicode = $this->UTF8StringToArray($str);
            return $this->arrUTF8ToUTF16BE($unicode, $setbom);
        }
        public function UTF8ToLatin1($str)
        {
            global $utf8tolatin;
            if (!$this->isunicode) {
                return $str;
            }
            $outstr = "";
            $unicode = $this->UTF8StringToArray($str);
            foreach ($unicode as $char) {
                if ($char < 256) {
                    $outstr .= chr($char);
                } else {
                    if (array_key_exists($char, $utf8tolatin)) {
                        $outstr .= chr($utf8tolatin[$char]);
                    } else {
                        if ($char != 65533) {
                            $outstr .= "?";
                        }
                    }
                }
            }
            return $outstr;
        }
        public function arrUTF8ToUTF16BE($unicode, $setbom = true)
        {
            $outstr = "";
            if ($setbom) {
                $outstr .= "��";
            }
            foreach ($unicode as $char) {
                if ($char == 65533) {
                    $outstr .= "��";
                } else {
                    if ($char < 65536) {
                        $outstr .= chr($char >> 8);
                        $outstr .= chr($char & 255);
                    } else {
                        $char -= 65536;
                        $w1 = 55296 | $char >> 16;
                        $w2 = 56320 | $char & 1023;
                        $outstr .= chr($w1 >> 8);
                        $outstr .= chr($w1 & 255);
                        $outstr .= chr($w2 >> 8);
                        $outstr .= chr($w2 & 255);
                    }
                }
            }
            return $outstr;
        }
        public function setHeaderFont($font)
        {
            $this->header_font = $font;
        }
        public function getHeaderFont()
        {
            return $this->header_font;
        }
        public function setFooterFont($font)
        {
            $this->footer_font = $font;
        }
        public function getFooterFont()
        {
            return $this->footer_font;
        }
        public function setLanguageArray($language)
        {
            $this->l = $language;
            $this->rtl = $this->l["a_meta_dir"] == "rtl" ? true : false;
        }
        public function getPDFData()
        {
            if ($this->state < 3) {
                $this->Close();
            }
            return $this->buffer;
        }
        public function addHtmlLink($url, $name, $fill = 0, $firstline = false, $color = "", $style = -1)
        {
            if (!$this->empty_string($url) && $url[0] == "#") {
                $page = intval(substr($url, 1));
                $url = $this->AddLink();
                $this->SetLink($url, 0, $page);
            }
            $prevcolor = $this->fgcolor;
            $prevstyle = $this->FontStyle;
            if (empty($color)) {
                $this->SetTextColorArray($this->htmlLinkColorArray);
            } else {
                $this->SetTextColorArray($color);
            }
            if ($style == -1) {
                $this->SetFont("", $this->FontStyle . $this->htmlLinkFontStyle);
            } else {
                $this->SetFont("", $this->FontStyle . $style);
            }
            $ret = $this->Write($this->lasth, $name, $url, $fill, "", false, 0, $firstline);
            $this->SetFont("", $prevstyle);
            $this->SetTextColorArray($prevcolor);
            return $ret;
        }
        public function convertHTMLColorToDec($color = "#FFFFFF")
        {
            global $webcolor;
            $returncolor = false;
            $color = preg_replace("/[\\s]*/", "", $color);
            $color = strtolower($color);
            if (strlen($color) == 0) {
                return false;
            }
            if (substr($color, 0, 3) == "rgb") {
                $codes = substr($color, 4);
                $codes = str_replace(")", "", $codes);
                $returncolor = explode(",", $codes, 3);
                return $returncolor;
            }
            if (substr($color, 0, 1) != "#") {
                if (isset($webcolor[$color])) {
                    $color_code = $webcolor[$color];
                } else {
                    return false;
                }
            } else {
                $color_code = substr($color, 1);
            }
            strlen($color_code);
            switch (strlen($color_code)) {
                case 3:
                    $r = substr($color_code, 0, 1);
                    $g = substr($color_code, 1, 1);
                    $b = substr($color_code, 2, 1);
                    $returncolor["R"] = hexdec($r . $r);
                    $returncolor["G"] = hexdec($g . $g);
                    $returncolor["B"] = hexdec($b . $b);
                    break;
                case 6:
                    $returncolor["R"] = hexdec(substr($color_code, 0, 2));
                    $returncolor["G"] = hexdec(substr($color_code, 2, 2));
                    $returncolor["B"] = hexdec(substr($color_code, 4, 2));
                    break;
                default:
                    return $returncolor;
            }
        }
        public function pixelsToUnits($px)
        {
            return $px / ($this->imgscale * $this->k);
        }
        public function unhtmlentities($text_to_convert)
        {
            require_once dirname(__FILE__) . "/html_entity_decode_php4.php";
            if (!$this->isunicode) {
                return html_entity_decode($text_to_convert);
            }
            return html_entity_decode_php4($text_to_convert);
        }
        public function _objectkey($n)
        {
            return substr($this->_md5_16($this->encryption_key . pack("VXxx", $n)), 0, 10);
        }
        public function _putencryption()
        {
            $this->_out("/Filter /Standard");
            $this->_out("/V 1");
            $this->_out("/R 2");
            $this->_out("/O (" . $this->_escape($this->Ovalue) . ")");
            $this->_out("/U (" . $this->_escape($this->Uvalue) . ")");
            $this->_out("/P " . $this->Pvalue);
        }
        public function _RC4($key, $text)
        {
            if ($this->last_rc4_key != $key) {
                $k = str_repeat($key, 256 / strlen($key) + 1);
                $rc4 = range(0, 255);
                $j = 0;
                for ($i = 0; $i < 256; $i++) {
                    $t = $rc4[$i];
                    $j = ($j + $t + ord($k[$i])) % 256;
                    $rc4[$i] = $rc4[$j];
                    $rc4[$j] = $t;
                }
                $this->last_rc4_key = $key;
                $this->last_rc4_key_c = $rc4;
            } else {
                $rc4 = $this->last_rc4_key_c;
            }
            $len = strlen($text);
            $a = 0;
            $b = 0;
            $out = "";
            for ($i = 0; $i < $len; $i++) {
                $a = ($a + 1) % 256;
                $t = $rc4[$a];
                $b = ($b + $t) % 256;
                $rc4[$a] = $rc4[$b];
                $rc4[$b] = $t;
                $k = $rc4[($rc4[$a] + $rc4[$b]) % 256];
                $out .= chr(ord($text[$i]) ^ $k);
            }
            return $out;
        }
        public function _md5_16($str)
        {
            return pack("H*", md5($str));
        }
        public function _Ovalue($user_pass, $owner_pass)
        {
            $tmp = $this->_md5_16($owner_pass);
            $owner_RC4_key = substr($tmp, 0, 5);
            return $this->_RC4($owner_RC4_key, $user_pass);
        }
        public function _Uvalue()
        {
            return $this->_RC4($this->encryption_key, $this->padding);
        }
        public function _generateencryptionkey($user_pass, $owner_pass, $protection)
        {
            $user_pass = substr($user_pass . $this->padding, 0, 32);
            $owner_pass = substr($owner_pass . $this->padding, 0, 32);
            $this->Ovalue = $this->_Ovalue($user_pass, $owner_pass);
            $tmp = $this->_md5_16($user_pass . $this->Ovalue . chr($protection) . "���");
            $this->encryption_key = substr($tmp, 0, 5);
            $this->Uvalue = $this->_Uvalue();
            $this->Pvalue = -1 * (($protection ^ 255) + 1);
        }
        public function SetProtection($permissions = [], $user_pass = "", $owner_pass = NULL)
        {
            $options = ["print" => 4, "modify" => 8, "copy" => 16, "annot-forms" => 32];
            $protection = 192;
            foreach ($permissions as $permission) {
                if (!isset($options[$permission])) {
                    $this->Error("Incorrect permission: " . $permission);
                }
                $protection += $options[$permission];
            }
            if ($owner_pass === NULL) {
                $owner_pass = uniqid(rand());
            }
            $this->encrypted = true;
            $this->_generateencryptionkey($user_pass, $owner_pass, $protection);
        }
        public function StartTransform()
        {
            $this->_out("q");
            $this->transfmrk[$this->page][] = $this->pagelen[$this->page];
        }
        public function StopTransform()
        {
            $this->_out("Q");
            if (isset($this->transfmatrix)) {
                array_pop($this->transfmatrix);
            }
            array_pop($this->transfmrk[$this->page]);
        }
        public function ScaleX($s_x, $x = "", $y = "")
        {
            $this->Scale($s_x, 100, $x, $y);
        }
        public function ScaleY($s_y, $x = "", $y = "")
        {
            $this->Scale(100, $s_y, $x, $y);
        }
        public function ScaleXY($s, $x = "", $y = "")
        {
            $this->Scale($s, $s, $x, $y);
        }
        public function Scale($s_x, $s_y, $x = "", $y = "")
        {
            if ($x === "") {
                $x = $this->x;
            }
            if ($y === "") {
                $y = $this->y;
            }
            if ($this->rtl) {
                $x = $this->w - $x;
            }
            if ($s_x == 0 || $s_y == 0) {
                $this->Error("Please do not use values equal to zero for scaling");
            }
            $y = ($this->h - $y) * $this->k;
            $x *= $this->k;
            $s_x /= 100;
            $s_y /= 100;
            $tm[0] = $s_x;
            $tm[1] = 0;
            $tm[2] = 0;
            $tm[3] = $s_y;
            $tm[4] = $x * (1 - $s_x);
            $tm[5] = $y * (1 - $s_y);
            $this->Transform($tm);
        }
        public function MirrorH($x = "")
        {
            $this->Scale(-100, 100, $x);
        }
        public function MirrorV($y = "")
        {
            $this->Scale(100, -100, "", $y);
        }
        public function MirrorP($x = "", $y = "")
        {
            $this->Scale(-100, -100, $x, $y);
        }
        public function MirrorL($angle = 0, $x = "", $y = "")
        {
            $this->Scale(-100, 100, $x, $y);
            $this->Rotate(-2 * ($angle - 90), $x, $y);
        }
        public function TranslateX($t_x)
        {
            $this->Translate($t_x, 0);
        }
        public function TranslateY($t_y)
        {
            $this->Translate(0, $t_y);
        }
        public function Translate($t_x, $t_y)
        {
            if ($this->rtl) {
                $t_x = -1 * $t_x;
            }
            $tm[0] = 1;
            $tm[1] = 0;
            $tm[2] = 0;
            $tm[3] = 1;
            $tm[4] = $t_x * $this->k;
            $tm[5] = -1 * $t_y * $this->k;
            $this->Transform($tm);
        }
        public function Rotate($angle, $x = "", $y = "")
        {
            if ($x === "") {
                $x = $this->x;
            }
            if ($y === "") {
                $y = $this->y;
            }
            if ($this->rtl) {
                $x = $this->w - $x;
                $angle = -1 * $angle;
            }
            $y = ($this->h - $y) * $this->k;
            $x *= $this->k;
            $tm[0] = cos(deg2rad($angle));
            $tm[1] = sin(deg2rad($angle));
            $tm[2] = -1 * $tm[1];
            $tm[3] = $tm[0];
            $tm[4] = $x + $tm[1] * $y - $tm[0] * $x;
            $tm[5] = $y - $tm[0] * $y - $tm[1] * $x;
            $this->Transform($tm);
        }
        public function SkewX($angle_x, $x = "", $y = "")
        {
            $this->Skew($angle_x, 0, $x, $y);
        }
        public function SkewY($angle_y, $x = "", $y = "")
        {
            $this->Skew(0, $angle_y, $x, $y);
        }
        public function Skew($angle_x, $angle_y, $x = "", $y = "")
        {
            if ($x === "") {
                $x = $this->x;
            }
            if ($y === "") {
                $y = $this->y;
            }
            if ($this->rtl) {
                $x = $this->w - $x;
                $angle_x = -1 * $angle_x;
            }
            if ($angle_x <= -90 || 90 <= $angle_x || $angle_y <= -90 || 90 <= $angle_y) {
                $this->Error("Please use values between -90 and +90 degrees for Skewing.");
            }
            $x *= $this->k;
            $y = ($this->h - $y) * $this->k;
            $tm[0] = 1;
            $tm[1] = tan(deg2rad($angle_y));
            $tm[2] = tan(deg2rad($angle_x));
            $tm[3] = 1;
            $tm[4] = -1 * $tm[2] * $y;
            $tm[5] = -1 * $tm[1] * $x;
            $this->Transform($tm);
        }
        public function Transform($tm)
        {
            $this->_out(sprintf("%.3F %.3F %.3F %.3F %.3F %.3F cm", $tm[0], $tm[1], $tm[2], $tm[3], $tm[4], $tm[5]));
            $this->transfmatrix[] = ["a" => $tm[0], "b" => $tm[1], "c" => $tm[2], "d" => $tm[3], "e" => $tm[4], "f" => $tm[5]];
            if (end($this->transfmrk[$this->page]) !== false) {
                $key = key($this->transfmrk[$this->page]);
                $this->transfmrk[$this->page][$key] = $this->pagelen[$this->page];
            }
        }
        public function SetLineWidth($width)
        {
            $this->LineWidth = $width;
            $this->linestyleWidth = sprintf("%.2F w", $width * $this->k);
            $this->_out($this->linestyleWidth);
        }
        public function GetLineWidth()
        {
            return $this->LineWidth;
        }
        public function SetLineStyle($style)
        {
            extract($style);
            if (isset($width)) {
                $width_prev = $this->LineWidth;
                $this->SetLineWidth($width);
                $this->LineWidth = $width_prev;
            }
            if (isset($cap)) {
                $ca = ["butt" => 0, "round" => 1, "square" => 2];
                if (isset($ca[$cap])) {
                    $this->linestyleCap = $ca[$cap] . " J";
                    $this->_out($this->linestyleCap);
                }
            }
            if (isset($join)) {
                $ja = ["miter" => 0, "round" => 1, "bevel" => 2];
                if (isset($ja[$join])) {
                    $this->linestyleJoin = $ja[$join] . " j";
                    $this->_out($this->linestyleJoin);
                }
            }
            if (isset($dash)) {
                $dash_string = "";
                if ($dash) {
                    if (stripos($dash, ",") !== false) {
                        $tab = explode(",", $dash);
                    } else {
                        $tab = [$dash];
                    }
                    $dash_string = "";
                    foreach ($tab as $i => $v) {
                        if ($i) {
                            $dash_string .= " ";
                        }
                        $dash_string .= sprintf("%.2F", $v);
                    }
                }
                if (!isset($phase) || !$dash) {
                    $phase = 0;
                }
                $this->linestyleDash = sprintf("[%s] %.2F d", $dash_string, $phase);
                $this->_out($this->linestyleDash);
            }
            if (isset($color)) {
                $this->SetDrawColorArray($color);
            }
        }
        public function _outPoint($x, $y)
        {
            if ($this->rtl) {
                $x = $this->w - $x;
            }
            $this->_out(sprintf("%.2F %.2F m", $x * $this->k, ($this->h - $y) * $this->k));
        }
        public function _outLine($x, $y)
        {
            if ($this->rtl) {
                $x = $this->w - $x;
            }
            $this->_out(sprintf("%.2F %.2F l", $x * $this->k, ($this->h - $y) * $this->k));
        }
        public function _outRect($x, $y, $w, $h, $op)
        {
            if ($this->rtl) {
                $x = $this->w - $x - $w;
            }
            $this->_out(sprintf("%.2F %.2F %.2F %.2F re %s", $x * $this->k, ($this->h - $y) * $this->k, $w * $this->k, -1 * $h * $this->k, $op));
        }
        public function _outCurve($x1, $y1, $x2, $y2, $x3, $y3)
        {
            if ($this->rtl) {
                $x1 = $this->w - $x1;
                $x2 = $this->w - $x2;
                $x3 = $this->w - $x3;
            }
            $this->_out(sprintf("%.2F %.2F %.2F %.2F %.2F %.2F c", $x1 * $this->k, ($this->h - $y1) * $this->k, $x2 * $this->k, ($this->h - $y2) * $this->k, $x3 * $this->k, ($this->h - $y3) * $this->k));
        }
        public function Line($x1, $y1, $x2, $y2, $style = [])
        {
            if ($style) {
                $this->SetLineStyle($style);
            }
            $this->_outPoint($x1, $y1);
            $this->_outLine($x2, $y2);
            $this->_out(" S");
        }
        public function Rect($x, $y, $w, $h, $style = "", $border_style = [], $fill_color = [])
        {
            while (false !== strpos($style, "F") && isset($fill_color)) {
                $this->SetFillColorArray($fill_color);
            }
            switch ($style) {
                case "F":
                    $op = "f";
                    $border_style = [];
                    $this->_outRect($x, $y, $w, $h, $op);
                    break;
                case "DF":
                case "FD":
                    if (!$border_style || isset($border_style["all"])) {
                        $op = "B";
                        if (isset($border_style["all"])) {
                            $this->SetLineStyle($border_style["all"]);
                            $border_style = [];
                        }
                    } else {
                        $op = "f";
                    }
                    $this->_outRect($x, $y, $w, $h, $op);
                    break;
                case "CNZ":
                    $op = "W n";
                    $this->_outRect($x, $y, $w, $h, $op);
                    break;
                case "CEO":
                    $op = "W* n";
                    $this->_outRect($x, $y, $w, $h, $op);
                    break;
                default:
                    $op = "S";
                    if (!$border_style || isset($border_style["all"])) {
                        if (isset($border_style["all"]) && $border_style["all"]) {
                            $this->SetLineStyle($border_style["all"]);
                            $border_style = [];
                        }
                        $this->_outRect($x, $y, $w, $h, $op);
                    }
                    if ($border_style) {
                        $border_style2 = [];
                        foreach ($border_style as $line => $value) {
                            $lenght = strlen($line);
                            for ($i = 0; $i < $lenght; $i++) {
                                $border_style2[$line[$i]] = $value;
                            }
                        }
                        $border_style = $border_style2;
                        if (isset($border_style["L"]) && $border_style["L"]) {
                            $this->Line($x, $y, $x, $y + $h, $border_style["L"]);
                        }
                        if (isset($border_style["T"]) && $border_style["T"]) {
                            $this->Line($x, $y, $x + $w, $y, $border_style["T"]);
                        }
                        if (isset($border_style["R"]) && $border_style["R"]) {
                            $this->Line($x + $w, $y, $x + $w, $y + $h, $border_style["R"]);
                        }
                        if (isset($border_style["B"]) && $border_style["B"]) {
                            $this->Line($x, $y + $h, $x + $w, $y + $h, $border_style["B"]);
                        }
                    }
            }
        }
        public function Curve($x0, $y0, $x1, $y1, $x2, $y2, $x3, $y3, $style = "", $line_style = [], $fill_color = [])
        {
            while (false !== strpos($style, "F") && isset($fill_color)) {
                $this->SetFillColorArray($fill_color);
            }
            switch ($style) {
                case "F":
                    $op = "f";
                    $line_style = [];
                    break;
                case "FD":
                case "DF":
                    $op = "B";
                    break;
                case "CNZ":
                    $op = "W n";
                    break;
                case "CEO":
                    $op = "W* n";
                    break;
                default:
                    $op = "S";
                    if ($line_style) {
                        $this->SetLineStyle($line_style);
                    }
                    $this->_outPoint($x0, $y0);
                    $this->_outCurve($x1, $y1, $x2, $y2, $x3, $y3);
                    $this->_out($op);
            }
        }
        public function Polycurve($x0, $y0, $segments, $style = "", $line_style = [], $fill_color = [])
        {
            while (false !== strpos($style, "F") && isset($fill_color)) {
                $this->SetFillColorArray($fill_color);
            }
            switch ($style) {
                case "F":
                    $op = "f";
                    $line_style = [];
                    break;
                case "FD":
                case "DF":
                    $op = "B";
                    break;
                case "CNZ":
                    $op = "W n";
                    break;
                case "CEO":
                    $op = "W* n";
                    break;
                default:
                    $op = "S";
                    if ($line_style) {
                        $this->SetLineStyle($line_style);
                    }
                    $this->_outPoint($x0, $y0);
                    foreach ($segments as $segment) {
                        list($x1, $y1, $x2, $y2, $x3, $y3) = $segment;
                        $this->_outCurve($x1, $y1, $x2, $y2, $x3, $y3);
                    }
                    $this->_out($op);
            }
        }
        public function Ellipse($x0, $y0, $rx, $ry = 0, $angle = 0, $astart = 0, $afinish = 360, $style = "", $line_style = [], $fill_color = [], $nc = 8)
        {
            while ($angle) {
                if ($rx) {
                    if (false !== strpos($style, "F") && isset($fill_color)) {
                        $this->SetFillColorArray($fill_color);
                    }
                    switch ($style) {
                        case "F":
                            $op = "f";
                            $line_style = [];
                            break;
                        case "FD":
                        case "DF":
                            $op = "B";
                            break;
                        case "C":
                            $op = "s";
                            break;
                        case "CNZ":
                            $op = "W n";
                            break;
                        case "CEO":
                            $op = "W* n";
                            break;
                        default:
                            $op = "S";
                            if ($line_style) {
                                $this->SetLineStyle($line_style);
                            }
                            if (!$ry) {
                                $ry = $rx;
                            }
                            $rx *= $this->k;
                            $ry *= $this->k;
                            if ($nc < 2) {
                                $nc = 2;
                            }
                            $astart = deg2rad((double) $astart);
                            $afinish = deg2rad((double) $afinish);
                            $total_angle = $afinish - $astart;
                            $dt = $total_angle / $nc;
                            $dtm = $dt / 3;
                            $x0 *= $this->k;
                            $y0 = ($this->h - $y0) * $this->k;
                            $t1 = $astart;
                            $a0 = $x0 + $rx * cos($t1);
                            $b0 = $y0 + $ry * sin($t1);
                            $c0 = -1 * $rx * sin($t1);
                            $d0 = $ry * cos($t1);
                            $this->_outPoint($a0 / $this->k, $this->h - $b0 / $this->k);
                            for ($i = 1; $i <= $nc; $i++) {
                                $t1 = $i * $dt + $astart;
                                $a1 = $x0 + $rx * cos($t1);
                                $b1 = $y0 + $ry * sin($t1);
                                $c1 = -1 * $rx * sin($t1);
                                $d1 = $ry * cos($t1);
                                $this->_outCurve(($a0 + $c0 * $dtm) / $this->k, $this->h - ($b0 + $d0 * $dtm) / $this->k, ($a1 - $c1 * $dtm) / $this->k, $this->h - ($b1 - $d1 * $dtm) / $this->k, $a1 / $this->k, $this->h - $b1 / $this->k);
                                $a0 = $a1;
                                $b0 = $b1;
                                $c0 = $c1;
                                $d0 = $d1;
                            }
                            $this->_out($op);
                    }
                }
            }
            $this->StartTransform();
            $this->Rotate($angle, $x0, $y0);
            $this->Ellipse($x0, $y0, $rx, $ry, 0, $astart, $afinish, $style, $line_style, $fill_color, $nc);
            $this->StopTransform();
        }
        public function Circle($x0, $y0, $r, $astart = 0, $afinish = 360, $style = "", $line_style = [], $fill_color = [], $nc = 8)
        {
            $this->Ellipse($x0, $y0, $r, 0, 0, $astart, $afinish, $style, $line_style, $fill_color, $nc);
        }
        public function Polygon($p, $style = "", $line_style = [], $fill_color = [])
        {
            $np = count($p) / 2;
            if (false !== strpos($style, "F") && isset($fill_color)) {
                $this->SetFillColorArray($fill_color);
            }
            switch ($style) {
                case "F":
                    $line_style = [];
                    $op = "f";
                    break;
                case "FD":
                case "DF":
                    $op = "B";
                    break;
                case "CNZ":
                    $op = "W n";
                    break;
                case "CEO":
                    $op = "W* n";
                    break;
                default:
                    $op = "S";
                    $draw = true;
                    if ($line_style) {
                        if (isset($line_style["all"])) {
                            $this->SetLineStyle($line_style["all"]);
                        } else {
                            $draw = false;
                            if ("B" == $op) {
                                $op = "f";
                                $this->_outPoint($p[0], $p[1]);
                                $i = 2;
                                while ($i < $np * 2) {
                                    $this->_outLine($p[$i], $p[$i + 1]);
                                    $i = $i + 2;
                                }
                                $this->_outLine($p[0], $p[1]);
                                $this->_out($op);
                            }
                            list($p[$np * 2], $p[$np * 2 + 1]) = $p;
                            for ($i = 0; $i < $np; $i++) {
                                if (isset($line_style[$i]) && $line_style[$i] != 0) {
                                    $this->Line($p[$i * 2], $p[$i * 2 + 1], $p[$i * 2 + 2], $p[$i * 2 + 3], $line_style[$i]);
                                }
                            }
                        }
                    }
                    if ($draw) {
                        $this->_outPoint($p[0], $p[1]);
                        $i = 2;
                        while ($i < $np * 2) {
                            $this->_outLine($p[$i], $p[$i + 1]);
                            $i = $i + 2;
                        }
                        $this->_outLine($p[0], $p[1]);
                        $this->_out($op);
                    }
            }
        }
        public function RegularPolygon($x0, $y0, $r, $ns, $angle = 0, $draw_circle = false, $style = "", $line_style = [], $fill_color = [], $circle_style = "", $circle_outLine_style = [], $circle_fill_color = [])
        {
            if ($ns < 3) {
                $ns = 3;
            }
            if ($draw_circle) {
                $this->Circle($x0, $y0, $r, 0, 360, $circle_style, $circle_outLine_style, $circle_fill_color);
            }
            $p = [];
            for ($i = 0; $i < $ns; $i++) {
                $a = $angle + $i * 360 / $ns;
                $a_rad = deg2rad((double) $a);
                $p[] = $x0 + $r * sin($a_rad);
                $p[] = $y0 + $r * cos($a_rad);
            }
            $this->Polygon($p, $style, $line_style, $fill_color);
        }
        public function StarPolygon($x0, $y0, $r, $nv, $ng, $angle = 0, $draw_circle = false, $style = "", $line_style = [], $fill_color = [], $circle_style = "", $circle_outLine_style = [], $circle_fill_color = [])
        {
            if ($nv < 2) {
                $nv = 2;
            }
            if ($draw_circle) {
                $this->Circle($x0, $y0, $r, 0, 360, $circle_style, $circle_outLine_style, $circle_fill_color);
            }
            $p2 = [];
            $visited = [];
            for ($i = 0; $i < $nv; $i++) {
                $a = $angle + $i * 360 / $nv;
                $a_rad = deg2rad((double) $a);
                $p2[] = $x0 + $r * sin($a_rad);
                $p2[] = $y0 + $r * cos($a_rad);
                $visited[] = false;
            }
            $p = [];
            do {
                $i = 0;
                $p[] = $p2[$i * 2];
                $p[] = $p2[$i * 2 + 1];
                $visited[$i] = true;
                $i += $ng;
                $i %= $nv;
            } while ($visited[$i]);
            $this->Polygon($p, $style, $line_style, $fill_color);
        }
        public function RoundedRect($x, $y, $w, $h, $r, $round_corner = "1111", $style = "", $border_style = [], $fill_color = [])
        {
            while ("0000" == $round_corner) {
                if (false !== strpos($style, "F") && isset($fill_color)) {
                    $this->SetFillColorArray($fill_color);
                }
                switch ($style) {
                    case "F":
                        $border_style = [];
                        $op = "f";
                        break;
                    case "FD":
                    case "DF":
                        $op = "B";
                        break;
                    case "CNZ":
                        $op = "W n";
                        break;
                    case "CEO":
                        $op = "W* n";
                        break;
                    default:
                        $op = "S";
                        if ($border_style) {
                            $this->SetLineStyle($border_style);
                        }
                        $MyArc = 0 * (sqrt(2) - 1);
                        $this->_outPoint($x + $r, $y);
                        $xc = $x + $w - $r;
                        $yc = $y + $r;
                        $this->_outLine($xc, $y);
                        if ($round_corner[0]) {
                            $this->_outCurve($xc + $r * $MyArc, $yc - $r, $xc + $r, $yc - $r * $MyArc, $xc + $r, $yc);
                        } else {
                            $this->_outLine($x + $w, $y);
                        }
                        $xc = $x + $w - $r;
                        $yc = $y + $h - $r;
                        $this->_outLine($x + $w, $yc);
                        if ($round_corner[1]) {
                            $this->_outCurve($xc + $r, $yc + $r * $MyArc, $xc + $r * $MyArc, $yc + $r, $xc, $yc + $r);
                        } else {
                            $this->_outLine($x + $w, $y + $h);
                        }
                        $xc = $x + $r;
                        $yc = $y + $h - $r;
                        $this->_outLine($xc, $y + $h);
                        if ($round_corner[2]) {
                            $this->_outCurve($xc - $r * $MyArc, $yc + $r, $xc - $r, $yc + $r * $MyArc, $xc - $r, $yc);
                        } else {
                            $this->_outLine($x, $y + $h);
                        }
                        $xc = $x + $r;
                        $yc = $y + $r;
                        $this->_outLine($x, $yc);
                        if ($round_corner[3]) {
                            $this->_outCurve($xc - $r, $yc - $r * $MyArc, $xc - $r * $MyArc, $yc - $r, $xc, $yc - $r);
                        } else {
                            $this->_outLine($x, $y);
                            $this->_outLine($x + $r, $y);
                        }
                        $this->_out($op);
                }
                $this->Rect($x, $y, $w, $h, $style, $border_style, $fill_color);
            }
        }
        public function utf8StrRev($str, $setbom = false, $forcertl = false)
        {
            return $this->arrUTF8ToUTF16BE($this->utf8Bidi($this->UTF8StringToArray($str), $str, $forcertl), $setbom);
        }
        public function utf8Bidi($ta, $str = "", $forcertl = false)
        {
            global $unicode;
            global $unicode_mirror;
            global $unicode_arlet;
            global $laa_array;
            global $diacritics;
            $pel = 0;
            $maxlevel = 0;
            if ($this->empty_string($str)) {
                $str = $this->UTF8ArrSubString($ta);
            }
            if (preg_match(K_RE_PATTERN_ARABIC, $str)) {
                $arabic = true;
            } else {
                $arabic = false;
            }
            if (!($forcertl || $arabic || preg_match(K_RE_PATTERN_RTL, $str))) {
                return $ta;
            }
            $numchars = count($ta);
            if ($forcertl == "R") {
                $pel = 1;
            } else {
                if ($forcertl == "L") {
                    $pel = 0;
                } else {
                    $i = 0;
                    while ($i < $numchars) {
                        $type = $unicode[$ta[$i]];
                        if ($type == "L") {
                            $pel = 0;
                        } else {
                            if ($type == "AL" || $type == "R") {
                                $pel = 1;
                            } else {
                                $i++;
                            }
                        }
                    }
                }
            }
            $cel = $pel;
            $dos = "N";
            $remember = [];
            $sor = $pel % 2 ? "R" : "L";
            $eor = $sor;
            $chardata = [];
            for ($i = 0; $i < $numchars; $i++) {
                if ($ta[$i] == K_RLE) {
                    $next_level = $cel + $cel % 2 + 1;
                    if ($next_level < 62) {
                        $remember[] = ["num" => K_RLE, "cel" => $cel, "dos" => $dos];
                        $cel = $next_level;
                        $dos = "N";
                        $sor = $eor;
                        $eor = $cel % 2 ? "R" : "L";
                    }
                } else {
                    if ($ta[$i] == K_LRE) {
                        $next_level = $cel + 2 - $cel % 2;
                        if ($next_level < 62) {
                            $remember[] = ["num" => K_LRE, "cel" => $cel, "dos" => $dos];
                            $cel = $next_level;
                            $dos = "N";
                            $sor = $eor;
                            $eor = $cel % 2 ? "R" : "L";
                        }
                    } else {
                        if ($ta[$i] == K_RLO) {
                            $next_level = $cel + $cel % 2 + 1;
                            if ($next_level < 62) {
                                $remember[] = ["num" => K_RLO, "cel" => $cel, "dos" => $dos];
                                $cel = $next_level;
                                $dos = "R";
                                $sor = $eor;
                                $eor = $cel % 2 ? "R" : "L";
                            }
                        } else {
                            if ($ta[$i] == K_LRO) {
                                $next_level = $cel + 2 - $cel % 2;
                                if ($next_level < 62) {
                                    $remember[] = ["num" => K_LRO, "cel" => $cel, "dos" => $dos];
                                    $cel = $next_level;
                                    $dos = "L";
                                    $sor = $eor;
                                    $eor = $cel % 2 ? "R" : "L";
                                }
                            } else {
                                if ($ta[$i] == K_PDF) {
                                    if (count($remember)) {
                                        $last = count($remember) - 1;
                                        if ($remember[$last]["num"] == K_RLE || $remember[$last]["num"] == K_LRE || $remember[$last]["num"] == K_RLO || $remember[$last]["num"] == K_LRO) {
                                            $match = array_pop($remember);
                                            $cel = $match["cel"];
                                            $dos = $match["dos"];
                                            $sor = $eor;
                                            $eor = ($match["cel"] < $cel ? $cel : $match["cel"]) % 2 ? "R" : "L";
                                        }
                                    }
                                } else {
                                    if ($ta[$i] != K_RLE && $ta[$i] != K_LRE && $ta[$i] != K_RLO && $ta[$i] != K_LRO && $ta[$i] != K_PDF) {
                                        if ($dos != "N") {
                                            $chardir = $dos;
                                        } else {
                                            $chardir = $unicode[$ta[$i]];
                                        }
                                        $chardata[] = ["char" => $ta[$i], "level" => $cel, "type" => $chardir, "sor" => $sor, "eor" => $eor];
                                    }
                                }
                            }
                        }
                    }
                }
            }
            $numchars = count($chardata);
            $prevlevel = -1;
            $levcount = 0;
            for ($i = 0; $i < $numchars; $i++) {
                if ($chardata[$i]["type"] == "NSM") {
                    if ($levcount) {
                        $chardata[$i]["type"] = $chardata[$i]["sor"];
                    } else {
                        if (0 < $i) {
                            $chardata[$i]["type"] = $chardata[$i - 1]["type"];
                        }
                    }
                }
                if ($chardata[$i]["level"] != $prevlevel) {
                    $levcount = 0;
                } else {
                    $levcount++;
                }
                $prevlevel = $chardata[$i]["level"];
            }
            $prevlevel = -1;
            $levcount = 0;
            for ($i = 0; $i < $numchars; $i++) {
                if ($chardata[$i]["char"] == "EN") {
                    for ($j = $levcount; 0 <= $j; $j--) {
                        if ($chardata[$j]["type"] == "AL") {
                            $chardata[$i]["type"] = "AN";
                        } else {
                            if (!($chardata[$j]["type"] == "L" || $chardata[$j]["type"] == "R")) {
                            }
                        }
                    }
                }
                if ($chardata[$i]["level"] != $prevlevel) {
                    $levcount = 0;
                } else {
                    $levcount++;
                }
                $prevlevel = $chardata[$i]["level"];
            }
            for ($i = 0; $i < $numchars; $i++) {
                if ($chardata[$i]["type"] == "AL") {
                    $chardata[$i]["type"] = "R";
                }
            }
            $prevlevel = -1;
            $levcount = 0;
            for ($i = 0; $i < $numchars; $i++) {
                if (0 < $levcount && $i + 1 < $numchars && $chardata[$i + 1]["level"] == $prevlevel) {
                    if ($chardata[$i]["type"] == "ES" && $chardata[$i - 1]["type"] == "EN" && $chardata[$i + 1]["type"] == "EN") {
                        $chardata[$i]["type"] = "EN";
                    } else {
                        if ($chardata[$i]["type"] == "CS" && $chardata[$i - 1]["type"] == "EN" && $chardata[$i + 1]["type"] == "EN") {
                            $chardata[$i]["type"] = "EN";
                        } else {
                            if ($chardata[$i]["type"] == "CS" && $chardata[$i - 1]["type"] == "AN" && $chardata[$i + 1]["type"] == "AN") {
                                $chardata[$i]["type"] = "AN";
                            }
                        }
                    }
                }
                if ($chardata[$i]["level"] != $prevlevel) {
                    $levcount = 0;
                } else {
                    $levcount++;
                }
                $prevlevel = $chardata[$i]["level"];
            }
            $prevlevel = -1;
            $levcount = 0;
            for ($i = 0; $i < $numchars; $i++) {
                if ($chardata[$i]["type"] == "ET") {
                    if (0 < $levcount && $chardata[$i - 1]["type"] == "EN") {
                        $chardata[$i]["type"] = "EN";
                    } else {
                        $j = $i + 1;
                        while ($j < $numchars && $chardata[$j]["level"] == $prevlevel) {
                            if ($chardata[$j]["type"] == "EN") {
                                $chardata[$i]["type"] = "EN";
                            } else {
                                if ($chardata[$j]["type"] == "ET") {
                                    $j++;
                                }
                            }
                        }
                    }
                }
                if ($chardata[$i]["level"] != $prevlevel) {
                    $levcount = 0;
                } else {
                    $levcount++;
                }
                $prevlevel = $chardata[$i]["level"];
            }
            $prevlevel = -1;
            $levcount = 0;
            for ($i = 0; $i < $numchars; $i++) {
                if ($chardata[$i]["type"] == "ET" || $chardata[$i]["type"] == "ES" || $chardata[$i]["type"] == "CS") {
                    $chardata[$i]["type"] = "ON";
                }
                if ($chardata[$i]["level"] != $prevlevel) {
                    $levcount = 0;
                } else {
                    $levcount++;
                }
                $prevlevel = $chardata[$i]["level"];
            }
            $prevlevel = -1;
            $levcount = 0;
            for ($i = 0; $i < $numchars; $i++) {
                if ($chardata[$i]["char"] == "EN") {
                    for ($j = $levcount; 0 <= $j; $j--) {
                        if ($chardata[$j]["type"] == "L") {
                            $chardata[$i]["type"] = "L";
                        } else {
                            if ($chardata[$j]["type"] != "R") {
                            }
                        }
                    }
                }
                if ($chardata[$i]["level"] != $prevlevel) {
                    $levcount = 0;
                } else {
                    $levcount++;
                }
                $prevlevel = $chardata[$i]["level"];
            }
            $prevlevel = -1;
            $levcount = 0;
            for ($i = 0; $i < $numchars; $i++) {
                if (0 < $levcount && $i + 1 < $numchars && $chardata[$i + 1]["level"] == $prevlevel) {
                    if ($chardata[$i]["type"] == "N" && $chardata[$i - 1]["type"] == "L" && $chardata[$i + 1]["type"] == "L") {
                        $chardata[$i]["type"] = "L";
                    } else {
                        if ($chardata[$i]["type"] == "N" && ($chardata[$i - 1]["type"] == "R" || $chardata[$i - 1]["type"] == "EN" || $chardata[$i - 1]["type"] == "AN") && ($chardata[$i + 1]["type"] == "R" || $chardata[$i + 1]["type"] == "EN" || $chardata[$i + 1]["type"] == "AN")) {
                            $chardata[$i]["type"] = "R";
                        } else {
                            if ($chardata[$i]["type"] == "N") {
                                $chardata[$i]["type"] = $chardata[$i]["sor"];
                            }
                        }
                    }
                } else {
                    if ($levcount == 0 && $i + 1 < $numchars && $chardata[$i + 1]["level"] == $prevlevel) {
                        if ($chardata[$i]["type"] == "N" && $chardata[$i]["sor"] == "L" && $chardata[$i + 1]["type"] == "L") {
                            $chardata[$i]["type"] = "L";
                        } else {
                            if ($chardata[$i]["type"] == "N" && ($chardata[$i]["sor"] == "R" || $chardata[$i]["sor"] == "EN" || $chardata[$i]["sor"] == "AN") && ($chardata[$i + 1]["type"] == "R" || $chardata[$i + 1]["type"] == "EN" || $chardata[$i + 1]["type"] == "AN")) {
                                $chardata[$i]["type"] = "R";
                            } else {
                                if ($chardata[$i]["type"] == "N") {
                                    $chardata[$i]["type"] = $chardata[$i]["sor"];
                                }
                            }
                        }
                    } else {
                        if (0 < $levcount && ($i + 1 == $numchars || $i + 1 < $numchars && $chardata[$i + 1]["level"] != $prevlevel)) {
                            if ($chardata[$i]["type"] == "N" && $chardata[$i - 1]["type"] == "L" && $chardata[$i]["eor"] == "L") {
                                $chardata[$i]["type"] = "L";
                            } else {
                                if ($chardata[$i]["type"] == "N" && ($chardata[$i - 1]["type"] == "R" || $chardata[$i - 1]["type"] == "EN" || $chardata[$i - 1]["type"] == "AN") && ($chardata[$i]["eor"] == "R" || $chardata[$i]["eor"] == "EN" || $chardata[$i]["eor"] == "AN")) {
                                    $chardata[$i]["type"] = "R";
                                } else {
                                    if ($chardata[$i]["type"] == "N") {
                                        $chardata[$i]["type"] = $chardata[$i]["sor"];
                                    }
                                }
                            }
                        } else {
                            if ($chardata[$i]["type"] == "N") {
                                $chardata[$i]["type"] = $chardata[$i]["sor"];
                            }
                        }
                    }
                }
                if ($chardata[$i]["level"] != $prevlevel) {
                    $levcount = 0;
                } else {
                    $levcount++;
                }
                $prevlevel = $chardata[$i]["level"];
            }
            for ($i = 0; $i < $numchars; $i++) {
                $odd = $chardata[$i]["level"] % 2;
                if ($odd) {
                    if ($chardata[$i]["type"] == "L" || $chardata[$i]["type"] == "AN" || $chardata[$i]["type"] == "EN") {
                        $chardata[$i]["level"] += 1;
                    }
                } else {
                    if ($chardata[$i]["type"] == "R") {
                        $chardata[$i]["level"] += 1;
                    } else {
                        if ($chardata[$i]["type"] == "AN" || $chardata[$i]["type"] == "EN") {
                            $chardata[$i]["level"] += 2;
                        }
                    }
                }
                $maxlevel = max($chardata[$i]["level"], $maxlevel);
            }
            for ($i = 0; $i < $numchars; $i++) {
                if ($chardata[$i]["type"] == "B" || $chardata[$i]["type"] == "S") {
                    $chardata[$i]["level"] = $pel;
                } else {
                    if ($chardata[$i]["type"] == "WS") {
                        $j = $i + 1;
                        while ($j < $numchars) {
                            if ($chardata[$j]["type"] == "B" || $chardata[$j]["type"] == "S" || $j == $numchars - 1 && $chardata[$j]["type"] == "WS") {
                                $chardata[$i]["level"] = $pel;
                            } else {
                                if ($chardata[$j]["type"] == "WS") {
                                    $j++;
                                }
                            }
                        }
                    }
                }
            }
            if ($arabic) {
                $endedletter = [1569, 1570, 1571, 1572, 1573, 1575, 1577, 1583, 1584, 1585, 1586, 1608, 1688];
                $alfletter = [1570, 1571, 1573, 1575];
                $chardata2 = $chardata;
                $laaletter = false;
                $charAL = [];
                $x = 0;
                for ($i = 0; $i < $numchars; $i++) {
                    if ($unicode[$chardata[$i]["char"]] == "AL" || $chardata[$i]["char"] == 32 || $chardata[$i]["char"] == 8204) {
                        $charAL[$x] = $chardata[$i];
                        $charAL[$x]["i"] = $i;
                        $chardata[$i]["x"] = $x;
                        $x++;
                    }
                }
                $numAL = $x;
                for ($i = 0; $i < $numchars; $i++) {
                    $thischar = $chardata[$i];
                    if (0 < $i) {
                        $prevchar = $chardata[$i - 1];
                    } else {
                        $prevchar = false;
                    }
                    if ($i + 1 < $numchars) {
                        $nextchar = $chardata[$i + 1];
                    } else {
                        $nextchar = false;
                    }
                    if ($unicode[$thischar["char"]] == "AL") {
                        $x = $thischar["x"];
                        if (0 < $x) {
                            $prevchar = $charAL[$x - 1];
                        } else {
                            $prevchar = false;
                        }
                        if ($x + 1 < $numAL) {
                            $nextchar = $charAL[$x + 1];
                        } else {
                            $nextchar = false;
                        }
                        if ($prevchar !== false && $prevchar["char"] == 1604 && in_array($thischar["char"], $alfletter)) {
                            $arabicarr = $laa_array;
                            $laaletter = true;
                            if (1 < $x) {
                                $prevchar = $charAL[$x - 2];
                            } else {
                                $prevchar = false;
                            }
                        } else {
                            $arabicarr = $unicode_arlet;
                            $laaletter = false;
                        }
                        if ($prevchar !== false && $nextchar !== false && ($unicode[$prevchar["char"]] == "AL" || $unicode[$prevchar["char"]] == "NSM") && ($unicode[$nextchar["char"]] == "AL" || $unicode[$nextchar["char"]] == "NSM") && $prevchar["type"] == $thischar["type"] && $nextchar["type"] == $thischar["type"] && $nextchar["char"] != 1567) {
                            if (in_array($prevchar["char"], $endedletter)) {
                                if (isset($arabicarr[$thischar["char"]][2])) {
                                    $chardata2[$i]["char"] = $arabicarr[$thischar["char"]][2];
                                }
                            } else {
                                if (isset($arabicarr[$thischar["char"]][3])) {
                                    $chardata2[$i]["char"] = $arabicarr[$thischar["char"]][3];
                                }
                            }
                        } else {
                            if ($nextchar !== false && ($unicode[$nextchar["char"]] == "AL" || $unicode[$nextchar["char"]] == "NSM") && $nextchar["type"] == $thischar["type"] && $nextchar["char"] != 1567) {
                                if (isset($arabicarr[$chardata[$i]["char"]][2])) {
                                    $chardata2[$i]["char"] = $arabicarr[$thischar["char"]][2];
                                }
                            } else {
                                if ($prevchar !== false && ($unicode[$prevchar["char"]] == "AL" || $unicode[$prevchar["char"]] == "NSM") && $prevchar["type"] == $thischar["type"] || $nextchar !== false && $nextchar["char"] == 1567) {
                                    if (1 < $i && $thischar["char"] == 1607 && $chardata[$i - 1]["char"] == 1604 && $chardata[$i - 2]["char"] == 1604) {
                                        $chardata2[$i - 2]["char"] = false;
                                        $chardata2[$i - 1]["char"] = false;
                                        $chardata2[$i]["char"] = 65010;
                                    } else {
                                        if ($prevchar !== false && in_array($prevchar["char"], $endedletter)) {
                                            if (isset($arabicarr[$thischar["char"]][0])) {
                                                $chardata2[$i]["char"] = $arabicarr[$thischar["char"]][0];
                                            }
                                        } else {
                                            if (isset($arabicarr[$thischar["char"]][1])) {
                                                $chardata2[$i]["char"] = $arabicarr[$thischar["char"]][1];
                                            }
                                        }
                                    }
                                } else {
                                    if (isset($arabicarr[$thischar["char"]][0])) {
                                        $chardata2[$i]["char"] = $arabicarr[$thischar["char"]][0];
                                    }
                                }
                            }
                        }
                        if ($laaletter) {
                            $chardata2[$charAL[$x - 1]["i"]]["char"] = false;
                        }
                    }
                }
                $cw =& $this->CurrentFont["cw"];
                for ($i = 0; $i < $numchars - 1; $i++) {
                    if ($chardata2[$i]["char"] == 1617 && isset($diacritics[$chardata2[$i + 1]["char"]]) && isset($cw[$diacritics[$chardata2[$i + 1]["char"]]])) {
                        $chardata2[$i]["char"] = false;
                        $chardata2[$i + 1]["char"] = $diacritics[$chardata2[$i + 1]["char"]];
                    }
                }
                foreach ($chardata2 as $key => $value) {
                    if ($value["char"] === false) {
                        unset($chardata2[$key]);
                    }
                }
                $chardata = array_values($chardata2);
                $numchars = count($chardata);
                unset($chardata2);
                unset($arabicarr);
                unset($laaletter);
                unset($charAL);
            }
            for ($j = $maxlevel; 0 < $j; $j--) {
                $ordarray = [];
                $revarr = [];
                $onlevel = false;
                for ($i = 0; $i < $numchars; $i++) {
                    if ($j <= $chardata[$i]["level"]) {
                        $onlevel = true;
                        if (isset($unicode_mirror[$chardata[$i]["char"]])) {
                            $chardata[$i]["char"] = $unicode_mirror[$chardata[$i]["char"]];
                        }
                        $revarr[] = $chardata[$i];
                    } else {
                        if ($onlevel) {
                            $revarr = array_reverse($revarr);
                            $ordarray = array_merge($ordarray, $revarr);
                            $revarr = [];
                            $onlevel = false;
                        }
                        $ordarray[] = $chardata[$i];
                    }
                }
                if ($onlevel) {
                    $revarr = array_reverse($revarr);
                    $ordarray = array_merge($ordarray, $revarr);
                }
                $chardata = $ordarray;
            }
            $ordarray = [];
            for ($i = 0; $i < $numchars; $i++) {
                $ordarray[] = $chardata[$i]["char"];
            }
            return $ordarray;
        }
        public function Bookmark($txt, $level = 0, $y = -1, $page = "")
        {
            if ($level < 0) {
                $level = 0;
            }
            if (isset($this->outlines[0])) {
                $lastoutline = end($this->outlines);
                $maxlevel = $lastoutline["l"] + 1;
            } else {
                $maxlevel = 0;
            }
            if ($maxlevel < $level) {
                $level = $maxlevel;
            }
            if ($y == -1) {
                $y = $this->GetY();
            }
            if (empty($page)) {
                $page = $this->PageNo();
            }
            $this->outlines[] = ["t" => $txt, "l" => $level, "y" => $y, "p" => $page];
        }
        public function _putbookmarks()
        {
            $nb = count($this->outlines);
            if ($nb == 0) {
                return NULL;
            }
            $lru = [];
            $level = 0;
            foreach ($this->outlines as $i => $o) {
                if (0 < $o["l"]) {
                    $parent = $lru[$o["l"] - 1];
                    $this->outlines[$i]["parent"] = $parent;
                    $this->outlines[$parent]["last"] = $i;
                    if ($level < $o["l"]) {
                        $this->outlines[$parent]["first"] = $i;
                    }
                } else {
                    $this->outlines[$i]["parent"] = $nb;
                }
                if ($o["l"] <= $level && 0 < $i) {
                    $prev = $lru[$o["l"]];
                    $this->outlines[$prev]["next"] = $i;
                    $this->outlines[$i]["prev"] = $prev;
                }
                $lru[$o["l"]] = $i;
                $level = $o["l"];
            }
            $n = $this->n + 1;
            foreach ($this->outlines as $i => $o) {
                $this->_newobj();
                $this->_out("<</Title " . $this->_textstring($o["t"]));
                $this->_out("/Parent " . ($n + $o["parent"]) . " 0 R");
                if (isset($o["prev"])) {
                    $this->_out("/Prev " . ($n + $o["prev"]) . " 0 R");
                }
                if (isset($o["next"])) {
                    $this->_out("/Next " . ($n + $o["next"]) . " 0 R");
                }
                if (isset($o["first"])) {
                    $this->_out("/First " . ($n + $o["first"]) . " 0 R");
                }
                if (isset($o["last"])) {
                    $this->_out("/Last " . ($n + $o["last"]) . " 0 R");
                }
                $this->_out(sprintf("/Dest [%d 0 R /XYZ 0 %.2F null]", 1 + 2 * $o["p"], $this->pagedim[$o["p"]]["h"] - $o["y"] * $this->k));
                $this->_out("/Count 0>>");
                $this->_out("endobj");
            }
            $this->_newobj();
            $this->OutlineRoot = $this->n;
            $this->_out("<</Type /Outlines /First " . $n . " 0 R");
            $this->_out("/Last " . ($n + $lru[0]) . " 0 R>>");
            $this->_out("endobj");
        }
        public function IncludeJS($script)
        {
            $this->javascript .= $script;
        }
        public function _putjavascript()
        {
            if (empty($this->javascript)) {
                return NULL;
            }
            $js1 = sprintf("ftcpdfdocsaved=this.addField('%s','%s',%d,[%.2F,%.2F,%.2F,%.2F]);", "tcpdfdocsaved", "text", 0, 0, 1, 0, 1);
            $js2 = "getField('tcpdfdocsaved').value = 'saved';";
            $this->_newobj();
            $this->n_js = $this->n;
            $this->_out("<<");
            $this->_out("/Names [(EmbeddedJS) " . ($this->n + 1) . " 0 R ]");
            $this->_out(">>");
            $this->_out("endobj");
            $this->_newobj();
            $this->_out("<<");
            $this->_out("/S /JavaScript");
            $this->_out("/JS " . $this->_textstring($js1 . "\n" . $this->javascript . "\n" . $js2));
            $this->_out(">>");
            $this->_out("endobj");
        }
        public function _JScolor($color)
        {
            static $aColors = ["transparent", "black", "white", "red", "green", "blue", "cyan", "magenta", "yellow", "dkGray", "gray", "ltGray"];
            if (substr($color, 0, 1) == "#") {
                return sprintf("['RGB',%.3F,%.3F,%.3F]", hexdec(substr($color, 1, 2)) / 255, hexdec(substr($color, 3, 2)) / 255, hexdec(substr($color, 5, 2)) / 255);
            }
            if (!in_array($color, $aColors)) {
                $this->Error("Invalid color: " . $color);
            }
            return "color." . $color;
        }
        public function _addfield($type, $name, $x, $y, $w, $h, $prop)
        {
            if ($this->rtl) {
                $x = $x - $w;
            }
            $this->javascript .= "if(getField('tcpdfdocsaved').value != 'saved') {";
            $k = $this->k;
            $this->javascript .= sprintf("f" . $name . "=this.addField('%s','%s',%d,[%.2F,%.2F,%.2F,%.2F]);", $name, $type, $this->PageNo() - 1, $x * $k, ($this->h - $y) * $k + 1, ($x + $w) * $k, ($this->h - $y - $h) * $k + 1) . "\n";
            $this->javascript .= "f" . $name . ".textSize=" . $this->FontSizePt . ";\n";
            while (list($key, $val) = each($prop)) {
                if (strcmp(substr($key, -5), "Color") == 0) {
                    $val = $this->_JScolor($val);
                } else {
                    $val = "'" . $val . "'";
                }
                $this->javascript .= "f" . $name . "." . $key . "=" . $val . ";\n";
            }
            if ($this->rtl) {
                $this->x -= $w;
            } else {
                $this->x += $w;
            }
            $this->javascript .= "}";
        }
        public function TextField($name, $w, $h, $prop = [])
        {
            $this->_addfield("text", $name, $this->x, $this->y, $w, $h, $prop);
        }
        public function RadioButton($name, $w, $prop = [])
        {
            if (!isset($prop["strokeColor"])) {
                $prop["strokeColor"] = "black";
            }
            $this->_addfield("radiobutton", $name, $this->x, $this->y, $w, $w, $prop);
        }
        public function ListBox($name, $w, $h, $values, $prop = [])
        {
            if (!isset($prop["strokeColor"])) {
                $prop["strokeColor"] = "ltGray";
            }
            $this->_addfield("listbox", $name, $this->x, $this->y, $w, $h, $prop);
            $s = "";
            foreach ($values as $value) {
                $s .= "'" . addslashes($value) . "',";
            }
            $this->javascript .= "f" . $name . ".setItems([" . substr($s, 0, -1) . "]);\n";
        }
        public function ComboBox($name, $w, $h, $values, $prop = [])
        {
            $this->_addfield("combobox", $name, $this->x, $this->y, $w, $h, $prop);
            $s = "";
            foreach ($values as $value) {
                $s .= "'" . addslashes($value) . "',";
            }
            $this->javascript .= "f" . $name . ".setItems([" . substr($s, 0, -1) . "]);\n";
        }
        public function CheckBox($name, $w, $checked = false, $prop = [])
        {
            $prop["value"] = $checked ? "Yes" : "Off";
            if (!isset($prop["strokeColor"])) {
                $prop["strokeColor"] = "black";
            }
            $this->_addfield("checkbox", $name, $this->x, $this->y, $w, $w, $prop);
        }
        public function Button($name, $w, $h, $caption, $action, $prop = [])
        {
            if (!isset($prop["strokeColor"])) {
                $prop["strokeColor"] = "black";
            }
            if (!isset($prop["borderStyle"])) {
                $prop["borderStyle"] = "beveled";
            }
            $this->_addfield("button", $name, $this->x, $this->y, $w, $h, $prop);
            $this->javascript .= "f" . $name . ".buttonSetCaption('" . addslashes($caption) . "');\n";
            $this->javascript .= "f" . $name . ".setAction('MouseUp','" . addslashes($action) . "');\n";
            $this->javascript .= "f" . $name . ".highlight='push';\n";
            $this->javascript .= "f" . $name . ".print=false;\n";
        }
        public function _putuserrights()
        {
            if (!$this->sign || isset($this->signature_data["cert_type"]) && 0 < $this->signature_data["cert_type"]) {
                return NULL;
            }
            $this->_out("/Perms");
            $this->_out("<<");
            $this->_out("/UR3");
            $this->_out("<<");
            $this->_out("/Type/Sig");
            $this->_out("/Filter/Adobe.PPKLite");
            $this->_out("/SubFilter/adbe.pkcs7.detached");
            $this->_out("/ByteRange[0 ********** ********** **********]");
            $this->_out("/Contents<>" . str_repeat(" ", $this->signature_max_lenght));
            if ($this->ur) {
                $this->_out("/Reference");
                $this->_out("[");
                $this->_out("<<");
                $this->_out("/Type/SigRef");
                $this->_out("/TransformMethod/UR3");
                $this->_out("/TransformParams");
                $this->_out("<<");
                $this->_out("/Type/TransformParams");
                $this->_out("/V/2.2");
                if (!$this->empty_string($this->ur_document)) {
                    $this->_out("/Document[" . $this->ur_document . "]");
                }
                if (!$this->empty_string($this->ur_annots)) {
                    $this->_out("/Annots[" . $this->ur_annots . "]");
                }
                if (!$this->empty_string($this->ur_form)) {
                    $this->_out("/Form[" . $this->ur_form . "]");
                }
                if (!$this->empty_string($this->ur_signature)) {
                    $this->_out("/Signature[" . $this->ur_signature . "]");
                }
                $this->_out(">>");
                $this->_out(">>");
                $this->_out("]");
            }
            $this->_out("/M " . $this->_datastring("D:" . date("YmdHisO")));
            $this->_out(">>");
            $this->_out(">>");
        }
        public function _putcertification()
        {
            if (!$this->sign || isset($this->signature_data["cert_type"]) && $this->signature_data["cert_type"] <= 0) {
                return NULL;
            }
            $this->_out("/Perms");
            $this->_out("<<");
            $this->_out("/DocMDP");
            $this->_out("<<");
            $this->_out("/Type/Sig");
            $this->_out("/Filter/Adobe.PPKLite");
            $this->_out("/SubFilter/adbe.pkcs7.detached");
            $this->_out("/ByteRange[0 ********** ********** **********]");
            $this->_out("/Contents<>" . str_repeat(" ", $this->signature_max_lenght));
            $this->_out("/Reference");
            $this->_out("[");
            $this->_out("<<");
            $this->_out("/Type/SigRef");
            $this->_out("/TransformMethod/DocMDP");
            $this->_out("/TransformParams");
            $this->_out("<<");
            $this->_out("/Type/TransformParams");
            $this->_out("/V/1.2");
            $this->_out("/P " . $this->signature_data["cert_type"] . "");
            $this->_out(">>");
            $this->_out(">>");
            $this->_out("]");
            $this->_out("/M " . $this->_datastring("D:" . date("YmdHisO")));
            if (isset($this->signature_data["info"]["Name"]) && !$this->empty_string($this->signature_data["info"]["Name"])) {
                $this->_out("/Name " . $this->_textstring($this->signature_data["info"]["Name"]) . "");
            }
            if (isset($this->signature_data["info"]["Location"]) && !$this->empty_string($this->signature_data["info"]["Location"])) {
                $this->_out("/Location " . $this->_textstring($this->signature_data["info"]["Location"]) . "");
            }
            if (isset($this->signature_data["info"]["Reason"]) && !$this->empty_string($this->signature_data["info"]["Reason"])) {
                $this->_out("/Reason " . $this->_textstring($this->signature_data["info"]["Reason"]) . "");
            }
            if (isset($this->signature_data["info"]["ContactInfo"]) && !$this->empty_string($this->signature_data["info"]["ContactInfo"])) {
                $this->_out("/ContactInfo " . $this->_textstring($this->signature_data["info"]["ContactInfo"]) . "");
            }
            $this->_out(">>");
            $this->_out(">>");
        }
        public function setUserRights($enable = true, $document = "/FullSave", $annots = "/Create/Delete/Modify/Copy/Import/Export", $form = "/Add/Delete/FillIn/Import/Export/SubmitStandalone/SpawnTemplate", $signature = "/Modify")
        {
            $this->ur = $enable;
            $this->ur_document = $document;
            $this->ur_annots = $annots;
            $this->ur_form = $form;
            $this->ur_signature = $signature;
        }
        public function setSignature($signing_cert = "", $private_key = "", $private_key_password = "", $extracerts = "", $cert_type = 2, $info = [])
        {
            $this->sign = true;
            $this->signature_data = [];
            if (strlen($signing_cert) == 0) {
                $signing_cert = "file://" . dirname(__FILE__) . "/tcpdf.pem";
            }
            if (strlen($private_key) == 0) {
                $private_key = $signing_cert;
            }
            $this->signature_data["signcert"] = $signing_cert;
            $this->signature_data["privkey"] = $private_key;
            $this->signature_data["password"] = $private_key_password;
            $this->signature_data["extracerts"] = $extracerts;
            $this->signature_data["cert_type"] = $cert_type;
            $this->signature_data["info"] = [];
        }
        public function startPageGroup($page = "")
        {
            if (empty($page)) {
                $page = $this->page + 1;
            }
            $this->newpagegroup[$page] = true;
        }
        public function AliasNbPages($alias = "{nb}")
        {
            $this->AliasNbPages = $alias;
        }
        public function getAliasNbPages()
        {
            if ($this->CurrentFont["type"] == "TrueTypeUnicode" || $this->CurrentFont["type"] == "cidfont0") {
                return "{" . $this->AliasNbPages . "}";
            }
            return $this->AliasNbPages;
        }
        public function AliasNumPage($alias = "{pnb}")
        {
            $this->AliasNumPage = $alias;
        }
        public function getAliasNumPage()
        {
            if ($this->CurrentFont["type"] == "TrueTypeUnicode" || $this->CurrentFont["type"] == "cidfont0") {
                return "{" . $this->AliasNumPage . "}";
            }
            return $this->AliasNumPage;
        }
        public function getGroupPageNo()
        {
            return $this->pagegroups[$this->currpagegroup];
        }
        public function getGroupPageNoFormatted()
        {
            return $this->formatPageNumber($this->getGroupPageNo());
        }
        public function getPageGroupAlias()
        {
            if ($this->CurrentFont["type"] == "TrueTypeUnicode" || $this->CurrentFont["type"] == "cidfont0") {
                return "{" . $this->currpagegroup . "}";
            }
            return $this->currpagegroup;
        }
        public function getPageNumGroupAlias()
        {
            if ($this->CurrentFont["type"] == "TrueTypeUnicode" || $this->CurrentFont["type"] == "cidfont0") {
                return "{" . str_replace("{nb", "{pnb", $this->currpagegroup) . "}";
            }
            return str_replace("{nb", "{pnb", $this->currpagegroup);
        }
        public function formatPageNumber($num)
        {
            return number_format((double) $num, 0, "", ".");
        }
        public function formatTOCPageNumber($num)
        {
            return number_format((double) $num, 0, "", ".");
        }
        public function PageNoFormatted()
        {
            return $this->formatPageNumber($this->PageNo());
        }
        public function _putocg()
        {
            $this->_newobj();
            $this->n_ocg_print = $this->n;
            $this->_out("<</Type /OCG /Name " . $this->_textstring("print"));
            $this->_out("/Usage <</Print <</PrintState /ON>> /View <</ViewState /OFF>>>>>>");
            $this->_out("endobj");
            $this->_newobj();
            $this->n_ocg_view = $this->n;
            $this->_out("<</Type /OCG /Name " . $this->_textstring("view"));
            $this->_out("/Usage <</Print <</PrintState /OFF>> /View <</ViewState /ON>>>>>>");
            $this->_out("endobj");
        }
        public function setVisibility($v)
        {
            while ($this->openMarkedContent) {
                $this->_out("EMC");
                $this->openMarkedContent = false;
            }
            switch ($v) {
                case "print":
                    $this->_out("/OC /OC1 BDC");
                    $this->openMarkedContent = true;
                    break;
                case "screen":
                    $this->_out("/OC /OC2 BDC");
                    $this->openMarkedContent = true;
                    break;
                case "all":
                    $this->_out("");
                    break;
                default:
                    $this->Error("Incorrect visibility: " . $v);
                    $this->visibility = $v;
            }
        }
        public function addExtGState($parms)
        {
            $n = count($this->extgstates) + 1;
            $this->extgstates[$n]["parms"] = $parms;
            return $n;
        }
        public function setExtGState($gs)
        {
            $this->_out(sprintf("/GS%d gs", $gs));
        }
        public function _putextgstates()
        {
            $ne = count($this->extgstates);
            for ($i = 1; $i <= $ne; $i++) {
                $this->_newobj();
                $this->extgstates[$i]["n"] = $this->n;
                $this->_out("<</Type /ExtGState");
                foreach ($this->extgstates[$i]["parms"] as $k => $v) {
                    $this->_out("/" . $k . " " . $v);
                }
                $this->_out(">>");
                $this->_out("endobj");
            }
        }
        public function setAlpha($alpha, $bm = "Normal")
        {
            $gs = $this->addExtGState(["ca" => $alpha, "CA" => $alpha, "BM" => "/" . $bm]);
            $this->setExtGState($gs);
        }
        public function setJPEGQuality($quality)
        {
            if ($quality < 1 || 100 < $quality) {
                $quality = 75;
            }
            $this->jpeg_quality = intval($quality);
        }
        public function setDefaultTableColumns($cols = 4)
        {
            $this->default_table_columns = intval($cols);
        }
        public function setCellHeightRatio($h)
        {
            $this->cell_height_ratio = $h;
        }
        public function getCellHeightRatio()
        {
            return $this->cell_height_ratio;
        }
        public function setPDFVersion($version = "1.7")
        {
            $this->PDFVersion = $version;
        }
        public function setViewerPreferences($preferences)
        {
            $this->viewer_preferences = $preferences;
        }
        public function LinearGradient($x, $y, $w, $h, $col1 = [], $col2 = [], $coords = [0, 0, 1, 0])
        {
            $this->Clip($x, $y, $w, $h);
            $this->Gradient(2, $col1, $col2, $coords);
        }
        public function RadialGradient($x, $y, $w, $h, $col1 = [], $col2 = [], $coords = [0.5, 0.5, 0.5, 0.5, 1])
        {
            $this->Clip($x, $y, $w, $h);
            $this->Gradient(3, $col1, $col2, $coords);
        }
        public function CoonsPatchMesh($x, $y, $w, $h, $col1 = [], $col2 = [], $col3 = [], $col4 = [], $coords = [0, 0, 0.33, 0, 0.67, 0, 1, 0, 1, 0.33, 1, 0.67, 1, 1, 0.67, 1, 0.33, 1, 0, 1, 0, 0.67, 0, 0.33], $coords_min = 0, $coords_max = 1)
        {
            $this->Clip($x, $y, $w, $h);
            $n = count($this->gradients) + 1;
            $this->gradients[$n]["type"] = 6;
            if (!isset($coords[0]["f"])) {
                if (!isset($col1[1])) {
                    list($col1[2], $col1[1]) = $col1;
                }
                if (!isset($col2[1])) {
                    list($col2[2], $col2[1]) = $col2;
                }
                if (!isset($col3[1])) {
                    list($col3[2], $col3[1]) = $col3;
                }
                if (!isset($col4[1])) {
                    list($col4[2], $col4[1]) = $col4;
                }
                $patch_array[0]["f"] = 0;
                $patch_array[0]["points"] = $coords;
                list($patch_array[0]["colors"][0]["r"], $patch_array[0]["colors"][0]["g"], $patch_array[0]["colors"][0]["b"]) = $col1;
                list($patch_array[0]["colors"][1]["r"], $patch_array[0]["colors"][1]["g"], $patch_array[0]["colors"][1]["b"]) = $col2;
                list($patch_array[0]["colors"][2]["r"], $patch_array[0]["colors"][2]["g"], $patch_array[0]["colors"][2]["b"]) = $col3;
                list($patch_array[0]["colors"][3]["r"], $patch_array[0]["colors"][3]["g"], $patch_array[0]["colors"][3]["b"]) = $col4;
            } else {
                $patch_array = $coords;
            }
            $bpcd = 65535;
            $this->gradients[$n]["stream"] = "";
            $count_patch = count($patch_array);
            for ($i = 0; $i < $count_patch; $i++) {
                $this->gradients[$n]["stream"] .= chr($patch_array[$i]["f"]);
                $count_points = count($patch_array[$i]["points"]);
                for ($j = 0; $j < $count_points; $j++) {
                    $patch_array[$i]["points"][$j] = ($patch_array[$i]["points"][$j] - $coords_min) / ($coords_max - $coords_min) * $bpcd;
                    if ($patch_array[$i]["points"][$j] < 0) {
                        $patch_array[$i]["points"][$j] = 0;
                    }
                    if ($bpcd < $patch_array[$i]["points"][$j]) {
                        $patch_array[$i]["points"][$j] = $bpcd;
                    }
                    $this->gradients[$n]["stream"] .= chr(floor($patch_array[$i]["points"][$j] / 256));
                    $this->gradients[$n]["stream"] .= chr(floor($patch_array[$i]["points"][$j] % 256));
                }
                $count_cols = count($patch_array[$i]["colors"]);
                for ($j = 0; $j < $count_cols; $j++) {
                    $this->gradients[$n]["stream"] .= chr($patch_array[$i]["colors"][$j]["r"]);
                    $this->gradients[$n]["stream"] .= chr($patch_array[$i]["colors"][$j]["g"]);
                    $this->gradients[$n]["stream"] .= chr($patch_array[$i]["colors"][$j]["b"]);
                }
            }
            $this->_out("/Sh" . $n . " sh");
            $this->_out("Q");
        }
        public function Clip($x, $y, $w, $h)
        {
            if ($this->rtl) {
                $x = $this->w - $x - $w;
            }
            $s = "q";
            $s .= sprintf(" %.2F %.2F %.2F %.2F re W n", $x * $this->k, ($this->h - $y) * $this->k, $w * $this->k, -1 * $h * $this->k);
            $s .= sprintf(" %.3F 0 0 %.3F %.3F %.3F cm", $w * $this->k, $h * $this->k, $x * $this->k, ($this->h - ($y + $h)) * $this->k);
            $this->_out($s);
        }
        public function Gradient($type, $col1, $col2, $coords)
        {
            $n = count($this->gradients) + 1;
            $this->gradients[$n]["type"] = $type;
            if (!isset($col1[1])) {
                list($col1[2], $col1[1]) = $col1;
            }
            $this->gradients[$n]["col1"] = sprintf("%.3F %.3F %.3F", $col1[0] / 255, $col1[1] / 255, $col1[2] / 255);
            if (!isset($col2[1])) {
                list($col2[2], $col2[1]) = $col2;
            }
            $this->gradients[$n]["col2"] = sprintf("%.3F %.3F %.3F", $col2[0] / 255, $col2[1] / 255, $col2[2] / 255);
            $this->gradients[$n]["coords"] = $coords;
            $this->_out("/Sh" . $n . " sh");
            $this->_out("Q");
        }
        public function _putshaders()
        {
            foreach ($this->gradients as $id => $grad) {
                if ($grad["type"] == 2 || $grad["type"] == 3) {
                    $this->_newobj();
                    $this->_out("<<");
                    $this->_out("/FunctionType 2");
                    $this->_out("/Domain [0.0 1.0]");
                    $this->_out("/C0 [" . $grad["col1"] . "]");
                    $this->_out("/C1 [" . $grad["col2"] . "]");
                    $this->_out("/N 1");
                    $this->_out(">>");
                    $this->_out("endobj");
                    $f1 = $this->n;
                }
                $this->_newobj();
                $this->_out("<<");
                $this->_out("/ShadingType " . $grad["type"]);
                $this->_out("/ColorSpace /DeviceRGB");
                if ($grad["type"] == 2) {
                    $this->_out(sprintf("/Coords [%.3F %.3F %.3F %.3F]", $grad["coords"][0], $grad["coords"][1], $grad["coords"][2], $grad["coords"][3]));
                    $this->_out("/Function " . $f1 . " 0 R");
                    $this->_out("/Extend [true true] ");
                    $this->_out(">>");
                } else {
                    if ($grad["type"] == 3) {
                        $this->_out(sprintf("/Coords [%.3F %.3F 0 %.3F %.3F %.3F]", $grad["coords"][0], $grad["coords"][1], $grad["coords"][2], $grad["coords"][3], $grad["coords"][4]));
                        $this->_out("/Function " . $f1 . " 0 R");
                        $this->_out("/Extend [true true] ");
                        $this->_out(">>");
                    } else {
                        if ($grad["type"] == 6) {
                            $this->_out("/BitsPerCoordinate 16");
                            $this->_out("/BitsPerComponent 8");
                            $this->_out("/Decode[0 1 0 1 0 1 0 1 0 1]");
                            $this->_out("/BitsPerFlag 8");
                            $this->_out("/Length " . strlen($grad["stream"]));
                            $this->_out(">>");
                            $this->_putstream($grad["stream"]);
                        }
                    }
                }
                $this->_out("endobj");
                $this->gradients[$id]["id"] = $this->n;
            }
        }
        public function _outarc($x1, $y1, $x2, $y2, $x3, $y3)
        {
            $h = $this->h;
            $this->_out(sprintf("%.2F %.2F %.2F %.2F %.2F %.2F c", $x1 * $this->k, ($h - $y1) * $this->k, $x2 * $this->k, ($h - $y2) * $this->k, $x3 * $this->k, ($h - $y3) * $this->k));
        }
        public function PieSector($xc, $yc, $r, $a, $b, $style = "FD", $cw = true, $o = 90)
        {
            if ($this->rtl) {
                $xc = $this->w - $xc;
            }
            if ($cw) {
                $d = $b;
                $b = $o - $a;
                $a = $o - $d;
            } else {
                $b += $o;
                $a += $o;
            }
            $a = $a % 360 + 360;
            $b = $b % 360 + 360;
            if ($b < $a) {
                $b += 360;
            }
            $b = $b / 360 * 2 * M_PI;
            $a = $a / 360 * 2 * M_PI;
            $d = $b - $a;
            if ($d == 0) {
                $d = 2 * M_PI;
            }
            $k = $this->k;
            $hp = $this->h;
            if ($style == "F") {
                $op = "f";
            } else {
                if ($style == "FD" || $style == "DF") {
                    $op = "b";
                } else {
                    $op = "s";
                }
            }
            if (sin($d / 2)) {
                $MyArc = 0 * (1 - cos($d / 2)) / sin($d / 2) * $r;
            }
            $this->_out(sprintf("%.2F %.2F m", $xc * $k, ($hp - $yc) * $k));
            $this->_out(sprintf("%.2F %.2F l", ($xc + $r * cos($a)) * $k, ($hp - ($yc - $r * sin($a))) * $k));
            if ($d < M_PI / 2) {
                $this->_outarc($xc + $r * cos($a) + $MyArc * cos(M_PI / 2 + $a), $yc - $r * sin($a) - $MyArc * sin(M_PI / 2 + $a), $xc + $r * cos($b) + $MyArc * cos($b - M_PI / 2), $yc - $r * sin($b) - $MyArc * sin($b - M_PI / 2), $xc + $r * cos($b), $yc - $r * sin($b));
            } else {
                $b = $a + $d / 4;
                $MyArc = 0 * (1 - cos($d / 8)) / sin($d / 8) * $r;
                $this->_outarc($xc + $r * cos($a) + $MyArc * cos(M_PI / 2 + $a), $yc - $r * sin($a) - $MyArc * sin(M_PI / 2 + $a), $xc + $r * cos($b) + $MyArc * cos($b - M_PI / 2), $yc - $r * sin($b) - $MyArc * sin($b - M_PI / 2), $xc + $r * cos($b), $yc - $r * sin($b));
                $a = $b;
                $b = $a + $d / 4;
                $this->_outarc($xc + $r * cos($a) + $MyArc * cos(M_PI / 2 + $a), $yc - $r * sin($a) - $MyArc * sin(M_PI / 2 + $a), $xc + $r * cos($b) + $MyArc * cos($b - M_PI / 2), $yc - $r * sin($b) - $MyArc * sin($b - M_PI / 2), $xc + $r * cos($b), $yc - $r * sin($b));
                $a = $b;
                $b = $a + $d / 4;
                $this->_outarc($xc + $r * cos($a) + $MyArc * cos(M_PI / 2 + $a), $yc - $r * sin($a) - $MyArc * sin(M_PI / 2 + $a), $xc + $r * cos($b) + $MyArc * cos($b - M_PI / 2), $yc - $r * sin($b) - $MyArc * sin($b - M_PI / 2), $xc + $r * cos($b), $yc - $r * sin($b));
                $a = $b;
                $b = $a + $d / 4;
                $this->_outarc($xc + $r * cos($a) + $MyArc * cos(M_PI / 2 + $a), $yc - $r * sin($a) - $MyArc * sin(M_PI / 2 + $a), $xc + $r * cos($b) + $MyArc * cos($b - M_PI / 2), $yc - $r * sin($b) - $MyArc * sin($b - M_PI / 2), $xc + $r * cos($b), $yc - $r * sin($b));
            }
            $this->_out($op);
        }
        public function ImageEps($file, $x = "", $y = "", $w = 0, $h = 0, $link = "", $useBoundingBox = true, $align = "", $palign = "", $border = 0)
        {
            while ($x === "") {
                $x = $this->x;
            }
            if ($y === "") {
                $y = $this->y;
            }
            $k = $this->k;
            $data = file_get_contents($file);
            if ($data === false) {
                $this->Error("EPS file not found: " . $file);
            }
            $regs = [];
            preg_match("/%%Creator:([^\r\n]+)/", $data, $regs);
            if (1 < count($regs)) {
                $version_str = trim($regs[1]);
                if (strpos($version_str, "Adobe Illustrator") !== false) {
                    $versexp = explode(" ", $version_str);
                    $version = (double) array_pop($versexp);
                    if (9 <= $version) {
                        $this->Error("This version of Adobe Illustrator file is not supported: " . $file);
                    }
                }
            }
            $start = strpos($data, "%!PS-Adobe");
            if (0 < $start) {
                $data = substr($data, $start);
            }
            preg_match("/%%BoundingBox:([^\r\n]+)/", $data, $regs);
            if (1 < count($regs)) {
                list($x1, $y1, $x2, $y2) = explode(" ", trim($regs[1]));
            } else {
                $this->Error("No BoundingBox found in EPS file: " . $file);
            }
            $start = strpos($data, "%%EndSetup");
            if ($start === false) {
                $start = strpos($data, "%%EndProlog");
            }
            if ($start === false) {
                $start = strpos($data, "%%BoundingBox");
            }
            $data = substr($data, $start);
            $end = strpos($data, "%%PageTrailer");
            if ($end === false) {
                $end = strpos($data, "showpage");
            }
            if ($end) {
                $data = substr($data, 0, $end);
            }
            if (0 < $w) {
                $scale_x = $w / (($x2 - $x1) / $k);
                if (0 < $h) {
                    $scale_y = $h / (($y2 - $y1) / $k);
                } else {
                    $scale_y = $scale_x;
                    $h = ($y2 - $y1) / $k * $scale_y;
                }
            } else {
                if (0 < $h) {
                    $scale_y = $h / (($y2 - $y1) / $k);
                    $scale_x = $scale_y;
                    $w = ($x2 - $x1) / $k * $scale_x;
                } else {
                    $w = ($x2 - $x1) / $k;
                    $h = ($y2 - $y1) / $k;
                }
            }
            if ($this->checkPageBreak($h, $y)) {
                $y = $this->GetY() + $this->cMargin;
            }
            $this->img_rb_y = $y + $h;
            if ($this->rtl) {
                if ($palign == "L") {
                    $ximg = $this->lMargin;
                    $this->img_rb_x = $ximg + $w;
                } else {
                    if ($palign == "C") {
                        $ximg = ($this->w - $x - $w) / 2;
                        $this->img_rb_x = $ximg + $w;
                    } else {
                        $ximg = $this->w - $x - $w;
                        $this->img_rb_x = $ximg;
                    }
                }
            } else {
                if ($palign == "R") {
                    $ximg = $this->w - $this->rMargin - $w;
                    $this->img_rb_x = $ximg;
                } else {
                    if ($palign == "C") {
                        $ximg = ($this->w - $x - $w) / 2;
                        $this->img_rb_x = $ximg + $w;
                    } else {
                        $ximg = $x;
                        $this->img_rb_x = $ximg + $w;
                    }
                }
            }
            if ($useBoundingBox) {
                $dx = $ximg * $k - $x1;
                $dy = $y * $k - $y1;
            } else {
                $dx = $ximg * $k;
                $dy = $y * $k;
            }
            $this->_out("q" . $this->epsmarker);
            $this->_out(sprintf("%.3F %.3F %.3F %.3F %.3F %.3F cm", 1, 0, 0, 1, $dx, $dy + $this->hPt - 2 * $y * $k - ($y2 - $y1)));
            if (isset($scale_x)) {
                $this->_out(sprintf("%.3F %.3F %.3F %.3F %.3F %.3F cm", $scale_x, 0, 0, $scale_y, $x1 * (1 - $scale_x), $y2 * (1 - $scale_y)));
            }
            preg_match("/[\\r\\n]+/s", $data, $regs);
            $lines = explode($regs[0], $data);
            $u = 0;
            $cnt = count($lines);
            for ($i = 0; $i < $cnt; $i++) {
                $line = $lines[$i];
                if (!($line == "" || $line[0] == "%")) {
                    $len = strlen($line);
                    $chunks = explode(" ", $line);
                    $cmd = array_pop($chunks);
                    if ($cmd == "Xa" || $cmd == "XA") {
                        $b = array_pop($chunks);
                        $g = array_pop($chunks);
                        $r = array_pop($chunks);
                        $this->_out("" . $r . " " . $g . " " . $b . " " . ($cmd == "Xa" ? "rg" : "RG"));
                    } else {
                        switch ($cmd) {
                            case "m":
                            case "l":
                            case "v":
                            case "y":
                            case "c":
                            case "k":
                            case "K":
                            case "g":
                            case "G":
                            case "s":
                            case "S":
                            case "J":
                            case "j":
                            case "w":
                            case "M":
                            case "d":
                            case "n":
                            case "v":
                                $this->_out($line);
                                break;
                            case "x":
                                list($c, $m, $y, $k) = $chunks;
                                $this->_out("" . $c . " " . $m . " " . $y . " " . $k . " k");
                                break;
                            case "X":
                                list($c, $m, $y, $k) = $chunks;
                                $this->_out("" . $c . " " . $m . " " . $y . " " . $k . " K");
                                break;
                            case "Y":
                            case "N":
                            case "V":
                            case "L":
                            case "C":
                                $line[$len - 1] = strtolower($cmd);
                                $this->_out($line);
                                break;
                            case "b":
                            case "B":
                                $this->_out($cmd . "*");
                                break;
                            case "f":
                            case "F":
                                if (0 < $u) {
                                    $isU = false;
                                    $max = min($i + 5, $cnt);
                                    for ($j = $i + 1; $j < $max; $j++) {
                                        $isU = $isU || $lines[$j] == "U" || $lines[$j] == "*U";
                                    }
                                    if ($isU) {
                                        $this->_out("f*");
                                    }
                                } else {
                                    $this->_out("f*");
                                }
                                break;
                            case "*u":
                                $u++;
                                break;
                            case "*U":
                                --$u;
                                break;
                        }
                    }
                }
            }
            $this->_out($this->epsmarker . "Q");
            if (!empty($border)) {
                $bx = $x;
                $by = $y;
                $this->x = $x;
                $this->y = $y;
                $this->Cell($w, $h, "", $border, 0, "", 0, "", 0);
                $this->x = $bx;
                $this->y = $by;
            }
            if ($link) {
                $this->Link($ximg, $y, $w, $h, $link, 0);
            }
            switch ($align) {
                case "T":
                    $this->y = $y;
                    $this->x = $this->img_rb_x;
                    break;
                case "M":
                    $this->y = $y + round($h / 2);
                    $this->x = $this->img_rb_x;
                    break;
                case "B":
                    $this->y = $this->img_rb_y;
                    $this->x = $this->img_rb_x;
                    break;
                case "N":
                    $this->SetY($this->img_rb_y);
                    break;
                default:
                    $this->endlinex = $this->img_rb_x;
            }
        }
        public function setBarcode($bc = "")
        {
            $this->barcode = $bc;
        }
        public function getBarcode()
        {
            return $this->barcode;
        }
        public function write1DBarcode($code, $type, $x = "", $y = "", $w = "", $h = "", $xres = 0, $style = "", $align = "")
        {
            while ($this->empty_string($code)) {
                require_once dirname(__FILE__) . "/barcodes.php";
                $gvars = $this->getGraphicVars();
                $barcodeobj = new TCPDFBarcode($code, $type);
                $arrcode = $barcodeobj->getBarcodeArray();
                if ($arrcode === false) {
                    $this->Error("Error in 1D barcode string");
                }
                if (!isset($style["position"])) {
                    if ($this->rtl) {
                        $style["position"] = "R";
                    } else {
                        $style["position"] = "L";
                    }
                }
                if (!isset($style["padding"])) {
                    $style["padding"] = 0;
                }
                if (!isset($style["fgcolor"])) {
                    $style["fgcolor"] = [0, 0, 0];
                }
                if (!isset($style["bgcolor"])) {
                    $style["bgcolor"] = false;
                }
                if (!isset($style["border"])) {
                    $style["border"] = false;
                }
                if (!isset($style["text"])) {
                    $style["text"] = false;
                    $fontsize = 0;
                }
                if ($style["text"] && isset($style["font"])) {
                    if (isset($style["fontsize"])) {
                        $fontsize = $style["fontsize"];
                    } else {
                        $fontsize = 0;
                    }
                    $this->SetFont($style["font"], "", $fontsize);
                }
                if (!isset($style["stretchtext"])) {
                    $style["stretchtext"] = 4;
                }
                $this->SetDrawColorArray($style["fgcolor"]);
                $this->SetTextColorArray($style["fgcolor"]);
                if ($this->empty_string($w) || $w <= 0) {
                    if ($this->rtl) {
                        $w = $this->x - $this->lMargin;
                    } else {
                        $w = $this->w - $this->rMargin - $this->x;
                    }
                }
                if ($this->empty_string($x)) {
                    $x = $this->GetX();
                }
                if ($this->rtl) {
                    $x = $this->w - $x;
                }
                if ($this->empty_string($y)) {
                    $y = $this->GetY();
                }
                if ($this->empty_string($xres)) {
                    $xres = 0;
                }
                $fbw = $arrcode["maxw"] * $xres + 2 * $style["padding"];
                $extraspace = $this->cell_height_ratio * $fontsize / $this->k + 2 * $style["padding"];
                if ($this->empty_string($h) || $h <= 0) {
                    $h = 10 + $extraspace;
                }
                if ($this->checkPageBreak($h)) {
                    $y = $this->y;
                }
                $barh = $h - $extraspace;
                switch ($style["position"]) {
                    case "L":
                        if ($this->rtl) {
                            $xpos = $x - $w;
                        } else {
                            $xpos = $x;
                        }
                        break;
                    case "C":
                        $xdiff = ($w - $fbw) / 2;
                        if ($this->rtl) {
                            $xpos = $x - $w + $xdiff;
                        } else {
                            $xpos = $x + $xdiff;
                        }
                        break;
                    case "R":
                        if ($this->rtl) {
                            $xpos = $x - $fbw;
                        } else {
                            $xpos = $x + $w - $fbw;
                        }
                        break;
                    case "S":
                        $fbw = $w;
                        $xres = ($w - 2 * $style["padding"]) / $arrcode["maxw"];
                        if ($this->rtl) {
                            $xpos = $x - $w;
                        } else {
                            $xpos = $x;
                        }
                        break;
                    default:
                        $xpos_rect = $xpos;
                        $xpos = $xpos_rect + $style["padding"];
                        $xpos_text = $xpos;
                        $tempRTL = $this->rtl;
                        $this->rtl = false;
                        if ($style["bgcolor"]) {
                            $this->Rect($xpos_rect, $y, $fbw, $h, "DF", "", $style["bgcolor"]);
                        } else {
                            if ($style["border"]) {
                                $this->Rect($xpos_rect, $y, $fbw, $h, "D");
                            }
                        }
                        if ($arrcode !== false) {
                            foreach ($arrcode["bcode"] as $k => $v) {
                                $bw = $v["w"] * $xres;
                                if ($v["t"]) {
                                    $ypos = $y + $style["padding"] + $v["p"] * $barh / $arrcode["maxh"];
                                    $this->Rect($xpos, $ypos, $bw, $v["h"] * $barh / $arrcode["maxh"], "F", [], $style["fgcolor"]);
                                }
                                $xpos += $bw;
                            }
                        }
                        if ($style["text"]) {
                            $this->x = $xpos_text;
                            $this->y = $y + $style["padding"] + $barh;
                            $this->Cell($arrcode["maxw"] * $xres, $this->cell_height_ratio * $fontsize / $this->k, $code, 0, 0, "C", 0, "", $style["stretchtext"]);
                        }
                        $this->rtl = $tempRTL;
                        $this->setGraphicVars($gvars);
                        $this->img_rb_y = $y + $h;
                        if ($this->rtl) {
                            $this->img_rb_x = $this->w - $x - $w;
                        } else {
                            $this->img_rb_x = $x + $w;
                        }
                        switch ($align) {
                            case "T":
                                $this->y = $y;
                                $this->x = $this->img_rb_x;
                                break;
                            case "M":
                                $this->y = $y + round($h / 2);
                                $this->x = $this->img_rb_x;
                                break;
                            case "B":
                                $this->y = $this->img_rb_y;
                                $this->x = $this->img_rb_x;
                                break;
                            case "N":
                                $this->SetY($this->img_rb_y);
                                break;
                        }
                }
            }
        }
        public function writeBarcode($x, $y, $w, $h, $type, $style, $font, $xres, $code)
        {
            $xres = 1 / $xres;
            $newstyle = ["position" => "L", "border" => false, "padding" => 0, "fgcolor" => [0, 0, 0], "bgcolor" => false, "text" => true, "font" => $font, "fontsize" => 8, "stretchtext" => 4];
            if ($style & 1) {
                $newstyle["border"] = true;
            }
            if ($style & 2) {
                $newstyle["bgcolor"] = false;
            }
            if ($style & 4) {
                $newstyle["position"] = "C";
            } else {
                if ($style & 8) {
                    $newstyle["position"] = "L";
                } else {
                    if ($style & 16) {
                        $newstyle["position"] = "R";
                    }
                }
            }
            if ($style & 128) {
                $newstyle["text"] = true;
            }
            if ($style & 256) {
                $newstyle["stretchtext"] = 4;
            }
            $this->write1DBarcode($code, $type, $x, $y, $w, $h, $xres, $newstyle, "");
        }
        public function write2DBarcode($code, $type, $x = "", $y = "", $w = "", $h = "", $style = "", $align = "")
        {
            while ($this->empty_string($code)) {
                require_once dirname(__FILE__) . "/2dbarcodes.php";
                $gvars = $this->getGraphicVars();
                $barcodeobj = new TCPDF2DBarcode($code, $type);
                $arrcode = $barcodeobj->getBarcodeArray();
                if ($arrcode === false) {
                    $this->Error("Error in 2D barcode string");
                }
                if (!isset($style["padding"])) {
                    $style["padding"] = 0;
                }
                if (!isset($style["fgcolor"])) {
                    $style["fgcolor"] = [0, 0, 0];
                }
                if (!isset($style["bgcolor"])) {
                    $style["bgcolor"] = false;
                }
                if (!isset($style["border"])) {
                    $style["border"] = false;
                }
                $this->SetDrawColorArray($style["fgcolor"]);
                if ($this->empty_string($x)) {
                    $x = $this->GetX();
                }
                if ($this->rtl) {
                    $x = $this->w - $x;
                }
                if ($this->empty_string($y)) {
                    $y = $this->GetY();
                }
                if ($this->empty_string($w) || $w <= 0) {
                    if ($this->rtl) {
                        $w = $x - $this->lMargin;
                    } else {
                        $w = $this->w - $this->rMargin - $x;
                    }
                }
                if ($this->empty_string($h) || $h <= 0) {
                    $h = $w;
                }
                if ($this->checkPageBreak($h)) {
                    $y = $this->y;
                }
                $bw = $w - 2 * $style["padding"];
                $bh = $h - 2 * $style["padding"];
                if ($this->rtl) {
                    $xpos = $x - $w;
                } else {
                    $xpos = $x;
                }
                $xpos += $style["padding"];
                $ypos = $y + $style["padding"];
                $tempRTL = $this->rtl;
                $this->rtl = false;
                if ($style["bgcolor"]) {
                    $this->Rect($x, $y, $w, $h, "DF", "", $style["bgcolor"]);
                } else {
                    if ($style["border"]) {
                        $this->Rect($x, $y, $w, $h, "D");
                    }
                }
                if ($arrcode !== false) {
                    $rows = $arrcode["num_rows"];
                    $cols = $arrcode["num_cols"];
                    $cw = $bw / $cols;
                    $ch = $bh / $rows;
                    for ($r = 0; $r < $rows; $r++) {
                        $xr = $xpos;
                        for ($c = 0; $c < $cols; $c++) {
                            if ($arrcode["bcode"][$r][$c] == 1) {
                                $this->Rect($xr, $ypos, $cw, $ch, "F", [], $style["fgcolor"]);
                            }
                            $xr += $cw;
                        }
                        $ypos += $ch;
                    }
                }
                $this->rtl = $tempRTL;
                $this->setGraphicVars($gvars);
                $this->img_rb_y = $y + $h;
                if ($this->rtl) {
                    $this->img_rb_x = $this->w - $x - $w;
                } else {
                    $this->img_rb_x = $x + $w;
                }
                switch ($align) {
                    case "T":
                        $this->y = $y;
                        $this->x = $this->img_rb_x;
                        break;
                    case "M":
                        $this->y = $y + round($h / 2);
                        $this->x = $this->img_rb_x;
                        break;
                    case "B":
                        $this->y = $this->img_rb_y;
                        $this->x = $this->img_rb_x;
                        break;
                    case "N":
                        $this->SetY($this->img_rb_y);
                        break;
                }
            }
        }
        public function getMargins()
        {
            $ret = ["left" => $this->lMargin, "right" => $this->rMargin, "top" => $this->tMargin, "bottom" => $this->bMargin, "header" => $this->header_margin, "footer" => $this->footer_margin, "cell" => $this->cMargin];
            return $ret;
        }
        public function getOriginalMargins()
        {
            $ret = ["left" => $this->original_lMargin, "right" => $this->original_rMargin];
            return $ret;
        }
        public function getFontSize()
        {
            return $this->FontSize;
        }
        public function getFontSizePt()
        {
            return $this->FontSizePt;
        }
        public function getFontFamily()
        {
            return $this->FontFamily;
        }
        public function getFontStyle()
        {
            return $this->FontStyle;
        }
        public function writeHTMLCell($w, $h, $x, $y, $html = "", $border = 0, $ln = 0, $fill = 0, $reseth = true, $align = "", $autopadding = true)
        {
            return $this->MultiCell($w, $h, $html, $border, $align, $fill, $ln, $x, $y, $reseth, 0, true, $autopadding, 0);
        }
        public function getHtmlDomArray($html)
        {
            $html = strip_tags($html, "<marker/><a><b><blockquote><br><br/><dd><del><div><dl><dt><em><font><h1><h2><h3><h4><h5><h6><hr><i><img><li><ol><p><pre><small><span><strong><sub><sup><table><tablehead><tcpdf><td><th><thead><tr><tt><u><ul>");
            $html = preg_replace("/<pre/", "<xre", $html);
            $html = preg_replace("/<(table|tr|td|th|tcpdf|blockquote|dd|div|dt|h1|h2|h3|h4|h5|h6|br|hr|li|ol|ul|p)([^\\>]*)>[\\n\\r\\t]+/", "<\\1\\2>", $html);
            $html = preg_replace("@(\\r\\n|\\r)@", "\n", $html);
            $repTable = ["\t" => " ", "\0" => " ", "\v" => " ", "\\" => "\\\\"];
            $html = strtr($html, $repTable);
            $offset = 0;
            while ($offset < strlen($html) && ($pos = strpos($html, "</pre>", $offset)) !== false) {
                $html_a = substr($html, 0, $offset);
                $html_b = substr($html, $offset, $pos - $offset + 6);
                while (preg_match("'<xre([^\\>]*)>(.*?)\n(.*?)</pre>'si", $html_b)) {
                    $html_b = preg_replace("'<xre([^\\>]*)>(.*?)\n(.*?)</pre>'si", "<xre\\1>\\2<br />\\3</pre>", $html_b);
                }
                $html = $html_a . $html_b . substr($html, $pos + 6);
                $offset = strlen($html_a . $html_b);
            }
            $html = str_replace("\n", " ", $html);
            $html = preg_replace("/[\\s]+<\\/(table|tr|td|th|ul|ol|li)>/", "</\\1>", $html);
            $html = preg_replace("/[\\s]+<(tr|td|th|ul|ol|li|br)/", "<\\1", $html);
            $html = preg_replace("/<\\/(table|tr|td|th|blockquote|dd|div|dt|h1|h2|h3|h4|h5|h6|hr|li|ol|ul|p)>[\\s]+</", "</\\1><", $html);
            $html = preg_replace("/<\\/(td|th)>/", "<marker style=\"font-size:0\"/></\\1>", $html);
            $html = preg_replace("/<\\/table>([\\s]*)<marker style=\"font-size:0\"\\/>/", "</table>", $html);
            $html = preg_replace("/<img/", " <img", $html);
            $html = preg_replace("/<img([^\\>]*)>/xi", "<img\\1><span></span>", $html);
            $html = preg_replace("/<xre/", "<pre", $html);
            $html = preg_replace("/^[\\s]+/", "", $html);
            $html = preg_replace("/[\\s]+\$/", "", $html);
            $tagpattern = "/(<[^>]+>)/";
            $a = preg_split($tagpattern, $html, -1, PREG_SPLIT_DELIM_CAPTURE | PREG_SPLIT_NO_EMPTY);
            $maxel = count($a);
            $elkey = 0;
            $key = 0;
            $dom = [];
            $dom[$key] = [];
            $dom[$key]["tag"] = false;
            $dom[$key]["value"] = "";
            $dom[$key]["parent"] = 0;
            $dom[$key]["fontname"] = $this->FontFamily;
            $dom[$key]["fontstyle"] = $this->FontStyle;
            $dom[$key]["fontsize"] = $this->FontSizePt;
            $dom[$key]["bgcolor"] = false;
            $dom[$key]["fgcolor"] = $this->fgcolor;
            $dom[$key]["align"] = "";
            $dom[$key]["listtype"] = "";
            $thead = false;
            $key++;
            $level = [];
            array_push($level, 0);
            while ($elkey < $maxel) {
                $dom[$key] = [];
                $element = $a[$elkey];
                $dom[$key]["elkey"] = $elkey;
                if (preg_match($tagpattern, $element)) {
                    $element = substr($element, 1, -1);
                    preg_match("/[\\/]?([a-zA-Z0-9]*)/", $element, $tag);
                    $tagname = strtolower($tag[1]);
                    if ($tagname == "thead") {
                        if ($element[0] == "/") {
                            $thead = false;
                        } else {
                            $thead = true;
                        }
                        $elkey++;
                    } else {
                        $dom[$key]["tag"] = true;
                        $dom[$key]["value"] = $tagname;
                        if ($element[0] == "/") {
                            $dom[$key]["opening"] = false;
                            $dom[$key]["parent"] = end($level);
                            array_pop($level);
                            $dom[$key]["fontname"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["fontname"];
                            $dom[$key]["fontstyle"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["fontstyle"];
                            $dom[$key]["fontsize"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["fontsize"];
                            $dom[$key]["bgcolor"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["bgcolor"];
                            $dom[$key]["fgcolor"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["fgcolor"];
                            $dom[$key]["align"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["align"];
                            if (isset($dom[$dom[$dom[$key]["parent"]]["parent"]]["listtype"])) {
                                $dom[$key]["listtype"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["listtype"];
                            }
                            if ($dom[$key]["value"] == "tr" && !isset($dom[$dom[$dom[$key]["parent"]]["parent"]]["cols"])) {
                                $dom[$dom[$dom[$key]["parent"]]["parent"]]["cols"] = $dom[$dom[$key]["parent"]]["cols"];
                            }
                            if ($dom[$key]["value"] == "td" || $dom[$key]["value"] == "th") {
                                $dom[$dom[$key]["parent"]]["content"] = "";
                                for ($i = $dom[$key]["parent"] + 1; $i < $key; $i++) {
                                    $dom[$dom[$key]["parent"]]["content"] .= $a[$dom[$i]["elkey"]];
                                }
                                $key = $i;
                            }
                            if ($dom[$key]["value"] == "tr" && $dom[$dom[$key]["parent"]]["thead"]) {
                                if ($this->empty_string($dom[$dom[$dom[$key]["parent"]]["parent"]]["thead"])) {
                                    $dom[$dom[$dom[$key]["parent"]]["parent"]]["thead"] = $a[$dom[$dom[$dom[$key]["parent"]]["parent"]]["elkey"]];
                                }
                                for ($i = $dom[$key]["parent"]; $i <= $key; $i++) {
                                    $dom[$dom[$dom[$key]["parent"]]["parent"]]["thead"] .= $a[$dom[$i]["elkey"]];
                                }
                            }
                            if ($dom[$key]["value"] == "table" && !$this->empty_string($dom[$dom[$key]["parent"]]["thead"])) {
                                $dom[$dom[$key]["parent"]]["thead"] .= "</tablehead>";
                            }
                        } else {
                            $dom[$key]["opening"] = true;
                            $dom[$key]["parent"] = end($level);
                            if (substr($element, -1, 1) != "/") {
                                array_push($level, $key);
                                $dom[$key]["self"] = false;
                            } else {
                                $dom[$key]["self"] = true;
                            }
                            $parentkey = 0;
                            if (0 < $key) {
                                $parentkey = $dom[$key]["parent"];
                                $dom[$key]["fontname"] = $dom[$parentkey]["fontname"];
                                $dom[$key]["fontstyle"] = $dom[$parentkey]["fontstyle"];
                                $dom[$key]["fontsize"] = $dom[$parentkey]["fontsize"];
                                $dom[$key]["bgcolor"] = $dom[$parentkey]["bgcolor"];
                                $dom[$key]["fgcolor"] = $dom[$parentkey]["fgcolor"];
                                $dom[$key]["align"] = $dom[$parentkey]["align"];
                                $dom[$key]["listtype"] = $dom[$parentkey]["listtype"];
                            }
                            preg_match_all("/([^=\\s]*)=[\"]?([^\"]*)[\"]?/", $element, $attr_array, PREG_PATTERN_ORDER);
                            $dom[$key]["attribute"] = [];
                            while (list($id, $name) = each($attr_array[1])) {
                                $dom[$key]["attribute"][strtolower($name)] = $attr_array[2][$id];
                            }
                            if (isset($dom[$key]["attribute"]["style"])) {
                                preg_match_all("/([^;:\\s]*):([^;]*)/", $dom[$key]["attribute"]["style"], $style_array, PREG_PATTERN_ORDER);
                                $dom[$key]["style"] = [];
                                while (list($id, $name) = each($style_array[1])) {
                                    $dom[$key]["style"][strtolower($name)] = trim($style_array[2][$id]);
                                }
                                if (isset($dom[$key]["style"]["font-family"]) && isset($dom[$key]["style"]["font-family"])) {
                                    $fontslist = explode(",", strtolower($dom[$key]["style"]["font-family"]));
                                    foreach ($fontslist as $font) {
                                        $font = trim(strtolower($font));
                                        if (in_array($font, $this->fontlist) || in_array($font, $this->fontkeys)) {
                                            $dom[$key]["fontname"] = $font;
                                        }
                                    }
                                }
                                if (isset($dom[$key]["style"]["list-style-type"])) {
                                    $dom[$key]["listtype"] = trim(strtolower($dom[$key]["style"]["list-style-type"]));
                                    if ($dom[$key]["listtype"] == "inherit") {
                                        $dom[$key]["listtype"] = $dom[$parentkey]["listtype"];
                                    }
                                }
                                if (isset($dom[$key]["style"]["font-size"])) {
                                    $fsize = trim($dom[$key]["style"]["font-size"]);
                                    switch ($fsize) {
                                        case "xx-small":
                                            $dom[$key]["fontsize"] = $dom[0]["fontsize"] - 4;
                                            break;
                                        case "x-small":
                                            $dom[$key]["fontsize"] = $dom[0]["fontsize"] - 3;
                                            break;
                                        case "small":
                                            $dom[$key]["fontsize"] = $dom[0]["fontsize"] - 2;
                                            break;
                                        case "medium":
                                            $dom[$key]["fontsize"] = $dom[0]["fontsize"];
                                            break;
                                        case "large":
                                            $dom[$key]["fontsize"] = $dom[0]["fontsize"] + 2;
                                            break;
                                        case "x-large":
                                            $dom[$key]["fontsize"] = $dom[0]["fontsize"] + 4;
                                            break;
                                        case "xx-large":
                                            $dom[$key]["fontsize"] = $dom[0]["fontsize"] + 6;
                                            break;
                                        case "smaller":
                                            $dom[$key]["fontsize"] = $dom[$parentkey]["fontsize"] - 3;
                                            break;
                                        case "larger":
                                            $dom[$key]["fontsize"] = $dom[$parentkey]["fontsize"] + 3;
                                            break;
                                        default:
                                            $dom[$key]["fontsize"] = $this->getHTMLUnitToUnits($fsize, $dom[$parentkey]["fontsize"], "pt", true);
                                    }
                                }
                                if (isset($dom[$key]["style"]["font-weight"]) && strtolower($dom[$key]["style"]["font-weight"][0]) == "b") {
                                    $dom[$key]["fontstyle"] .= "B";
                                }
                                if (isset($dom[$key]["style"]["font-style"]) && strtolower($dom[$key]["style"]["font-style"][0]) == "i") {
                                    $dom[$key]["fontstyle"] .= "\"I";
                                }
                                if (isset($dom[$key]["style"]["color"]) && !$this->empty_string($dom[$key]["style"]["color"])) {
                                    $dom[$key]["fgcolor"] = $this->convertHTMLColorToDec($dom[$key]["style"]["color"]);
                                }
                                if (isset($dom[$key]["style"]["background-color"]) && !$this->empty_string($dom[$key]["style"]["background-color"])) {
                                    $dom[$key]["bgcolor"] = $this->convertHTMLColorToDec($dom[$key]["style"]["background-color"]);
                                }
                                if (isset($dom[$key]["style"]["text-decoration"])) {
                                    $decors = explode(" ", strtolower($dom[$key]["style"]["text-decoration"]));
                                    foreach ($decors as $dec) {
                                        $dec = trim($dec);
                                        if (!$this->empty_string($dec)) {
                                            if ($dec[0] == "u") {
                                                $dom[$key]["fontstyle"] .= "U";
                                            } else {
                                                if ($dec[0] == "l") {
                                                    $dom[$key]["fontstyle"] .= "D";
                                                }
                                            }
                                        }
                                    }
                                }
                                if (isset($dom[$key]["style"]["width"])) {
                                    $dom[$key]["width"] = $dom[$key]["style"]["width"];
                                }
                                if (isset($dom[$key]["style"]["height"])) {
                                    $dom[$key]["height"] = $dom[$key]["style"]["height"];
                                }
                                if (isset($dom[$key]["style"]["text-align"])) {
                                    $dom[$key]["align"] = strtoupper($dom[$key]["style"]["text-align"][0]);
                                }
                                if (isset($dom[$key]["style"]["border"])) {
                                    $dom[$key]["attribute"]["border"] = $dom[$key]["style"]["border"];
                                }
                            }
                            if ($dom[$key]["value"] == "font") {
                                if (isset($dom[$key]["attribute"]["face"])) {
                                    $fontslist = explode(",", strtolower($dom[$key]["attribute"]["face"]));
                                    foreach ($fontslist as $font) {
                                        $font = trim(strtolower($font));
                                        if (in_array($font, $this->fontlist) || in_array($font, $this->fontkeys)) {
                                            $dom[$key]["fontname"] = $font;
                                        }
                                    }
                                }
                                if (isset($dom[$key]["attribute"]["size"])) {
                                    if (0 < $key) {
                                        if ($dom[$key]["attribute"]["size"][0] == "+") {
                                            $dom[$key]["fontsize"] = $dom[$dom[$key]["parent"]]["fontsize"] + intval(substr($dom[$key]["attribute"]["size"], 1));
                                        } else {
                                            if ($dom[$key]["attribute"]["size"][0] == "-") {
                                                $dom[$key]["fontsize"] = $dom[$dom[$key]["parent"]]["fontsize"] - intval(substr($dom[$key]["attribute"]["size"], 1));
                                            } else {
                                                $dom[$key]["fontsize"] = intval($dom[$key]["attribute"]["size"]);
                                            }
                                        }
                                    } else {
                                        $dom[$key]["fontsize"] = intval($dom[$key]["attribute"]["size"]);
                                    }
                                }
                            }
                            if (($dom[$key]["value"] == "ul" || $dom[$key]["value"] == "ol" || $dom[$key]["value"] == "dl") && (!isset($dom[$key]["align"]) || $this->empty_string($dom[$key]["align"]) || $dom[$key]["align"] != "J")) {
                                if ($this->rtl) {
                                    $dom[$key]["align"] = "R";
                                } else {
                                    $dom[$key]["align"] = "L";
                                }
                            }
                            if ($dom[$key]["value"] == "small" || $dom[$key]["value"] == "sup" || $dom[$key]["value"] == "sub") {
                                $dom[$key]["fontsize"] = $dom[$key]["fontsize"] * K_SMALL_RATIO;
                            }
                            if ($dom[$key]["value"] == "strong" || $dom[$key]["value"] == "b") {
                                $dom[$key]["fontstyle"] .= "B";
                            }
                            if ($dom[$key]["value"] == "em" || $dom[$key]["value"] == "i") {
                                $dom[$key]["fontstyle"] .= "I";
                            }
                            if ($dom[$key]["value"] == "u") {
                                $dom[$key]["fontstyle"] .= "U";
                            }
                            if ($dom[$key]["value"] == "del") {
                                $dom[$key]["fontstyle"] .= "D";
                            }
                            if ($dom[$key]["value"] == "pre" || $dom[$key]["value"] == "tt") {
                                $dom[$key]["fontname"] = $this->default_monospaced_font;
                            }
                            if ($dom[$key]["value"][0] == "h" && 0 < intval($dom[$key]["value"][1]) && intval($dom[$key]["value"][1]) < 7) {
                                $headsize = (4 - intval($dom[$key]["value"][1])) * 2;
                                $dom[$key]["fontsize"] = $dom[0]["fontsize"] + $headsize;
                                $dom[$key]["fontstyle"] .= "B";
                            }
                            if ($dom[$key]["value"] == "table") {
                                $dom[$key]["rows"] = 0;
                                $dom[$key]["trids"] = [];
                                $dom[$key]["thead"] = "";
                            }
                            if ($dom[$key]["value"] == "tr") {
                                $dom[$key]["cols"] = 0;
                                $dom[$dom[$key]["parent"]]["rows"]++;
                                array_push($dom[$dom[$key]["parent"]]["trids"], $key);
                                if ($thead) {
                                    $dom[$key]["thead"] = true;
                                } else {
                                    $dom[$key]["thead"] = false;
                                }
                            }
                            if ($dom[$key]["value"] == "th" || $dom[$key]["value"] == "td") {
                                if (isset($dom[$key]["attribute"]["colspan"])) {
                                    $colspan = intval($dom[$key]["attribute"]["colspan"]);
                                } else {
                                    $colspan = 1;
                                }
                                $dom[$key]["attribute"]["colspan"] = $colspan;
                                $dom[$dom[$key]["parent"]]["cols"] += $colspan;
                            }
                            if (isset($dom[$key]["attribute"]["color"]) && !$this->empty_string($dom[$key]["attribute"]["color"])) {
                                $dom[$key]["fgcolor"] = $this->convertHTMLColorToDec($dom[$key]["attribute"]["color"]);
                            }
                            if (isset($dom[$key]["attribute"]["bgcolor"]) && !$this->empty_string($dom[$key]["attribute"]["bgcolor"])) {
                                $dom[$key]["bgcolor"] = $this->convertHTMLColorToDec($dom[$key]["attribute"]["bgcolor"]);
                            }
                            if (isset($dom[$key]["attribute"]["width"])) {
                                $dom[$key]["width"] = $dom[$key]["attribute"]["width"];
                            }
                            if (isset($dom[$key]["attribute"]["height"])) {
                                $dom[$key]["height"] = $dom[$key]["attribute"]["height"];
                            }
                            if (isset($dom[$key]["attribute"]["align"]) && !$this->empty_string($dom[$key]["attribute"]["align"]) && $dom[$key]["value"] !== "img") {
                                $dom[$key]["align"] = strtoupper($dom[$key]["attribute"]["align"][0]);
                            }
                        }
                    }
                } else {
                    $dom[$key]["tag"] = false;
                    $dom[$key]["value"] = stripslashes($this->unhtmlentities($element));
                    $dom[$key]["parent"] = end($level);
                }
                $elkey++;
                $key++;
            }
            return $dom;
        }
        public function writeHTML($html, $ln = true, $fill = false, $reseth = false, $cell = false, $align = "")
        {
            $gvars = $this->getGraphicVars();
            $prevPage = $this->page;
            $prevlMargin = $this->lMargin;
            $prevrMargin = $this->rMargin;
            $curfontname = $this->FontFamily;
            $curfontstyle = $this->FontStyle;
            $curfontsize = $this->FontSizePt;
            $this->newline = true;
            $minstartliney = $this->y;
            $yshift = 0;
            $startlinepage = $this->page;
            $newline = true;
            $loop = 0;
            $curpos = 0;
            $blocktags = ["blockquote", "br", "dd", "div", "dt", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "li", "ol", "p", "ul", "tcpdf"];
            $this->premode = false;
            if (isset($this->PageAnnots[$this->page])) {
                $pask = count($this->PageAnnots[$this->page]);
            } else {
                $pask = 0;
            }
            if (isset($this->footerlen[$this->page])) {
                $this->footerpos[$this->page] = $this->pagelen[$this->page] - $this->footerlen[$this->page];
            } else {
                $this->footerpos[$this->page] = $this->pagelen[$this->page];
            }
            $startlinepos = $this->footerpos[$this->page];
            $lalign = $align;
            $plalign = $align;
            if ($this->rtl) {
                $w = $this->x - $this->lMargin;
            } else {
                $w = $this->w - $this->rMargin - $this->x;
            }
            $w -= 2 * $this->cMargin;
            if ($cell) {
                if ($this->rtl) {
                    $this->x -= $this->cMargin;
                } else {
                    $this->x += $this->cMargin;
                }
            }
            if (0 <= $this->customlistindent) {
                $this->listindent = $this->customlistindent;
            } else {
                $this->listindent = $this->GetStringWidth("0000");
            }
            $this->listnum = 0;
            if ($this->empty_string($this->lasth) || $reseth) {
                $this->lasth = $this->FontSize * $this->cell_height_ratio;
            }
            $dom = $this->getHtmlDomArray($html);
            $maxel = count($dom);
            for ($key = 0; $key < $maxel; $key++) {
                if ($dom[$key]["tag"] || $key == 0) {
                    if (($dom[$key]["value"] == "table" || $dom[$key]["value"] == "tr") && isset($dom[$key]["align"])) {
                        $dom[$key]["align"] = $this->rtl ? "R" : "L";
                    }
                    if (!$this->newline && $dom[$key]["value"] == "img" && isset($dom[$key]["attribute"]["height"]) && 0 < $dom[$key]["attribute"]["height"]) {
                        $imgh = $this->getHTMLUnitToUnits($dom[$key]["attribute"]["height"], $this->lasth, "px");
                        if (!$this->InFooter) {
                            $this->checkPageBreak($imgh);
                        }
                        if ($startlinepage < $this->page) {
                            if (isset($this->footerlen[$startlinepage])) {
                                $curpos = $this->pagelen[$startlinepage] - $this->footerlen[$startlinepage];
                            }
                            $pagebuff = $this->getPageBuffer($startlinepage);
                            $linebeg = substr($pagebuff, $startlinepos, $curpos - $startlinepos);
                            $tstart = substr($pagebuff, 0, $startlinepos);
                            $tend = substr($this->getPageBuffer($startlinepage), $curpos);
                            $this->setPageBuffer($startlinepage, $tstart . "" . $tend);
                            $pagebuff = $this->getPageBuffer($this->page);
                            $tstart = substr($pagebuff, 0, $this->intmrk[$this->page]);
                            $tend = substr($pagebuff, $this->intmrk[$this->page]);
                            $yshift = $minstartliney - $this->y;
                            $try = sprintf("1 0 0 1 0 %.3F cm", $yshift * $this->k);
                            $this->setPageBuffer($this->page, $tstart . "\nq\n" . $try . "\n" . $linebeg . "\nQ\n" . $tend);
                            if (isset($this->PageAnnots[$startlinepage])) {
                                foreach ($this->PageAnnots[$startlinepage] as $pak => $pac) {
                                    if ($pask <= $pak) {
                                        $this->PageAnnots[$this->page][] = $pac;
                                        unset($this->PageAnnots[$startlinepage][$pak]);
                                        $npak = count($this->PageAnnots[$this->page]) - 1;
                                        $this->PageAnnots[$this->page][$npak]["y"] -= $yshift;
                                    }
                                }
                            }
                            $startlinepos = $this->intmrk[$this->page];
                            $startlinepage = $this->page;
                            $startliney = $this->y;
                        }
                        $this->y += $curfontsize / $this->k - $imgh;
                        $minstartliney = min($this->y, $minstartliney);
                    } else {
                        if (isset($dom[$key]["fontname"]) || isset($dom[$key]["fontstyle"]) || isset($dom[$key]["fontsize"])) {
                            $pfontname = $curfontname;
                            $pfontstyle = $curfontstyle;
                            $pfontsize = $curfontsize;
                            $fontname = isset($dom[$key]["fontname"]) ? $dom[$key]["fontname"] : $curfontname;
                            $fontstyle = isset($dom[$key]["fontstyle"]) ? $dom[$key]["fontstyle"] : $curfontstyle;
                            $fontsize = isset($dom[$key]["fontsize"]) ? $dom[$key]["fontsize"] : $curfontsize;
                            if ($fontname != $curfontname || $fontstyle != $curfontstyle || $fontsize != $curfontsize) {
                                $this->SetFont($fontname, $fontstyle, $fontsize);
                                $this->lasth = $this->FontSize * $this->cell_height_ratio;
                                if (is_numeric($fontsize) && 0 < $fontsize && is_numeric($curfontsize) && 0 < $curfontsize && $fontsize != $curfontsize && !$this->newline && $key < $maxel - 1) {
                                    if (!$this->newline && $startlinepage < $this->page) {
                                        if (isset($this->footerlen[$startlinepage])) {
                                            $curpos = $this->pagelen[$startlinepage] - $this->footerlen[$startlinepage];
                                        }
                                        $pagebuff = $this->getPageBuffer($startlinepage);
                                        $linebeg = substr($pagebuff, $startlinepos, $curpos - $startlinepos);
                                        $tstart = substr($pagebuff, 0, $startlinepos);
                                        $tend = substr($this->getPageBuffer($startlinepage), $curpos);
                                        $this->setPageBuffer($startlinepage, $tstart . "" . $tend);
                                        $pagebuff = $this->getPageBuffer($this->page);
                                        $tstart = substr($pagebuff, 0, $this->intmrk[$this->page]);
                                        $tend = substr($pagebuff, $this->intmrk[$this->page]);
                                        $yshift = $minstartliney - $this->y;
                                        $try = sprintf("1 0 0 1 0 %.3F cm", $yshift * $this->k);
                                        $this->setPageBuffer($this->page, $tstart . "\nq\n" . $try . "\n" . $linebeg . "\nQ\n" . $tend);
                                        if (isset($this->PageAnnots[$startlinepage])) {
                                            foreach ($this->PageAnnots[$startlinepage] as $pak => $pac) {
                                                if ($pask <= $pak) {
                                                    $this->PageAnnots[$this->page][] = $pac;
                                                    unset($this->PageAnnots[$startlinepage][$pak]);
                                                    $npak = count($this->PageAnnots[$this->page]) - 1;
                                                    $this->PageAnnots[$this->page][$npak]["y"] -= $yshift;
                                                }
                                            }
                                        }
                                    }
                                    $this->y += ($curfontsize - $fontsize) / $this->k;
                                    $minstartliney = min($this->y, $minstartliney);
                                }
                                $curfontname = $fontname;
                                $curfontstyle = $fontstyle;
                                $curfontsize = $fontsize;
                            }
                        }
                    }
                    if ($plalign == "J" && in_array($dom[$key]["value"], $blocktags)) {
                        $plalign = "";
                    }
                    $curpos = $this->pagelen[$startlinepage];
                    if (isset($dom[$key]["bgcolor"]) && $dom[$key]["bgcolor"] !== false) {
                        $this->SetFillColorArray($dom[$key]["bgcolor"]);
                        $wfill = true;
                    } else {
                        $wfill = $fill | false;
                    }
                    if (isset($dom[$key]["fgcolor"]) && $dom[$key]["fgcolor"] !== false) {
                        $this->SetTextColorArray($dom[$key]["fgcolor"]);
                    }
                    if (isset($dom[$key]["align"])) {
                        $lalign = $dom[$key]["align"];
                    }
                    if ($this->empty_string($lalign)) {
                        $lalign = $align;
                    }
                }
                if ($this->newline && 0 < strlen($dom[$key]["value"]) && $dom[$key]["value"] != "td" && $dom[$key]["value"] != "th") {
                    $newline = true;
                    if (isset($startlinex)) {
                        $yshift = $minstartliney - $startliney;
                        if (0 < $yshift || $startlinepage < $this->page) {
                            $yshift = 0;
                        }
                        if (isset($plalign) && ($plalign == "C" || $plalign == "J" || $plalign == "R" && !$this->rtl || $plalign == "L" && $this->rtl) || $yshift < 0) {
                            $linew = abs($this->endlinex - $startlinex);
                            $pstart = substr($this->getPageBuffer($startlinepage), 0, $startlinepos);
                            if (isset($opentagpos) && isset($this->footerlen[$startlinepage]) && !$this->InFooter) {
                                $this->footerpos[$startlinepage] = $this->pagelen[$startlinepage] - $this->footerlen[$startlinepage];
                                $midpos = min($opentagpos, $this->footerpos[$startlinepage]);
                            } else {
                                if (isset($opentagpos)) {
                                    $midpos = $opentagpos;
                                } else {
                                    if (isset($this->footerlen[$startlinepage]) && !$this->InFooter) {
                                        $this->footerpos[$startlinepage] = $this->pagelen[$startlinepage] - $this->footerlen[$startlinepage];
                                        $midpos = $this->footerpos[$startlinepage];
                                    } else {
                                        $midpos = 0;
                                    }
                                }
                            }
                            if (0 < $midpos) {
                                $pmid = substr($this->getPageBuffer($startlinepage), $startlinepos, $midpos - $startlinepos);
                                $pend = substr($this->getPageBuffer($startlinepage), $midpos);
                            } else {
                                $pmid = substr($this->getPageBuffer($startlinepage), $startlinepos);
                                $pend = "";
                            }
                            $tw = $w;
                            if ($this->lMargin != $prevlMargin) {
                                $tw += $prevlMargin - $this->lMargin;
                            }
                            if ($this->rMargin != $prevrMargin) {
                                $tw += $prevrMargin - $this->rMargin;
                            }
                            $mdiff = abs($tw - $linew);
                            $t_x = 0;
                            if ($plalign == "C") {
                                if ($this->rtl) {
                                    $t_x = -1 * $mdiff / 2;
                                } else {
                                    $t_x = $mdiff / 2;
                                }
                            } else {
                                if ($plalign == "R" && !$this->rtl) {
                                    $t_x = $mdiff;
                                } else {
                                    if ($plalign == "L" && $this->rtl) {
                                        $t_x = -1 * $mdiff;
                                    } else {
                                        if ($plalign == "J" && $plalign == $lalign) {
                                            if ($this->rtl || $this->tmprtl) {
                                                $t_x = $this->lMargin - $this->endlinex;
                                            }
                                            $no = 0;
                                            $ns = 0;
                                            $pmidtemp = $pmid;
                                            $pmidtemp = preg_replace("/[\\\\][\\(]/x", "\\#!#OP#!#", $pmidtemp);
                                            $pmidtemp = preg_replace("/[\\\\][\\)]/x", "\\#!#CP#!#", $pmidtemp);
                                            if (preg_match_all("/\\[\\(([^\\)]*)\\)\\]/x", $pmidtemp, $lnstring, PREG_PATTERN_ORDER)) {
                                                $maxkk = count($lnstring[1]) - 1;
                                                for ($kk = 0; $kk <= $maxkk; $kk++) {
                                                    $lnstring[1][$kk] = str_replace("#!#OP#!#", "(", $lnstring[1][$kk]);
                                                    $lnstring[1][$kk] = str_replace("#!#CP#!#", ")", $lnstring[1][$kk]);
                                                    if ($kk == $maxkk) {
                                                        if ($this->rtl || $this->tmprtl) {
                                                            $tvalue = ltrim($lnstring[1][$kk]);
                                                        } else {
                                                            $tvalue = rtrim($lnstring[1][$kk]);
                                                        }
                                                    } else {
                                                        $tvalue = $lnstring[1][$kk];
                                                    }
                                                    $no += substr_count($lnstring[1][$kk], chr(32));
                                                    $ns += substr_count($tvalue, chr(32));
                                                }
                                                if ($this->rtl || $this->tmprtl) {
                                                    $t_x = $this->lMargin - $this->endlinex - ($no - $ns - 1) * $this->GetStringWidth(chr(32));
                                                }
                                                $spacewidth = ($tw - $linew + ($no - $ns) * $this->GetStringWidth(chr(32))) / ($ns ? $ns : 1) * $this->k;
                                                $spacewidthu = ($tw - $linew + $no * $this->GetStringWidth(chr(32))) / ($ns ? $ns : 1) / $this->FontSize / $this->k;
                                                $nsmax = $ns;
                                                $ns = 0;
                                                reset($lnstring);
                                                $offset = 0;
                                                $strcount = 0;
                                                $prev_epsposbeg = 0;
                                                global $spacew;
                                                while (preg_match("/([0-9\\.\\+\\-]*)[\\s](Td|cm|m|l|c|re)[\\s]/x", $pmid, $strpiece, PREG_OFFSET_CAPTURE, $offset) == 1) {
                                                    if ($this->rtl || $this->tmprtl) {
                                                        $spacew = $spacewidth * ($nsmax - $ns);
                                                    } else {
                                                        $spacew = $spacewidth * $ns;
                                                    }
                                                    $offset = $strpiece[2][1] + strlen($strpiece[2][0]);
                                                    $epsposbeg = strpos($pmid, "q" . $this->epsmarker, $offset);
                                                    $epsposend = strpos($pmid, $this->epsmarker . "Q", $offset) + strlen($this->epsmarker . "Q");
                                                    if (0 < $epsposbeg && 0 < $epsposend && $epsposbeg < $offset && $offset < $epsposend || $epsposbeg === false && 0 < $epsposend && $offset < $epsposend) {
                                                        $trx = sprintf("1 0 0 1 %.3F 0 cm", $spacew);
                                                        $epsposbeg = strpos($pmid, "q" . $this->epsmarker, $prev_epsposbeg - 6);
                                                        $pmid_b = substr($pmid, 0, $epsposbeg);
                                                        $pmid_m = substr($pmid, $epsposbeg, $epsposend - $epsposbeg);
                                                        $pmid_e = substr($pmid, $epsposend);
                                                        $pmid = $pmid_b . "\nq\n" . $trx . "\n" . $pmid_m . "\nQ\n" . $pmid_e;
                                                        $offset = $epsposend;
                                                    } else {
                                                        $prev_epsposbeg = $epsposbeg;
                                                        $currentxpos = 0;
                                                        switch ($strpiece[2][0]) {
                                                            case "Td":
                                                            case "cm":
                                                            case "m":
                                                            case "l":
                                                                preg_match("/([0-9\\.\\+\\-]*)[\\s](" . $strpiece[1][0] . ")[\\s](" . $strpiece[2][0] . ")([\\s]*)/x", $pmid, $xmatches);
                                                                $currentxpos = $xmatches[1];
                                                                if ($strcount <= $maxkk && $strpiece[2][0] == "Td") {
                                                                    if ($strcount == $maxkk) {
                                                                        if ($this->rtl || $this->tmprtl) {
                                                                            $tvalue = $lnstring[1][$strcount];
                                                                        } else {
                                                                            $tvalue = rtrim($lnstring[1][$strcount]);
                                                                        }
                                                                    } else {
                                                                        $tvalue = $lnstring[1][$strcount];
                                                                    }
                                                                    $ns += substr_count($tvalue, chr(32));
                                                                    $strcount++;
                                                                }
                                                                if ($this->rtl || $this->tmprtl) {
                                                                    $spacew = $spacewidth * ($nsmax - $ns);
                                                                }
                                                                $pmid = preg_replace_callback("/([0-9\\.\\+\\-]*)[\\s](" . $strpiece[1][0] . ")[\\s](" . $strpiece[2][0] . ")([\\s]*)/x", create_function("\$matches", "global \$spacew;\n\t\t\t\t\t\t\t\t\t\t\t\t\t\$newx = sprintf(\"%.2F\",(floatval(\$matches[1]) + \$spacew));\n\t\t\t\t\t\t\t\t\t\t\t\t\treturn \"\".\$newx.\" \".\$matches[2].\" x*#!#*x\".\$matches[3].\$matches[4];"), $pmid, 1);
                                                                break;
                                                            case "re":
                                                                preg_match("/([0-9\\.\\+\\-]*)[\\s]([0-9\\.\\+\\-]*)[\\s]([0-9\\.\\+\\-]*)[\\s](" . $strpiece[1][0] . ")[\\s](" . $strpiece[2][0] . ")([\\s]*)/x", $pmid, $xmatches);
                                                                $currentxpos = $xmatches[1];
                                                                $pmid = preg_replace_callback("/([0-9\\.\\+\\-]*)[\\s]([0-9\\.\\+\\-]*)[\\s]([0-9\\.\\+\\-]*)[\\s](" . $strpiece[1][0] . ")[\\s](" . $strpiece[2][0] . ")([\\s]*)/x", create_function("\$matches", "global \$spacew;\n\t\t\t\t\t\t\t\t\t\t\t\t\t\$newx = sprintf(\"%.2F\",(floatval(\$matches[1]) + \$spacew));\n\t\t\t\t\t\t\t\t\t\t\t\t\treturn \"\".\$newx.\" \".\$matches[2].\" \".\$matches[3].\" \".\$matches[4].\" x*#!#*x\".\$matches[5].\$matches[6];"), $pmid, 1);
                                                                break;
                                                            case "c":
                                                                preg_match("/([0-9\\.\\+\\-]*)[\\s]([0-9\\.\\+\\-]*)[\\s]([0-9\\.\\+\\-]*)[\\s]([0-9\\.\\+\\-]*)[\\s]([0-9\\.\\+\\-]*)[\\s](" . $strpiece[1][0] . ")[\\s](" . $strpiece[2][0] . ")([\\s]*)/x", $pmid, $xmatches);
                                                                $currentxpos = $xmatches[1];
                                                                $pmid = preg_replace_callback("/([0-9\\.\\+\\-]*)[\\s]([0-9\\.\\+\\-]*)[\\s]([0-9\\.\\+\\-]*)[\\s]([0-9\\.\\+\\-]*)[\\s]([0-9\\.\\+\\-]*)[\\s](" . $strpiece[1][0] . ")[\\s](" . $strpiece[2][0] . ")([\\s]*)/x", create_function("\$matches", "global \$spacew;\n\t\t\t\t\t\t\t\t\t\t\t\t\t\$newx1 = sprintf(\"%.3F\",(floatval(\$matches[1]) + \$spacew));\n\t\t\t\t\t\t\t\t\t\t\t\t\t\$newx2 = sprintf(\"%.3F\",(floatval(\$matches[3]) + \$spacew));\n\t\t\t\t\t\t\t\t\t\t\t\t\t\$newx3 = sprintf(\"%.3F\",(floatval(\$matches[5]) + \$spacew));\n\t\t\t\t\t\t\t\t\t\t\t\t\treturn \"\".\$newx1.\" \".\$matches[2].\" \".\$newx2.\" \".\$matches[4].\" \".\$newx3.\" \".\$matches[6].\" x*#!#*x\".\$matches[7].\$matches[8];"), $pmid, 1);
                                                                break;
                                                            default:
                                                                if (isset($this->PageAnnots[$this->page])) {
                                                                    foreach ($this->PageAnnots[$this->page] as $pak => $pac) {
                                                                        if ($minstartliney <= $pac["y"] && $currentxpos - $this->feps <= $pac["x"] * $this->k && $pac["x"] * $this->k <= $currentxpos + $this->feps) {
                                                                            $this->PageAnnots[$this->page][$pak]["x"] += $spacew / $this->k;
                                                                            $this->PageAnnots[$this->page][$pak]["w"] += $spacewidth * $pac["numspaces"] / $this->k;
                                                                        }
                                                                    }
                                                                }
                                                        }
                                                    }
                                                }
                                                $pmid = str_replace("x*#!#*x", "", $pmid);
                                                if ($this->CurrentFont["type"] == "TrueTypeUnicode" || $this->CurrentFont["type"] == "cidfont0") {
                                                    $spacew = $spacewidthu;
                                                    $pmidtemp = $pmid;
                                                    $pmidtemp = preg_replace("/[\\\\][\\(]/x", "\\#!#OP#!#", $pmidtemp);
                                                    $pmidtemp = preg_replace("/[\\\\][\\)]/x", "\\#!#CP#!#", $pmidtemp);
                                                    $pmid = preg_replace_callback("/\\[\\(([^\\)]*)\\)\\]/x", create_function("\$matches", "global \$spacew;\n\t\t\t\t\t\t\t\t\t\t\t\t\t\$matches[1] = str_replace(\"#!#OP#!#\", \"(\", \$matches[1]);\n\t\t\t\t\t\t\t\t\t\t\t\t\t\$matches[1] = str_replace(\"#!#CP#!#\", \")\", \$matches[1]);\n\t\t\t\t\t\t\t\t\t\t\t\t\treturn \"[(\".str_replace(chr(0).chr(32), \") \".(-2830 * \$spacew).\" (\", \$matches[1]).\")]\";"), $pmidtemp);
                                                    $this->setPageBuffer($startlinepage, $pstart . "\n" . $pmid . "\n" . $pend);
                                                    $endlinepos = strlen($pstart . "\n" . $pmid . "\n");
                                                } else {
                                                    $rs = sprintf("%.3F Tw", $spacewidth);
                                                    $pmid = preg_replace("/\\[\\(/x", $rs . " [(", $pmid);
                                                    $this->setPageBuffer($startlinepage, $pstart . "\n" . $pmid . "\nBT 0 Tw ET\n" . $pend);
                                                    $endlinepos = strlen($pstart . "\n" . $pmid . "\nBT 0 Tw ET\n");
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if ($t_x != 0 || $yshift < 0) {
                                $trx = sprintf("1 0 0 1 %.3F %.3F cm", $t_x * $this->k, $yshift * $this->k);
                                $this->setPageBuffer($startlinepage, $pstart . "\nq\n" . $trx . "\n" . $pmid . "\nQ\n" . $pend);
                                $endlinepos = strlen($pstart . "\nq\n" . $trx . "\n" . $pmid . "\nQ\n");
                                if (isset($this->PageAnnots[$this->page])) {
                                    foreach ($this->PageAnnots[$this->page] as $pak => $pac) {
                                        if ($pask <= $pak) {
                                            $this->PageAnnots[$this->page][$pak]["x"] += $t_x;
                                            $this->PageAnnots[$this->page][$pak]["y"] -= $yshift;
                                        }
                                    }
                                }
                                $this->y -= $yshift;
                            }
                        }
                    }
                    $this->newline = false;
                    $pbrk = $this->checkPageBreak($this->lasth);
                    $this->SetFont($fontname, $fontstyle, $fontsize);
                    if ($wfill) {
                        $this->SetFillColorArray($this->bgcolor);
                    }
                    $startlinex = $this->x;
                    $startliney = $this->y;
                    $minstartliney = $this->y;
                    $startlinepage = $this->page;
                    if (isset($endlinepos) && !$pbrk) {
                        $startlinepos = $endlinepos;
                        unset($endlinepos);
                    } else {
                        if (isset($this->footerlen[$this->page])) {
                            $this->footerpos[$this->page] = $this->pagelen[$this->page] - $this->footerlen[$this->page];
                        } else {
                            $this->footerpos[$this->page] = $this->pagelen[$this->page];
                        }
                        $startlinepos = $this->footerpos[$this->page];
                    }
                    $plalign = $lalign;
                    if (isset($this->PageAnnots[$this->page])) {
                        $pask = count($this->PageAnnots[$this->page]);
                    } else {
                        $pask = 0;
                    }
                }
                if (isset($opentagpos)) {
                    unset($opentagpos);
                }
                if ($dom[$key]["tag"]) {
                    if ($dom[$key]["opening"]) {
                        if ($dom[$key]["value"] == "table") {
                            if ($this->rtl) {
                                $wtmp = $this->x - $this->lMargin;
                            } else {
                                $wtmp = $this->w - $this->rMargin - $this->x;
                            }
                            $wtmp -= 2 * $this->cMargin;
                            if (isset($dom[$key]["width"])) {
                                $table_width = $this->getHTMLUnitToUnits($dom[$key]["width"], $wtmp, "px");
                            } else {
                                $table_width = $wtmp;
                            }
                        }
                        if ($dom[$key]["value"] == "td" || $dom[$key]["value"] == "th") {
                            $trid = $dom[$key]["parent"];
                            $table_el = $dom[$trid]["parent"];
                            if (!isset($dom[$table_el]["cols"])) {
                                $dom[$table_el]["cols"] = $trid["cols"];
                            }
                            $oldmargin = $this->cMargin;
                            if (isset($dom[$dom[$trid]["parent"]]["attribute"]["cellpadding"])) {
                                $currentcmargin = $this->getHTMLUnitToUnits($dom[$dom[$trid]["parent"]]["attribute"]["cellpadding"], 1, "px");
                            } else {
                                $currentcmargin = 0;
                            }
                            $this->cMargin = $currentcmargin;
                            if (isset($dom[$dom[$trid]["parent"]]["attribute"]["cellspacing"])) {
                                $cellspacing = $this->getHTMLUnitToUnits($dom[$dom[$trid]["parent"]]["attribute"]["cellspacing"], 1, "px");
                            } else {
                                $cellspacing = 0;
                            }
                            if ($this->rtl) {
                                $cellspacingx = -1 * $cellspacing;
                            } else {
                                $cellspacingx = $cellspacing;
                            }
                            $colspan = $dom[$key]["attribute"]["colspan"];
                            $wtmp = $colspan * $table_width / $dom[$table_el]["cols"];
                            if (isset($dom[$key]["width"])) {
                                $cellw = $this->getHTMLUnitToUnits($dom[$key]["width"], $wtmp, "px");
                            } else {
                                $cellw = $wtmp;
                            }
                            if (isset($dom[$key]["height"])) {
                                $cellh = $this->getHTMLUnitToUnits($dom[$key]["height"], 0, "px");
                            } else {
                                $cellh = 0;
                            }
                            $cellw -= $cellspacing;
                            if (isset($dom[$key]["content"])) {
                                $cell_content = $dom[$key]["content"];
                            } else {
                                $cell_content = "&nbsp;";
                            }
                            $tagtype = $dom[$key]["value"];
                            for ($parentid = $key; $key < $maxel && !($dom[$key]["tag"] && !$dom[$key]["opening"] && $dom[$key]["value"] == $tagtype && $dom[$key]["parent"] == $parentid); $key++) {
                            }
                            if (!isset($dom[$trid]["startpage"])) {
                                $dom[$trid]["startpage"] = $this->page;
                            } else {
                                $this->setPage($dom[$trid]["startpage"]);
                            }
                            if (!isset($dom[$trid]["starty"])) {
                                $dom[$trid]["starty"] = $this->y;
                            } else {
                                $this->y = $dom[$trid]["starty"];
                            }
                            if (!isset($dom[$trid]["startx"])) {
                                $dom[$trid]["startx"] = $this->x;
                            }
                            $this->x += $cellspacingx / 2;
                            if (isset($dom[$parentid]["attribute"]["rowspan"])) {
                                $rowspan = intval($dom[$parentid]["attribute"]["rowspan"]);
                            } else {
                                $rowspan = 1;
                            }
                            if (isset($dom[$table_el]["rowspans"])) {
                                $rsk = 0;
                                $rskmax = count($dom[$table_el]["rowspans"]);
                                while ($rsk < $rskmax) {
                                    $trwsp = $dom[$table_el]["rowspans"][$rsk];
                                    $rsstartx = $trwsp["startx"];
                                    $rsendx = $trwsp["endx"];
                                    if ($trwsp["startpage"] < $this->page) {
                                        if ($this->rtl && $this->pagedim[$this->page]["orm"] != $this->pagedim[$trwsp["startpage"]]["orm"]) {
                                            $dl = $this->pagedim[$this->page]["orm"] - $this->pagedim[$trwsp["startpage"]]["orm"];
                                            $rsstartx -= $dl;
                                            $rsendx -= $dl;
                                        } else {
                                            if (!$this->rtl && $this->pagedim[$this->page]["olm"] != $this->pagedim[$trwsp["startpage"]]["olm"]) {
                                                $dl = $this->pagedim[$this->page]["olm"] - $this->pagedim[$trwsp["startpage"]]["olm"];
                                                $rsstartx += $dl;
                                                $rsendx += $dl;
                                            }
                                        }
                                    }
                                    if (0 < $trwsp["rowspan"] && $this->x - $cellspacing - $currentcmargin - $this->feps < $rsstartx && $rsstartx < $this->x + $cellspacing + $currentcmargin + $this->feps && ($trwsp["starty"] < $this->y - $this->feps || $trwsp["startpage"] < $this->page)) {
                                        $this->x = $rsendx + $cellspacingx;
                                        if ($trwsp["rowspan"] == 1 && isset($dom[$trid]["endy"]) && isset($dom[$trid]["endpage"]) && $trwsp["endpage"] == $dom[$trid]["endpage"]) {
                                            $dom[$table_el]["rowspans"][$rsk]["endy"] = max($dom[$trid]["endy"], $trwsp["endy"]);
                                            $dom[$trid]["endy"] = $dom[$table_el]["rowspans"][$rsk]["endy"];
                                        }
                                        $rsk = 0;
                                    } else {
                                        $rsk++;
                                    }
                                }
                            }
                            if (1 < $rowspan) {
                                if (isset($this->footerlen[$this->page])) {
                                    $this->footerpos[$this->page] = $this->pagelen[$this->page] - $this->footerlen[$this->page];
                                } else {
                                    $this->footerpos[$this->page] = $this->pagelen[$this->page];
                                }
                                $trintmrkpos = $this->footerpos[$this->page];
                                $trsid = array_push($dom[$table_el]["rowspans"], ["trid" => $trid, "rowspan" => $rowspan, "mrowspan" => $rowspan, "colspan" => $colspan, "startpage" => $this->page, "startx" => $this->x, "starty" => $this->y, "intmrkpos" => $trintmrkpos]);
                            }
                            $cellid = array_push($dom[$trid]["cellpos"], ["startx" => $this->x]);
                            if (1 < $rowspan) {
                                $dom[$trid]["cellpos"][$cellid - 1]["rowspanid"] = $trsid - 1;
                            }
                            if (isset($dom[$parentid]["bgcolor"]) && $dom[$parentid]["bgcolor"] !== false) {
                                $dom[$trid]["cellpos"][$cellid - 1]["bgcolor"] = $dom[$parentid]["bgcolor"];
                            }
                            $prevLastH = $this->lasth;
                            $this->MultiCell($cellw, $cellh, $cell_content, false, $lalign, false, 2, "", "", true, 0, true);
                            $this->lasth = $prevLastH;
                            $this->cMargin = $oldmargin;
                            $dom[$trid]["cellpos"][$cellid - 1]["endx"] = $this->x;
                            if ($rowspan <= 1) {
                                if (isset($dom[$trid]["endy"])) {
                                    if ($this->page == $dom[$trid]["endpage"]) {
                                        $dom[$trid]["endy"] = max($this->y, $dom[$trid]["endy"]);
                                    } else {
                                        if ($dom[$trid]["endpage"] < $this->page) {
                                            $dom[$trid]["endy"] = $this->y;
                                        }
                                    }
                                } else {
                                    $dom[$trid]["endy"] = $this->y;
                                }
                                if (isset($dom[$trid]["endpage"])) {
                                    $dom[$trid]["endpage"] = max($this->page, $dom[$trid]["endpage"]);
                                } else {
                                    $dom[$trid]["endpage"] = $this->page;
                                }
                            } else {
                                $dom[$table_el]["rowspans"][$trsid - 1]["endx"] = $this->x;
                                $dom[$table_el]["rowspans"][$trsid - 1]["endy"] = $this->y;
                                $dom[$table_el]["rowspans"][$trsid - 1]["endpage"] = $this->page;
                            }
                            if (isset($dom[$table_el]["rowspans"])) {
                                foreach ($dom[$table_el]["rowspans"] as $k => $trwsp) {
                                    if (0 < $trwsp["rowspan"] && isset($dom[$trid]["endpage"])) {
                                        if ($trwsp["endpage"] == $dom[$trid]["endpage"]) {
                                            $dom[$table_el]["rowspans"][$k]["endy"] = max($dom[$trid]["endy"], $trwsp["endy"]);
                                        } else {
                                            if ($trwsp["endpage"] < $dom[$trid]["endpage"]) {
                                                $dom[$table_el]["rowspans"][$k]["endy"] = $dom[$trid]["endy"];
                                                $dom[$table_el]["rowspans"][$k]["endpage"] = $dom[$trid]["endpage"];
                                            } else {
                                                $dom[$trid]["endy"] = $this->pagedim[$dom[$trid]["endpage"]]["hk"] - $this->pagedim[$dom[$trid]["endpage"]]["bm"];
                                            }
                                        }
                                    }
                                }
                            }
                            $this->x += $cellspacingx / 2;
                        } else {
                            if (!isset($opentagpos) && !$this->InFooter) {
                                if (isset($this->footerlen[$this->page])) {
                                    $this->footerpos[$this->page] = $this->pagelen[$this->page] - $this->footerlen[$this->page];
                                } else {
                                    $this->footerpos[$this->page] = $this->pagelen[$this->page];
                                }
                                $opentagpos = $this->footerpos[$this->page];
                            }
                            $this->openHTMLTagHandler($dom, $key, $cell);
                        }
                    } else {
                        $this->closeHTMLTagHandler($dom, $key, $cell);
                    }
                } else {
                    if (0 < strlen($dom[$key]["value"])) {
                        if (!$this->empty_string($this->lispacer)) {
                            $this->SetFont($pfontname, $pfontstyle, $pfontsize);
                            $this->lasth = $this->FontSize * $this->cell_height_ratio;
                            $minstartliney = $this->y;
                            $this->putHtmlListBullet($this->listnum, $this->lispacer, $pfontsize);
                            $this->SetFont($curfontname, $curfontstyle, $curfontsize);
                            $this->lasth = $this->FontSize * $this->cell_height_ratio;
                            if (is_numeric($pfontsize) && 0 < $pfontsize && is_numeric($curfontsize) && 0 < $curfontsize && $pfontsize != $curfontsize) {
                                $this->y += ($pfontsize - $curfontsize) / $this->k;
                                $minstartliney = min($this->y, $minstartliney);
                            }
                        }
                        $this->htmlvspace = 0;
                        if (!$this->premode && ($this->rtl || $this->tmprtl)) {
                            $len1 = strlen($dom[$key]["value"]);
                            $lsp = $len1 - strlen(ltrim($dom[$key]["value"]));
                            $rsp = $len1 - strlen(rtrim($dom[$key]["value"]));
                            $tmpstr = "";
                            if (0 < $rsp) {
                                $tmpstr .= substr($dom[$key]["value"], -1 * $rsp);
                            }
                            $tmpstr .= trim($dom[$key]["value"]);
                            if (0 < $lsp) {
                                $tmpstr .= substr($dom[$key]["value"], 0, $lsp);
                            }
                            $dom[$key]["value"] = $tmpstr;
                        }
                        if ($newline) {
                            if (!$this->premode) {
                                if ($this->rtl || $this->tmprtl) {
                                    $dom[$key]["value"] = rtrim($dom[$key]["value"]);
                                } else {
                                    $dom[$key]["value"] = ltrim($dom[$key]["value"]);
                                }
                            }
                            $newline = false;
                            $firstblock = true;
                        } else {
                            $firstblock = false;
                        }
                        $strrest = "";
                        if (!empty($this->HREF) && isset($this->HREF["url"])) {
                            $strrest = $this->addHtmlLink($this->HREF["url"], $dom[$key]["value"], $wfill, true, $this->HREF["color"], $this->HREF["style"]);
                        } else {
                            $ctmpmargin = $this->cMargin;
                            $this->cMargin = 0;
                            $strrest = $this->Write($this->lasth, $dom[$key]["value"], "", $wfill, "", false, 0, true, $firstblock);
                            $this->cMargin = $ctmpmargin;
                        }
                        if (0 < strlen($strrest)) {
                            $this->newline = true;
                            if ($cell) {
                                if ($this->rtl) {
                                    $this->x -= $this->cMargin;
                                } else {
                                    $this->x += $this->cMargin;
                                }
                            }
                            if ($strrest == $dom[$key]["value"]) {
                                $loop++;
                            } else {
                                $loop = 0;
                            }
                            $dom[$key]["value"] = ltrim($strrest);
                            if ($loop < 3) {
                                --$key;
                            }
                        } else {
                            $loop = 0;
                        }
                    }
                }
            }
            if (isset($startlinex)) {
                $yshift = $minstartliney - $startliney;
                if (0 < $yshift || $startlinepage < $this->page) {
                    $yshift = 0;
                }
                if (isset($plalign) && ($plalign == "C" || $plalign == "J" || $plalign == "R" && !$this->rtl || $plalign == "L" && $this->rtl) || $yshift < 0) {
                    $linew = abs($this->endlinex - $startlinex);
                    $pstart = substr($this->getPageBuffer($startlinepage), 0, $startlinepos);
                    if (isset($opentagpos) && isset($this->footerlen[$startlinepage]) && !$this->InFooter) {
                        $this->footerpos[$startlinepage] = $this->pagelen[$startlinepage] - $this->footerlen[$startlinepage];
                        $midpos = min($opentagpos, $this->footerpos[$startlinepage]);
                    } else {
                        if (isset($opentagpos)) {
                            $midpos = $opentagpos;
                        } else {
                            if (isset($this->footerlen[$startlinepage]) && !$this->InFooter) {
                                $this->footerpos[$startlinepage] = $this->pagelen[$startlinepage] - $this->footerlen[$startlinepage];
                                $midpos = $this->footerpos[$startlinepage];
                            } else {
                                $midpos = 0;
                            }
                        }
                    }
                    if (0 < $midpos) {
                        $pmid = substr($this->getPageBuffer($startlinepage), $startlinepos, $midpos - $startlinepos);
                        $pend = substr($this->getPageBuffer($startlinepage), $midpos);
                    } else {
                        $pmid = substr($this->getPageBuffer($startlinepage), $startlinepos);
                        $pend = "";
                    }
                    $tw = $w;
                    if ($this->lMargin != $prevlMargin) {
                        $tw += $prevlMargin - $this->lMargin;
                    }
                    if ($this->rMargin != $prevrMargin) {
                        $tw += $prevrMargin - $this->rMargin;
                    }
                    $mdiff = abs($tw - $linew);
                    if ($plalign == "C") {
                        if ($this->rtl) {
                            $t_x = -1 * $mdiff / 2;
                        } else {
                            $t_x = $mdiff / 2;
                        }
                    } else {
                        if ($plalign == "R" && !$this->rtl) {
                            $t_x = $mdiff;
                        } else {
                            if ($plalign == "L" && $this->rtl) {
                                $t_x = -1 * $mdiff;
                            } else {
                                $t_x = 0;
                            }
                        }
                    }
                    if ($t_x != 0 || $yshift < 0) {
                        $trx = sprintf("1 0 0 1 %.3F %.3F cm", $t_x * $this->k, $yshift * $this->k);
                        $this->setPageBuffer($startlinepage, $pstart . "\nq\n" . $trx . "\n" . $pmid . "\nQ\n" . $pend);
                        $endlinepos = strlen($pstart . "\nq\n" . $trx . "\n" . $pmid . "\nQ\n");
                        if (isset($this->PageAnnots[$this->page])) {
                            foreach ($this->PageAnnots[$this->page] as $pak => $pac) {
                                if ($pask <= $pak) {
                                    $this->PageAnnots[$this->page][$pak]["x"] += $t_x;
                                    $this->PageAnnots[$this->page][$pak]["y"] -= $yshift;
                                }
                            }
                        }
                        $this->y -= $yshift;
                    }
                }
            }
            if ($ln && !($cell && $dom[$key - 1]["value"] == "table")) {
                $this->Ln($this->lasth);
            }
            $this->setGraphicVars($gvars);
            if ($prevPage < $this->page) {
                $this->lMargin = $this->pagedim[$this->page]["olm"];
                $this->rMargin = $this->pagedim[$this->page]["orm"];
            }
            unset($dom);
        }
        public function openHTMLTagHandler(&$dom, $key, $cell = false)
        {
            $tag = $dom[$key];
            $parent = $dom[$dom[$key]["parent"]];
            $firstorlast = $key == 1;
            if (isset($tag["attribute"]["dir"])) {
                $this->tmprtl = $tag["attribute"]["dir"] == "rtl" ? "R" : "L";
            } else {
                $this->tmprtl = false;
            }
            switch ($tag["value"]) {
                case "table":
                    $cp = 0;
                    $cs = 0;
                    $dom[$key]["rowspans"] = [];
                    if (!$this->empty_string($dom[$key]["thead"])) {
                        $this->thead = $dom[$key]["thead"];
                        if (!isset($this->theadMargins) || empty($this->theadMargins)) {
                            $this->theadMargins = [];
                            $this->theadMargins["cmargin"] = $this->cMargin;
                        }
                    }
                    if (isset($tag["attribute"]["cellpadding"])) {
                        $cp = $this->getHTMLUnitToUnits($tag["attribute"]["cellpadding"], 1, "px");
                        $this->oldcMargin = $this->cMargin;
                        $this->cMargin = $cp;
                    }
                    if (isset($tag["attribute"]["cellspacing"])) {
                        $cs = $this->getHTMLUnitToUnits($tag["attribute"]["cellspacing"], 1, "px");
                    }
                    $this->checkPageBreak(2 * $cp + 2 * $cs + $this->lasth);
                    break;
                case "tr":
                    $dom[$key]["cellpos"] = [];
                    break;
                case "hr":
                    $this->addHTMLVertSpace(1, $cell, "", $firstorlast, $tag["value"], false);
                    $this->htmlvspace = 0;
                    $wtmp = $this->w - $this->lMargin - $this->rMargin;
                    if (isset($tag["attribute"]["width"]) && $tag["attribute"]["width"] != "") {
                        $hrWidth = $this->getHTMLUnitToUnits($tag["attribute"]["width"], $wtmp, "px");
                    } else {
                        $hrWidth = $wtmp;
                    }
                    $x = $this->GetX();
                    $y = $this->GetY();
                    $prevlinewidth = $this->GetLineWidth();
                    $this->Line($x, $y, $x + $hrWidth, $y);
                    $this->SetLineWidth($prevlinewidth);
                    $this->addHTMLVertSpace(1, $cell, "", !isset($dom[$key + 1]), $tag["value"], false);
                    break;
                case "a":
                    if (array_key_exists("href", $tag["attribute"])) {
                        $this->HREF["url"] = $tag["attribute"]["href"];
                    }
                    $this->HREF["color"] = $this->htmlLinkColorArray;
                    $this->HREF["style"] = $this->htmlLinkFontStyle;
                    if (array_key_exists("style", $tag["attribute"])) {
                        preg_match_all("/([^;:\\s]*):([^;]*)/", $tag["attribute"]["style"], $style_array, PREG_PATTERN_ORDER);
                        $astyle = [];
                        while (list($id, $name) = each($style_array[1])) {
                            $name = strtolower($name);
                            $astyle[$name] = trim($style_array[2][$id]);
                        }
                        if (isset($astyle["color"])) {
                            $this->HREF["color"] = $this->convertHTMLColorToDec($astyle["color"]);
                        }
                        if (isset($astyle["text-decoration"])) {
                            $this->HREF["style"] = "";
                            $decors = explode(" ", strtolower($astyle["text-decoration"]));
                            foreach ($decors as $dec) {
                                $dec = trim($dec);
                                if (!$this->empty_string($dec)) {
                                    if ($dec[0] == "u") {
                                        $this->HREF["style"] .= "U";
                                    } else {
                                        if ($dec[0] == "l") {
                                            $this->HREF["style"] .= "D";
                                        }
                                    }
                                }
                            }
                        }
                    }
                    break;
                case "img":
                    if (isset($tag["attribute"]["src"])) {
                        if ($tag["attribute"]["src"][0] == "/") {
                            $tag["attribute"]["src"] = $_SERVER["DOCUMENT_ROOT"] . $tag["attribute"]["src"];
                        }
                        $tag["attribute"]["src"] = urldecode($tag["attribute"]["src"]);
                        $tag["attribute"]["src"] = str_replace(K_PATH_URL, K_PATH_MAIN, $tag["attribute"]["src"]);
                        if (!isset($tag["attribute"]["width"])) {
                            $tag["attribute"]["width"] = 0;
                        }
                        if (!isset($tag["attribute"]["height"])) {
                            $tag["attribute"]["height"] = 0;
                        }
                        $tag["attribute"]["align"] = "bottom";
                        switch ($tag["attribute"]["align"]) {
                            case "top":
                                $align = "T";
                                break;
                            case "middle":
                                $align = "M";
                                break;
                            case "bottom":
                                $align = "B";
                                break;
                            default:
                                $align = "B";
                                $fileinfo = pathinfo($tag["attribute"]["src"]);
                                if (isset($fileinfo["extension"]) && !$this->empty_string($fileinfo["extension"])) {
                                    $type = strtolower($fileinfo["extension"]);
                                }
                                $prevy = $this->y;
                                $xpos = $this->GetX();
                                if (isset($dom[$key - 1]) && $dom[$key - 1]["value"] == " ") {
                                    if ($this->rtl) {
                                        $xpos += $this->GetStringWidth(" ");
                                    } else {
                                        $xpos -= $this->GetStringWidth(" ");
                                    }
                                }
                                $imglink = "";
                                if (isset($this->HREF["url"]) && !$this->empty_string($this->HREF["url"])) {
                                    $imglink = $this->HREF["url"];
                                    if ($imglink[0] == "#") {
                                        $page = intval(substr($imglink, 1));
                                        $imglink = $this->AddLink();
                                        $this->SetLink($imglink, 0, $page);
                                    }
                                }
                                $border = 0;
                                if (isset($tag["attribute"]["border"]) && !empty($tag["attribute"]["border"])) {
                                    $border = $tag["attribute"]["border"];
                                }
                                $iw = "";
                                if (isset($tag["attribute"]["width"])) {
                                    $iw = $this->getHTMLUnitToUnits($tag["attribute"]["width"], 1, "px", false);
                                }
                                $ih = "";
                                if (isset($tag["attribute"]["height"])) {
                                    $ih = $this->getHTMLUnitToUnits($tag["attribute"]["height"], 1, "px", false);
                                }
                                if ($type == "eps" || $type == "ai") {
                                    $this->ImageEps($tag["attribute"]["src"], $xpos, $this->GetY(), $iw, $ih, $imglink, true, $align, "", $border);
                                } else {
                                    $this->Image($tag["attribute"]["src"], $xpos, $this->GetY(), $iw, $ih, "", $imglink, $align, false, 300, "", false, false, $border);
                                }
                                switch ($align) {
                                    case "T":
                                        $this->y = $prevy;
                                        break;
                                    case "M":
                                        $this->y = ($this->img_rb_y + $prevy - $tag["fontsize"] / $this->k) / 2;
                                        break;
                                    case "B":
                                        $this->y = $this->img_rb_y - $tag["fontsize"] / $this->k;
                                        break;
                                }
                        }
                    }
                    break;
                case "dl":
                    $this->listnum++;
                    $this->addHTMLVertSpace(0, $cell, "", $firstorlast, $tag["value"], false);
                    break;
                case "dt":
                    $this->addHTMLVertSpace(1, $cell, "", $firstorlast, $tag["value"], false);
                    break;
                case "dd":
                    if ($this->rtl) {
                        $this->rMargin += $this->listindent;
                    } else {
                        $this->lMargin += $this->listindent;
                    }
                    $this->addHTMLVertSpace(1, $cell, "", $firstorlast, $tag["value"], false);
                    break;
                case "ul":
                case "ol":
                    $this->addHTMLVertSpace(0, $cell, "", $firstorlast, $tag["value"], false);
                    $this->htmlvspace = 0;
                    $this->listnum++;
                    if ($tag["value"] == "ol") {
                        $this->listordered[$this->listnum] = true;
                    } else {
                        $this->listordered[$this->listnum] = false;
                    }
                    if (isset($tag["attribute"]["start"])) {
                        $this->listcount[$this->listnum] = intval($tag["attribute"]["start"]) - 1;
                    } else {
                        $this->listcount[$this->listnum] = 0;
                    }
                    if ($this->rtl) {
                        $this->rMargin += $this->listindent;
                    } else {
                        $this->lMargin += $this->listindent;
                    }
                    $this->addHTMLVertSpace(0, $cell, "", $firstorlast, $tag["value"], false);
                    $this->htmlvspace = 0;
                    break;
                case "li":
                    $this->addHTMLVertSpace(1, $cell, "", $firstorlast, $tag["value"], false);
                    if ($this->listordered[$this->listnum]) {
                        if (isset($parent["attribute"]["type"]) && !$this->empty_string($parent["attribute"]["type"])) {
                            $this->lispacer = $parent["attribute"]["type"];
                        } else {
                            if (isset($parent["listtype"]) && !$this->empty_string($parent["listtype"])) {
                                $this->lispacer = $parent["listtype"];
                            } else {
                                if (isset($this->lisymbol) && !$this->empty_string($this->lisymbol)) {
                                    $this->lispacer = $this->lisymbol;
                                } else {
                                    $this->lispacer = "#";
                                }
                            }
                        }
                        $this->listcount[$this->listnum]++;
                        if (isset($tag["attribute"]["value"])) {
                            $this->listcount[$this->listnum] = intval($tag["attribute"]["value"]);
                        }
                    } else {
                        if (isset($parent["attribute"]["type"]) && !$this->empty_string($parent["attribute"]["type"])) {
                            $this->lispacer = $parent["attribute"]["type"];
                        } else {
                            if (isset($parent["listtype"]) && !$this->empty_string($parent["listtype"])) {
                                $this->lispacer = $parent["listtype"];
                            } else {
                                if (isset($this->lisymbol) && !$this->empty_string($this->lisymbol)) {
                                    $this->lispacer = $this->lisymbol;
                                } else {
                                    $this->lispacer = "!";
                                }
                            }
                        }
                    }
                    break;
                case "blockquote":
                    if ($this->rtl) {
                        $this->rMargin += $this->listindent;
                    } else {
                        $this->lMargin += $this->listindent;
                    }
                    $this->addHTMLVertSpace(2, $cell, "", $firstorlast, $tag["value"], false);
                    break;
                case "br":
                    $this->Ln("", $cell);
                    break;
                case "div":
                    $this->addHTMLVertSpace(1, $cell, "", $firstorlast, $tag["value"], false);
                    break;
                case "p":
                    $this->addHTMLVertSpace(2, $cell, "", $firstorlast, $tag["value"], false);
                    break;
                case "pre":
                    $this->addHTMLVertSpace(1, $cell, "", $firstorlast, $tag["value"], false);
                    $this->premode = true;
                    break;
                case "sup":
                    $this->SetXY($this->GetX(), $this->GetY() - 0 * $this->FontSizePt / $this->k);
                    break;
                case "sub":
                    $this->SetXY($this->GetX(), $this->GetY() + 0 * $this->FontSizePt / $this->k);
                    break;
                case "h1":
                case "h2":
                case "h3":
                case "h4":
                case "h5":
                case "h6":
                    $this->addHTMLVertSpace(1, $cell, $tag["fontsize"] * 0 / $this->k, $firstorlast, $tag["value"], false);
                    break;
                case "tcpdf":
                    if (isset($tag["attribute"]["method"])) {
                        $tcpdf_method = $tag["attribute"]["method"];
                        if (method_exists($this, $tcpdf_method)) {
                            if (isset($tag["attribute"]["params"]) && !empty($tag["attribute"]["params"])) {
                                eval("\$params = array(" . $tag["attribute"]["params"] . ");");
                                call_user_func_array([$this, $tcpdf_method], $params);
                            } else {
                                $this->{$tcpdf_method}();
                            }
                            $this->newline = true;
                        }
                    }
                    break;
            }
        }
        public function closeHTMLTagHandler(&$dom, $key, $cell = false)
        {
            $tag = $dom[$key];
            $parent = $dom[$dom[$key]["parent"]];
            $firstorlast = !isset($dom[$key + 1]) || !isset($dom[$key + 2]) && $dom[$key + 1]["value"] == "marker";
            $in_table_head = false;
            switch ($tag["value"]) {
                case "tr":
                    $table_el = $dom[$dom[$key]["parent"]]["parent"];
                    if (!isset($parent["endy"])) {
                        $dom[$dom[$key]["parent"]]["endy"] = $this->y;
                        $parent["endy"] = $this->y;
                    }
                    if (!isset($parent["endpage"])) {
                        $dom[$dom[$key]["parent"]]["endpage"] = $this->page;
                        $parent["endpage"] = $this->page;
                    }
                    if (isset($dom[$table_el]["rowspans"])) {
                        foreach ($dom[$table_el]["rowspans"] as $k => $trwsp) {
                            $dom[$table_el]["rowspans"][$k]["rowspan"] -= 1;
                            if ($dom[$table_el]["rowspans"][$k]["rowspan"] == 0) {
                                if ($dom[$table_el]["rowspans"][$k]["endpage"] == $parent["endpage"]) {
                                    $dom[$dom[$key]["parent"]]["endy"] = max($dom[$table_el]["rowspans"][$k]["endy"], $parent["endy"]);
                                } else {
                                    if ($parent["endpage"] < $dom[$table_el]["rowspans"][$k]["endpage"]) {
                                        $dom[$dom[$key]["parent"]]["endy"] = $dom[$table_el]["rowspans"][$k]["endy"];
                                        $dom[$dom[$key]["parent"]]["endpage"] = $dom[$table_el]["rowspans"][$k]["endpage"];
                                    }
                                }
                            }
                        }
                        foreach ($dom[$table_el]["rowspans"] as $k => $trwsp) {
                            if ($dom[$table_el]["rowspans"][$k]["rowspan"] == 0) {
                                $dom[$table_el]["rowspans"][$k]["endpage"] = max($dom[$table_el]["rowspans"][$k]["endpage"], $dom[$dom[$key]["parent"]]["endpage"]);
                                $dom[$dom[$key]["parent"]]["endpage"] = $dom[$table_el]["rowspans"][$k]["endpage"];
                                $dom[$table_el]["rowspans"][$k]["endy"] = max($dom[$table_el]["rowspans"][$k]["endy"], $dom[$dom[$key]["parent"]]["endy"]);
                                $dom[$dom[$key]["parent"]]["endy"] = $dom[$table_el]["rowspans"][$k]["endy"];
                            }
                        }
                        foreach ($dom[$table_el]["rowspans"] as $k => $trwsp) {
                            if ($dom[$table_el]["rowspans"][$k]["rowspan"] == 0) {
                                $dom[$table_el]["rowspans"][$k]["endpage"] = $dom[$dom[$key]["parent"]]["endpage"];
                                $dom[$table_el]["rowspans"][$k]["endy"] = $dom[$dom[$key]["parent"]]["endy"];
                            }
                        }
                    }
                    $this->setPage($dom[$dom[$key]["parent"]]["endpage"]);
                    $this->y = $dom[$dom[$key]["parent"]]["endy"];
                    if (isset($dom[$table_el]["attribute"]["cellspacing"])) {
                        $cellspacing = $this->getHTMLUnitToUnits($dom[$table_el]["attribute"]["cellspacing"], 1, "px");
                        $this->y += $cellspacing;
                    }
                    $this->Ln(0, $cell);
                    $this->x = $parent["startx"];
                    if ($parent["startpage"] < $this->page) {
                        if ($this->rtl && $this->pagedim[$this->page]["orm"] != $this->pagedim[$parent["startpage"]]["orm"]) {
                            $this->x += $this->pagedim[$this->page]["orm"] - $this->pagedim[$parent["startpage"]]["orm"];
                        } else {
                            if (!$this->rtl && $this->pagedim[$this->page]["olm"] != $this->pagedim[$parent["startpage"]]["olm"]) {
                                $this->x += $this->pagedim[$this->page]["olm"] - $this->pagedim[$parent["startpage"]]["olm"];
                            }
                        }
                    }
                    break;
                case "tablehead":
                    $in_table_head = true;
                    break;
                case "table":
                    $table_el = $parent;
                    if (isset($table_el["attribute"]["border"]) && 0 < $table_el["attribute"]["border"] || isset($table_el["style"]["border"]) && 0 < $table_el["style"]["border"]) {
                        $border = 1;
                    } else {
                        $border = 0;
                    }
                    foreach ($dom[$dom[$key]["parent"]]["trids"] as $j => $trkey) {
                        if (isset($dom[$dom[$key]["parent"]]["rowspans"])) {
                            foreach ($dom[$dom[$key]["parent"]]["rowspans"] as $k => $trwsp) {
                                if ($trwsp["trid"] == $trkey) {
                                    $dom[$dom[$key]["parent"]]["rowspans"][$k]["mrowspan"] -= 1;
                                }
                                if (isset($prevtrkey) && $trwsp["trid"] == $prevtrkey && 0 <= $trwsp["mrowspan"]) {
                                    $dom[$dom[$key]["parent"]]["rowspans"][$k]["trid"] = $trkey;
                                }
                            }
                        }
                        if (isset($prevtrkey) && $dom[$prevtrkey]["endpage"] < $dom[$trkey]["startpage"]) {
                            $pgendy = $this->pagedim[$dom[$prevtrkey]["endpage"]]["hk"] - $this->pagedim[$dom[$prevtrkey]["endpage"]]["bm"];
                            $dom[$prevtrkey]["endy"] = $pgendy;
                            if (isset($dom[$dom[$key]["parent"]]["rowspans"])) {
                                foreach ($dom[$dom[$key]["parent"]]["rowspans"] as $k => $trwsp) {
                                    if ($trwsp["trid"] == $trkey && $trwsp["mrowspan"] == 1 && $trwsp["endpage"] == $dom[$prevtrkey]["endpage"]) {
                                        $dom[$dom[$key]["parent"]]["rowspans"][$k]["endy"] = $pgendy;
                                        $dom[$dom[$key]["parent"]]["rowspans"][$k]["mrowspan"] = -1;
                                    }
                                }
                            }
                        }
                        $prevtrkey = $trkey;
                        $table_el = $dom[$dom[$key]["parent"]];
                    }
                    foreach ($table_el["trids"] as $j => $trkey) {
                        $parent = $dom[$trkey];
                        foreach ($parent["cellpos"] as $k => $cellpos) {
                            if (isset($cellpos["rowspanid"]) && 0 <= $cellpos["rowspanid"]) {
                                $cellpos["startx"] = $table_el["rowspans"][$cellpos["rowspanid"]]["startx"];
                                $cellpos["endx"] = $table_el["rowspans"][$cellpos["rowspanid"]]["endx"];
                                $endy = $table_el["rowspans"][$cellpos["rowspanid"]]["endy"];
                                $startpage = $table_el["rowspans"][$cellpos["rowspanid"]]["startpage"];
                                $endpage = $table_el["rowspans"][$cellpos["rowspanid"]]["endpage"];
                            } else {
                                $endy = $parent["endy"];
                                $startpage = $parent["startpage"];
                                $endpage = $parent["endpage"];
                            }
                            if ($startpage < $endpage) {
                                for ($page = $startpage; $page <= $endpage; $page++) {
                                    $this->setPage($page);
                                    if ($page == $startpage) {
                                        $this->y = $parent["starty"];
                                        $ch = $this->getPageHeight() - $parent["starty"] - $this->getBreakMargin();
                                        $cborder = $this->getBorderMode($border, $position = "start");
                                    } else {
                                        if ($page == $endpage) {
                                            $this->y = $this->tMargin;
                                            $ch = $endy - $this->tMargin;
                                            $cborder = $this->getBorderMode($border, $position = "end");
                                        } else {
                                            $this->y = $this->tMargin;
                                            $ch = $this->getPageHeight() - $this->tMargin - $this->getBreakMargin();
                                            $cborder = $this->getBorderMode($border, $position = "middle");
                                        }
                                    }
                                    if (isset($cellpos["bgcolor"]) && $cellpos["bgcolor"] !== false) {
                                        $this->SetFillColorArray($cellpos["bgcolor"]);
                                        $fill = true;
                                    } else {
                                        $fill = false;
                                    }
                                    $cw = abs($cellpos["endx"] - $cellpos["startx"]);
                                    $this->x = $cellpos["startx"];
                                    if ($startpage < $page) {
                                        if ($this->rtl && $this->pagedim[$page]["orm"] != $this->pagedim[$startpage]["orm"]) {
                                            $this->x -= $this->pagedim[$page]["orm"] - $this->pagedim[$startpage]["orm"];
                                        } else {
                                            if (!$this->rtl && $this->pagedim[$page]["lm"] != $this->pagedim[$startpage]["olm"]) {
                                                $this->x += $this->pagedim[$page]["olm"] - $this->pagedim[$startpage]["olm"];
                                            }
                                        }
                                    }
                                    $ccode = $this->FillColor . "\n" . $this->getCellCode($cw, $ch, "", $cborder, 1, "", $fill, "", 0, true);
                                    if ($cborder || $fill) {
                                        $pagebuff = $this->getPageBuffer($this->page);
                                        $pstart = substr($pagebuff, 0, $this->intmrk[$this->page]);
                                        $pend = substr($pagebuff, $this->intmrk[$this->page]);
                                        $this->setPageBuffer($this->page, $pstart . $ccode . "\n" . $pend);
                                        $this->intmrk[$this->page] += strlen($ccode . "\n");
                                    }
                                }
                            } else {
                                $this->setPage($startpage);
                                if (isset($cellpos["bgcolor"]) && $cellpos["bgcolor"] !== false) {
                                    $this->SetFillColorArray($cellpos["bgcolor"]);
                                    $fill = true;
                                } else {
                                    $fill = false;
                                }
                                $this->x = $cellpos["startx"];
                                $this->y = $parent["starty"];
                                $cw = abs($cellpos["endx"] - $cellpos["startx"]);
                                $ch = $endy - $parent["starty"];
                                $ccode = $this->FillColor . "\n" . $this->getCellCode($cw, $ch, "", $border, 1, "", $fill, "", 0, true);
                                if ($border || $fill) {
                                    if (end($this->transfmrk[$this->page]) !== false) {
                                        $pagemarkkey = key($this->transfmrk[$this->page]);
                                        $pagemark =& $this->transfmrk[$this->page][$pagemarkkey];
                                    } else {
                                        if ($this->InFooter) {
                                            $pagemark =& $this->footerpos[$this->page];
                                        } else {
                                            $pagemark =& $this->intmrk[$this->page];
                                        }
                                    }
                                    $pagebuff = $this->getPageBuffer($this->page);
                                    $pstart = substr($pagebuff, 0, $pagemark);
                                    $pend = substr($pagebuff, $pagemark);
                                    $this->setPageBuffer($this->page, $pstart . $ccode . "\n" . $pend);
                                    $pagemark += strlen($ccode . "\n");
                                }
                            }
                        }
                        if (isset($table_el["attribute"]["cellspacing"])) {
                            $cellspacing = $this->getHTMLUnitToUnits($table_el["attribute"]["cellspacing"], 1, "px");
                            $this->y += $cellspacing;
                        }
                        $this->Ln(0, $cell);
                        $this->x = $parent["startx"];
                        if ($startpage < $endpage) {
                            if ($this->rtl && $this->pagedim[$endpage]["orm"] != $this->pagedim[$startpage]["orm"]) {
                                $this->x += $this->pagedim[$endpage]["orm"] - $this->pagedim[$startpage]["orm"];
                            } else {
                                if (!$this->rtl && $this->pagedim[$endpage]["olm"] != $this->pagedim[$startpage]["olm"]) {
                                    $this->x += $this->pagedim[$endpage]["olm"] - $this->pagedim[$startpage]["olm"];
                                }
                            }
                        }
                    }
                    if (!$in_table_head) {
                        if (isset($parent["cellpadding"])) {
                            $this->cMargin = $this->oldcMargin;
                        }
                        $this->lasth = $this->FontSize * $this->cell_height_ratio;
                        if (!empty($this->theadMargins)) {
                            $this->tMargin = $this->theadMargins["top"];
                            $this->pagedim[$this->page]["tm"] = $this->tMargin;
                        }
                        $this->thead = "";
                        $this->theadMargins = [];
                    }
                    break;
                case "a":
                    $this->HREF = "";
                    break;
                case "sup":
                    $this->SetXY($this->GetX(), $this->GetY() + 0 * $parent["fontsize"] / $this->k);
                    break;
                case "sub":
                    $this->SetXY($this->GetX(), $this->GetY() - 0 * $parent["fontsize"] / $this->k);
                    break;
                case "div":
                    $this->addHTMLVertSpace(1, $cell, "", $firstorlast, $tag["value"], true);
                    break;
                case "blockquote":
                    if ($this->rtl) {
                        $this->rMargin -= $this->listindent;
                    } else {
                        $this->lMargin -= $this->listindent;
                    }
                    $this->addHTMLVertSpace(2, $cell, "", $firstorlast, $tag["value"], true);
                    break;
                case "p":
                    $this->addHTMLVertSpace(2, $cell, "", $firstorlast, $tag["value"], true);
                    break;
                case "pre":
                    $this->addHTMLVertSpace(1, $cell, "", $firstorlast, $tag["value"], true);
                    $this->premode = false;
                    break;
                case "dl":
                    --$this->listnum;
                    if ($this->listnum <= 0) {
                        $this->listnum = 0;
                        $this->addHTMLVertSpace(2, $cell, "", $firstorlast, $tag["value"], true);
                    }
                    break;
                case "dt":
                    $this->lispacer = "";
                    $this->addHTMLVertSpace(0, $cell, "", $firstorlast, $tag["value"], true);
                    break;
                case "dd":
                    $this->lispacer = "";
                    if ($this->rtl) {
                        $this->rMargin -= $this->listindent;
                    } else {
                        $this->lMargin -= $this->listindent;
                    }
                    $this->addHTMLVertSpace(0, $cell, "", $firstorlast, $tag["value"], true);
                    break;
                case "ul":
                case "ol":
                    --$this->listnum;
                    $this->lispacer = "";
                    if ($this->rtl) {
                        $this->rMargin -= $this->listindent;
                    } else {
                        $this->lMargin -= $this->listindent;
                    }
                    if ($this->listnum <= 0) {
                        $this->listnum = 0;
                        $this->addHTMLVertSpace(2, $cell, "", $firstorlast, $tag["value"], true);
                    }
                    $this->lasth = $this->FontSize * $this->cell_height_ratio;
                    break;
                case "li":
                    $this->lispacer = "";
                    $this->addHTMLVertSpace(0, $cell, "", $firstorlast, $tag["value"], true);
                    break;
                case "h1":
                case "h2":
                case "h3":
                case "h4":
                case "h5":
                case "h6":
                    $this->addHTMLVertSpace(1, $cell, $parent["fontsize"] * 0 / $this->k, $firstorlast, $tag["value"], true);
                    break;
                default:
                    $this->tmprtl = false;
            }
        }
        public function addHTMLVertSpace($n, $cell = false, $h = "", $firstorlast = false, $tag = "", $closing = false)
        {
            if ($firstorlast) {
                $this->Ln(0, $cell);
                $this->htmlvspace = 0;
            } else {
                if (isset($this->tagvspaces[$tag][intval($closing)]["n"])) {
                    $n = $this->tagvspaces[$tag][intval($closing)]["n"];
                }
                if (isset($this->tagvspaces[$tag][intval($closing)]["h"])) {
                    $h = $this->tagvspaces[$tag][intval($closing)]["h"];
                }
                if (is_string($h)) {
                    $vsize = $n * $this->lasth;
                } else {
                    $vsize = $n * $h;
                }
                if ($this->htmlvspace < $vsize) {
                    $this->Ln($vsize - $this->htmlvspace, $cell);
                    $this->htmlvspace = $vsize;
                }
            }
        }
        public function setLIsymbol($symbol = "!")
        {
            $symbol = strtolower($symbol);
            switch ($symbol) {
                case "!":
                case "#":
                case "disc":
                case "disc":
                case "circle":
                case "square":
                case "1":
                case "decimal":
                case "decimal-leading-zero":
                case "i":
                case "lower-roman":
                case "I":
                case "upper-roman":
                case "a":
                case "lower-alpha":
                case "lower-latin":
                case "A":
                case "upper-alpha":
                case "upper-latin":
                case "lower-greek":
                    $this->lisymbol = $symbol;
                    break;
                default:
                    $this->lisymbol = "";
            }
        }
        public function SetBooklet($booklet = true, $inner = -1, $outer = -1)
        {
            $this->booklet = $booklet;
            if (0 <= $inner) {
                $this->lMargin = $inner;
            }
            if (0 <= $outer) {
                $this->rMargin = $outer;
            }
        }
        public function swapMargins($reverse = true)
        {
            if ($reverse) {
                $mtemp = $this->original_lMargin;
                $this->original_lMargin = $this->original_rMargin;
                $this->original_rMargin = $mtemp;
                $deltam = $this->original_lMargin - $this->original_rMargin;
                $this->lMargin += $deltam;
                $this->rMargin -= $deltam;
            }
        }
        public function setHtmlVSpace($tagvs)
        {
            $this->tagvspaces = $tagvs;
        }
        public function setListIndentWidth($width)
        {
            return $this->customlistindent = floatval($width);
        }
        public function setOpenCell($isopen)
        {
            $this->opencell = $isopen;
        }
        public function setHtmlLinksStyle($color = [0, 0, 255], $fontstyle = "U")
        {
            $this->htmlLinkColorArray = $color;
            $this->htmlLinkFontStyle = $fontstyle;
        }
        public function getHTMLUnitToUnits($htmlval, $refsize = 1, $defaultunit = "px", $points = false)
        {
            $supportedunits = ["%", "em", "ex", "px", "in", "cm", "mm", "pc", "pt"];
            $retval = 0;
            $value = 0;
            $unit = "px";
            $k = $this->k;
            if ($points) {
                $k = 1;
            }
            if (in_array($defaultunit, $supportedunits)) {
                $unit = $defaultunit;
            }
            if (is_numeric($htmlval)) {
                $value = floatval($htmlval);
            } else {
                if (preg_match("/([0-9\\.]+)/", $htmlval, $mnum)) {
                    $value = floatval($mnum[1]);
                    if (preg_match("/([a-z%]+)/", $htmlval, $munit) && in_array($munit[1], $supportedunits)) {
                        $unit = $munit[1];
                    }
                }
            }
            switch ($unit) {
                case "%":
                    $retval = $value * $refsize / 100;
                    break;
                case "em":
                    $retval = $value * $refsize;
                    break;
                case "ex":
                    $retval = $value * $refsize / 2;
                    break;
                case "in":
                    $retval = $value * $this->dpi / $k;
                    break;
                case "cm":
                    $retval = $value / 0 * $this->dpi / $k;
                    break;
                case "mm":
                    $retval = $value / 0 * $this->dpi / $k;
                    break;
                case "pc":
                    $retval = $value * 12 / $k;
                    break;
                case "pt":
                    $retval = $value / $k;
                    break;
                case "px":
                    $retval = $this->pixelsToUnits($value);
                    break;
                default:
                    return $retval;
            }
        }
        public function intToRoman($number)
        {
            $roman = "";
            while (1000 <= $number) {
                $roman .= "M";
                $number -= 1000;
            }
            while (900 <= $number) {
                $roman .= "CM";
                $number -= 900;
            }
            while (500 <= $number) {
                $roman .= "D";
                $number -= 500;
            }
            while (400 <= $number) {
                $roman .= "CD";
                $number -= 400;
            }
            while (100 <= $number) {
                $roman .= "C";
                $number -= 100;
            }
            while (90 <= $number) {
                $roman .= "XC";
                $number -= 90;
            }
            while (50 <= $number) {
                $roman .= "L";
                $number -= 50;
            }
            while (40 <= $number) {
                $roman .= "XL";
                $number -= 40;
            }
            while (10 <= $number) {
                $roman .= "X";
                $number -= 10;
            }
            while (9 <= $number) {
                $roman .= "IX";
                $number -= 9;
            }
            while (5 <= $number) {
                $roman .= "V";
                $number -= 5;
            }
            while (4 <= $number) {
                $roman .= "IV";
                $number -= 4;
            }
            while (1 <= $number) {
                $roman .= "I";
                --$number;
            }
            return $roman;
        }
        public function putHtmlListBullet($listdepth, $listtype = "", $size = 10)
        {
            $size /= $this->k;
            $fill = "";
            $color = $this->fgcolor;
            $width = 0;
            $textitem = "";
            $tmpx = $this->x;
            $lspace = $this->GetStringWidth("  ");
            if ($listtype == "!") {
                $deftypes = ["disc", "circle", "square"];
                $listtype = $deftypes[($listdepth - 1) % 3];
            } else {
                if ($listtype == "#") {
                    $listtype = "decimal";
                }
            }
            switch ($listtype) {
                case "none":
                case "disc":
                    $fill = "F";
                    break;
                case "circle":
                    $fill .= "D";
                    $r = $size / 6;
                    $lspace += 2 * $r;
                    if ($this->rtl) {
                        $this->x = $this->w - $this->x - $lspace;
                    } else {
                        $this->x -= $lspace;
                    }
                    $this->Circle($this->x + $r, $this->y + $this->lasth / 2, $r, 0, 360, $fill, ["color" => $color], $color, 8);
                    break;
                case "square":
                    $l = $size / 3;
                    $lspace += $l;
                    if ($this->rtl) {
                        $this->x = $this->w - $this->x - $lspace;
                    } else {
                        $this->x -= $lspace;
                    }
                    $this->Rect($this->x, $this->y + ($this->lasth - $l) / 2, $l, $l, "F", [], $color);
                    break;
                case "1":
                case "decimal":
                    $textitem = $this->listcount[$this->listnum];
                    break;
                case "decimal-leading-zero":
                    $textitem = sprintf("%02d", $this->listcount[$this->listnum]);
                    break;
                case "i":
                case "lower-roman":
                    $textitem = strtolower($this->intToRoman($this->listcount[$this->listnum]));
                    break;
                case "I":
                case "upper-roman":
                    $textitem = $this->intToRoman($this->listcount[$this->listnum]);
                    break;
                case "a":
                case "lower-alpha":
                case "lower-latin":
                    $textitem = chr(97 + $this->listcount[$this->listnum] - 1);
                    break;
                case "A":
                case "upper-alpha":
                case "upper-latin":
                    $textitem = chr(65 + $this->listcount[$this->listnum] - 1);
                    break;
                case "lower-greek":
                    $textitem = $this->unichr(945 + $this->listcount[$this->listnum] - 1);
                    break;
                default:
                    $textitem = $this->listcount[$this->listnum];
                    if (!$this->empty_string($textitem)) {
                        if ($this->rtl) {
                            $textitem = "." . $textitem;
                        } else {
                            $textitem = $textitem . ".";
                        }
                        $lspace += $this->GetStringWidth($textitem);
                        if ($this->rtl) {
                            $this->x += $lspace;
                        } else {
                            $this->x -= $lspace;
                        }
                        $this->Write($this->lasth, $textitem, "", false, "", false, 0, false);
                    }
                    $this->x = $tmpx;
                    $this->lispacer = "";
            }
        }
        public function getGraphicVars()
        {
            $grapvars = ["FontFamily" => $this->FontFamily, "FontStyle" => $this->FontStyle, "FontSizePt" => $this->FontSizePt, "rMargin" => $this->rMargin, "lMargin" => $this->lMargin, "cMargin" => $this->cMargin, "LineWidth" => $this->LineWidth, "linestyleWidth" => $this->linestyleWidth, "linestyleCap" => $this->linestyleCap, "linestyleJoin" => $this->linestyleJoin, "linestyleDash" => $this->linestyleDash, "DrawColor" => $this->DrawColor, "FillColor" => $this->FillColor, "TextColor" => $this->TextColor, "ColorFlag" => $this->ColorFlag, "bgcolor" => $this->bgcolor, "fgcolor" => $this->fgcolor, "htmlvspace" => $this->htmlvspace, "lasth" => $this->lasth];
            return $grapvars;
        }
        public function setGraphicVars($gvars)
        {
            $this->FontFamily = $gvars["FontFamily"];
            $this->FontStyle = $gvars["FontStyle"];
            $this->FontSizePt = $gvars["FontSizePt"];
            $this->rMargin = $gvars["rMargin"];
            $this->lMargin = $gvars["lMargin"];
            $this->cMargin = $gvars["cMargin"];
            $this->LineWidth = $gvars["LineWidth"];
            $this->linestyleWidth = $gvars["linestyleWidth"];
            $this->linestyleCap = $gvars["linestyleCap"];
            $this->linestyleJoin = $gvars["linestyleJoin"];
            $this->linestyleDash = $gvars["linestyleDash"];
            $this->DrawColor = $gvars["DrawColor"];
            $this->FillColor = $gvars["FillColor"];
            $this->TextColor = $gvars["TextColor"];
            $this->ColorFlag = $gvars["ColorFlag"];
            $this->bgcolor = $gvars["bgcolor"];
            $this->fgcolor = $gvars["fgcolor"];
            $this->htmlvspace = $gvars["htmlvspace"];
            $this->_out("" . $this->linestyleWidth . " " . $this->linestyleCap . " " . $this->linestyleJoin . " " . $this->linestyleDash . " " . $this->DrawColor . " " . $this->FillColor . "");
            if (!$this->empty_string($this->FontFamily)) {
                $this->SetFont($this->FontFamily, $this->FontStyle, $this->FontSizePt);
            }
        }
        public function getObjFilename($name)
        {
            return tempnam(K_PATH_CACHE, $name . "_");
        }
        public function writeDiskCache($filename, $data, $append = false)
        {
            if ($append) {
                $fmode = "ab+";
            } else {
                $fmode = "wb+";
            }
            $f = fopen($filename, $fmode);
            if (!$f) {
                $this->Error("Unable to write cache file: " . $filename);
            } else {
                fwrite($f, $data);
                fclose($f);
            }
            if (!isset($this->cache_file_lenght["_" . $filename])) {
                $this->cache_file_lenght["_" . $filename] = strlen($data);
            } else {
                $this->cache_file_lenght["_" . $filename] += strlen($data);
            }
        }
        public function readDiskCache($filename)
        {
            return file_get_contents($filename);
        }
        public function setBuffer($data)
        {
            $this->bufferlen += strlen($data);
            if ($this->diskcache) {
                if (!isset($this->buffer) || $this->empty_string($this->buffer)) {
                    $this->buffer = $this->getObjFilename("buffer");
                }
                $this->writeDiskCache($this->buffer, $data, true);
            } else {
                $this->buffer .= $data;
            }
        }
        public function getBuffer()
        {
            if ($this->diskcache) {
                return $this->readDiskCache($this->buffer);
            }
            return $this->buffer;
        }
        public function setPageBuffer($page, $data, $append = false)
        {
            if ($this->diskcache) {
                if (!isset($this->pages[$page])) {
                    $this->pages[$page] = $this->getObjFilename("page" . $page);
                }
                $this->writeDiskCache($this->pages[$page], $data, $append);
            } else {
                if ($append) {
                    $this->pages[$page] .= $data;
                } else {
                    $this->pages[$page] = $data;
                }
            }
            if ($append && isset($this->pagelen[$page])) {
                $this->pagelen[$page] += strlen($data);
            } else {
                $this->pagelen[$page] = strlen($data);
            }
        }
        public function getPageBuffer($page)
        {
            if ($this->diskcache) {
                return $this->readDiskCache($this->pages[$page]);
            }
            if (isset($this->pages[$page])) {
                return $this->pages[$page];
            }
            return false;
        }
        public function setImageBuffer($image, $data)
        {
            if ($this->diskcache) {
                if (!isset($this->images[$image])) {
                    $this->images[$image] = $this->getObjFilename("image" . $image);
                }
                $this->writeDiskCache($this->images[$image], serialize($data));
            } else {
                $this->images[$image] = $data;
            }
            if (!in_array($image, $this->imagekeys)) {
                $this->imagekeys[] = $image;
            }
            $this->numimages++;
        }
        public function setImageSubBuffer($image, $key, $data)
        {
            if (!isset($this->images[$image])) {
                $this->setImageBuffer($image, []);
            }
            if ($this->diskcache) {
                $tmpimg = $this->getImageBuffer($image);
                $tmpimg[$key] = $data;
                $this->writeDiskCache($this->images[$image], serialize($tmpimg));
            } else {
                $this->images[$image][$key] = $data;
            }
        }
        public function getImageBuffer($image)
        {
            if ($this->diskcache && isset($this->images[$image])) {
                return unserialize($this->readDiskCache($this->images[$image]));
            }
            if (isset($this->images[$image])) {
                return $this->images[$image];
            }
            return false;
        }
        public function setFontBuffer($font, $data)
        {
            if ($this->diskcache) {
                if (!isset($this->fonts[$font])) {
                    $this->fonts[$font] = $this->getObjFilename("font");
                }
                $this->writeDiskCache($this->fonts[$font], serialize($data));
            } else {
                $this->fonts[$font] = $data;
            }
            if (!in_array($font, $this->fontkeys)) {
                $this->fontkeys[] = $font;
            }
        }
        public function setFontSubBuffer($font, $key, $data)
        {
            if (!isset($this->fonts[$font])) {
                $this->setFontBuffer($font, []);
            }
            if ($this->diskcache) {
                $tmpfont = $this->getFontBuffer($font);
                $tmpfont[$key] = $data;
                $this->writeDiskCache($this->fonts[$font], serialize($tmpfont));
            } else {
                $this->fonts[$font][$key] = $data;
            }
        }
        public function getFontBuffer($font)
        {
            if ($this->diskcache && isset($this->fonts[$font])) {
                return unserialize($this->readDiskCache($this->fonts[$font]));
            }
            if (isset($this->fonts[$font])) {
                return $this->fonts[$font];
            }
            return false;
        }
        public function movePage($frompage, $topage)
        {
            if ($this->numpages < $frompage || $frompage <= $topage) {
                return false;
            }
            if ($frompage == $this->page) {
                $this->endPage();
            }
            $tmppage = $this->pages[$frompage];
            $tmppagedim = $this->pagedim[$frompage];
            $tmppagelen = $this->pagelen[$frompage];
            $tmpintmrk = $this->intmrk[$frompage];
            if (isset($this->footerpos[$frompage])) {
                $tmpfooterpos = $this->footerpos[$frompage];
            }
            if (isset($this->footerlen[$frompage])) {
                $tmpfooterlen = $this->footerlen[$frompage];
            }
            if (isset($this->transfmrk[$frompage])) {
                $tmptransfmrk = $this->transfmrk[$frompage];
            }
            if (isset($this->PageAnnots[$frompage])) {
                $tmpannots = $this->PageAnnots[$frompage];
            }
            if (isset($this->newpagegroup[$frompage])) {
                $tmpnewpagegroup = $this->newpagegroup[$frompage];
            }
            $i = $frompage;
            while ($topage < $i) {
                $j = $i - 1;
                $this->pages[$i] = $this->pages[$j];
                $this->pagedim[$i] = $this->pagedim[$j];
                $this->pagelen[$i] = $this->pagelen[$j];
                $this->intmrk[$i] = $this->intmrk[$j];
                if (isset($this->footerpos[$j])) {
                    $this->footerpos[$i] = $this->footerpos[$j];
                } else {
                    if (isset($this->footerpos[$i])) {
                        unset($this->footerpos[$i]);
                    }
                }
                if (isset($this->footerlen[$j])) {
                    $this->footerlen[$i] = $this->footerlen[$j];
                } else {
                    if (isset($this->footerlen[$i])) {
                        unset($this->footerlen[$i]);
                    }
                }
                if (isset($this->transfmrk[$j])) {
                    $this->transfmrk[$i] = $this->transfmrk[$j];
                } else {
                    if (isset($this->transfmrk[$i])) {
                        unset($this->transfmrk[$i]);
                    }
                }
                if (isset($this->PageAnnots[$j])) {
                    $this->PageAnnots[$i] = $this->PageAnnots[$j];
                } else {
                    if (isset($this->PageAnnots[$i])) {
                        unset($this->PageAnnots[$i]);
                    }
                }
                if (isset($this->newpagegroup[$j])) {
                    $this->newpagegroup[$i] = $this->newpagegroup[$j];
                } else {
                    if (isset($this->newpagegroup[$i])) {
                        unset($this->newpagegroup[$i]);
                    }
                }
                --$i;
            }
            $this->pages[$topage] = $tmppage;
            $this->pagedim[$topage] = $tmppagedim;
            $this->pagelen[$topage] = $tmppagelen;
            $this->intmrk[$topage] = $tmpintmrk;
            if (isset($tmpfooterpos)) {
                $this->footerpos[$topage] = $tmpfooterpos;
            } else {
                if (isset($this->footerpos[$topage])) {
                    unset($this->footerpos[$topage]);
                }
            }
            if (isset($tmpfooterlen)) {
                $this->footerlen[$topage] = $tmpfooterlen;
            } else {
                if (isset($this->footerlen[$topage])) {
                    unset($this->footerlen[$topage]);
                }
            }
            if (isset($tmptransfmrk)) {
                $this->transfmrk[$topage] = $tmptransfmrk;
            } else {
                if (isset($this->transfmrk[$topage])) {
                    unset($this->transfmrk[$topage]);
                }
            }
            if (isset($tmpannots)) {
                $this->PageAnnots[$topage] = $tmpannots;
            } else {
                if (isset($this->PageAnnots[$topage])) {
                    unset($this->PageAnnots[$topage]);
                }
            }
            if (isset($tmpnewpagegroup)) {
                $this->newpagegroup[$topage] = $tmpnewpagegroup;
            } else {
                if (isset($this->newpagegroup[$topage])) {
                    unset($this->newpagegroup[$topage]);
                }
            }
            $tmpoutlines = $this->outlines;
            foreach ($tmpoutlines as $key => $outline) {
                if ($topage <= $outline["p"] && $outline["p"] < $frompage) {
                    $this->outlines[$key]["p"] = $outline["p"] + 1;
                } else {
                    if ($outline["p"] == $frompage) {
                        $this->outlines[$key]["p"] = $topage;
                    }
                }
            }
            $tmplinks = $this->links;
            foreach ($tmplinks as $key => $link) {
                if ($topage <= $link[0] && $link[0] < $frompage) {
                    $this->links[$key][0] = $link[0] + 1;
                } else {
                    if ($link[0] == $frompage) {
                        $this->links[$key][0] = $topage;
                    }
                }
            }
            $tmpjavascript = $this->javascript;
            global $jfrompage;
            global $jtopage;
            $jfrompage = $frompage;
            $jtopage = $topage;
            $this->javascript = preg_replace_callback("/this\\.addField\\('([^']*)','([^']*)',([0-9]+)/", create_function("\$matches", "global \$jfrompage, \$jtopage;\n\t\t\t\t\$pagenum = intval(\$matches[3]) + 1;\n\t\t\t\tif ((\$pagenum >= \$jtopage) AND (\$pagenum < \$jfrompage)) {\n\t\t\t\t\t\$newpage = (\$pagenum + 1);\n\t\t\t\t} elseif (\$pagenum == \$jfrompage) {\n\t\t\t\t\t\$newpage = \$jtopage;\n\t\t\t\t} else {\n\t\t\t\t\t\$newpage = \$pagenum;\n\t\t\t\t}\n\t\t\t\t--\$newpage;\n\t\t\t\treturn \"this.addField('\".\$matches[1].\"','\".\$matches[2].\"',\".\$newpage.\"\";"), $tmpjavascript);
            $this->lastPage(true);
            return true;
        }
        public function deletePage($page)
        {
            if ($this->numpages < $page) {
                return false;
            }
            unset($this->pages[$page]);
            unset($this->pagedim[$page]);
            unset($this->pagelen[$page]);
            unset($this->intmrk[$page]);
            if (isset($this->footerpos[$page])) {
                unset($this->footerpos[$page]);
            }
            if (isset($this->footerlen[$page])) {
                unset($this->footerlen[$page]);
            }
            if (isset($this->transfmrk[$page])) {
                unset($this->transfmrk[$page]);
            }
            if (isset($this->PageAnnots[$page])) {
                unset($this->PageAnnots[$page]);
            }
            if (isset($this->newpagegroup[$page])) {
                unset($this->newpagegroup[$page]);
            }
            if (isset($this->pageopen[$page])) {
                unset($this->pageopen[$page]);
            }
            for ($i = $page; $i < $this->numpages; $i++) {
                $j = $i + 1;
                $this->pages[$i] = $this->pages[$j];
                $this->pagedim[$i] = $this->pagedim[$j];
                $this->pagelen[$i] = $this->pagelen[$j];
                $this->intmrk[$i] = $this->intmrk[$j];
                if (isset($this->footerpos[$j])) {
                    $this->footerpos[$i] = $this->footerpos[$j];
                } else {
                    if (isset($this->footerpos[$i])) {
                        unset($this->footerpos[$i]);
                    }
                }
                if (isset($this->footerlen[$j])) {
                    $this->footerlen[$i] = $this->footerlen[$j];
                } else {
                    if (isset($this->footerlen[$i])) {
                        unset($this->footerlen[$i]);
                    }
                }
                if (isset($this->transfmrk[$j])) {
                    $this->transfmrk[$i] = $this->transfmrk[$j];
                } else {
                    if (isset($this->transfmrk[$i])) {
                        unset($this->transfmrk[$i]);
                    }
                }
                if (isset($this->PageAnnots[$j])) {
                    $this->PageAnnots[$i] = $this->PageAnnots[$j];
                } else {
                    if (isset($this->PageAnnots[$i])) {
                        unset($this->PageAnnots[$i]);
                    }
                }
                if (isset($this->newpagegroup[$j])) {
                    $this->newpagegroup[$i] = $this->newpagegroup[$j];
                } else {
                    if (isset($this->newpagegroup[$i])) {
                        unset($this->newpagegroup[$i]);
                    }
                }
                if (isset($this->pageopen[$j])) {
                    $this->pageopen[$i] = $this->pageopen[$j];
                } else {
                    if (isset($this->pageopen[$i])) {
                        unset($this->pageopen[$i]);
                    }
                }
            }
            unset($this->pages[$this->numpages]);
            unset($this->pagedim[$this->numpages]);
            unset($this->pagelen[$this->numpages]);
            unset($this->intmrk[$this->numpages]);
            if (isset($this->footerpos[$this->numpages])) {
                unset($this->footerpos[$this->numpages]);
            }
            if (isset($this->footerlen[$this->numpages])) {
                unset($this->footerlen[$this->numpages]);
            }
            if (isset($this->transfmrk[$this->numpages])) {
                unset($this->transfmrk[$this->numpages]);
            }
            if (isset($this->PageAnnots[$this->numpages])) {
                unset($this->PageAnnots[$this->numpages]);
            }
            if (isset($this->newpagegroup[$this->numpages])) {
                unset($this->newpagegroup[$this->numpages]);
            }
            if (isset($this->pageopen[$this->numpages])) {
                unset($this->pageopen[$this->numpages]);
            }
            --$this->numpages;
            $this->page = $this->numpages;
            $tmpoutlines = $this->outlines;
            foreach ($tmpoutlines as $key => $outline) {
                if ($page < $outline["p"]) {
                    $this->outlines[$key]["p"] = $outline["p"] - 1;
                } else {
                    if ($outline["p"] == $page) {
                        unset($this->outlines[$key]);
                    }
                }
            }
            $tmplinks = $this->links;
            foreach ($tmplinks as $key => $link) {
                if ($page < $link[0]) {
                    $this->links[$key][0] = $link[0] - 1;
                } else {
                    if ($link[0] == $page) {
                        unset($this->links[$key]);
                    }
                }
            }
            $tmpjavascript = $this->javascript;
            global $jpage;
            $jpage = $page;
            $this->javascript = preg_replace_callback("/this\\.addField\\('([^']*)','([^']*)',([0-9]+)/", create_function("\$matches", "global \$jpage;\n\t\t\t\t\$pagenum = intval(\$matches[3]) + 1;\n\t\t\t\tif (\$pagenum >= \$jpage) {\n\t\t\t\t\t\$newpage = (\$pagenum - 1);\n\t\t\t\t} elseif (\$pagenum == \$jpage) {\n\t\t\t\t\t\$newpage = 1;\n\t\t\t\t} else {\n\t\t\t\t\t\$newpage = \$pagenum;\n\t\t\t\t}\n\t\t\t\t--\$newpage;\n\t\t\t\treturn \"this.addField('\".\$matches[1].\"','\".\$matches[2].\"',\".\$newpage.\"\";"), $tmpjavascript);
            $this->lastPage(true);
            return true;
        }
        public function addTOC($page = "", $numbersfont = "", $filler = ".")
        {
            $fontsize = $this->FontSizePt;
            $fontfamily = $this->FontFamily;
            $fontstyle = $this->FontStyle;
            $w = $this->w - $this->lMargin - $this->rMargin;
            $spacer = $this->GetStringWidth(" ") * 4;
            $page_first = $this->getPage();
            $lmargin = $this->lMargin;
            $rmargin = $this->rMargin;
            $x_start = $this->GetX();
            if ($this->empty_string($numbersfont)) {
                $numbersfont = $this->default_monospaced_font;
            }
            if ($this->empty_string($filler)) {
                $filler = " ";
            }
            if ($this->empty_string($page)) {
                $gap = " ";
            } else {
                $gap = "";
            }
            foreach ($this->outlines as $key => $outline) {
                if ($this->rtl) {
                    $aligntext = "R";
                    $alignnum = "L";
                } else {
                    $aligntext = "L";
                    $alignnum = "R";
                }
                if ($outline["l"] == 0) {
                    $this->SetFont($fontfamily, $fontstyle . "B", $fontsize);
                } else {
                    $this->SetFont($fontfamily, $fontstyle, $fontsize - $outline["l"]);
                }
                $indent = $spacer * $outline["l"];
                if ($this->rtl) {
                    $this->rMargin += $indent;
                    $this->x -= $indent;
                } else {
                    $this->lMargin += $indent;
                    $this->x += $indent;
                }
                $link = $this->AddLink();
                $this->SetLink($link, 0, $outline["p"]);
                $this->Write(0, $outline["t"], $link, 0, $aligntext, false, 0, false, false, 0);
                $this->SetFont($numbersfont, $fontstyle, $fontsize);
                if ($this->empty_string($page)) {
                    $pagenum = $outline["p"];
                } else {
                    $pagenum = "{#" . $outline["p"] . "}";
                    if ($this->CurrentFont["type"] == "TrueTypeUnicode" || $this->CurrentFont["type"] == "cidfont0") {
                        $pagenum = "{" . $pagenum . "}";
                    }
                }
                $numwidth = $this->GetStringWidth($pagenum);
                if ($this->rtl) {
                    $tw = $this->x - $this->lMargin;
                } else {
                    $tw = $this->w - $this->rMargin - $this->x;
                }
                $fw = $tw - $numwidth - $this->GetStringWidth(" ");
                $numfills = floor($fw / $this->GetStringWidth($filler));
                if (0 < $numfills) {
                    $rowfill = str_repeat($filler, $numfills);
                } else {
                    $rowfill = "";
                }
                if ($this->rtl) {
                    $pagenum = $pagenum . $gap . $rowfill . " ";
                } else {
                    $pagenum = " " . $rowfill . $gap . $pagenum;
                }
                $this->Cell($tw, 0, $pagenum, 0, 1, $alignnum, 0, $link, 0);
                $this->SetX($x_start);
                $this->lMargin = $lmargin;
                $this->rMargin = $rmargin;
            }
            $page_last = $this->getPage();
            $numpages = $page_last - $page_first + 1;
            if (!$this->empty_string($page)) {
                for ($p = $page_first; $p <= $page_last; $p++) {
                    $temppage = $this->getPageBuffer($p);
                    for ($n = 1; $n <= $this->numpages; $n++) {
                        $k = "{#" . $n . "}";
                        $ku = "{" . $k . "}";
                        $alias_a = $this->_escape($k);
                        $alias_au = $this->_escape("{" . $k . "}");
                        if ($this->isunicode) {
                            $alias_b = $this->_escape($this->UTF8ToLatin1($k));
                            $alias_bu = $this->_escape($this->UTF8ToLatin1($ku));
                            $alias_c = $this->_escape($this->utf8StrRev($k, false, $this->tmprtl));
                            $alias_cu = $this->_escape($this->utf8StrRev($ku, false, $this->tmprtl));
                        }
                        if ($page <= $n) {
                            $np = $n + $numpages;
                        } else {
                            $np = $n;
                        }
                        $ns = $this->formatTOCPageNumber($np);
                        $nu = $ns;
                        $sdiff = strlen($k) - strlen($ns) - 1;
                        $sdiffu = strlen($ku) - strlen($ns) - 1;
                        $sfill = str_repeat($filler, $sdiff);
                        $sfillu = str_repeat($filler, $sdiffu);
                        if ($this->rtl) {
                            $ns = $ns . " " . $sfill;
                            $nu = $nu . " " . $sfillu;
                        } else {
                            $ns = $sfill . " " . $ns;
                            $nu = $sfillu . " " . $nu;
                        }
                        $nu = $this->UTF8ToUTF16BE($nu, false);
                        $temppage = str_replace($alias_au, $nu, $temppage);
                        if ($this->isunicode) {
                            $temppage = str_replace($alias_bu, $nu, $temppage);
                            $temppage = str_replace($alias_cu, $nu, $temppage);
                            $temppage = str_replace($alias_b, $ns, $temppage);
                            $temppage = str_replace($alias_c, $ns, $temppage);
                        }
                        $temppage = str_replace($alias_a, $ns, $temppage);
                    }
                    $this->setPageBuffer($p, $temppage);
                }
                for ($i = 0; $i < $numpages; $i++) {
                    $this->movePage($page_last, $page);
                }
            }
            $this->SetFont($fontfamily, $fontstyle, $fontsize);
        }
        public function startTransaction()
        {
            if (isset($this->objcopy)) {
                $this->commitTransaction();
            }
            $this->objcopy = $this->objclone($this);
        }
        public function commitTransaction()
        {
            if (isset($this->objcopy)) {
                $this->objcopy->_destroy(true, true);
                unset($this->objcopy);
            }
        }
        public function rollbackTransaction()
        {
            if (isset($this->objcopy)) {
                if (isset($this->objcopy->diskcache) && $this->objcopy->diskcache) {
                    foreach ($this->objcopy->cache_file_lenght as $file => $lenght) {
                        $file = substr($file, 1);
                        $handle = fopen($file, "r+");
                        ftruncate($handle, $lenght);
                    }
                }
                $this->_destroy(true, true);
                return $this->objcopy;
            } else {
                return $this;
            }
        }
        public function objclone($object)
        {
            if (version_compare(phpversion(), "5.0") < 0) {
                return $object;
            }
            return clone $object;
        }
        public function empty_string($str)
        {
            return is_null($str) || is_string($str) && strlen($str) == 0;
        }
    }
}

?>