<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.2 & 7.3
 * @ Decoder version: 1.0.6
 * @ Release: 10/08/2022
 */

namespace Stripe;

/**
 * Class Person
 *
 * @package Stripe
 *
 * @property string $id
 * @property string $object
 * @property string $account
 * @property mixed $address
 * @property mixed $address_kana
 * @property mixed $address_kanji
 * @property int $created
 * @property bool $deleted
 * @property mixed $dob
 * @property string $email
 * @property string $first_name
 * @property string $first_name_kana
 * @property string $first_name_kanji
 * @property string $gender
 * @property bool $id_number_provided
 * @property string $last_name
 * @property string $last_name_kana
 * @property string $last_name_kanji
 * @property string $maiden_name
 * @property StripeObject $metadata
 * @property string $phone
 * @property mixed $relationship
 * @property mixed $requirements
 * @property bool $ssn_last_4_provided
 * @property mixed $verification
 */
class Person extends ApiResource
{
    use ApiOperations\Delete;
    use ApiOperations\Update;
    const OBJECT_NAME = "person";
    const GENDER_MALE = "male";
    const GENDER_FEMALE = "female";
    const VERIFICATION_STATUS_PENDING = "pending";
    const VERIFICATION_STATUS_UNVERIFIED = "unverified";
    const VERIFICATION_STATUS_VERIFIED = "verified";
    public function instanceUrl()
    {
        $id = $this["id"];
        $account = $this["account"];
        if (!$id) {
            throw new Error\InvalidRequest("Could not determine which URL to request: " . "class instance has invalid ID: " . $id, NULL);
        }
        $id = Util\Util::utf8($id);
        $account = Util\Util::utf8($account);
        $base = Account::classUrl();
        $accountExtn = urlencode($account);
        $extn = urlencode($id);
        return $base . "/" . $accountExtn . "/persons/" . $extn;
    }
    public static function retrieve($_id, $_opts = NULL)
    {
        $msg = "Persons cannot be accessed without an account ID. Retrieve a Person using \$account->retrievePerson('person_id') instead.";
        throw new Error\InvalidRequest($msg, NULL);
    }
    public static function update($_id, $_params = NULL, $_options = NULL)
    {
        $msg = "Persons cannot be accessed without an account ID. Retrieve a Person using \$account->retrievePerson('person_id') instead.";
        throw new Error\InvalidRequest($msg, NULL);
    }
}

?>