<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.2 & 7.3
 * @ Decoder version: 1.0.6
 * @ Release: 10/08/2022
 */

namespace SquareConnect\Model;

/**
 * CreateCustomerCardRequest Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 */
class CreateCustomerCardRequest implements \ArrayAccess
{
    /**
     * $card_nonce A card nonce representing the credit card to link to the customer.  Card nonces are generated by the `SqPaymentForm` that buyers enter their card information into. See [Embedding the payment form](/payments/sqpaymentform/overview) for more information.  __Note:__ Card nonces generated by digital wallets (e.g., Apple Pay) cannot be used to create a customer card.
     * @var string
     */
    protected $card_nonce = NULL;
    /**
     * $billing_address Address information for the card on file. Only the `postal_code` field is required for payments in the US and Canada.
     * @var \SquareConnect\Model\Address
     */
    protected $billing_address = NULL;
    /**
     * $cardholder_name The cardholder's name.
     * @var string
     */
    protected $cardholder_name = NULL;
    /**
     * Array of property to type mappings. Used for (de)serialization 
     * @var string[]
     */
    public static $swaggerTypes = ["card_nonce" => "string", "billing_address" => "\\SquareConnect\\Model\\Address", "cardholder_name" => "string"];
    /** 
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[] 
     */
    public static $attributeMap = ["card_nonce" => "card_nonce", "billing_address" => "billing_address", "cardholder_name" => "cardholder_name"];
    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    public static $setters = ["card_nonce" => "setCardNonce", "billing_address" => "setBillingAddress", "cardholder_name" => "setCardholderName"];
    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    public static $getters = ["card_nonce" => "getCardNonce", "billing_address" => "getBillingAddress", "cardholder_name" => "getCardholderName"];
    public function __construct($data = NULL)
    {
        if ($data != NULL) {
            if (isset($data["card_nonce"])) {
                $this->card_nonce = $data["card_nonce"];
            } else {
                $this->card_nonce = NULL;
            }
            if (isset($data["billing_address"])) {
                $this->billing_address = $data["billing_address"];
            } else {
                $this->billing_address = NULL;
            }
            if (isset($data["cardholder_name"])) {
                $this->cardholder_name = $data["cardholder_name"];
            } else {
                $this->cardholder_name = NULL;
            }
        }
    }
    public function getCardNonce()
    {
        return $this->card_nonce;
    }
    public function setCardNonce($card_nonce)
    {
        $this->card_nonce = $card_nonce;
        return $this;
    }
    public function getBillingAddress()
    {
        return $this->billing_address;
    }
    public function setBillingAddress($billing_address)
    {
        $this->billing_address = $billing_address;
        return $this;
    }
    public function getCardholderName()
    {
        return $this->cardholder_name;
    }
    public function setCardholderName($cardholder_name)
    {
        $this->cardholder_name = $cardholder_name;
        return $this;
    }
    public function offsetExists($offset)
    {
        return isset($this->{$offset});
    }
    public function offsetGet($offset)
    {
        return $this->{$offset};
    }
    public function offsetSet($offset, $value)
    {
        $this->{$offset} = $value;
    }
    public function offsetUnset($offset)
    {
        unset($this->{$offset});
    }
    public function __toString()
    {
        if (defined("JSON_PRETTY_PRINT")) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }
        return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
    }
}

?>