<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.2 & 7.3
 * @ Decoder version: 1.0.6
 * @ Release: 10/08/2022
 */

namespace SquareConnect\Model;

/**
 * Card Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 */
class Card implements \ArrayAccess
{
    /**
     * $id Unique ID for this card. Generated by Square.
     * @var string
     */
    protected $id = NULL;
    /**
     * $card_brand The card's brand (such as `VISA`). See [CardBrand](#type-cardbrand) for possible values
     * @var string
     */
    protected $card_brand = NULL;
    /**
     * $last_4 The last 4 digits of the card number.
     * @var string
     */
    protected $last_4 = NULL;
    /**
     * $exp_month The expiration month of the associated card as an integer between 1 and 12.
     * @var int
     */
    protected $exp_month = NULL;
    /**
     * $exp_year The four-digit year of the card's expiration date.
     * @var int
     */
    protected $exp_year = NULL;
    /**
     * $cardholder_name The name of the cardholder.
     * @var string
     */
    protected $cardholder_name = NULL;
    /**
     * $billing_address The billing address for this card.
     * @var \SquareConnect\Model\Address
     */
    protected $billing_address = NULL;
    /**
     * $fingerprint A unique, Square-assigned ID that identifies the card across multiple locations and applications for a single Square account.
     * @var string
     */
    protected $fingerprint = NULL;
    /**
     * Array of property to type mappings. Used for (de)serialization 
     * @var string[]
     */
    public static $swaggerTypes = ["id" => "string", "card_brand" => "string", "last_4" => "string", "exp_month" => "int", "exp_year" => "int", "cardholder_name" => "string", "billing_address" => "\\SquareConnect\\Model\\Address", "fingerprint" => "string"];
    /** 
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[] 
     */
    public static $attributeMap = ["id" => "id", "card_brand" => "card_brand", "last_4" => "last_4", "exp_month" => "exp_month", "exp_year" => "exp_year", "cardholder_name" => "cardholder_name", "billing_address" => "billing_address", "fingerprint" => "fingerprint"];
    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    public static $setters = ["id" => "setId", "card_brand" => "setCardBrand", "last_4" => "setLast4", "exp_month" => "setExpMonth", "exp_year" => "setExpYear", "cardholder_name" => "setCardholderName", "billing_address" => "setBillingAddress", "fingerprint" => "setFingerprint"];
    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    public static $getters = ["id" => "getId", "card_brand" => "getCardBrand", "last_4" => "getLast4", "exp_month" => "getExpMonth", "exp_year" => "getExpYear", "cardholder_name" => "getCardholderName", "billing_address" => "getBillingAddress", "fingerprint" => "getFingerprint"];
    public function __construct($data = NULL)
    {
        if ($data != NULL) {
            if (isset($data["id"])) {
                $this->id = $data["id"];
            } else {
                $this->id = NULL;
            }
            if (isset($data["card_brand"])) {
                $this->card_brand = $data["card_brand"];
            } else {
                $this->card_brand = NULL;
            }
            if (isset($data["last_4"])) {
                $this->last_4 = $data["last_4"];
            } else {
                $this->last_4 = NULL;
            }
            if (isset($data["exp_month"])) {
                $this->exp_month = $data["exp_month"];
            } else {
                $this->exp_month = NULL;
            }
            if (isset($data["exp_year"])) {
                $this->exp_year = $data["exp_year"];
            } else {
                $this->exp_year = NULL;
            }
            if (isset($data["cardholder_name"])) {
                $this->cardholder_name = $data["cardholder_name"];
            } else {
                $this->cardholder_name = NULL;
            }
            if (isset($data["billing_address"])) {
                $this->billing_address = $data["billing_address"];
            } else {
                $this->billing_address = NULL;
            }
            if (isset($data["fingerprint"])) {
                $this->fingerprint = $data["fingerprint"];
            } else {
                $this->fingerprint = NULL;
            }
        }
    }
    public function getId()
    {
        return $this->id;
    }
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }
    public function getCardBrand()
    {
        return $this->card_brand;
    }
    public function setCardBrand($card_brand)
    {
        $this->card_brand = $card_brand;
        return $this;
    }
    public function getLast4()
    {
        return $this->last_4;
    }
    public function setLast4($last_4)
    {
        $this->last_4 = $last_4;
        return $this;
    }
    public function getExpMonth()
    {
        return $this->exp_month;
    }
    public function setExpMonth($exp_month)
    {
        $this->exp_month = $exp_month;
        return $this;
    }
    public function getExpYear()
    {
        return $this->exp_year;
    }
    public function setExpYear($exp_year)
    {
        $this->exp_year = $exp_year;
        return $this;
    }
    public function getCardholderName()
    {
        return $this->cardholder_name;
    }
    public function setCardholderName($cardholder_name)
    {
        $this->cardholder_name = $cardholder_name;
        return $this;
    }
    public function getBillingAddress()
    {
        return $this->billing_address;
    }
    public function setBillingAddress($billing_address)
    {
        $this->billing_address = $billing_address;
        return $this;
    }
    public function getFingerprint()
    {
        return $this->fingerprint;
    }
    public function setFingerprint($fingerprint)
    {
        $this->fingerprint = $fingerprint;
        return $this;
    }
    public function offsetExists($offset)
    {
        return isset($this->{$offset});
    }
    public function offsetGet($offset)
    {
        return $this->{$offset};
    }
    public function offsetSet($offset, $value)
    {
        $this->{$offset} = $value;
    }
    public function offsetUnset($offset)
    {
        unset($this->{$offset});
    }
    public function __toString()
    {
        if (defined("JSON_PRETTY_PRINT")) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }
        return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
    }
}

?>