<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.2 & 7.3
 * @ Decoder version: 1.0.6
 * @ Release: 10/08/2022
 */

/**
 * The "operations" collection of methods.
 * Typical usage is:
 *  <code>
 *   $computeService = new Google_ComputeService(...);
 *   $operations = $computeService->operations;
 *  </code>
 */
class Google_OperationsServiceResource extends Google_ServiceResource
{
    public function get($project, $operation, $optParams = [])
    {
        $params = ["project" => $project, "operation" => $operation];
        $params = array_merge($params, $optParams);
        $data = $this->__call("get", [$params]);
        if ($this->useObjects()) {
            return new Google_Operation($data);
        }
        return $data;
    }
    public function listOperations($project, $optParams = [])
    {
        $params = ["project" => $project];
        $params = array_merge($params, $optParams);
        $data = $this->__call("list", [$params]);
        if ($this->useObjects()) {
            return new Google_OperationList($data);
        }
        return $data;
    }
    public function delete($project, $operation, $optParams = [])
    {
        $params = ["project" => $project, "operation" => $operation];
        $params = array_merge($params, $optParams);
        $data = $this->__call("delete", [$params]);
        return $data;
    }
}
/**
 * The "kernels" collection of methods.
 * Typical usage is:
 *  <code>
 *   $computeService = new Google_ComputeService(...);
 *   $kernels = $computeService->kernels;
 *  </code>
 */
class Google_KernelsServiceResource extends Google_ServiceResource
{
    public function listKernels($project, $optParams = [])
    {
        $params = ["project" => $project];
        $params = array_merge($params, $optParams);
        $data = $this->__call("list", [$params]);
        if ($this->useObjects()) {
            return new Google_KernelList($data);
        }
        return $data;
    }
    public function get($project, $kernel, $optParams = [])
    {
        $params = ["project" => $project, "kernel" => $kernel];
        $params = array_merge($params, $optParams);
        $data = $this->__call("get", [$params]);
        if ($this->useObjects()) {
            return new Google_Kernel($data);
        }
        return $data;
    }
}
/**
 * The "disks" collection of methods.
 * Typical usage is:
 *  <code>
 *   $computeService = new Google_ComputeService(...);
 *   $disks = $computeService->disks;
 *  </code>
 */
class Google_DisksServiceResource extends Google_ServiceResource
{
    public function insert($project, Google_Disk $postBody, $optParams = [])
    {
        $params = ["project" => $project, "postBody" => $postBody];
        $params = array_merge($params, $optParams);
        $data = $this->__call("insert", [$params]);
        if ($this->useObjects()) {
            return new Google_Operation($data);
        }
        return $data;
    }
    public function get($project, $disk, $optParams = [])
    {
        $params = ["project" => $project, "disk" => $disk];
        $params = array_merge($params, $optParams);
        $data = $this->__call("get", [$params]);
        if ($this->useObjects()) {
            return new Google_Disk($data);
        }
        return $data;
    }
    public function listDisks($project, $optParams = [])
    {
        $params = ["project" => $project];
        $params = array_merge($params, $optParams);
        $data = $this->__call("list", [$params]);
        if ($this->useObjects()) {
            return new Google_DiskList($data);
        }
        return $data;
    }
    public function delete($project, $disk, $optParams = [])
    {
        $params = ["project" => $project, "disk" => $disk];
        $params = array_merge($params, $optParams);
        $data = $this->__call("delete", [$params]);
        if ($this->useObjects()) {
            return new Google_Operation($data);
        }
        return $data;
    }
}
/**
 * The "snapshots" collection of methods.
 * Typical usage is:
 *  <code>
 *   $computeService = new Google_ComputeService(...);
 *   $snapshots = $computeService->snapshots;
 *  </code>
 */
class Google_SnapshotsServiceResource extends Google_ServiceResource
{
    public function insert($project, Google_Snapshot $postBody, $optParams = [])
    {
        $params = ["project" => $project, "postBody" => $postBody];
        $params = array_merge($params, $optParams);
        $data = $this->__call("insert", [$params]);
        if ($this->useObjects()) {
            return new Google_Operation($data);
        }
        return $data;
    }
    public function get($project, $snapshot, $optParams = [])
    {
        $params = ["project" => $project, "snapshot" => $snapshot];
        $params = array_merge($params, $optParams);
        $data = $this->__call("get", [$params]);
        if ($this->useObjects()) {
            return new Google_Snapshot($data);
        }
        return $data;
    }
    public function listSnapshots($project, $optParams = [])
    {
        $params = ["project" => $project];
        $params = array_merge($params, $optParams);
        $data = $this->__call("list", [$params]);
        if ($this->useObjects()) {
            return new Google_SnapshotList($data);
        }
        return $data;
    }
    public function delete($project, $snapshot, $optParams = [])
    {
        $params = ["project" => $project, "snapshot" => $snapshot];
        $params = array_merge($params, $optParams);
        $data = $this->__call("delete", [$params]);
        if ($this->useObjects()) {
            return new Google_Operation($data);
        }
        return $data;
    }
}
/**
 * The "zones" collection of methods.
 * Typical usage is:
 *  <code>
 *   $computeService = new Google_ComputeService(...);
 *   $zones = $computeService->zones;
 *  </code>
 */
class Google_ZonesServiceResource extends Google_ServiceResource
{
    public function listZones($project, $optParams = [])
    {
        $params = ["project" => $project];
        $params = array_merge($params, $optParams);
        $data = $this->__call("list", [$params]);
        if ($this->useObjects()) {
            return new Google_ZoneList($data);
        }
        return $data;
    }
    public function get($project, $zone, $optParams = [])
    {
        $params = ["project" => $project, "zone" => $zone];
        $params = array_merge($params, $optParams);
        $data = $this->__call("get", [$params]);
        if ($this->useObjects()) {
            return new Google_Zone($data);
        }
        return $data;
    }
}
/**
 * The "instances" collection of methods.
 * Typical usage is:
 *  <code>
 *   $computeService = new Google_ComputeService(...);
 *   $instances = $computeService->instances;
 *  </code>
 */
class Google_InstancesServiceResource extends Google_ServiceResource
{
    public function insert($project, Google_Instance $postBody, $optParams = [])
    {
        $params = ["project" => $project, "postBody" => $postBody];
        $params = array_merge($params, $optParams);
        $data = $this->__call("insert", [$params]);
        if ($this->useObjects()) {
            return new Google_Operation($data);
        }
        return $data;
    }
    public function deleteAccessConfig($project, $instance, $access_config, $network_interface, $optParams = [])
    {
        $params = ["project" => $project, "instance" => $instance, "access_config" => $access_config, "network_interface" => $network_interface];
        $params = array_merge($params, $optParams);
        $data = $this->__call("deleteAccessConfig", [$params]);
        if ($this->useObjects()) {
            return new Google_Operation($data);
        }
        return $data;
    }
    public function get($project, $instance, $optParams = [])
    {
        $params = ["project" => $project, "instance" => $instance];
        $params = array_merge($params, $optParams);
        $data = $this->__call("get", [$params]);
        if ($this->useObjects()) {
            return new Google_Instance($data);
        }
        return $data;
    }
    public function listInstances($project, $optParams = [])
    {
        $params = ["project" => $project];
        $params = array_merge($params, $optParams);
        $data = $this->__call("list", [$params]);
        if ($this->useObjects()) {
            return new Google_InstanceList($data);
        }
        return $data;
    }
    public function addAccessConfig($project, $instance, $network_interface, Google_AccessConfig $postBody, $optParams = [])
    {
        $params = ["project" => $project, "instance" => $instance, "network_interface" => $network_interface, "postBody" => $postBody];
        $params = array_merge($params, $optParams);
        $data = $this->__call("addAccessConfig", [$params]);
        if ($this->useObjects()) {
            return new Google_Operation($data);
        }
        return $data;
    }
    public function delete($project, $instance, $optParams = [])
    {
        $params = ["project" => $project, "instance" => $instance];
        $params = array_merge($params, $optParams);
        $data = $this->__call("delete", [$params]);
        if ($this->useObjects()) {
            return new Google_Operation($data);
        }
        return $data;
    }
}
/**
 * The "machineTypes" collection of methods.
 * Typical usage is:
 *  <code>
 *   $computeService = new Google_ComputeService(...);
 *   $machineTypes = $computeService->machineTypes;
 *  </code>
 */
class Google_MachineTypesServiceResource extends Google_ServiceResource
{
    public function listMachineTypes($project, $optParams = [])
    {
        $params = ["project" => $project];
        $params = array_merge($params, $optParams);
        $data = $this->__call("list", [$params]);
        if ($this->useObjects()) {
            return new Google_MachineTypeList($data);
        }
        return $data;
    }
    public function get($project, $machineType, $optParams = [])
    {
        $params = ["project" => $project, "machineType" => $machineType];
        $params = array_merge($params, $optParams);
        $data = $this->__call("get", [$params]);
        if ($this->useObjects()) {
            return new Google_MachineType($data);
        }
        return $data;
    }
}
/**
 * The "images" collection of methods.
 * Typical usage is:
 *  <code>
 *   $computeService = new Google_ComputeService(...);
 *   $images = $computeService->images;
 *  </code>
 */
class Google_ImagesServiceResource extends Google_ServiceResource
{
    public function insert($project, Google_Image $postBody, $optParams = [])
    {
        $params = ["project" => $project, "postBody" => $postBody];
        $params = array_merge($params, $optParams);
        $data = $this->__call("insert", [$params]);
        if ($this->useObjects()) {
            return new Google_Operation($data);
        }
        return $data;
    }
    public function get($project, $image, $optParams = [])
    {
        $params = ["project" => $project, "image" => $image];
        $params = array_merge($params, $optParams);
        $data = $this->__call("get", [$params]);
        if ($this->useObjects()) {
            return new Google_Image($data);
        }
        return $data;
    }
    public function listImages($project, $optParams = [])
    {
        $params = ["project" => $project];
        $params = array_merge($params, $optParams);
        $data = $this->__call("list", [$params]);
        if ($this->useObjects()) {
            return new Google_ImageList($data);
        }
        return $data;
    }
    public function delete($project, $image, $optParams = [])
    {
        $params = ["project" => $project, "image" => $image];
        $params = array_merge($params, $optParams);
        $data = $this->__call("delete", [$params]);
        if ($this->useObjects()) {
            return new Google_Operation($data);
        }
        return $data;
    }
}
/**
 * The "firewalls" collection of methods.
 * Typical usage is:
 *  <code>
 *   $computeService = new Google_ComputeService(...);
 *   $firewalls = $computeService->firewalls;
 *  </code>
 */
class Google_FirewallsServiceResource extends Google_ServiceResource
{
    public function insert($project, Google_Firewall $postBody, $optParams = [])
    {
        $params = ["project" => $project, "postBody" => $postBody];
        $params = array_merge($params, $optParams);
        $data = $this->__call("insert", [$params]);
        if ($this->useObjects()) {
            return new Google_Operation($data);
        }
        return $data;
    }
    public function get($project, $firewall, $optParams = [])
    {
        $params = ["project" => $project, "firewall" => $firewall];
        $params = array_merge($params, $optParams);
        $data = $this->__call("get", [$params]);
        if ($this->useObjects()) {
            return new Google_Firewall($data);
        }
        return $data;
    }
    public function listFirewalls($project, $optParams = [])
    {
        $params = ["project" => $project];
        $params = array_merge($params, $optParams);
        $data = $this->__call("list", [$params]);
        if ($this->useObjects()) {
            return new Google_FirewallList($data);
        }
        return $data;
    }
    public function update($project, $firewall, Google_Firewall $postBody, $optParams = [])
    {
        $params = ["project" => $project, "firewall" => $firewall, "postBody" => $postBody];
        $params = array_merge($params, $optParams);
        $data = $this->__call("update", [$params]);
        if ($this->useObjects()) {
            return new Google_Operation($data);
        }
        return $data;
    }
    public function patch($project, $firewall, Google_Firewall $postBody, $optParams = [])
    {
        $params = ["project" => $project, "firewall" => $firewall, "postBody" => $postBody];
        $params = array_merge($params, $optParams);
        $data = $this->__call("patch", [$params]);
        if ($this->useObjects()) {
            return new Google_Operation($data);
        }
        return $data;
    }
    public function delete($project, $firewall, $optParams = [])
    {
        $params = ["project" => $project, "firewall" => $firewall];
        $params = array_merge($params, $optParams);
        $data = $this->__call("delete", [$params]);
        if ($this->useObjects()) {
            return new Google_Operation($data);
        }
        return $data;
    }
}
/**
 * The "networks" collection of methods.
 * Typical usage is:
 *  <code>
 *   $computeService = new Google_ComputeService(...);
 *   $networks = $computeService->networks;
 *  </code>
 */
class Google_NetworksServiceResource extends Google_ServiceResource
{
    public function insert($project, Google_Network $postBody, $optParams = [])
    {
        $params = ["project" => $project, "postBody" => $postBody];
        $params = array_merge($params, $optParams);
        $data = $this->__call("insert", [$params]);
        if ($this->useObjects()) {
            return new Google_Operation($data);
        }
        return $data;
    }
    public function get($project, $network, $optParams = [])
    {
        $params = ["project" => $project, "network" => $network];
        $params = array_merge($params, $optParams);
        $data = $this->__call("get", [$params]);
        if ($this->useObjects()) {
            return new Google_Network($data);
        }
        return $data;
    }
    public function listNetworks($project, $optParams = [])
    {
        $params = ["project" => $project];
        $params = array_merge($params, $optParams);
        $data = $this->__call("list", [$params]);
        if ($this->useObjects()) {
            return new Google_NetworkList($data);
        }
        return $data;
    }
    public function delete($project, $network, $optParams = [])
    {
        $params = ["project" => $project, "network" => $network];
        $params = array_merge($params, $optParams);
        $data = $this->__call("delete", [$params]);
        if ($this->useObjects()) {
            return new Google_Operation($data);
        }
        return $data;
    }
}
/**
 * The "projects" collection of methods.
 * Typical usage is:
 *  <code>
 *   $computeService = new Google_ComputeService(...);
 *   $projects = $computeService->projects;
 *  </code>
 */
class Google_ProjectsServiceResource extends Google_ServiceResource
{
    public function setCommonInstanceMetadata($project, Google_Metadata $postBody, $optParams = [])
    {
        $params = ["project" => $project, "postBody" => $postBody];
        $params = array_merge($params, $optParams);
        $data = $this->__call("setCommonInstanceMetadata", [$params]);
        return $data;
    }
    public function get($project, $optParams = [])
    {
        $params = ["project" => $project];
        $params = array_merge($params, $optParams);
        $data = $this->__call("get", [$params]);
        if ($this->useObjects()) {
            return new Google_Project($data);
        }
        return $data;
    }
}
/**
 * Service definition for Google_Compute (v1beta12).
 *
 * <p>
 * API for the Google Compute Engine service.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/compute/docs/reference/v1beta12" target="_blank">API Documentation</a>
 * </p>
 *
 * @author Google, Inc.
 */
class Google_ComputeService extends Google_Service
{
    public $operations = NULL;
    public $kernels = NULL;
    public $disks = NULL;
    public $snapshots = NULL;
    public $zones = NULL;
    public $instances = NULL;
    public $machineTypes = NULL;
    public $images = NULL;
    public $firewalls = NULL;
    public $networks = NULL;
    public $projects = NULL;
    public function __construct(Google_Client $client)
    {
        $this->servicePath = "compute/v1beta12/projects/";
        $this->version = "v1beta12";
        $this->serviceName = "compute";
        $client->addService($this->serviceName, $this->version);
        $this->operations = new Google_OperationsServiceResource($this, $this->serviceName, "operations", json_decode("{\"methods\": {\"get\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"operation\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"id\": \"compute.operations.get\", \"httpMethod\": \"GET\", \"path\": \"{project}/operations/{operation}\", \"response\": {\"\$ref\": \"Operation\"}}, \"list\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"filter\": {\"type\": \"string\", \"location\": \"query\"}, \"pageToken\": {\"type\": \"string\", \"location\": \"query\"}, \"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"maxResults\": {\"type\": \"integer\", \"location\": \"query\", \"format\": \"uint32\"}}, \"id\": \"compute.operations.list\", \"httpMethod\": \"GET\", \"path\": \"{project}/operations\", \"response\": {\"\$ref\": \"OperationList\"}}, \"delete\": {\"scopes\": [\"https://www.googleapis.com/auth/compute\"], \"path\": \"{project}/operations/{operation}\", \"id\": \"compute.operations.delete\", \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"operation\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"httpMethod\": \"DELETE\"}}}", true));
        $this->kernels = new Google_KernelsServiceResource($this, $this->serviceName, "kernels", json_decode("{\"methods\": {\"list\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"filter\": {\"type\": \"string\", \"location\": \"query\"}, \"pageToken\": {\"type\": \"string\", \"location\": \"query\"}, \"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"maxResults\": {\"type\": \"integer\", \"location\": \"query\", \"format\": \"uint32\"}}, \"id\": \"compute.kernels.list\", \"httpMethod\": \"GET\", \"path\": \"{project}/kernels\", \"response\": {\"\$ref\": \"KernelList\"}}, \"get\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"kernel\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"id\": \"compute.kernels.get\", \"httpMethod\": \"GET\", \"path\": \"{project}/kernels/{kernel}\", \"response\": {\"\$ref\": \"Kernel\"}}}}", true));
        $this->disks = new Google_DisksServiceResource($this, $this->serviceName, "disks", json_decode("{\"methods\": {\"insert\": {\"scopes\": [\"https://www.googleapis.com/auth/compute\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"request\": {\"\$ref\": \"Disk\"}, \"response\": {\"\$ref\": \"Operation\"}, \"httpMethod\": \"POST\", \"path\": \"{project}/disks\", \"id\": \"compute.disks.insert\"}, \"get\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"disk\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"id\": \"compute.disks.get\", \"httpMethod\": \"GET\", \"path\": \"{project}/disks/{disk}\", \"response\": {\"\$ref\": \"Disk\"}}, \"list\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"filter\": {\"type\": \"string\", \"location\": \"query\"}, \"pageToken\": {\"type\": \"string\", \"location\": \"query\"}, \"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"maxResults\": {\"type\": \"integer\", \"location\": \"query\", \"format\": \"uint32\"}}, \"id\": \"compute.disks.list\", \"httpMethod\": \"GET\", \"path\": \"{project}/disks\", \"response\": {\"\$ref\": \"DiskList\"}}, \"delete\": {\"scopes\": [\"https://www.googleapis.com/auth/compute\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"disk\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"id\": \"compute.disks.delete\", \"httpMethod\": \"DELETE\", \"path\": \"{project}/disks/{disk}\", \"response\": {\"\$ref\": \"Operation\"}}}}", true));
        $this->snapshots = new Google_SnapshotsServiceResource($this, $this->serviceName, "snapshots", json_decode("{\"methods\": {\"insert\": {\"scopes\": [\"https://www.googleapis.com/auth/compute\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"request\": {\"\$ref\": \"Snapshot\"}, \"response\": {\"\$ref\": \"Operation\"}, \"httpMethod\": \"POST\", \"path\": \"{project}/snapshots\", \"id\": \"compute.snapshots.insert\"}, \"get\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"snapshot\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"id\": \"compute.snapshots.get\", \"httpMethod\": \"GET\", \"path\": \"{project}/snapshots/{snapshot}\", \"response\": {\"\$ref\": \"Snapshot\"}}, \"list\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"filter\": {\"type\": \"string\", \"location\": \"query\"}, \"pageToken\": {\"type\": \"string\", \"location\": \"query\"}, \"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"maxResults\": {\"type\": \"integer\", \"location\": \"query\", \"format\": \"uint32\"}}, \"id\": \"compute.snapshots.list\", \"httpMethod\": \"GET\", \"path\": \"{project}/snapshots\", \"response\": {\"\$ref\": \"SnapshotList\"}}, \"delete\": {\"scopes\": [\"https://www.googleapis.com/auth/compute\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"snapshot\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"id\": \"compute.snapshots.delete\", \"httpMethod\": \"DELETE\", \"path\": \"{project}/snapshots/{snapshot}\", \"response\": {\"\$ref\": \"Operation\"}}}}", true));
        $this->zones = new Google_ZonesServiceResource($this, $this->serviceName, "zones", json_decode("{\"methods\": {\"list\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"filter\": {\"type\": \"string\", \"location\": \"query\"}, \"pageToken\": {\"type\": \"string\", \"location\": \"query\"}, \"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"maxResults\": {\"type\": \"integer\", \"location\": \"query\", \"format\": \"uint32\"}}, \"id\": \"compute.zones.list\", \"httpMethod\": \"GET\", \"path\": \"{project}/zones\", \"response\": {\"\$ref\": \"ZoneList\"}}, \"get\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"zone\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"id\": \"compute.zones.get\", \"httpMethod\": \"GET\", \"path\": \"{project}/zones/{zone}\", \"response\": {\"\$ref\": \"Zone\"}}}}", true));
        $this->instances = new Google_InstancesServiceResource($this, $this->serviceName, "instances", json_decode("{\"methods\": {\"insert\": {\"scopes\": [\"https://www.googleapis.com/auth/compute\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"request\": {\"\$ref\": \"Instance\"}, \"response\": {\"\$ref\": \"Operation\"}, \"httpMethod\": \"POST\", \"path\": \"{project}/instances\", \"id\": \"compute.instances.insert\"}, \"deleteAccessConfig\": {\"scopes\": [\"https://www.googleapis.com/auth/compute\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"instance\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"access_config\": {\"required\": true, \"type\": \"string\", \"location\": \"query\"}, \"network_interface\": {\"required\": true, \"type\": \"string\", \"location\": \"query\"}}, \"id\": \"compute.instances.deleteAccessConfig\", \"httpMethod\": \"POST\", \"path\": \"{project}/instances/{instance}/delete-access-config\", \"response\": {\"\$ref\": \"Operation\"}}, \"get\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"instance\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"id\": \"compute.instances.get\", \"httpMethod\": \"GET\", \"path\": \"{project}/instances/{instance}\", \"response\": {\"\$ref\": \"Instance\"}}, \"list\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"filter\": {\"type\": \"string\", \"location\": \"query\"}, \"pageToken\": {\"type\": \"string\", \"location\": \"query\"}, \"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"maxResults\": {\"type\": \"integer\", \"location\": \"query\", \"format\": \"uint32\"}}, \"id\": \"compute.instances.list\", \"httpMethod\": \"GET\", \"path\": \"{project}/instances\", \"response\": {\"\$ref\": \"InstanceList\"}}, \"addAccessConfig\": {\"scopes\": [\"https://www.googleapis.com/auth/compute\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"instance\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"network_interface\": {\"required\": true, \"type\": \"string\", \"location\": \"query\"}}, \"request\": {\"\$ref\": \"AccessConfig\"}, \"response\": {\"\$ref\": \"Operation\"}, \"httpMethod\": \"POST\", \"path\": \"{project}/instances/{instance}/add-access-config\", \"id\": \"compute.instances.addAccessConfig\"}, \"delete\": {\"scopes\": [\"https://www.googleapis.com/auth/compute\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"instance\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"id\": \"compute.instances.delete\", \"httpMethod\": \"DELETE\", \"path\": \"{project}/instances/{instance}\", \"response\": {\"\$ref\": \"Operation\"}}}}", true));
        $this->machineTypes = new Google_MachineTypesServiceResource($this, $this->serviceName, "machineTypes", json_decode("{\"methods\": {\"list\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"filter\": {\"type\": \"string\", \"location\": \"query\"}, \"pageToken\": {\"type\": \"string\", \"location\": \"query\"}, \"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"maxResults\": {\"type\": \"integer\", \"location\": \"query\", \"format\": \"uint32\"}}, \"id\": \"compute.machineTypes.list\", \"httpMethod\": \"GET\", \"path\": \"{project}/machine-types\", \"response\": {\"\$ref\": \"MachineTypeList\"}}, \"get\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"machineType\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"id\": \"compute.machineTypes.get\", \"httpMethod\": \"GET\", \"path\": \"{project}/machine-types/{machineType}\", \"response\": {\"\$ref\": \"MachineType\"}}}}", true));
        $this->images = new Google_ImagesServiceResource($this, $this->serviceName, "images", json_decode("{\"methods\": {\"insert\": {\"scopes\": [\"https://www.googleapis.com/auth/compute\", \"https://www.googleapis.com/auth/devstorage.read_only\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"request\": {\"\$ref\": \"Image\"}, \"response\": {\"\$ref\": \"Operation\"}, \"httpMethod\": \"POST\", \"path\": \"{project}/images\", \"id\": \"compute.images.insert\"}, \"get\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"image\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"id\": \"compute.images.get\", \"httpMethod\": \"GET\", \"path\": \"{project}/images/{image}\", \"response\": {\"\$ref\": \"Image\"}}, \"list\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"filter\": {\"type\": \"string\", \"location\": \"query\"}, \"pageToken\": {\"type\": \"string\", \"location\": \"query\"}, \"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"maxResults\": {\"type\": \"integer\", \"location\": \"query\", \"format\": \"uint32\"}}, \"id\": \"compute.images.list\", \"httpMethod\": \"GET\", \"path\": \"{project}/images\", \"response\": {\"\$ref\": \"ImageList\"}}, \"delete\": {\"scopes\": [\"https://www.googleapis.com/auth/compute\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"image\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"id\": \"compute.images.delete\", \"httpMethod\": \"DELETE\", \"path\": \"{project}/images/{image}\", \"response\": {\"\$ref\": \"Operation\"}}}}", true));
        $this->firewalls = new Google_FirewallsServiceResource($this, $this->serviceName, "firewalls", json_decode("{\"methods\": {\"insert\": {\"scopes\": [\"https://www.googleapis.com/auth/compute\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"request\": {\"\$ref\": \"Firewall\"}, \"response\": {\"\$ref\": \"Operation\"}, \"httpMethod\": \"POST\", \"path\": \"{project}/firewalls\", \"id\": \"compute.firewalls.insert\"}, \"get\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"firewall\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"id\": \"compute.firewalls.get\", \"httpMethod\": \"GET\", \"path\": \"{project}/firewalls/{firewall}\", \"response\": {\"\$ref\": \"Firewall\"}}, \"list\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"filter\": {\"type\": \"string\", \"location\": \"query\"}, \"pageToken\": {\"type\": \"string\", \"location\": \"query\"}, \"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"maxResults\": {\"type\": \"integer\", \"location\": \"query\", \"format\": \"uint32\"}}, \"id\": \"compute.firewalls.list\", \"httpMethod\": \"GET\", \"path\": \"{project}/firewalls\", \"response\": {\"\$ref\": \"FirewallList\"}}, \"update\": {\"scopes\": [\"https://www.googleapis.com/auth/compute\"], \"parameters\": {\"firewall\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"request\": {\"\$ref\": \"Firewall\"}, \"response\": {\"\$ref\": \"Operation\"}, \"httpMethod\": \"PUT\", \"path\": \"{project}/firewalls/{firewall}\", \"id\": \"compute.firewalls.update\"}, \"patch\": {\"scopes\": [\"https://www.googleapis.com/auth/compute\"], \"parameters\": {\"firewall\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"request\": {\"\$ref\": \"Firewall\"}, \"response\": {\"\$ref\": \"Operation\"}, \"httpMethod\": \"PATCH\", \"path\": \"{project}/firewalls/{firewall}\", \"id\": \"compute.firewalls.patch\"}, \"delete\": {\"scopes\": [\"https://www.googleapis.com/auth/compute\"], \"parameters\": {\"firewall\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"id\": \"compute.firewalls.delete\", \"httpMethod\": \"DELETE\", \"path\": \"{project}/firewalls/{firewall}\", \"response\": {\"\$ref\": \"Operation\"}}}}", true));
        $this->networks = new Google_NetworksServiceResource($this, $this->serviceName, "networks", json_decode("{\"methods\": {\"insert\": {\"scopes\": [\"https://www.googleapis.com/auth/compute\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"request\": {\"\$ref\": \"Network\"}, \"response\": {\"\$ref\": \"Operation\"}, \"httpMethod\": \"POST\", \"path\": \"{project}/networks\", \"id\": \"compute.networks.insert\"}, \"get\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"network\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"id\": \"compute.networks.get\", \"httpMethod\": \"GET\", \"path\": \"{project}/networks/{network}\", \"response\": {\"\$ref\": \"Network\"}}, \"list\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"filter\": {\"type\": \"string\", \"location\": \"query\"}, \"pageToken\": {\"type\": \"string\", \"location\": \"query\"}, \"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"maxResults\": {\"type\": \"integer\", \"location\": \"query\", \"format\": \"uint32\"}}, \"id\": \"compute.networks.list\", \"httpMethod\": \"GET\", \"path\": \"{project}/networks\", \"response\": {\"\$ref\": \"NetworkList\"}}, \"delete\": {\"scopes\": [\"https://www.googleapis.com/auth/compute\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}, \"network\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"id\": \"compute.networks.delete\", \"httpMethod\": \"DELETE\", \"path\": \"{project}/networks/{network}\", \"response\": {\"\$ref\": \"Operation\"}}}}", true));
        $this->projects = new Google_ProjectsServiceResource($this, $this->serviceName, "projects", json_decode("{\"methods\": {\"setCommonInstanceMetadata\": {\"scopes\": [\"https://www.googleapis.com/auth/compute\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"request\": {\"\$ref\": \"Metadata\"}, \"httpMethod\": \"POST\", \"path\": \"{project}/set-common-instance-metadata\", \"id\": \"compute.projects.setCommonInstanceMetadata\"}, \"get\": {\"scopes\": [\"https://www.googleapis.com/auth/compute.readonly\"], \"parameters\": {\"project\": {\"required\": true, \"type\": \"string\", \"location\": \"path\"}}, \"id\": \"compute.projects.get\", \"httpMethod\": \"GET\", \"path\": \"{project}\", \"response\": {\"\$ref\": \"Project\"}}}}", true));
    }
}
class Google_AccessConfig extends Google_Model
{
    public $kind = NULL;
    public $type = NULL;
    public $name = NULL;
    public $natIP = NULL;
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setType($type)
    {
        $this->type = $type;
    }
    public function getType()
    {
        return $this->type;
    }
    public function setName($name)
    {
        $this->name = $name;
    }
    public function getName()
    {
        return $this->name;
    }
    public function setNatIP($natIP)
    {
        $this->natIP = $natIP;
    }
    public function getNatIP()
    {
        return $this->natIP;
    }
}
class Google_AttachedDisk extends Google_Model
{
    public $deviceName = NULL;
    public $kind = NULL;
    public $index = NULL;
    public $source = NULL;
    public $mode = NULL;
    public $deleteOnTerminate = NULL;
    public $type = NULL;
    public function setDeviceName($deviceName)
    {
        $this->deviceName = $deviceName;
    }
    public function getDeviceName()
    {
        return $this->deviceName;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setIndex($index)
    {
        $this->index = $index;
    }
    public function getIndex()
    {
        return $this->index;
    }
    public function setSource($source)
    {
        $this->source = $source;
    }
    public function getSource()
    {
        return $this->source;
    }
    public function setMode($mode)
    {
        $this->mode = $mode;
    }
    public function getMode()
    {
        return $this->mode;
    }
    public function setDeleteOnTerminate($deleteOnTerminate)
    {
        $this->deleteOnTerminate = $deleteOnTerminate;
    }
    public function getDeleteOnTerminate()
    {
        return $this->deleteOnTerminate;
    }
    public function setType($type)
    {
        $this->type = $type;
    }
    public function getType()
    {
        return $this->type;
    }
}
class Google_Disk extends Google_Model
{
    public $status = NULL;
    public $sourceSnapshot = NULL;
    public $kind = NULL;
    public $description = NULL;
    public $sizeGb = NULL;
    public $id = NULL;
    public $sourceSnapshotId = NULL;
    public $zone = NULL;
    public $creationTimestamp = NULL;
    public $options = NULL;
    public $selfLink = NULL;
    public $name = NULL;
    public function setStatus($status)
    {
        $this->status = $status;
    }
    public function getStatus()
    {
        return $this->status;
    }
    public function setSourceSnapshot($sourceSnapshot)
    {
        $this->sourceSnapshot = $sourceSnapshot;
    }
    public function getSourceSnapshot()
    {
        return $this->sourceSnapshot;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setDescription($description)
    {
        $this->description = $description;
    }
    public function getDescription()
    {
        return $this->description;
    }
    public function setSizeGb($sizeGb)
    {
        $this->sizeGb = $sizeGb;
    }
    public function getSizeGb()
    {
        return $this->sizeGb;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSourceSnapshotId($sourceSnapshotId)
    {
        $this->sourceSnapshotId = $sourceSnapshotId;
    }
    public function getSourceSnapshotId()
    {
        return $this->sourceSnapshotId;
    }
    public function setZone($zone)
    {
        $this->zone = $zone;
    }
    public function getZone()
    {
        return $this->zone;
    }
    public function setCreationTimestamp($creationTimestamp)
    {
        $this->creationTimestamp = $creationTimestamp;
    }
    public function getCreationTimestamp()
    {
        return $this->creationTimestamp;
    }
    public function setOptions($options)
    {
        $this->options = $options;
    }
    public function getOptions()
    {
        return $this->options;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
    public function setName($name)
    {
        $this->name = $name;
    }
    public function getName()
    {
        return $this->name;
    }
}
class Google_DiskList extends Google_Model
{
    public $nextPageToken = NULL;
    protected $__itemsType = "Google_Disk";
    protected $__itemsDataType = "array";
    public $items = NULL;
    public $kind = NULL;
    public $id = NULL;
    public $selfLink = NULL;
    public function setNextPageToken($nextPageToken)
    {
        $this->nextPageToken = $nextPageToken;
    }
    public function getNextPageToken()
    {
        return $this->nextPageToken;
    }
    public function setItems($items)
    {
        $this->assertIsArray($items, "Google_Disk", "Google_DiskList::setItems");
        $this->items = $items;
    }
    public function getItems()
    {
        return $this->items;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
}
class Google_Firewall extends Google_Model
{
    public $kind = NULL;
    public $description = NULL;
    public $sourceTags = NULL;
    public $sourceRanges = NULL;
    public $network = NULL;
    public $targetTags = NULL;
    protected $__allowedType = "Google_FirewallAllowed";
    protected $__allowedDataType = "array";
    public $allowed = NULL;
    public $creationTimestamp = NULL;
    public $id = NULL;
    public $selfLink = NULL;
    public $name = NULL;
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setDescription($description)
    {
        $this->description = $description;
    }
    public function getDescription()
    {
        return $this->description;
    }
    public function setSourceTags($sourceTags)
    {
        $this->sourceTags = $sourceTags;
    }
    public function getSourceTags()
    {
        return $this->sourceTags;
    }
    public function setSourceRanges($sourceRanges)
    {
        $this->sourceRanges = $sourceRanges;
    }
    public function getSourceRanges()
    {
        return $this->sourceRanges;
    }
    public function setNetwork($network)
    {
        $this->network = $network;
    }
    public function getNetwork()
    {
        return $this->network;
    }
    public function setTargetTags($targetTags)
    {
        $this->targetTags = $targetTags;
    }
    public function getTargetTags()
    {
        return $this->targetTags;
    }
    public function setAllowed($allowed)
    {
        $this->assertIsArray($allowed, "Google_FirewallAllowed", "Google_Firewall::setAllowed");
        $this->allowed = $allowed;
    }
    public function getAllowed()
    {
        return $this->allowed;
    }
    public function setCreationTimestamp($creationTimestamp)
    {
        $this->creationTimestamp = $creationTimestamp;
    }
    public function getCreationTimestamp()
    {
        return $this->creationTimestamp;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
    public function setName($name)
    {
        $this->name = $name;
    }
    public function getName()
    {
        return $this->name;
    }
}
class Google_FirewallAllowed extends Google_Model
{
    public $IPProtocol = NULL;
    public $ports = NULL;
    public function setIPProtocol($IPProtocol)
    {
        $this->IPProtocol = $IPProtocol;
    }
    public function getIPProtocol()
    {
        return $this->IPProtocol;
    }
    public function setPorts($ports)
    {
        $this->ports = $ports;
    }
    public function getPorts()
    {
        return $this->ports;
    }
}
class Google_FirewallList extends Google_Model
{
    public $nextPageToken = NULL;
    protected $__itemsType = "Google_Firewall";
    protected $__itemsDataType = "array";
    public $items = NULL;
    public $kind = NULL;
    public $id = NULL;
    public $selfLink = NULL;
    public function setNextPageToken($nextPageToken)
    {
        $this->nextPageToken = $nextPageToken;
    }
    public function getNextPageToken()
    {
        return $this->nextPageToken;
    }
    public function setItems($items)
    {
        $this->assertIsArray($items, "Google_Firewall", "Google_FirewallList::setItems");
        $this->items = $items;
    }
    public function getItems()
    {
        return $this->items;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
}
class Google_Image extends Google_Model
{
    public $kind = NULL;
    public $description = NULL;
    protected $__rawDiskType = "Google_ImageRawDisk";
    protected $__rawDiskDataType = "";
    public $rawDisk = NULL;
    public $preferredKernel = NULL;
    protected $__diskSnapshotType = "Google_ImageDiskSnapshot";
    protected $__diskSnapshotDataType = "";
    public $diskSnapshot = NULL;
    public $sourceType = NULL;
    public $creationTimestamp = NULL;
    public $id = NULL;
    public $selfLink = NULL;
    public $name = NULL;
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setDescription($description)
    {
        $this->description = $description;
    }
    public function getDescription()
    {
        return $this->description;
    }
    public function setRawDisk(Google_ImageRawDisk $rawDisk)
    {
        $this->rawDisk = $rawDisk;
    }
    public function getRawDisk()
    {
        return $this->rawDisk;
    }
    public function setPreferredKernel($preferredKernel)
    {
        $this->preferredKernel = $preferredKernel;
    }
    public function getPreferredKernel()
    {
        return $this->preferredKernel;
    }
    public function setDiskSnapshot(Google_ImageDiskSnapshot $diskSnapshot)
    {
        $this->diskSnapshot = $diskSnapshot;
    }
    public function getDiskSnapshot()
    {
        return $this->diskSnapshot;
    }
    public function setSourceType($sourceType)
    {
        $this->sourceType = $sourceType;
    }
    public function getSourceType()
    {
        return $this->sourceType;
    }
    public function setCreationTimestamp($creationTimestamp)
    {
        $this->creationTimestamp = $creationTimestamp;
    }
    public function getCreationTimestamp()
    {
        return $this->creationTimestamp;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
    public function setName($name)
    {
        $this->name = $name;
    }
    public function getName()
    {
        return $this->name;
    }
}
class Google_ImageDiskSnapshot extends Google_Model
{
    public $source = NULL;
    public function setSource($source)
    {
        $this->source = $source;
    }
    public function getSource()
    {
        return $this->source;
    }
}
class Google_ImageList extends Google_Model
{
    public $nextPageToken = NULL;
    protected $__itemsType = "Google_Image";
    protected $__itemsDataType = "array";
    public $items = NULL;
    public $kind = NULL;
    public $id = NULL;
    public $selfLink = NULL;
    public function setNextPageToken($nextPageToken)
    {
        $this->nextPageToken = $nextPageToken;
    }
    public function getNextPageToken()
    {
        return $this->nextPageToken;
    }
    public function setItems($items)
    {
        $this->assertIsArray($items, "Google_Image", "Google_ImageList::setItems");
        $this->items = $items;
    }
    public function getItems()
    {
        return $this->items;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
}
class Google_ImageRawDisk extends Google_Model
{
    public $containerType = NULL;
    public $source = NULL;
    public $sha1Checksum = NULL;
    public function setContainerType($containerType)
    {
        $this->containerType = $containerType;
    }
    public function getContainerType()
    {
        return $this->containerType;
    }
    public function setSource($source)
    {
        $this->source = $source;
    }
    public function getSource()
    {
        return $this->source;
    }
    public function setSha1Checksum($sha1Checksum)
    {
        $this->sha1Checksum = $sha1Checksum;
    }
    public function getSha1Checksum()
    {
        return $this->sha1Checksum;
    }
}
class Google_Instance extends Google_Model
{
    public $status = NULL;
    public $kind = NULL;
    public $machineType = NULL;
    public $description = NULL;
    public $zone = NULL;
    public $tags = NULL;
    public $image = NULL;
    protected $__disksType = "Google_AttachedDisk";
    protected $__disksDataType = "array";
    public $disks = NULL;
    public $name = NULL;
    public $statusMessage = NULL;
    protected $__serviceAccountsType = "Google_ServiceAccount";
    protected $__serviceAccountsDataType = "array";
    public $serviceAccounts = NULL;
    protected $__networkInterfacesType = "Google_NetworkInterface";
    protected $__networkInterfacesDataType = "array";
    public $networkInterfaces = NULL;
    public $creationTimestamp = NULL;
    public $id = NULL;
    public $selfLink = NULL;
    protected $__metadataType = "Google_Metadata";
    protected $__metadataDataType = "";
    public $metadata = NULL;
    public function setStatus($status)
    {
        $this->status = $status;
    }
    public function getStatus()
    {
        return $this->status;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setMachineType($machineType)
    {
        $this->machineType = $machineType;
    }
    public function getMachineType()
    {
        return $this->machineType;
    }
    public function setDescription($description)
    {
        $this->description = $description;
    }
    public function getDescription()
    {
        return $this->description;
    }
    public function setZone($zone)
    {
        $this->zone = $zone;
    }
    public function getZone()
    {
        return $this->zone;
    }
    public function setTags($tags)
    {
        $this->tags = $tags;
    }
    public function getTags()
    {
        return $this->tags;
    }
    public function setImage($image)
    {
        $this->image = $image;
    }
    public function getImage()
    {
        return $this->image;
    }
    public function setDisks($disks)
    {
        $this->assertIsArray($disks, "Google_AttachedDisk", "Google_Instance::setDisks");
        $this->disks = $disks;
    }
    public function getDisks()
    {
        return $this->disks;
    }
    public function setName($name)
    {
        $this->name = $name;
    }
    public function getName()
    {
        return $this->name;
    }
    public function setStatusMessage($statusMessage)
    {
        $this->statusMessage = $statusMessage;
    }
    public function getStatusMessage()
    {
        return $this->statusMessage;
    }
    public function setServiceAccounts($serviceAccounts)
    {
        $this->assertIsArray($serviceAccounts, "Google_ServiceAccount", "Google_Instance::setServiceAccounts");
        $this->serviceAccounts = $serviceAccounts;
    }
    public function getServiceAccounts()
    {
        return $this->serviceAccounts;
    }
    public function setNetworkInterfaces($networkInterfaces)
    {
        $this->assertIsArray($networkInterfaces, "Google_NetworkInterface", "Google_Instance::setNetworkInterfaces");
        $this->networkInterfaces = $networkInterfaces;
    }
    public function getNetworkInterfaces()
    {
        return $this->networkInterfaces;
    }
    public function setCreationTimestamp($creationTimestamp)
    {
        $this->creationTimestamp = $creationTimestamp;
    }
    public function getCreationTimestamp()
    {
        return $this->creationTimestamp;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
    public function setMetadata(Google_Metadata $metadata)
    {
        $this->metadata = $metadata;
    }
    public function getMetadata()
    {
        return $this->metadata;
    }
}
class Google_InstanceList extends Google_Model
{
    public $nextPageToken = NULL;
    protected $__itemsType = "Google_Instance";
    protected $__itemsDataType = "array";
    public $items = NULL;
    public $kind = NULL;
    public $id = NULL;
    public $selfLink = NULL;
    public function setNextPageToken($nextPageToken)
    {
        $this->nextPageToken = $nextPageToken;
    }
    public function getNextPageToken()
    {
        return $this->nextPageToken;
    }
    public function setItems($items)
    {
        $this->assertIsArray($items, "Google_Instance", "Google_InstanceList::setItems");
        $this->items = $items;
    }
    public function getItems()
    {
        return $this->items;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
}
class Google_Kernel extends Google_Model
{
    public $kind = NULL;
    public $description = NULL;
    public $creationTimestamp = NULL;
    public $id = NULL;
    public $selfLink = NULL;
    public $name = NULL;
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setDescription($description)
    {
        $this->description = $description;
    }
    public function getDescription()
    {
        return $this->description;
    }
    public function setCreationTimestamp($creationTimestamp)
    {
        $this->creationTimestamp = $creationTimestamp;
    }
    public function getCreationTimestamp()
    {
        return $this->creationTimestamp;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
    public function setName($name)
    {
        $this->name = $name;
    }
    public function getName()
    {
        return $this->name;
    }
}
class Google_KernelList extends Google_Model
{
    public $nextPageToken = NULL;
    protected $__itemsType = "Google_Kernel";
    protected $__itemsDataType = "array";
    public $items = NULL;
    public $kind = NULL;
    public $id = NULL;
    public $selfLink = NULL;
    public function setNextPageToken($nextPageToken)
    {
        $this->nextPageToken = $nextPageToken;
    }
    public function getNextPageToken()
    {
        return $this->nextPageToken;
    }
    public function setItems($items)
    {
        $this->assertIsArray($items, "Google_Kernel", "Google_KernelList::setItems");
        $this->items = $items;
    }
    public function getItems()
    {
        return $this->items;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
}
class Google_MachineType extends Google_Model
{
    public $guestCpus = NULL;
    public $imageSpaceGb = NULL;
    public $kind = NULL;
    protected $__ephemeralDisksType = "Google_MachineTypeEphemeralDisks";
    protected $__ephemeralDisksDataType = "array";
    public $ephemeralDisks = NULL;
    public $maximumPersistentDisksSizeGb = NULL;
    public $description = NULL;
    public $maximumPersistentDisks = NULL;
    public $name = NULL;
    public $memoryMb = NULL;
    public $availableZone = NULL;
    public $creationTimestamp = NULL;
    public $id = NULL;
    public $selfLink = NULL;
    public $hostCpus = NULL;
    public function setGuestCpus($guestCpus)
    {
        $this->guestCpus = $guestCpus;
    }
    public function getGuestCpus()
    {
        return $this->guestCpus;
    }
    public function setImageSpaceGb($imageSpaceGb)
    {
        $this->imageSpaceGb = $imageSpaceGb;
    }
    public function getImageSpaceGb()
    {
        return $this->imageSpaceGb;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setEphemeralDisks($ephemeralDisks)
    {
        $this->assertIsArray($ephemeralDisks, "Google_MachineTypeEphemeralDisks", "Google_MachineType::setEphemeralDisks");
        $this->ephemeralDisks = $ephemeralDisks;
    }
    public function getEphemeralDisks()
    {
        return $this->ephemeralDisks;
    }
    public function setMaximumPersistentDisksSizeGb($maximumPersistentDisksSizeGb)
    {
        $this->maximumPersistentDisksSizeGb = $maximumPersistentDisksSizeGb;
    }
    public function getMaximumPersistentDisksSizeGb()
    {
        return $this->maximumPersistentDisksSizeGb;
    }
    public function setDescription($description)
    {
        $this->description = $description;
    }
    public function getDescription()
    {
        return $this->description;
    }
    public function setMaximumPersistentDisks($maximumPersistentDisks)
    {
        $this->maximumPersistentDisks = $maximumPersistentDisks;
    }
    public function getMaximumPersistentDisks()
    {
        return $this->maximumPersistentDisks;
    }
    public function setName($name)
    {
        $this->name = $name;
    }
    public function getName()
    {
        return $this->name;
    }
    public function setMemoryMb($memoryMb)
    {
        $this->memoryMb = $memoryMb;
    }
    public function getMemoryMb()
    {
        return $this->memoryMb;
    }
    public function setAvailableZone($availableZone)
    {
        $this->availableZone = $availableZone;
    }
    public function getAvailableZone()
    {
        return $this->availableZone;
    }
    public function setCreationTimestamp($creationTimestamp)
    {
        $this->creationTimestamp = $creationTimestamp;
    }
    public function getCreationTimestamp()
    {
        return $this->creationTimestamp;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
    public function setHostCpus($hostCpus)
    {
        $this->hostCpus = $hostCpus;
    }
    public function getHostCpus()
    {
        return $this->hostCpus;
    }
}
class Google_MachineTypeEphemeralDisks extends Google_Model
{
    public $diskGb = NULL;
    public function setDiskGb($diskGb)
    {
        $this->diskGb = $diskGb;
    }
    public function getDiskGb()
    {
        return $this->diskGb;
    }
}
class Google_MachineTypeList extends Google_Model
{
    public $nextPageToken = NULL;
    protected $__itemsType = "Google_MachineType";
    protected $__itemsDataType = "array";
    public $items = NULL;
    public $kind = NULL;
    public $id = NULL;
    public $selfLink = NULL;
    public function setNextPageToken($nextPageToken)
    {
        $this->nextPageToken = $nextPageToken;
    }
    public function getNextPageToken()
    {
        return $this->nextPageToken;
    }
    public function setItems($items)
    {
        $this->assertIsArray($items, "Google_MachineType", "Google_MachineTypeList::setItems");
        $this->items = $items;
    }
    public function getItems()
    {
        return $this->items;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
}
class Google_Metadata extends Google_Model
{
    protected $__itemsType = "Google_MetadataItems";
    protected $__itemsDataType = "array";
    public $items = NULL;
    public $kind = NULL;
    public function setItems($items)
    {
        $this->assertIsArray($items, "Google_MetadataItems", "Google_Metadata::setItems");
        $this->items = $items;
    }
    public function getItems()
    {
        return $this->items;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
}
class Google_MetadataItems extends Google_Model
{
    public $value = NULL;
    public $key = NULL;
    public function setValue($value)
    {
        $this->value = $value;
    }
    public function getValue()
    {
        return $this->value;
    }
    public function setKey($key)
    {
        $this->key = $key;
    }
    public function getKey()
    {
        return $this->key;
    }
}
class Google_Network extends Google_Model
{
    public $kind = NULL;
    public $description = NULL;
    public $IPv4Range = NULL;
    public $gatewayIPv4 = NULL;
    public $creationTimestamp = NULL;
    public $id = NULL;
    public $selfLink = NULL;
    public $name = NULL;
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setDescription($description)
    {
        $this->description = $description;
    }
    public function getDescription()
    {
        return $this->description;
    }
    public function setIPv4Range($IPv4Range)
    {
        $this->IPv4Range = $IPv4Range;
    }
    public function getIPv4Range()
    {
        return $this->IPv4Range;
    }
    public function setGatewayIPv4($gatewayIPv4)
    {
        $this->gatewayIPv4 = $gatewayIPv4;
    }
    public function getGatewayIPv4()
    {
        return $this->gatewayIPv4;
    }
    public function setCreationTimestamp($creationTimestamp)
    {
        $this->creationTimestamp = $creationTimestamp;
    }
    public function getCreationTimestamp()
    {
        return $this->creationTimestamp;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
    public function setName($name)
    {
        $this->name = $name;
    }
    public function getName()
    {
        return $this->name;
    }
}
class Google_NetworkInterface extends Google_Model
{
    public $network = NULL;
    protected $__accessConfigsType = "Google_AccessConfig";
    protected $__accessConfigsDataType = "array";
    public $accessConfigs = NULL;
    public $networkIP = NULL;
    public $kind = NULL;
    public $name = NULL;
    public function setNetwork($network)
    {
        $this->network = $network;
    }
    public function getNetwork()
    {
        return $this->network;
    }
    public function setAccessConfigs($accessConfigs)
    {
        $this->assertIsArray($accessConfigs, "Google_AccessConfig", "Google_NetworkInterface::setAccessConfigs");
        $this->accessConfigs = $accessConfigs;
    }
    public function getAccessConfigs()
    {
        return $this->accessConfigs;
    }
    public function setNetworkIP($networkIP)
    {
        $this->networkIP = $networkIP;
    }
    public function getNetworkIP()
    {
        return $this->networkIP;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setName($name)
    {
        $this->name = $name;
    }
    public function getName()
    {
        return $this->name;
    }
}
class Google_NetworkList extends Google_Model
{
    public $nextPageToken = NULL;
    protected $__itemsType = "Google_Network";
    protected $__itemsDataType = "array";
    public $items = NULL;
    public $kind = NULL;
    public $id = NULL;
    public $selfLink = NULL;
    public function setNextPageToken($nextPageToken)
    {
        $this->nextPageToken = $nextPageToken;
    }
    public function getNextPageToken()
    {
        return $this->nextPageToken;
    }
    public function setItems($items)
    {
        $this->assertIsArray($items, "Google_Network", "Google_NetworkList::setItems");
        $this->items = $items;
    }
    public function getItems()
    {
        return $this->items;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
}
class Google_Operation extends Google_Model
{
    public $status = NULL;
    public $kind = NULL;
    public $name = NULL;
    public $startTime = NULL;
    public $httpErrorStatusCode = NULL;
    public $user = NULL;
    protected $__errorType = "Google_OperationError";
    protected $__errorDataType = "";
    public $error = NULL;
    public $targetId = NULL;
    public $operationType = NULL;
    public $statusMessage = NULL;
    public $insertTime = NULL;
    public $httpErrorMessage = NULL;
    public $progress = NULL;
    public $clientOperationId = NULL;
    public $endTime = NULL;
    public $creationTimestamp = NULL;
    public $id = NULL;
    public $selfLink = NULL;
    public $targetLink = NULL;
    public function setStatus($status)
    {
        $this->status = $status;
    }
    public function getStatus()
    {
        return $this->status;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setName($name)
    {
        $this->name = $name;
    }
    public function getName()
    {
        return $this->name;
    }
    public function setStartTime($startTime)
    {
        $this->startTime = $startTime;
    }
    public function getStartTime()
    {
        return $this->startTime;
    }
    public function setHttpErrorStatusCode($httpErrorStatusCode)
    {
        $this->httpErrorStatusCode = $httpErrorStatusCode;
    }
    public function getHttpErrorStatusCode()
    {
        return $this->httpErrorStatusCode;
    }
    public function setUser($user)
    {
        $this->user = $user;
    }
    public function getUser()
    {
        return $this->user;
    }
    public function setError(Google_OperationError $error)
    {
        $this->error = $error;
    }
    public function getError()
    {
        return $this->error;
    }
    public function setTargetId($targetId)
    {
        $this->targetId = $targetId;
    }
    public function getTargetId()
    {
        return $this->targetId;
    }
    public function setOperationType($operationType)
    {
        $this->operationType = $operationType;
    }
    public function getOperationType()
    {
        return $this->operationType;
    }
    public function setStatusMessage($statusMessage)
    {
        $this->statusMessage = $statusMessage;
    }
    public function getStatusMessage()
    {
        return $this->statusMessage;
    }
    public function setInsertTime($insertTime)
    {
        $this->insertTime = $insertTime;
    }
    public function getInsertTime()
    {
        return $this->insertTime;
    }
    public function setHttpErrorMessage($httpErrorMessage)
    {
        $this->httpErrorMessage = $httpErrorMessage;
    }
    public function getHttpErrorMessage()
    {
        return $this->httpErrorMessage;
    }
    public function setProgress($progress)
    {
        $this->progress = $progress;
    }
    public function getProgress()
    {
        return $this->progress;
    }
    public function setClientOperationId($clientOperationId)
    {
        $this->clientOperationId = $clientOperationId;
    }
    public function getClientOperationId()
    {
        return $this->clientOperationId;
    }
    public function setEndTime($endTime)
    {
        $this->endTime = $endTime;
    }
    public function getEndTime()
    {
        return $this->endTime;
    }
    public function setCreationTimestamp($creationTimestamp)
    {
        $this->creationTimestamp = $creationTimestamp;
    }
    public function getCreationTimestamp()
    {
        return $this->creationTimestamp;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
    public function setTargetLink($targetLink)
    {
        $this->targetLink = $targetLink;
    }
    public function getTargetLink()
    {
        return $this->targetLink;
    }
}
class Google_OperationError extends Google_Model
{
    protected $__errorsType = "Google_OperationErrorErrors";
    protected $__errorsDataType = "array";
    public $errors = NULL;
    public function setErrors($errors)
    {
        $this->assertIsArray($errors, "Google_OperationErrorErrors", "Google_OperationError::setErrors");
        $this->errors = $errors;
    }
    public function getErrors()
    {
        return $this->errors;
    }
}
class Google_OperationErrorErrors extends Google_Model
{
    public $message = NULL;
    public $code = NULL;
    public $location = NULL;
    public function setMessage($message)
    {
        $this->message = $message;
    }
    public function getMessage()
    {
        return $this->message;
    }
    public function setCode($code)
    {
        $this->code = $code;
    }
    public function getCode()
    {
        return $this->code;
    }
    public function setLocation($location)
    {
        $this->location = $location;
    }
    public function getLocation()
    {
        return $this->location;
    }
}
class Google_OperationList extends Google_Model
{
    public $nextPageToken = NULL;
    protected $__itemsType = "Google_Operation";
    protected $__itemsDataType = "array";
    public $items = NULL;
    public $kind = NULL;
    public $id = NULL;
    public $selfLink = NULL;
    public function setNextPageToken($nextPageToken)
    {
        $this->nextPageToken = $nextPageToken;
    }
    public function getNextPageToken()
    {
        return $this->nextPageToken;
    }
    public function setItems($items)
    {
        $this->assertIsArray($items, "Google_Operation", "Google_OperationList::setItems");
        $this->items = $items;
    }
    public function getItems()
    {
        return $this->items;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
}
class Google_Project extends Google_Model
{
    public $kind = NULL;
    public $description = NULL;
    protected $__commonInstanceMetadataType = "Google_Metadata";
    protected $__commonInstanceMetadataDataType = "";
    public $commonInstanceMetadata = NULL;
    public $externalIpAddresses = NULL;
    protected $__quotasType = "Google_ProjectQuotas";
    protected $__quotasDataType = "array";
    public $quotas = NULL;
    public $creationTimestamp = NULL;
    public $id = NULL;
    public $selfLink = NULL;
    public $name = NULL;
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setDescription($description)
    {
        $this->description = $description;
    }
    public function getDescription()
    {
        return $this->description;
    }
    public function setCommonInstanceMetadata(Google_Metadata $commonInstanceMetadata)
    {
        $this->commonInstanceMetadata = $commonInstanceMetadata;
    }
    public function getCommonInstanceMetadata()
    {
        return $this->commonInstanceMetadata;
    }
    public function setExternalIpAddresses($externalIpAddresses)
    {
        $this->externalIpAddresses = $externalIpAddresses;
    }
    public function getExternalIpAddresses()
    {
        return $this->externalIpAddresses;
    }
    public function setQuotas($quotas)
    {
        $this->assertIsArray($quotas, "Google_ProjectQuotas", "Google_Project::setQuotas");
        $this->quotas = $quotas;
    }
    public function getQuotas()
    {
        return $this->quotas;
    }
    public function setCreationTimestamp($creationTimestamp)
    {
        $this->creationTimestamp = $creationTimestamp;
    }
    public function getCreationTimestamp()
    {
        return $this->creationTimestamp;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
    public function setName($name)
    {
        $this->name = $name;
    }
    public function getName()
    {
        return $this->name;
    }
}
class Google_ProjectQuotas extends Google_Model
{
    public $usage = NULL;
    public $metric = NULL;
    public $limit = NULL;
    public function setUsage($usage)
    {
        $this->usage = $usage;
    }
    public function getUsage()
    {
        return $this->usage;
    }
    public function setMetric($metric)
    {
        $this->metric = $metric;
    }
    public function getMetric()
    {
        return $this->metric;
    }
    public function setLimit($limit)
    {
        $this->limit = $limit;
    }
    public function getLimit()
    {
        return $this->limit;
    }
}
class Google_ServiceAccount extends Google_Model
{
    public $scopes = NULL;
    public $kind = NULL;
    public $email = NULL;
    public function setScopes($scopes)
    {
        $this->scopes = $scopes;
    }
    public function getScopes()
    {
        return $this->scopes;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setEmail($email)
    {
        $this->email = $email;
    }
    public function getEmail()
    {
        return $this->email;
    }
}
class Google_Snapshot extends Google_Model
{
    public $status = NULL;
    public $kind = NULL;
    public $description = NULL;
    public $sourceDisk = NULL;
    public $sourceDiskId = NULL;
    public $diskSizeGb = NULL;
    public $creationTimestamp = NULL;
    public $id = NULL;
    public $selfLink = NULL;
    public $name = NULL;
    public function setStatus($status)
    {
        $this->status = $status;
    }
    public function getStatus()
    {
        return $this->status;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setDescription($description)
    {
        $this->description = $description;
    }
    public function getDescription()
    {
        return $this->description;
    }
    public function setSourceDisk($sourceDisk)
    {
        $this->sourceDisk = $sourceDisk;
    }
    public function getSourceDisk()
    {
        return $this->sourceDisk;
    }
    public function setSourceDiskId($sourceDiskId)
    {
        $this->sourceDiskId = $sourceDiskId;
    }
    public function getSourceDiskId()
    {
        return $this->sourceDiskId;
    }
    public function setDiskSizeGb($diskSizeGb)
    {
        $this->diskSizeGb = $diskSizeGb;
    }
    public function getDiskSizeGb()
    {
        return $this->diskSizeGb;
    }
    public function setCreationTimestamp($creationTimestamp)
    {
        $this->creationTimestamp = $creationTimestamp;
    }
    public function getCreationTimestamp()
    {
        return $this->creationTimestamp;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
    public function setName($name)
    {
        $this->name = $name;
    }
    public function getName()
    {
        return $this->name;
    }
}
class Google_SnapshotList extends Google_Model
{
    public $nextPageToken = NULL;
    protected $__itemsType = "Google_Snapshot";
    protected $__itemsDataType = "array";
    public $items = NULL;
    public $kind = NULL;
    public $id = NULL;
    public $selfLink = NULL;
    public function setNextPageToken($nextPageToken)
    {
        $this->nextPageToken = $nextPageToken;
    }
    public function getNextPageToken()
    {
        return $this->nextPageToken;
    }
    public function setItems($items)
    {
        $this->assertIsArray($items, "Google_Snapshot", "Google_SnapshotList::setItems");
        $this->items = $items;
    }
    public function getItems()
    {
        return $this->items;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
}
class Google_Zone extends Google_Model
{
    public $status = NULL;
    public $kind = NULL;
    public $availableMachineType = NULL;
    public $description = NULL;
    protected $__maintenanceWindowsType = "Google_ZoneMaintenanceWindows";
    protected $__maintenanceWindowsDataType = "array";
    public $maintenanceWindows = NULL;
    public $creationTimestamp = NULL;
    public $id = NULL;
    public $selfLink = NULL;
    public $name = NULL;
    public function setStatus($status)
    {
        $this->status = $status;
    }
    public function getStatus()
    {
        return $this->status;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setAvailableMachineType($availableMachineType)
    {
        $this->availableMachineType = $availableMachineType;
    }
    public function getAvailableMachineType()
    {
        return $this->availableMachineType;
    }
    public function setDescription($description)
    {
        $this->description = $description;
    }
    public function getDescription()
    {
        return $this->description;
    }
    public function setMaintenanceWindows($maintenanceWindows)
    {
        $this->assertIsArray($maintenanceWindows, "Google_ZoneMaintenanceWindows", "Google_Zone::setMaintenanceWindows");
        $this->maintenanceWindows = $maintenanceWindows;
    }
    public function getMaintenanceWindows()
    {
        return $this->maintenanceWindows;
    }
    public function setCreationTimestamp($creationTimestamp)
    {
        $this->creationTimestamp = $creationTimestamp;
    }
    public function getCreationTimestamp()
    {
        return $this->creationTimestamp;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
    public function setName($name)
    {
        $this->name = $name;
    }
    public function getName()
    {
        return $this->name;
    }
}
class Google_ZoneList extends Google_Model
{
    public $nextPageToken = NULL;
    protected $__itemsType = "Google_Zone";
    protected $__itemsDataType = "array";
    public $items = NULL;
    public $kind = NULL;
    public $id = NULL;
    public $selfLink = NULL;
    public function setNextPageToken($nextPageToken)
    {
        $this->nextPageToken = $nextPageToken;
    }
    public function getNextPageToken()
    {
        return $this->nextPageToken;
    }
    public function setItems($items)
    {
        $this->assertIsArray($items, "Google_Zone", "Google_ZoneList::setItems");
        $this->items = $items;
    }
    public function getItems()
    {
        return $this->items;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    public function getSelfLink()
    {
        return $this->selfLink;
    }
}
class Google_ZoneMaintenanceWindows extends Google_Model
{
    public $endTime = NULL;
    public $beginTime = NULL;
    public $name = NULL;
    public $description = NULL;
    public function setEndTime($endTime)
    {
        $this->endTime = $endTime;
    }
    public function getEndTime()
    {
        return $this->endTime;
    }
    public function setBeginTime($beginTime)
    {
        $this->beginTime = $beginTime;
    }
    public function getBeginTime()
    {
        return $this->beginTime;
    }
    public function setName($name)
    {
        $this->name = $name;
    }
    public function getName()
    {
        return $this->name;
    }
    public function setDescription($description)
    {
        $this->description = $description;
    }
    public function getDescription()
    {
        return $this->description;
    }
}

?>