<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.2 & 7.3
 * @ Decoder version: 1.0.6
 * @ Release: 10/08/2022
 */

function getTableidbyTabID($tabid)
{
    $tableid = false;
    if (strpos($tabid, "T") !== false) {
        $tableid = str_replace("T", "", $tabid);
    }
    return $tableid;
}
function is_json($string)
{
    return !empty($string) && is_string($string) && preg_match("/^(\"(\\.|[^\"\\\\n\\r])*?\"|[,:{}\\[\\]0-9.\\-+Eaeflnr-u \\n\\r\\t])+?\$/", $string);
}
function sendtoChannel($channel, $message)
{
    global $config;
    $slacktoken = $config["slacktoken"];
    $telegramurl = "https://api.telegram.org/bot" . $slacktoken . "/sendMessage?chat_id=@" . $channel . "&text=" . $message;
    telegramCurl($telegramurl);
}
function getClientCredit($uid, $serviceid, $credit)
{
    global $conn;
    global $config;
    $user = $conn->query("select default_currency,reseller_id,usertype\r\n    ,credit_left,sell_credit_limit from tblUsers where id='" . $uid . "'");
    $user = $user->fetch(PDO::FETCH_ASSOC);
    $resellercredit = 0;
    if ($user["reseller_id"]) {
        $service = getServices("imei", "", "", "", "", 1, $serviceid);
        $resellercredit = $service["credit"];
    }
    $baseq = $conn->query("select id from tbl_currencies where \r\n    code='" . $config["base_currency"] . "'");
    $baseq = $baseq->fetch(PDO::FETCH_ASSOC);
    $defaultcurrency = $baseq["id"];
    if ($user["default_currency"] != $defaultcurrency) {
        $credit = convertRate($user["default_currency"], $defaultcurrency, $credit);
        $resellercredit = convertRate($user["default_currency"], $defaultcurrency, $resellercredit);
    }
    if ($user["usertype"] == 0) {
        if ($credit <= $user["credit_left"]) {
            $RETURN["status"] = "success";
        } else {
            $RETURN["status"] = "error";
        }
    } else {
        if ($user["usertype"] == 1) {
            if ($credit <= $user["credit_left"] && $credit <= $user["sell_credit_limit"]) {
                $RETURN["status"] = "success";
            } else {
                $RETURN["status"] = "error";
            }
        } else {
            if ($user["usertype"] == 3) {
                if ($credit <= $user["credit_left"]) {
                    $RETURN["status"] = "success";
                } else {
                    $RETURN["status"] = "error";
                }
                $resel = $conn->query("select default_currency,reseller_id,usertype\r\n        ,credit_left,sell_credit_limit from tblUsers where id='" . $user["reseller_id"] . "'");
                $resel = $resel->fetch(PDO::FETCH_ASSOC);
                if ($resellercredit <= $resel["credit_left"] && $resellercredit <= $resel["sell_credit_limit"]) {
                    $RETURN["status"] = "success";
                } else {
                    $RETURN["status"] = "error";
                }
            }
        }
    }
    $RETURN["credit"] = $credit;
    $RETURN["resellcredit"] = $resellercredit;
    return $RETURN;
}
function creditDeduct($uid, $credit, $resellcredit)
{
    global $conn;
    if (0 < $credit) {
        $user = $conn->query("select usertype,reseller_id from tblUsers where id='" . $uid . "'");
        $user = $user->fetch(PDO::FETCH_ASSOC);
        if ($user["usertype"] == 0) {
            $conn->query("UPDATE tblUsers set credit_left=credit_left-" . $credit . "\r\n            ,credit_used=credit_used+" . $credit . "\r\n            ,credit_inprocess=credit_inprocess+" . $credit . "\r\n            WHERE id='" . $uid . "'");
            $RESULT["status"] = "success";
            userStatement($uid, "New Order Placed", "DR", $credit, "", "imei", "", "");
        } else {
            if ($user["usertype"] == 1) {
                $conn->query("UPDATE tblUsers set credit_left=credit_left-" . $credit . "\r\n            ,credit_used=credit_used+" . $credit . "\r\n            ,credit_inprocess=credit_inprocess+" . $credit . "\r\n            ,sell_credit_limit=sell_credit_limit-" . $credit . "\r\n            WHERE id='" . $uid . "'");
                $RESULT["status"] = "success";
                userStatement($uid, "New Order Placed", "DR", $credit, "", "imei", 1, "");
            } else {
                if ($user["usertype"] == 3) {
                    $conn->query("UPDATE tblUsers set credit_left=credit_left-" . $credit . "\r\n            ,credit_used=credit_used+" . $credit . "\r\n            ,credit_inprocess=credit_inprocess+" . $credit . "\r\n            WHERE id='" . $uid . "'");
                    userStatement($uid, "New Order Placed", "DR", $credit, "", "imei", "", "");
                    $conn->query("UPDATE tblUsers set credit_left=credit_left-" . $resellcredit . "\r\n            ,credit_used=credit_used+" . $resellcredit . "\r\n            ,credit_inprocess=credit_inprocess+" . $resellcredit . "\r\n            ,sell_credit_limit=sell_credit_limit-" . $resellcredit . "\r\n            WHERE id='" . $user["reseller_id"] . "'");
                    userStatement($user["reseller_id"], "New Order Placed", "DR", $credit, "", "imei", 1, "");
                    $RESULT["status"] = "success";
                }
            }
        }
        return $RESULT;
    }
}
function getAdminRole($adminid, $related, $rid = 0, $detail = false)
{
    global $conn;
    if ($rid) {
        $iQuery = $conn->query("select * from tbl_admin_role where\r\n         adminid='" . $adminid . "' and relatedtable='" . $related . "'\r\n         and relid='" . $rid . "'");
        return $iQuery->fetchColumn();
    }
    if ($detail) {
        $arow = $conn->query("select * from tbl_admin_role where\r\n             adminid='" . $adminid . "' and relatedtable='" . $related . "' ");
        $row = $arow->fetch(PDO::FETCH_ASSOC);
        return $row;
    }
    $q = $conn->query("select * from tbl_admin_role where\r\n             adminid='" . $adminid . "' and relatedtable='" . $related . "' ");
    while ($r = $q->fetch(PDO::FETCH_ASSOC)) {
        $OUT[] = $r["relid"];
    }
    return $OUT;
}
function saveDiscount($orderid, $discounttype, $discountdata, $invoiceid = "")
{
    global $conn;
    global $NonChargeable;
    $FIELD["orderid"] = $orderid;
    $FIELD["invoiceid"] = $invoiceid;
    $FIELD["discounttype"] = $discounttype;
    $FIELD["discountamount"] = $discountdata["amount"];
    $FIELD["discountpercentage"] = $discountdata["percentage"];
    if ($NonChargeable) {
        $FIELD["ordertype"] = "NC";
    }
    insertData("tblDiscount", $FIELD);
}
function savePayment($Payment, $invoiceid, $clientid, $AdvanceAmount = 0, $adminid = "")
{
    global $conn;
    $PaidAmount = 0;
    foreach ($Payment as $paxid => $Part) {
        foreach ($Part as $key => $PaymentDetail) {
            if (0 < $PaymentDetail["pay"] && !is_numeric($PaymentDetail)) {
                $gatewayid = $PaymentDetail["gid"];
                $Gateway = $conn->query("select * from tbl_payments\r\nwhere id='" . $gatewayid . "'");
                $Gatewayrow = $Gateway->fetch(PDO::FETCH_ASSOC);
                if ($Gatewayrow["account"] != 99999) {
                    $Amount = $PaymentDetail["pay"];
                    $receipttype = "";
                    $PaidAmount += $Amount;
                    if ($Gatewayrow["receipt"] == 0) {
                        $RECEIPTITEM[0]["account"] = $Gatewayrow["account"];
                        $RECEIPTITEM[0]["clientid"] = $clientid;
                        $RECEIPTITEM[0]["billid"] = $invoiceid;
                        $RECEIPTITEM[0]["income"] = $Amount;
                        $RECEIPTITEM[0]["date"] = date("Y-m-d");
                        $RECEIPTITEM[0]["fy"] = $_SESSION["financialyear"];
                        unset($RECEITPS);
                        $RECEITPS["items"] = json_encode($RECEIPTITEM);
                        $RECEITPS["type"] = "cash";
                        $RECEITPS["date"] = date("Y-m-d");
                        $RECEITPS["time"] = time();
                        $RECEITPS["createdby"] = $adminid;
                        $RECEITPS["fy"] = $_SESSION["financialyear"];
                        $REPLY = createReceipt($RECEITPS);
                        $receipttype = "receipt";
                    } else {
                        if ($Gatewayrow["receipt"] == 1) {
                            $RECEIPTITEM[0]["account"] = $Gatewayrow["account"];
                            $RECEIPTITEM[0]["clientid"] = $clientid;
                            $RECEIPTITEM[0]["billid"] = $invoiceid;
                            $RECEIPTITEM[0]["income"] = $Amount;
                            $RECEIPTITEM[0]["cheque"] = $PaymentDetail["field"][0]["receiptid"];
                            $RECEIPTITEM[0]["date"] = date("Y-m-d");
                            $RECEIPTITEM[0]["fy"] = $_SESSION["financialyear"];
                            unset($RECEITPS);
                            $RECEITPS["items"] = json_encode($RECEIPTITEM);
                            $RECEITPS["type"] = "bank";
                            $RECEITPS["date"] = date("Y-m-d");
                            $RECEITPS["time"] = time();
                            $RECEITPS["createdby"] = $adminid;
                            $RECEITPS["fy"] = $_SESSION["financialyear"];
                            $REPLY = createReceipt($RECEITPS);
                            $receipttype = "receipt";
                        } else {
                            if ($Gatewayrow["receipt"] == 3) {
                                $RECEIPTITEM[0]["type"] = "CR";
                                $RECEIPTITEM[0]["sid"] = $clientid;
                                $RECEIPTITEM[0]["amount"] = $Amount;
                                $RECEIPTITEM[0]["date"] = date("Y-m-d");
                                $RECEIPTITEM[0]["fy"] = $_SESSION["financialyear"];
                                $RECEIPTITEM[1]["type"] = "DR";
                                $RECEIPTITEM[1]["aid"] = $Gatewayrow["account"];
                                $RECEIPTITEM[1]["amount"] = $Amount;
                                $RECEIPTITEM[1]["date"] = date("Y-m-d");
                                $RECEIPTITEM[1]["fy"] = $_SESSION["financialyear"];
                                unset($RECEITPS);
                                $RECEITPS["items"] = json_encode($RECEIPTITEM);
                                $RECEITPS["createdby"] = $_SESSION["sc_adminid"];
                                $RECEITPS["date"] = date("Y-m-d");
                                $RECEITPS["time"] = time();
                                $RECEITPS["fy"] = $_SESSION["financialyear"];
                                $REPLY = createJournal($RECEITPS);
                                $receipttype = "jv";
                            } else {
                                if (0 < $PaymentDetail["complementryby"]) {
                                    $receipttype = "complementary";
                                    $conn->query("update tbl_invoices set complementary='" . $PaymentDetail["complementryby"] . "'\r\nwhere id='" . $invoiceid . "'");
                                }
                            }
                        }
                    }
                    $REFDATA["receipttype"] = "sales";
                    $REFDATA["receiptid"] = $invoiceid;
                    $REFDATA["vouchertype"] = $receipttype;
                    $REFDATA["voucherid"] = $REPLY["item"][0];
                    $REFDATA["gatewayid"] = $gatewayid;
                    $REFDATA["vouchermasterid"] = $REPLY["id"];
                    $REFDATA["pax"] = $paxid + 1;
                    insertData("tbl_receipt_reference", $REFDATA);
                }
            }
        }
    }
    foreach ($Payment as $key => $PaymentDetail) {
        if (0 < $PaymentDetail["pay"]) {
            $gatewayid = $PaymentDetail["gid"];
            $Gateway = $conn->query("select * from tbl_payments where id='" . $gatewayid . "'");
            $Gatewayrow = $Gateway->fetch(PDO::FETCH_ASSOC);
            if ($Gatewayrow["account"] != 99999) {
                $Amount = $PaymentDetail["pay"];
                $receipttype = "";
                $PaidAmount += $Amount;
                if ($Gatewayrow["receipt"] == 0) {
                    $RECEIPTITEM[0]["account"] = $Gatewayrow["account"];
                    $RECEIPTITEM[0]["clientid"] = $clientid;
                    $RECEIPTITEM[0]["billid"] = $invoiceid;
                    $RECEIPTITEM[0]["income"] = $Amount;
                    $RECEIPTITEM[0]["date"] = date("Y-m-d");
                    $RECEIPTITEM[0]["fy"] = $_SESSION["financialyear"];
                    unset($RECEITPS);
                    $RECEITPS["items"] = json_encode($RECEIPTITEM);
                    $RECEITPS["type"] = "cash";
                    $RECEITPS["date"] = date("Y-m-d");
                    $RECEITPS["time"] = time();
                    $RECEITPS["createdby"] = $adminid;
                    $RECEITPS["fy"] = $_SESSION["financialyear"];
                    $REPLY = createReceipt($RECEITPS);
                    $receipttype = "receipt";
                } else {
                    if ($Gatewayrow["receipt"] == 1) {
                        $RECEIPTITEM[0]["account"] = $Gatewayrow["account"];
                        $RECEIPTITEM[0]["clientid"] = $clientid;
                        $RECEIPTITEM[0]["billid"] = $invoiceid;
                        $RECEIPTITEM[0]["income"] = $Amount;
                        $RECEIPTITEM[0]["cheque"] = $PaymentDetail["field"][0]["receiptid"];
                        $RECEIPTITEM[0]["date"] = date("Y-m-d");
                        $RECEIPTITEM[0]["fy"] = $_SESSION["financialyear"];
                        unset($RECEITPS);
                        $RECEITPS["items"] = json_encode($RECEIPTITEM);
                        $RECEITPS["type"] = "bank";
                        $RECEITPS["date"] = date("Y-m-d");
                        $RECEITPS["time"] = time();
                        $RECEITPS["createdby"] = $adminid;
                        $RECEITPS["fy"] = $_SESSION["financialyear"];
                        $REPLY = createReceipt($RECEITPS);
                        $receipttype = "receipt";
                    } else {
                        if ($Gatewayrow["receipt"] == 3) {
                            $RECEIPTITEM[0]["type"] = "CR";
                            $RECEIPTITEM[0]["sid"] = $clientid;
                            $RECEIPTITEM[0]["amount"] = $Amount;
                            $RECEIPTITEM[0]["date"] = date("Y-m-d");
                            $RECEIPTITEM[0]["fy"] = $_SESSION["financialyear"];
                            $RECEIPTITEM[1]["type"] = "DR";
                            $RECEIPTITEM[1]["aid"] = $Gatewayrow["account"];
                            $RECEIPTITEM[1]["amount"] = $Amount;
                            $RECEIPTITEM[1]["date"] = date("Y-m-d");
                            $RECEIPTITEM[1]["fy"] = $_SESSION["financialyear"];
                            unset($RECEITPS);
                            $RECEITPS["items"] = json_encode($RECEIPTITEM);
                            $RECEITPS["createdby"] = $_SESSION["sc_adminid"];
                            $RECEITPS["date"] = date("Y-m-d");
                            $RECEITPS["time"] = time();
                            $RECEITPS["fy"] = $_SESSION["financialyear"];
                            $REPLY = createJournal($RECEITPS);
                            $receipttype = "jv";
                        } else {
                            if (0 < $PaymentDetail["complementryby"]) {
                                $receipttype = "complementary";
                                $conn->query("update tbl_invoices set complementary='" . $PaymentDetail["complementryby"] . "'\r\n                        where id='" . $invoiceid . "'");
                            }
                        }
                    }
                }
                $REFDATA["receipttype"] = "sales";
                $REFDATA["receiptid"] = $invoiceid;
                $REFDATA["vouchertype"] = $receipttype;
                $REFDATA["voucherid"] = $REPLY["item"][0];
                $REFDATA["gatewayid"] = $gatewayid;
                $REFDATA["vouchermasterid"] = $REPLY["id"];
                $REFDATA["pax"] = $paxid + 1;
                insertData("tbl_receipt_reference", $REFDATA);
            }
        }
    }
    return $PaidAmount;
}
function getPaymentGateway($clientid = "", $clientgroup = "")
{
    global $conn;
    $where = "";
    $qc = $conn->query("select * from tbl_user_gateway where userid='" . $clientid . "'");
    if (0 < $qc->fetchColumn()) {
        $where = " and gateway in (select payment from tbl_user_gateway where userid='" . $clientid . "')";
    }
    if ($where == "" && $clientgroup) {
        $cg = $conn->query("select paymentgateway from tbl_client_group\r\nwhere id='" . $clientgroup . "'");
        $cgr = $cg->fetch(PDO::FETCH_ASSOC);
        if ($cgr[paymentgateway]) {
            $where = " and gateway in (" . $cgr["paymentgateway"] . ") ";
        }
    }
    $q = $conn->query("select `value` from tbl_paymentgateways \r\n    WHERE setting='name' " . $where);
    while ($r = $q->fetch(PDO::FETCH_ASSOC)) {
        $Gateway[$r["value"]] = $r["value"];
    }
    return $Gateway;
}
function updateSoldQnt($stockid, $qnt, $unit = "")
{
    global $conn;
    $stock = $conn->query("SELECT * FROM `tbl_stock`  WHERE `sid`='" . $stockid . "'");
    $stock = $stock->fetch(PDO::FETCH_ASSOC);
    $newsoldqnt = $qnt;
    if (0 < $stock["rate"]) {
        if ($unit != $stock["newunit"]) {
            $newsoldqnt = $qnt * $stock["rate"];
        } else {
            $qnt = round($qnt / $stock["rate"], 4);
        }
    }
    $conn->query("update tbl_stock set sold=sold+" . $qnt . " ,newsold=newsold+" . $newsoldqnt . "\r\n     where sid='" . $stockid . "'");
    return true;
}
function getClientsStats($userid = "")
{
    global $conn;
    if (!$userid) {
        $userid = $_SESSION["uid"];
    }
    $stats = [];
    $result = $conn->query("select COUNT(*) as cnt,SUM(credit-discount) as tot \r\nfrom tbl_order_imei\r\nwhere user_id='" . $userid . "' and  user_can_c='3' and server=0");
    $data = $result->fetch(PDO::FETCH_ASSOC);
    $stats["imeiservice"]["totalused"] = $data["cnt"];
    $stats["imeiservice"]["totalcreditused"] = $data["tot"];
    $qd = $conn->query("select count(*)as \r\n    totalorder from tbl_order_imei where user_id=" . $userid . " and user_can_c<5\r\n    and server=0");
    $imeitotal = $qd->fetch(PDO::FETCH_ASSOC);
    $stats["imeiservice"]["totalorder"] = $imeitotal["totalorder"];
    $result = $conn->query("select count(*)as total,sum(credit-discount)as credit\r\n    ,user_can_c from tbl_order_imei where user_id=" . $userid . " and server=0 group by user_can_c");
    $servicearr = ["imeiservice", "fileservice", "serverservice", "shopservice"];
    $field = ["total", "credit"];
    foreach ($servicearr as $servicetype) {
        foreach ($field as $fieldnm) {
            $stats[$servicetype][$fieldnm][0] = 0;
            $stats[$servicetype][$fieldnm][1] = 0;
            $stats[$servicetype][$fieldnm][4] = 0;
            $stats[$servicetype][$fieldnm][3] = 0;
        }
    }
    while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
        $stats["imeiservice"]["total"][$row["user_can_c"]] = $row["total"];
        $stats["imeiservice"]["credit"][$row["user_can_c"]] = $row["credit"];
    }
    $bc = $conn->query("select count(*)as totalorder \r\n    from tbl_order_file where user_id=" . $userid . " and user_can_c<5");
    $filetotal = $bc->fetch(PDO::FETCH_ASSOC);
    $stats["fileservice"]["totalorder"] = $filetotal["totalorder"];
    $result = $conn->query("select count(*)as total,sum(credit-discount)as credit,user_can_c from tbl_order_file where user_id=" . $userid . " group by user_can_c");
    while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
        $stats["fileservice"]["total"][$row["user_can_c"]] = $row["total"];
        $stats["fileservice"]["credit"][$row["user_can_c"]] = $row["credit"];
    }
    $stot = $conn->query("select count(*)as totalorder \r\n    from tbl_order_imei where user_id=" . $userid . "  and server=1 and user_can_c<5");
    $servertotal = $stot->fetch(PDO::FETCH_ASSOC);
    $stats["serverservice"]["totalorder"] = $servertotal["totalorder"];
    $result = $conn->query("select count(*)as total,sum(credit-discount)as credit,user_can_c \r\n    from tbl_order_imei where user_id=" . $userid . " and server=1 group by user_can_c");
    while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
        $stats["serverservice"]["total"][$row["user_can_c"]] = $row["total"];
        $stats["serverservice"]["credit"][$row["user_can_c"]] = $row["credit"];
    }
    $sto = $conn->query("select count(*)as totalorder from tbl_order_product\r\n     where user_id=" . $userid . " and user_can_c<5");
    $servertotal = $sto->fetch(PDO::FETCH_ASSOC);
    $stats["shopservice"]["totalorder"] = $servertotal["totalorder"];
    $result = $conn->query("select count(*)as total,sum(credit-discount)as \r\n    credit,user_can_c from tbl_order_product where user_id=" . $userid . " group by user_can_c");
    while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
        $stats["shopservice"]["total"][$row["user_can_c"]] = $row["total"];
        $stats["shopservice"]["credit"][$row["user_can_c"]] = $row["credit"];
    }
    return $stats;
}
function sendSMS($to, $templateid, $msg = "", $variable = "", $uid = "")
{
    global $config;
    global $conn;
    global $smsgatewayconfig;
    $to = trim($to);
    if (!$smsgatewayconfig) {
        $smsgatewayconfig = [];
        $r = $conn->query("select * from tbl_settings where attribute='smsgateway'");
        $result = $r->fetch(PDO::FETCH_ASSOC);
        $smsgatewayconfig = unserialize($result["value"]);
    }
    if (!$msg) {
        $q = $conn->query("select * from tbl_smstemplate where id='" . $templateid . "'");
        $sql = $q->fetch(PDO::FETCH_ASSOC);
        if ($uid) {
            $uq = $conn->query("select language from tblUsers where id='" . $uid . "'");
            $usr = $uq->fetch(PDO::FETCH_ASSOC);
            if ($usr["language"] != "English") {
                $lq = $conn->query("select message from tbl_smstemplate_language\r\n                 where template_id='" . $templateid . "' AND `language`='" . $usr["language"] . "'");
                $lang = $lq->fetch(PDO::FETCH_ASSOC);
                if ($lang["message"]) {
                    $sql["message"] = $lang["message"];
                }
            }
        }
        if (!$sql["status"]) {
            return "error: Template not enabled";
        }
        $msg = $sql["message"];
        $msg = str_replace("\n", "%0A", $msg);
        $msg1 = str_replace("{\$PASSWORD}", "XXXX", $msg);
        if ($variable) {
            foreach ($variable as $k => $v) {
                $msg = str_replace("{\$" . $k . "}", $v, $msg);
                $msg1 = str_replace("{\$" . $k . "}", $v, $msg1);
            }
        }
    }
    if ($config["smsgateway"] == "clickatell") {
        $sendlink = "https://api.clickatell.com/http/sendmsg?user=" . $smsgatewayconfig["clickatellusername"] . "&password=" . $smsgatewayconfig["clickatellpassword"] . "&api_id=" . $smsgatewayconfig["clickatellapikey"] . "&to=" . $to . "&text=" . str_replace(" ", "+", $msg);
        $responce = @file_get_contents($sendlink);
        if (stripos($responce, "ID") !== false) {
            $smsid = str_replace("ID: ", "", $responce);
            $return = "success: Message sent Successfull -" . $smsid;
        } else {
            if (stripos($responce, "Cannot route message") !== false) {
                $return = "error:Invalid phone number";
            } else {
                $return = "error:" . $responce;
            }
        }
        $datas = "To : " . $to . " <br> Message : " . $msg1;
        $qd = $conn->query("select * from tbl_smsgatewaylog");
        if ($qd->rowCount() < $config["ActivityLogLimit"]) {
            $conn->query("INSERT INTO tbl_smsgatewaylog\r\n            (date,gateway,data,result) values ('now()','" . $config["smsgateway"] . "','" . $datas . "','" . $responce . "')");
        }
    } else {
        if ($config["smsgateway"] == "customgateway") {
            $buff = "";
            if ($smsgatewayconfig["customparameter1"] && $smsgatewayconfig["customparameter1value"]) {
                $buff .= "&" . $smsgatewayconfig["customparameter1"] . "=" . $smsgatewayconfig["customparameter1value"];
            }
            if ($smsgatewayconfig["customparameter2"] && $smsgatewayconfig["customparameter2value"]) {
                $buff .= "&" . $smsgatewayconfig["customparameter2"] . "=" . $smsgatewayconfig["customparameter2value"];
            }
            if ($smsgatewayconfig["customparameter3"] && $smsgatewayconfig["customparameter3value"]) {
                $buff .= "&" . $smsgatewayconfig["customparameter3"] . "=" . $smsgatewayconfig["customparameter3value"];
            }
            if ($smsgatewayconfig["customparameter4"] && $smsgatewayconfig["customparameter4value"]) {
                $buff .= "&" . $smsgatewayconfig["customparameter4"] . "=" . $smsgatewayconfig["customparameter4value"];
            }
            if ($smsgatewayconfig["customparameter5"] && $smsgatewayconfig["customparameter5value"]) {
                $buff .= "&" . $smsgatewayconfig["customparameter5"] . "=" . $smsgatewayconfig["customparameter5value"];
            }
            $sendlink = $smsgatewayconfig["httpgeturl"] . "?" . $smsgatewayconfig["usernameparameter"] . "=" . $smsgatewayconfig["smsgatwayusername"] . "&" . $smsgatewayconfig["passwordparameter"] . "=" . $smsgatewayconfig["smsgatwaypassword"] . $buff . "&" . $smsgatewayconfig["toparameter"] . "=" . $smsgatewayconfig["addbeforenumber"] . $to . "&" . $smsgatewayconfig["textparameter"] . "=" . str_replace(" ", "+", $msg);
            if ($smsgatewayconfig["senderid"] != "") {
                $sendlink .= "&from=" . $smsgatewayconfig["senderid"];
            }
            if ($smsgatewayconfig["forcesenderid"] == 1) {
                $sendlink .= "&req_feat=32";
            }
            if ($smsgatewayconfig["unicode"] == 1) {
                $sendlink .= "&unicode=1";
            }
            $responce = initCurl($sendlink);
            $return = "success: " . $responce;
            $datas = "To : " . $to . " <br> Message : " . $msg;
            $q = $conn->query("select * from tbl_smsgatewaylog");
            if ($q->rowCount() < $config["ActivityLogLimit"]) {
                $times = date("Y-m-d h:i:s");
                $conn->query("INSERT INTO tbl_smsgatewaylog\r\n            (date,gateway,data,result) VALUES ('" . $times . "','" . $config["smsgateway"] . "','" . $datas . "','" . $responce . "')");
            }
        }
    }
    return $return;
}
function ledger($Uid, $cramount = 0, $dramount = 0, $type, $relid = "", $sid = "", $aid = "", $date = "", $relid2 = "", $fy = "")
{
    global $config;
    global $conn;
    global $Category;
    if (0 < $cramount || 0 < $dramount) {
        $data = NULL;
        $data["sid"] = $sid;
        $data["aid"] = $aid;
        $data["cramount"] = trim($cramount);
        $data["dramount"] = trim($dramount);
        $data["type"] = $type;
        if ($Category) {
            $data["category"] = $Category;
        }
        if ($Uid) {
            $data["uid"] = $Uid;
        }
        $time = time();
        $data["time"] = $time;
        $data["relid"] = $relid;
        if (stripos($date, "/") !== false) {
            $myDateTime = DateTime::createFromFormat("d/m/Y", $date);
            $date = $myDateTime->format("Y-m-d");
        }
        if (!$date) {
            $date = date("Y-m-d");
        }
        if ($relid2) {
            $data["relid2"] = $relid2;
        }
        $data["date"] = $date;
        if ($fy) {
            $data["fy"] = $fy;
        } else {
            $data["fy"] = $_SESSION["financialyear"];
        }
        $data["warehouse"] = $_SESSION["WAREHOUSE"];
        insertData("tbl_ledger", $data);
        $data = NULL;
    }
}
function createKOTSync($DATA, $warehouseid, $adminid, $tableid, $orderid, $kotdisplayid, $invoiceid)
{
    global $conn;
    $TotalQnt = 0;
    $MASTERDATA = [];
    $MASTERDATA["kotdate"] = $DATA["date"];
    $MASTERDATA["kottime"] = $DATA["time"];
    $MASTERDATA["warehouseid"] = $warehouseid;
    $MASTERDATA["totalqnt"] = $TotalQnt;
    $MASTERDATA["kotstatus"] = "COMPLETED";
    $MASTERDATA["createdby"] = $adminid;
    $MASTERDATA["kotdata"] = json_encode($DATA);
    $MASTERDATA["tableid"] = $tableid;
    $MASTERDATA["orderid"] = $orderid;
    $MASTERDATA["kotdisplayid"] = $kotdisplayid;
    $MASTERDATA["invoiceid"] = $invoiceid;
    $kotmasterid = insertData("tblKOTMaster", $MASTERDATA);
    $MASTERDATA = NULL;
    foreach ($DATA["kotitem"] as $tmpid => $kotitemrow) {
        $KOTITEM = [];
        $KOTITEM["kotid"] = $kotmasterid;
        $KOTITEM["productid"] = $kotitemrow["id"];
        $KOTITEM["qnt"] = $kotitemrow["qnt"];
        $KOTITEM["kotnotes"] = $kotitemrow["notes"] . " " . $DATA["kotcommonnotes"];
        $KOTITEM["adminid"] = $DATA["adminid"];
        $KOTITEM["unitid"] = $kotitemrow["unitid"];
        $KOTITEM["kotitemstatus"] = $kotitemrow["status"];
        $KOTITEM["time"] = $DATA["time"];
        $KOTITEM["data"] = json_encode($kotitemrow);
        insertData("tblKOTItems", $KOTITEM);
    }
}
function updateLedgerSync($DATA, $items, $invoiceid, $clientid, $discount = 0, $salesaccount, $roundoffaccount, $Date, $ExtraCharge = [], $discountaccount = 0)
{
    global $conn;
    global $Category;
    global $NonChargeable;
    $Category2 = "TAXIN";
    $Category = "SALES";
    if ($NonChargeable) {
        $Category2 = "NCTAX";
        $Category = "NC";
    }
    $RoughTotal = $DATA["subtotal"];
    foreach ($DATA["taxarr"] as $ki => $taxs) {
        $RoughTotal += $taxs["taxprice"];
    }
    foreach ($items as $itemdata) {
        foreach ($itemdata["tax"] as $taxdata) {
            ledger($invoiceid, $taxdata["taxprice"], "", $Category2, 2000, "", $taxdata["aid"], $Date, $taxdata["taxid"]);
        }
    }
    foreach ($ExtraCharge as $chargeid => $chargedetail) {
        if ($chargedetail["selected"] == 1) {
            foreach ($chargedetail["tax"] as $tmpid => $chargetax) {
                ledger($invoiceid, $chargetax["taxprice"], "", $Category, $invoiceid, "", $chargetax["aid"], $Date, 2000);
            }
            ledger($invoiceid, $chargedetail["credit"], "", $Category, $invoiceid, "", $chargedetail["account"], $Date, 2000);
            $RoughTotal += $chargedetail["credit"];
        }
    }
    $Converted = $RoughTotal;
    if (0 < $DATA["roundoff"]) {
        $Converted = round($RoughTotal);
        $roundoff = round($RoughTotal - $Converted, 5);
        if ($roundoff < 0) {
            ledger($invoiceid, abs($roundoff), "", $Category, $invoiceid, "", $roundoffaccount, $Date);
        } else {
            ledger($invoiceid, "", $roundoff, $Category, $invoiceid, "", $roundoffaccount, $Date);
        }
    }
    if ($discount) {
        ledger($invoiceid, $discount, "", "DISCOUNT", $invoiceid, $clientid, "", $Date);
        ledger($invoiceid, "", $discount, "DISCOUNT", $invoiceid, "", $discountaccount, $Date);
    }
    ledger($invoiceid, "", round($Converted, 5), $Category, $invoiceid, $clientid, "", $Date);
    $DATA["subtotal"] = $DATA["subtotal"] ? $DATA["subtotal"] : 0;
    $TotalAmount = round($DATA["subtotal"], 5);
    ledger($invoiceid, $TotalAmount, "", $Category, $invoiceid, "", $salesaccount, $Date);
}
function addContact($DATA)
{
    global $conn;
    global $operationId;
    if (checkDuplicate("tbl_supplier", "phone", $DATA["phone"])) {
        $RETURN["status"] = "error";
        $RETURN["msg"] = "Phone number already exists";
    } else {
        $id = insertData("tbl_supplier", $DATA);
        $DATA["id"] = $id;
        $RETURN["status"] = "success";
        $RETURN["id"] = $id;
        $RETURN["msg"] = "Contact Created successfully";
        $RETURN["data"] = $DATA;
    }
    return $RETURN;
}
function saveInvoiceSync($DATA, $clientid, $ordertype, $tableid, $restaurantid, $warehouseid, $orderid, $terminalid, $total, $invoiceid, $adminid, $Discount)
{
    global $conn;
    global $NonChargeable;
    $table = "tbl_invoices";
    if ($NonChargeable) {
        $table = "tbl_nonchargeable";
    }
    $data["clientid"] = $clientid;
    $data["due_date"] = date("Y-m-d", strtotime("+10 days " . date("Y-m-d")));
    $data["date"] = $DATA["date"];
    $data["time"] = $DATA["time"];
    $data["subtotal"] = $DATA["subtotal"];
    $Tax = 0;
    foreach ($DATA["tax"] as $taxdetail) {
        $Tax += $taxdetail["taxprice"];
    }
    $data["tax"] = $Tax;
    $data["tableid"] = $tableid;
    $data["restaurantid"] = $restaurantid;
    $data["total"] = $total;
    $data["adminid"] = $adminid;
    $data["status"] = "Unpaid";
    $data["note"] = $DATA["notes"];
    $data["securenote"] = $DATA["securenotes"];
    $data["warehouse"] = $warehouseid;
    $data["ordertype"] = $ordertype;
    $data["discount"] = $Discount;
    $data["discount_type"] = "fixed";
    $data["percentage"] = $Discount;
    $data["roundoff"] = $DATA["roundoff"];
    $data["fy"] = $_SESSION["financialyear"];
    if (!$NonChargeable) {
        $data["sourceid"] = $DATA["source"];
        $data["prefix"] = $orderid;
    }
    if (0 < $DATA["salesaccount"]) {
        $data["salesaccount"] = $DATA["salesaccount"];
    }
    if ($DATA["discount_type"]) {
        $data["discount_type"] = $DATA["discount_type"];
    }
    if (!$DATA["duedate"]) {
        $data["due_date"] = date("Y-m-d", strtotime("+10 days"));
    } else {
        $myDateTime = DateTime::createFromFormat("d/m/Y", $DATA["duedate"]);
        $bdate = $myDateTime->format("Y-m-d");
        $data["due_date"] = $bdate;
    }
    if ($DATA["pax"]) {
        $data["pax"] = $DATA["pax"];
    }
    $data["complementary"] = $DATA["complementry"];
    $uq = $conn->query("SELECT * FROM `tblTerminal` \r\n          WHERE `terminaluid`='" . $DATA["deviceid"] . "'");
    $Dev = $uq->fetch(PDO::FETCH_ASSOC);
    $data["deviceid"] = $Dev["terminalid"];
    updateData($table, $data, "id='" . $invoiceid . "'");
    $conn->query("UPDATE tblOrders set invoiceid='" . $invoiceid . "'\r\n    where orderid='" . $orderid . "'");
    return $invoiceid;
}
function saveInvoice($DATA, $clientid, $ordertype, $tableid, $restaurantid, $warehouseid, $orderid, $terminalid, $total, $invoiceid = "")
{
    global $conn;
    $ditem = getData("*", "tblDiscount", "invoiceid='" . $invoiceid . "'");
    $Discount = 0;
    foreach ($ditem as $items) {
        $Discount += $items["discountamount"];
    }
    $data["clientid"] = $clientid;
    $data["due_date"] = date("Y-m-d", strtotime("+10 days " . date("Y-m-d")));
    $data["date"] = date("Y-m-d");
    $data["time"] = time();
    $data["subtotal"] = $DATA["invoice"]["subtotal"];
    $Tax = 0;
    foreach ($DATA["invoice"]["tax"] as $taxdetail) {
        $Tax += $taxdetail["taxprice"];
    }
    $data["tax"] = $Tax;
    $data["tableid"] = $tableid;
    $data["restaurantid"] = $restaurantid;
    $data["total"] = $total;
    $data["adminid"] = $_SESSION["sc_adminid"];
    $data["status"] = "Unpaid";
    $data["note"] = $DATA["notes"];
    $data["securenote"] = $DATA["securenotes"];
    $data["warehouse"] = $warehouseid;
    $data["ordertype"] = $ordertype;
    $data["discount"] = $Discount;
    $data["percentage"] = $Discount;
    $data["roundoff"] = $DATA["roundoff"];
    $data["fy"] = $_SESSION["financialyear"];
    $data["sourceid"] = $DATA["source"];
    if (0 < $DATA["salesaccount"]) {
        $data["salesaccount"] = $DATA["salesaccount"];
    }
    if ($DATA["discount_type"]) {
        $data["discount_type"] = $DATA["discount_type"];
    }
    $data["uniqueid"] = $orderid;
    $data["prefix"] = $terminalid . "_" . $orderid;
    if (!$DATA["duedate"]) {
        $data["due_date"] = date("Y-m-d", strtotime("+10 days"));
    } else {
        $myDateTime = DateTime::createFromFormat("d/m/Y", $DATA["duedate"]);
        $bdate = $myDateTime->format("Y-m-d");
        $data["due_date"] = $bdate;
    }
    if ($DATA["pax"]) {
        $data["pax"] = $DATA["pax"];
    }
    $data["complementary"] = $DATA["complementry"];
    $data["deviceid"] = $terminalid;
    if (isset($_SESSION["private"])) {
        $data["private"] = $_SESSION["sc_adminid"];
    }
    if ($invoiceid) {
        updateData("tbl_invoices", $data, "id='" . $invoiceid . "'");
    } else {
        $invoiceid = insertData("tbl_invoices", $data);
    }
    return $invoiceid;
}
function insertInvoiceItemsSync($itemdata, $invoiceid, $clientid = "")
{
    global $conn;
    global $NonChargeable;
    $table = "tbl_invoiceitems";
    if ($NonChargeable) {
        $table = "tbl_ncitems";
    }
    $data["pid"] = $itemdata["id"];
    $data["price"] = round($itemdata["credit"], 2);
    $data["qnt"] = $itemdata["qnt"];
    $data["discount"] = round($itemdata["itemdiscount"] / $itemdata["qnt"], 2);
    $data["serial"] = $itemdata["serialno"];
    $data["taxgroup"] = $itemdata["taxgroup"];
    $pq = $conn->query("SELECT service_name FROM `tbl_products` WHERE `id`='" . $itemdata["id"] . "'");
    $Pros = $pq->fetch(PDO::FETCH_ASSOC);
    $TypeName = "";
    if ($itemdata["typeid"]) {
        $tq = $conn->query("SELECT `type` FROM `tbl_type_manager` WHERE `id`='" . $itemdata["typeid"] . "'");
        $T = $tq->fetch(PDO::FETCH_ASSOC);
        $TypeName .= " " . $T["type"];
    }
    $data["note"] = $Pros["service_name"] . $TypeName;
    $data["direct"] = $itemdata["id"];
    $data["fy"] = $_SESSION["financialyear"];
    $Instruction = "";
    foreach ($itemdata["iteminstruction"] as $inid => $indetail) {
        $Instruction .= $indetail["pre"] . ", ";
    }
    $data["instruction"] = trim(trim($Instruction), ",");
    $data["typeid"] = $itemdata["typeid"];
    $data["stockid"] = $itemdata["sid"];
    $data["invoiceid"] = $invoiceid;
    $data["clientid"] = $clientid;
    $data["paxid"] = 0 < $itemdata["guest"] ? $itemdata["guest"] : 0;
    if (!$NonChargeable) {
        $data["complementary"] = $itemdata["complementaryby"];
    }
    $invoiceitemid = insertData($table, $data);
    if ($itemdata["tags"]) {
        $tagtotal = 0;
        foreach ($itemdata["tags"] as $tid => $detail) {
            if ($detail["price"]) {
                $currentprice = 0;
                $tagdata["invoiceitemid"] = $invoiceitemid;
                $tagdata["tagid"] = $tid;
                $tagtotal += $detail["price"];
                $currentprice = $detail["price"];
                $tagdata["perprice"] = $currentprice;
                $tagdata["price"] = $detail["price"];
                $tagdata["qnt"] = 0 < $detail["qnt"] ? $detail["qnt"] : 1;
                insertData("tbl_invoice_tag", $tagdata);
            }
        }
        $conn->query("update " . $table . " set tagtotal='" . $tagtotal . "'\r\n        where id='" . $invoiceitemid . "'");
    }
    $data = NULL;
    return $invoiceitemid;
}
function insertInvoiceItems($itemdata, $invoiceid, $clientid = "")
{
    global $conn;
    $data["pid"] = $itemdata["id"];
    $data["price"] = round($itemdata["credit"], 2);
    $data["qnt"] = $itemdata["qnt"];
    $data["discount"] = $itemdata["discountprice1"];
    $data["serial"] = $itemdata["serialno"];
    $data["taxgroup"] = $itemdata["taxgroup"];
    $data["note"] = $itemdata["service_name"];
    $data["direct"] = $itemdata["id"];
    $data["fy"] = $_SESSION["financialyear"];
    $data["instruction"] = $itemdata["instructionnotes"];
    $data["typeid"] = $itemdata["type_id"];
    $data["manufacture"] = $itemdata["manufacture_id"];
    $data["model"] = $itemdata["model_id"];
    $data["stockid"] = $itemdata["sid"];
    $data["invoiceid"] = $invoiceid;
    $data["clientid"] = $clientid;
    $data["paxid"] = $itemdata["pax"];
    $data["complementary"] = $itemdata["complementary"];
    $invoiceitemid = insertData("tbl_invoiceitems", $data);
    if ($itemdata["selectedtags"]) {
        $tagtotal = 0;
        foreach ($itemdata["selectedtags"] as $tid => $price) {
            if ($price["selected"]) {
                $currentprice = 0;
                $tagdata["invoiceitemid"] = $invoiceitemid;
                $tagdata["tagid"] = $tid;
                $tagtotal += $price["price"];
                $currentprice = $price["price"];
                $tagdata["perprice"] = $currentprice;
                $tagdata["price"] = $price["price"];
                insertData("tbl_invoice_tag", $tagdata);
            }
        }
        $conn->query("update tbl_invoiceitems set tagtotal='" . $tagtotal . "'\r\n        where id='" . $invoiceitemid . "'");
    }
    $data = NULL;
    return $invoiceitemid;
}
function getNextInvoiceId($warehouseid, $terminalno = "")
{
    global $conn;
    global $NonChargeable;
    if ($NonChargeable) {
        $table = "tbl_nonchargeable";
    } else {
        $table = "tbl_invoices";
    }
    $sac = $conn->query("SELECT `value` FROM `tbl_configer` \r\n                    WHERE category='config' and ckey='invinc'");
    $Config = $sac->fetch(PDO::FETCH_ASSOC);
    if ($Config["value"] == "ware" && !$NonChargeable) {
        $iQuery = $conn->query("SELECT * FROM " . $table . " \r\n        WHERE `warehouse`='" . $warehouseid . "' order by id desc");
    } else {
        $iQuery = $conn->query("SELECT * FROM " . $table . " \r\n          order by id desc");
    }
    $iData = $iQuery->fetch(PDO::FETCH_ASSOC);
    $newId = $iData["id"] + 1;
    $uniqueNo = $iData["uniqueid"];
    $uniqueNo = $uniqueNo + 1;
    $params["id"] = $newId;
    if (!$NonChargeable) {
        $params["uniqueid"] = $uniqueNo;
    }
    insertData($table, $params);
    return $newId;
}
function getClientGroup()
{
    global $conn;
    if (!isset($_SESSION["clientgrouparr"])) {
        $qc = $conn->query("select id,groupname from tbl_client_group");
        $ClientGroup = [];
        while ($r = $qc->fetch(PDO::FETCH_ASSOC)) {
            $ClientGroup[$r["id"]] = $r;
        }
        $_SESSION["clientgrouparr"] = $ClientGroup;
    }
    return $_SESSION["clientgrouparr"];
}
function getUsersPrice($servicetype, $serviceid, $credit, $usercurrency, $basecurrency, $clientgroup = "", $userid)
{
    global $conn;
    if ($servicetype == "file") {
        $discounttable = "tbl_discount_file";
    } else {
        $discounttable = "tbl_discount_imei";
    }
    $qdisc = $conn->query("select price from " . $discounttable . "\r\n                where service_id='" . $serviceid . "' and user_id='" . $userid . "'");
    $userdiscount = $qdisc->fetch(PDO::FETCH_ASSOC);
    if ($userdiscount["price"] != 0) {
        if ($usercurrency == $basecurrency) {
            $credit = $userdiscount["price"];
        } else {
            $credit = convertRate($usercurrency, $basecurrency, $userdiscount["price"]);
        }
    } else {
        $discounts = getGroupDiscount($servicetype, $clientgroup, $_SESSION["uid"], $serviceid, $usercurrency, $basecurrency);
        if ($discounts != 0) {
            $row["credit"] = $discounts;
        } else {
            $servicecredit = $conn->query("select credit from tbl_imei_credit\r\n                        where service_id='" . $serviceid . "' and currency_id='" . $usercurrency . "'");
            $servicecredit = $servicecredit->fetch(PDO::FETCH_ASSOC);
            if (0 < $servicecredit["credit"]) {
                $row["credit"] = $servicecredit["credit"];
            } else {
                $row["credit"] = convertRate($basecurrency, $usercurrency, $credit);
            }
        }
    }
    return $credit;
}
function SlackSendMsg($to, $msg, $colour = "good", $_cols, $short, $text = "", $callwithoutshort = "")
{
    global $config;
    global $remote_ip;
    global $conn;
    if (!$config["slacksubscription"]) {
        return true;
    }
    if (!$config["slacktoken"]) {
        return true;
    }
    if ($config["messenger"] == "slack") {
        $_msg["channel"] = $to;
        $_msg["text"] = "";
        $_attachments["color"] = $colour;
        $_attachments["title"] = $msg;
        $_attachments["text"] = $text;
        if ($_SESSION["adminname"]) {
            $_attachments["footer"] = $config["companyname"] . " @ " . $_SESSION["adminname"] . " | " . $remote_ip . " ";
        } else {
            $_attachments["footer"] = $config["companyname"];
        }
        $_attachments["ts"] = time();
        if (is_array($_cols)) {
            foreach ($_cols as $k => $v) {
                $_attachments["fields"][$k]["title"] = $v["titel"];
                $_attachments["fields"][$k]["value"] = $v["text"];
                $_attachments["fields"][$k]["short"] = $short;
            }
        }
        if (is_array($callwithoutshort)) {
            foreach ($callwithoutshort as $k => $v) {
                $_attachments["fields"][$k]["title"] = $v["titel"];
                $_attachments["fields"][$k]["value"] = $v["text"];
                $_attachments["fields"][$k]["short"] = false;
            }
        }
        $_msg["attachments"][] = $_attachments;
        return slackposttourl("https://slack.com/api/chat.postMessage", $_msg);
    } else {
        if ($config["messenger"] == "telegram") {
            $message = "<b>" . $msg . "</b>\n";
            if ($text) {
                $message .= "<i>" . $text . "</i>\n";
            }
            if (is_array($_cols)) {
                foreach ($_cols as $k => $v) {
                    if (stripos($v["text"], "<") !== false) {
                        $v["text"] = str_replace("<", "", $v["text"]);
                        $v["text"] = str_replace(">", "", $v["text"]);
                        $v["text"] = explode("|", $v["text"]);
                        $v["text"] = "<a href='" . $v["text"][0] . "'>" . $v["text"][1] . "</a>";
                    }
                    $message .= $v["titel"] . " : " . strip_tags($v["text"]) . " \n";
                }
            }
            if (is_array($callwithoutshort)) {
                foreach ($callwithoutshort as $k => $v) {
                    $message .= $v["titel"] . " : " . strip_tags($v["text"]) . " \n";
                }
            }
            if ($_SESSION["adminname"]) {
                $message .= "<i>" . $config["companyname"] . " @ " . $_SESSION["adminname"] . " | " . $remote_ip . " </i>";
            } else {
                $message .= "<i>" . $config["companyname"] . "</i>";
            }
            $slacktoken = $config["slacktoken"];
            $telegramurl = "https://api.telegram.org/bot" . $slacktoken . "/sendMessage?chat_id=" . $to . "&text=" . urlencode($message) . "&parse_mode=HTML";
            telegramCurl($telegramurl);
        }
    }
}
function slackposttourl($url, $post = "")
{
    global $config;
    $slacktoken = decrypt($config["slacktoken"]);
    try {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch, CURLOPT_POST, 1);
        if ($post) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post));
        }
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type:application/json", "Authorization: Bearer " . $slacktoken]);
        $result = curl_exec($ch);
        $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if ($result === false) {
            echo $result;
            return false;
        }
        $response_array = json_decode($result, true);
        return $response_array;
    } catch (Exception $e) {
        echo $result;
        return false;
    }
}
function telegramCurl($telegramurl)
{
    $curl_handle = curl_init();
    curl_setopt($curl_handle, CURLOPT_URL, $telegramurl);
    curl_setopt($curl_handle, CURLOPT_CONNECTTIMEOUT, 2);
    curl_setopt($curl_handle, CURLOPT_RETURNTRANSFER, 1);
    $telegramdata = curl_exec($curl_handle);
    curl_close($curl_handle);
    return $telegramdata;
}
function sendNotification($to = "system", $subject, $adminmessage, $mailto, $adminnotificaionfromname = "", $attachmentfilename = "", $attachmentdata = "", $ReplyTo = "")
{
    global $config;
    global $smtpdebug;
    global $conn;
    global $storeowner;
    if (!$adminmessage) {
        return false;
    }
    $message = "";
    $message .= "<font style=\"font-family:Verdana;font-size:11px\"><p>" . $adminmessage . "</p>";
    if (is_file("Mail.php")) {
        require_once "Mail.php";
    } else {
        include_once ROOTDIR . "/../../includes/phpmailer.class.php";
    }
    $toemails = [];
    $mail = new PHPMailer();
    $mail->From = $config["config_admin_mail"];
    if (trim($adminnotificaionfromname)) {
        $mail->FromName = $adminnotificaionfromname;
    } else {
        $mail->FromName = "[FUSION]";
    }
    $mail->Subject = $subject;
    $mail->CharSet = $config["charset"];
    $emailcount = 0;
    if ($config["mail_type"] == "sendgrid") {
        $mail->Mailer = "SendGrid";
        if ($to == "system" || $to == "account" || $to == "support") {
            $_result = $conn->query("SELECT tbl_admin.email,tbl_admin.firstname,tbl_admin.lastname\r\n            FROM tbl_admin ,tbl_admin_access_group WHERE tbl_admin.group_id = tbl_admin_access_group.id\r\n            AND tbl_admin_access_group." . $to . " = '1'");
            while ($data = $_result->fetch(PDO::FETCH_ASSOC)) {
                if ($data["email"]) {
                    $toemails[]["to"] = $data["email"];
                    $emailcount++;
                }
            }
        }
        if ($mailto) {
            foreach ($mailto as $othertomail) {
                $toemails[]["to"] = trim($othertomail);
                $emailcount++;
            }
        }
        $Json = [];
        foreach ($toemails as $mail) {
            $Json["personalizations"][0]["to"][]["email"] = $mail["to"];
        }
        if (!$fromemail) {
            $fromemail = $config["config_admin_mail"];
        }
        $Json["from"]["email"] = $fromemail;
        $Json["subject"] = $subject;
        if ($plaintext) {
            $Json["content"][0]["value"] = $message;
            $Json["content"][0]["type"] = "text/plain";
        } else {
            $Json["content"][0]["value"] = $message;
            $Json["content"][0]["type"] = "text/html";
        }
        $CURLheaders["HEADER"] = ["Authorization: Bearer " . $config["aggregatorapi"], "Content-Type: application/json"];
        $OUT = initCurl("https://api.sendgrid.com/v3/mail/send", "", $CURLheaders, $config["aggregatorapi"], $Json);
        return true;
    } else {
        if ($config["mail_type"] == "mailgun") {
            $mail->Mailer = "mailgun";
            if ($to == "system" || $to == "account" || $to == "support") {
                $_result = $conn->query("SELECT tbl_admin.email,tbl_admin.firstname,tbl_admin.lastname\r\n               FROM tbl_admin ,tbl_admin_access_group\r\n               WHERE tbl_admin.group_id = tbl_admin_access_group.id\r\n               AND tbl_admin_access_group." . $to . " = '1'");
                while ($data = $_result->fetch(PDO::FETCH_ASSOC)) {
                    if ($data["email"]) {
                        $toemails[]["to"] = $data["email"];
                        $emailcount++;
                    }
                }
            }
            if ($mailto) {
                foreach ($mailto as $othertomail) {
                    $toemails[]["to"] = trim($othertomail);
                    $emailcount++;
                }
            }
            foreach ($toemails as $e) {
                $buff .= $e . ",";
            }
            $Field["to"] = trim($buff, ",");
            $Field["from"] = $fromname . "<" . $fromemail . ">";
            $Field["fromname"] = $fromname;
            $Field["subject"] = $subject;
            if ($plaintext) {
                $Field["text"] = $message;
            } else {
                $Field["html"] = $message;
            }
            $Field["apikey"] = $config["aggregatorapi"];
            $OUT = initCurl("https://api.mailgun.net/v3/" . $config["mailgundomain"] . "/messages", $Field, "", $config["aggregatorapi"]);
            $OUT = json_decode($OUT, true);
            if ($OUT["id"]) {
                return false;
            }
            return true;
        } else {
            if ($config["mail_type"] == "aggregator") {
                $mail->Mailer = "aggregator";
                if ($to == "system" || $to == "account" || $to == "support") {
                    $_result = $conn->query("SELECT tbl_admin.email,tbl_admin.firstname,tbl_admin.lastname\r\n            FROM tbl_admin ,tbl_admin_access_group\r\n            WHERE tbl_admin.group_id = tbl_admin_access_group.id\r\n            AND tbl_admin_access_group." . $to . " = '1'");
                    while ($data = $_result->fetch(PDO::FETCH_ASSOC)) {
                        if ($data["email"]) {
                            $toemails[]["to"] = $data["email"];
                            $emailcount++;
                        }
                    }
                }
                if ($mailto) {
                    foreach ($mailto as $othertomail) {
                        $toemails[]["to"] = trim($othertomail);
                        $emailcount++;
                    }
                }
                $Field["toemails"] = json_encode($toemails);
                $Field["from"] = $config["config_admin_mail"];
                $Field["fromname"] = "[FUSION]";
                $Field["subject"] = $subject;
                $Field["message"] = $message;
                $Field["apikey"] = $config["aggregatorapi"];
                $OUT = initCurl($config["aggregatorlink"], $Field);
                $OUT = json_decode($OUT, true);
                if ($OUT["status"] != "success") {
                    return false;
                }
                return true;
            } else {
                if ($config["mail_type"] == "mail") {
                    $mail->Mailer = "mail";
                } else {
                    if ($config["mail_type"] == "smtp") {
                        $mail->IsSMTP();
                        $mail->Host = $config["smtp_host"];
                        $mail->Port = $config["smtp_port"];
                        $mail->Hostname = $_SERVER["SERVER_NAME"];
                        if ($config["smtp_enc"]) {
                            $mail->SMTPSecure = "ssl";
                        }
                        if ($config["smtp_username"]) {
                            $mail->SMTPAuth = true;
                            $mail->Username = $config["smtp_username"];
                            $mail->Password = $config["smtp_password"];
                        }
                        $mail->Sender = $mail->From;
                    }
                }
                if ($smtp_debug) {
                    $mail->SMTPDebug = true;
                }
                $message_text = str_replace("</p>", "", $message);
                $message_text = str_replace("<br>", "", $message_text);
                $message_text = str_replace("<br />", "", $message_text);
                if ($storeowner["id"]) {
                    $message = strip_tags($message, "<br>");
                }
                $message_text = strip_tags($message_text);
                $mail->Body = $message;
                $mail->AltBody = $message_text;
                if ($attachmentfilename) {
                    if (is_array($attachmentfilename)) {
                        $count = 0;
                        foreach ($attachmentfilename as $filelist) {
                            $mail->AddStringAttachment($attachmentdata[$count], $filelist);
                            $count++;
                        }
                    } else {
                        $mail->AddStringAttachment($attachmentdata, $attachmentfilename);
                    }
                }
                $emailcount = 0;
                if ($to == "system" || $to == "account" || $to == "support") {
                    $_result = $conn->query("SELECT tbl_admin.email,tbl_admin.firstname,tbl_admin.lastname\r\n                    FROM tbl_admin ,tbl_admin_access_group\r\n                    WHERE tbl_admin.group_id = tbl_admin_access_group.id\r\n                    AND tbl_admin_access_group." . $to . " = '1'");
                    while ($data = $_result->fetch(PDO::FETCH_ASSOC)) {
                        if ($data["email"]) {
                            $mail->AddAddress($data["email"], $data["firstname"] . " " . $data["lastname"]);
                            $emailcount++;
                        }
                    }
                }
                if ($ReplyTo) {
                    $mail->AddReplyTo($ReplyTo);
                }
                if ($mailto) {
                    foreach ($mailto as $othertomail) {
                        $mail->AddAddress(trim($othertomail));
                        $emailcount++;
                    }
                }
                if (!$emailcount) {
                    return false;
                }
                if ($mail->Send()) {
                }
                $mail->ClearAddresses();
            }
        }
    }
}
function checkRepeatIMEI($userid, $imei, $serviceid = "")
{
    global $conn;
    $sql = "SELECT * from `tbl_order_imei` where `user_id`='" . $userid . "'\r\n     AND `imei`='" . $imei . "' AND  (`user_can_c`=0 OR `user_can_c`=1 )";
    if ($serviceid) {
        $sql .= " and service_id='" . $serviceid . "'";
    }
    $countRows = $conn->query($sql);
    if ($countRows->rowCount() == 0) {
        return true;
    }
    return false;
}
function sendMail($templateid, $uid = "", $updateuserdetail = false, $mailfield = [], $relId = "", $scheduled = "", $attachmentfilename = "", $attachmentdata = "", $toemailsnew = "", $history = true, $sendnow = "")
{
    global $conn;
    global $config;
    include_once ROOTDIR . "/../../includes/smarty/Smarty.class.php";
    $smarty = new SmartyBC();
    $smarty->caching = 0;
    $toemails = [];
    if ($toemailsnew != "") {
        $toemails = $toemailsnew;
    }
    $tq = $conn->query("select * from tbl_emailtemplates where id='" . $templateid . "'");
    $template = $tq->fetch(PDO::FETCH_ASSOC);
    $type = $template["type"];
    $fromname = $template["fromname"];
    $fromemail = $template["fromemail"];
    $disabled = $template["disabled"];
    $copyto = $template["copyto"];
    $plaintext = $template["plaintext"];
    $scheduled = $template["scheduled"];
    $mailserv = $template["mailserv"];
    $layoutid = $template["layoutid"];
    $subject = $template["subject"];
    $message = $template["message"];
    $cache_id = md5($_SERVER["REQUEST_URI"]);
    $smarty->compile_dir = ROOTDIR . "/../../templates_c";
    $smarty->compile_id = md5($subject . $message);
    $smarty->assign("emailsubject", trim($subject));
    $smarty->assign("emailmessage", $message);
    if (!$uid["email"] && count($toemails) == 0 && !isset($_SESSION["uid"])) {
        return false;
    }
    if (!$uid) {
        $uid = $_SESSION["uid"];
    }
    if ($uid) {
        $uq = $conn->query("select * from tblUsers where id='" . $uid . "'");
        $user = $uq->fetch(PDO::FETCH_ASSOC);
        if ($user) {
            foreach ($user as $mergefield => $mergevalue) {
                $smarty->assign($mergefield, $mergevalue);
            }
        }
        $mailto[] = $user["email"];
        if (is_array($mailfield)) {
            foreach ($mailfield as $mergefield => $mergevalue) {
                $smarty->assign($mergefield, $mergevalue);
            }
        }
        $enc = md5($user["id"]) . "-" . md5($template["id"]);
        $smarty->assign("enc", $enc);
        if ($type == "imeiorder" || $type == "serverorder") {
            $oq = $conn->query("SELECT *,(select service_name from tbl_services_imei\r\n            where id=service_id)  as service FROM `tbl_order_imei` WHERE `order_id`='" . $relId . "'");
            $orderdtl = $oq->fetch(PDO::FETCH_ASSOC);
            $priority = 1;
            if ($config["encryptedorderid"]) {
                $smarty->assign("orderid", $orderdtl["encnum"] ? $orderdtl["encnum"] : $orderdtl["order_id"]);
            } else {
                $smarty->assign("orderid", $orderdtl["order_id"]);
            }
            $smarty->assign("imei", $orderdtl["imei"]);
            $smarty->assign("reply", $orderdtl["reply"]);
            $smarty->assign("orderdatetime", date("d-m-Y H:i:s", $orderdtl["time"]));
            $smarty->assign("replydatetime", date("d-m-Y H:i:s", $orderdtl["reply_time"]));
            $smarty->assign("qnt", $orderdtl["qnt"]);
            $smarty->assign("service", $orderdtl["service"]);
            $smarty->assign("notes", $orderdtl["note"]);
            $smarty->assign("comments", $orderdtl["comments"]);
            $creditdtl = $orderdtl["credit"] - $orderdtl["discount"];
            $smarty->assign("ordercredit", $creditdtl);
            $smarty->assign("pin", $orderdtl["PIN"]);
            $smarty->assign("kbh", $orderdtl["KBH"]);
            $smarty->assign("prd", $orderdtl["PRD"]);
            $smarty->assign("type", $orderdtl["Type"]);
            $smarty->assign("reference", $orderdtl["Reference"]);
            $smarty->assign("locks", $orderdtl["Locks"]);
            $smarty->assign("SN", $orderdtl["SN"]);
            $smarty->assign("SecRO", $orderdtl["SecRO"]);
            $mq = $conn->query("SELECT `Name` FROM tbl_mobile WHERE ID='" . $orderdtl["model_id"] . "'");
            $models = $mq->fetch(PDO::FETCH_ASSOC);
            $smarty->assign("model", $models["Name"]);
            $mq = $conn->query("SELECT `Name` FROM tbl_provider WHERE ID='" . $orderdtl["provider_id"] . "'");
            $models = $mq->fetch(PDO::FETCH_ASSOC);
            $smarty->assign("provider", $models["Name"]);
            $mq = $conn->query("SELECT mep FROM tbl_mep WHERE ID='" . $orderdtl["mep"] . "'");
            $models = $mq->fetch(PDO::FETCH_ASSOC);
            $smarty->assign("mep", $models["mep"]);
            if (!$mailfield["custom"]) {
                $customs = getCustomFields("serviceimei", $orderdtl["service_id"], $orderdtl["order_id"], "on");
                $smarty->assign("custom", $customs);
            } else {
                $smarty->assign("custom", $mailfield["custom"]);
            }
        }
        if ($type == "fileorder") {
            $oq = $conn->query("SELECT *,(select service_name from tbl_services_imei\r\n            where id=service_id)  as service FROM `tbl_order_file` WHERE `order_id`='" . $relId . "'");
            $orderdtl = $oq->fetch(PDO::FETCH_ASSOC);
            $priority = 1;
            $smarty->assign("orderid", $orderdtl["order_id"]);
            $smarty->assign("requestedfile", $orderdtl["file"]);
            $smarty->assign("notes", $orderdtl["note"]);
            $smarty->assign("orderdatetime", date("d-m-Y H:i:s", $orderdtl["time"]));
            $smarty->assign("comments", $orderdtl["comments"]);
            $creditdtl = NULL;
            $creditdtl = $orderdtl["credit"] - $orderdtl["discount"];
            $smarty->assign("ordercredit", $creditdtl);
            $customs = getCustomFields("servicefile", $orderdtl["service_id"], $orderdtl["order_id"], "on");
            $smarty->assign("custom", $customs);
        }
        $smarty->assign("balance", $user["credit_left"]);
        $smarty->assign("companyname", $config["companyname"]);
        $smarty->assign("adminsignature", $config["adminsignature"]);
        $smarty->assign("adminmail", $config["config_admin_mail"]);
        $smarty->assign("siteaddress", $config["site_address"]);
        $smarty->assign("twitter", $config["twitter"]);
        $smarty->assign("facebook", $config["facebook_link"]);
        $smarty->assign("linkedln", $config["linkedln"]);
        $subject = $smarty->fetch("string:" . $subject);
        $message = $smarty->fetch("string:" . $message);
        if ($config["mail_sending_type"] == 1 && $scheduled == 1) {
            $data = [];
            $data["userid"] = $uid;
            $data["subject"] = $subject;
            $data["message"] = $message;
            $data["fromname"] = $fromname;
            $data["fromemail"] = $fromemail;
            $data["attachname"] = serialize($attachmentfilename);
            $data["attachment"] = base64_encode(serialize($attachmentdata));
            $data["priority"] = $priority;
            $data["to"] = serialize($toemails);
            $data["cc"] = serialize($copyto);
            $data["replyto"] = $ReplyTo;
            $data["response_email"] = $response_email;
            $data["plaintext"] = $plaintext;
            $data["history"] = $history ? $history : $config["mail_history"];
            $data["mailserv"] = $mailserv;
            $conn->insertData("tbl_sheduledmail", $data);
            $data = NULL;
            return true;
        }
        if ($template["disabled"]) {
            return false;
        }
        $type = $template["type"];
        if ($type == "imeiorder" || $type == "serverorder") {
            $oq = $conn->query("SELECT *,(select service_name from tbl_services_imei\r\n            where id=service_id)  as service FROM `tbl_order_imei` WHERE `order_id`='" . $relId . "'");
            $orderdtl = $oq->fetch(PDO::FETCH_ASSOC);
        }
        if ($type == "fileorder") {
            $oq = $conn->query("SELECT *,(select service_name from tbl_services_file\r\n            where id=service_id)  as service FROM `tbl_order_file` WHERE `order_id`='" . $relId . "'");
            $orderdtl = $oq->fetch(PDO::FETCH_ASSOC);
        }
        if ($sendnow) {
            $shdl = $conn->query("select * from tbl_sheduledmail \r\n        where id='" . $sendnow . "'");
            $shdl = $shdl->fetch(PDO::FETCH_ASSOC);
            $conn->query("DELETE FROM tbl_sheduledmail WHERE id='" . $sendnow . "'");
            $body = $shdl["message"];
            $fromemail = $shdl["fromemail"];
            $fromname = $shdl["fromname"];
            $ReplyTo = $shdl["replyto"];
            $toemails = unserialize($shdl["to"]);
            $orderdtl["response_email"] = $shdl["response_email"];
            $copyto = unserialize($shdl["cc"]);
            $subject = $shdl["subject"];
            $plaintext = $shdl["plaintext"];
            $attachmentfilename = unserialize($shdl["attachname"]);
            $attachmentdata = unserialize(base64_decode($shdl["attachment"]));
            $mailserv = $shdl["mailserv"];
            $response_email = $shdl["response_email"];
            $history = $shdl["history"];
        }
        if ($body) {
            $message .= "\t\n \t\n" . $body;
        }
        if (is_file("Mail.php")) {
            require_once "Mail.php";
        } else {
            include_once ROOTDIR . "/../../includes/phpmailer.class.php";
        }
        $mail = new PHPMailer(true);
        if ($mailserv) {
            $config["mail_type"] = $config["mail_type" . $mailserv];
            $config["smtp_host"] = $config["smtp_host" . $mailserv];
            $config["smtp_port"] = $config["smtp_port" . $mailserv];
            $config["smtp_enc"] = $config["smtp_enc" . $mailserv];
            $config["smtp_username"] = $config["smtp_username" . $mailserv];
            $config["smtp_password"] = $config["smtp_password" . $mailserv];
        }
        $mail->From = $fromemail;
        $mail->FromName = $fromname;
        $mail->FromName = "[FUSION]";
        $mail->Subject = $subject;
        $mail->CharSet = $config["charset"];
        $emailcount = 0;
        if ($config["mail_type"] == "sendgrid") {
            $mail->Mailer = "SendGrid";
            if ($to == "system" || $to == "account" || $to == "support") {
                $_result = $conn->query("SELECT tbl_admin.email,tbl_admin.firstname,tbl_admin.lastname\r\n            FROM tbl_admin ,tbl_admin_access_group\r\n            WHERE tbl_admin.group_id = tbl_admin_access_group.id\r\n            AND tbl_admin_access_group." . $to . " = '1'");
                while ($data = $_result->fetch(PDO::FETCH_ASSOC)) {
                    if ($data["email"]) {
                        $toemails[]["to"] = $data["email"];
                        $emailcount++;
                    }
                }
            }
            if ($mailto) {
                foreach ($mailto as $othertomail) {
                    $toemails[]["to"] = trim($othertomail);
                    $emailcount++;
                }
            }
            $Json = [];
            foreach ($toemails as $mail) {
                $Json["personalizations"][0]["to"][]["email"] = $mail["to"];
            }
            if (!$fromemail) {
                $fromemail = $config["config_admin_mail"];
            }
            $Json["from"]["email"] = $fromemail;
            $Json["subject"] = $subject;
            if ($plaintext) {
                $Json["content"][0]["value"] = $message;
                $Json["content"][0]["type"] = "text/plain";
            } else {
                $Json["content"][0]["value"] = $message;
                $Json["content"][0]["type"] = "text/html";
            }
            $CURLheaders["HEADER"] = ["Authorization: Bearer " . $config["aggregatorapi"], "Content-Type: application/json"];
            $OUT = initCurl("https://api.sendgrid.com/v3/mail/send", "", $CURLheaders, $config["aggregatorapi"], $Json);
            return true;
        } else {
            if ($config["mail_type"] == "mailgun") {
                $mail->Mailer = "mailgun";
                if ($to == "system" || $to == "account" || $to == "support") {
                    $_result = $conn->query("SELECT tbl_admin.email,tbl_admin.firstname,tbl_admin.lastname\r\n                    FROM tbl_admin ,tbl_admin_access_group\r\n                    WHERE tbl_admin.group_id = tbl_admin_access_group.id\r\n                    AND tbl_admin_access_group." . $to . " = '1'");
                    while ($data = $_result->fetch(PDO::FETCH_ASSOC)) {
                        if ($data["email"]) {
                            $toemails[]["to"] = $data["email"];
                            $emailcount++;
                        }
                    }
                }
                if ($mailto) {
                    foreach ($mailto as $othertomail) {
                        $toemails[]["to"] = trim($othertomail);
                        $emailcount++;
                    }
                }
                foreach ($toemails as $e) {
                    $buff .= $e . ",";
                }
                $Field["to"] = trim($buff, ",");
                $Field["from"] = $fromname . "<" . $fromemail . ">";
                $Field["fromname"] = $fromname;
                $Field["subject"] = $subject;
                if ($plaintext) {
                    $Field["text"] = $message;
                } else {
                    $Field["html"] = $message;
                }
                $Field["apikey"] = $config["aggregatorapi"];
                $OUT = initCurl("https://api.mailgun.net/v3/" . $config["mailgundomain"] . "/messages", $Field, "", $config["aggregatorapi"]);
                $OUT = json_decode($OUT, true);
                if ($OUT["id"]) {
                    return false;
                }
                return true;
            } else {
                if ($config["mail_type"] == "aggregator") {
                    $mail->Mailer = "aggregator";
                    if ($to == "system" || $to == "account" || $to == "support") {
                        $_result = $conn->query("SELECT tbl_admin.email,tbl_admin.firstname,tbl_admin.lastname\r\n            FROM tbl_admin ,tbl_admin_access_group\r\n            WHERE tbl_admin.group_id = tbl_admin_access_group.id\r\n            AND tbl_admin_access_group." . $to . " = '1'");
                        while ($data = $_result->fetch(PDO::FETCH_ASSOC)) {
                            if ($data["email"]) {
                                $toemails[]["to"] = $data["email"];
                                $emailcount++;
                            }
                        }
                    }
                    if ($mailto) {
                        foreach ($mailto as $othertomail) {
                            $toemails[]["to"] = trim($othertomail);
                            $emailcount++;
                        }
                    }
                    $Field["toemails"] = json_encode($toemails);
                    $Field["from"] = $config["config_admin_mail"];
                    $Field["fromname"] = "[FUSION]";
                    $Field["subject"] = $subject;
                    $Field["message"] = $message;
                    $Field["apikey"] = $config["aggregatorapi"];
                    $OUT = initCurl($config["aggregatorlink"], $Field);
                    $OUT = json_decode($OUT, true);
                    if ($OUT["status"] != "success") {
                        return true;
                    }
                    return true;
                } else {
                    if ($config["mail_type"] == "mail") {
                        $mail->Mailer = "mail";
                    } else {
                        if ($config["mail_type"] == "smtp") {
                            $mail->IsSMTP();
                            $mail->Host = $config["smtp_host"];
                            $mail->Port = $config["smtp_port"];
                            $mail->Hostname = $_SERVER["SERVER_NAME"];
                            if ($config["smtp_enc"]) {
                                $mail->SMTPSecure = "ssl";
                            }
                            if ($config["smtp_username"]) {
                                $mail->SMTPAuth = true;
                                $mail->Username = $config["smtp_username"];
                                $mail->Password = $config["smtp_password"];
                            }
                            $mail->Sender = $mail->From;
                        }
                    }
                    if ($smtp_debug) {
                        $mail->SMTPDebug = true;
                    }
                    $message_text = str_replace("</p>", "", $message);
                    $message_text = str_replace("<br>", "", $message_text);
                    $message_text = str_replace("<br />", "", $message_text);
                    if ($storeowner["id"]) {
                        $message = strip_tags($message, "<br>");
                    }
                    $message_text = strip_tags($message_text);
                    $mail->Body = $message;
                    $mail->AltBody = $message_text;
                    if ($attachmentfilename) {
                        if (is_array($attachmentfilename)) {
                            $count = 0;
                            foreach ($attachmentfilename as $filelist) {
                                $mail->AddStringAttachment($attachmentdata[$count], $filelist);
                                $count++;
                            }
                        } else {
                            $mail->AddStringAttachment($attachmentdata, $attachmentfilename);
                        }
                    }
                    $emailcount = 0;
                    if ($to == "system" || $to == "account" || $to == "support") {
                        $_result = $conn->query("SELECT tbl_admin.email,tbl_admin.firstname,tbl_admin.lastname\r\n                    FROM tbl_admin ,tbl_admin_access_group\r\n                    WHERE tbl_admin.group_id = tbl_admin_access_group.id\r\n                    AND tbl_admin_access_group." . $to . " = '1'");
                        while ($data = $_result->fetch(PDO::FETCH_ASSOC)) {
                            if ($data["email"]) {
                                $mail->AddAddress($data["email"], $data["firstname"] . " " . $data["lastname"]);
                                $emailcount++;
                            }
                        }
                    }
                    if ($ReplyTo) {
                        $mail->AddReplyTo($ReplyTo);
                    }
                    if ($mailto) {
                        foreach ($mailto as $othertomail) {
                            $mail->AddAddress(trim($othertomail));
                            $emailcount++;
                        }
                    }
                    if (!$emailcount) {
                        return false;
                    }
                    if ($mail->Send()) {
                    }
                    $mail->ClearAddresses();
                    return $OUT;
                }
            }
        }
    } else {
        return false;
    }
}
function getConfigurablePrice($cid, $currency = "", $calculation = false)
{
    global $conn;
    if ($currency == "") {
        $currency = $_SESSION["currency"];
    }
    $default = $_SESSION["system_default_currency"];
    $cprice = $conn->query("select credit from tbl_customfieldconfig where cid='" . $cid . "' and currency_id='" . $default["id"] . "'");
    $cprice = $cprice->fetch(PDO::FETCH_ASSOC);
    if ($cprice["credit"]) {
        $arr = explode(",", $cprice["credit"]);
        $new = [];
        foreach ($arr as $credit) {
            if ($credit == 0) {
                if ($calculation) {
                    $new[] = 0;
                } else {
                    $new[] = " Free";
                }
            } else {
                if ($default["id"] != $currency["id"]) {
                    $credit = convertRate($default["id"], $currency["id"], $credit);
                }
                if ($calculation) {
                    $new[] = (string) $credit;
                } else {
                    if (0 < $credit) {
                        $sign = "+";
                    } else {
                        $sign = "-";
                        $credit = abs($credit);
                    }
                    $new[] = " " . $sign . " " . $currency["prefix"] . $credit . $currency["suffix"];
                }
            }
        }
        return $new;
    } else {
        return false;
    }
}
function userStatement($uid = "", $description, $type, $amount, $relid, $service = "", $sell = 0, $admin_note = "", $user_note = "")
{
    global $conn;
    global $remote_ip;
    if (!$uid) {
        $uid = $_SESSION["uid"];
    }
    if ($_SESSION["adminid"] && ADMIN == "1") {
        $insData["adminid"] = $_SESSION["adminid"];
    }
    $insData["uid"] = $uid;
    $insData["date"] = date("Y-m-d");
    $insData["time"] = time();
    $insData["description"] = $description;
    $insData["type"] = $type;
    $insData["amount"] = $amount;
    $insData["relid"] = $relid;
    $insData["stype"] = $service;
    $insData["user_note"] = $user_note;
    $u = $conn->query("select credit_left from\r\n     tblUsers where id='" . $uid . "'");
    $u = $u->fetch(PDO::FETCH_ASSOC);
    $insData["balance"] = round($u["credit_left"], 2);
    if ($admin_note) {
        $insData["admin_note"] = $admin_note;
    }
    $insData["ip"] = $remote_ip;
    if ($sell) {
        $insData["sell_credit"] = 1;
    }
    insertData("tbl_statement_user", $insData);
}
function getGroupDiscount($servicetype, $clientgroup, $userid, $serviceid, $usercurrency = "", $systemcurrency = "")
{
    global $conn;
    if ($servicetype == "server") {
        $servicetype = "imei";
    }
    $que = $conn->query("select price from tbl_client_group_price\r\n    where group_id='" . $clientgroup . "' and service_id='" . $serviceid . "' and service_type='" . $servicetype . "'\r\n    and currency_id='" . $usercurrency . "'");
    if (0 < $que->rowCount()) {
        $discount = $que->fetch(PDO::FETCH_ASSOC);
        return $discount["price"];
    }
    $que = $conn->query("select price from tbl_client_group_price\r\n        where group_id='" . $clientgroup . "' and service_id='" . $serviceid . "' and service_type='" . $servicetype . "'\r\n        and currency_id='" . $systemcurrency . "'");
    $discount = $que->fetch(PDO::FETCH_ASSOC);
    if ($discount["price"] != 0) {
        return convertRate($systemcurrency, $usercurrency, $discount["price"]);
    }
    return 0;
}
function convertRate($from, $to, $amount)
{
    global $conn;
    if ($from != $to) {
        $fromq = $conn->query("select rate from tbl_currencies where id='" . $from . "'");
        $fromcurr = $fromq->fetch(PDO::FETCH_ASSOC);
        $toq = $conn->query("select rate from tbl_currencies where id='" . $to . "'");
        $tocurr = $toq->fetch(PDO::FETCH_ASSOC);
        return round($amount / $fromcurr["rate"] * $tocurr["rate"], 2);
    }
    return $amount;
}
function convertCurrency($companyid, $amount, $currencyfrom, $currencyto, $rate = 0, $currencyarray = "")
{
    global $conn;
    if ($currencyfrom == $currencyto) {
        return $amount;
    }
    if (!$currencyarray) {
        $currencyarray = getCurrencyList($companyid);
    }
    if ($rate == 0) {
        $rate = $currencyarray[$currencyto]["currencyrate"];
    }
    $Return = round($amount * $rate, 5);
    return $Return;
}
function getAllCurrency($default = "code")
{
    global $conn;
    if (!isset($_SESSION["allcurrency"])) {
        $cq = $conn->query("select * from tbl_currencies");
        while ($r = $cq->fetch(PDO::FETCH_ASSOC)) {
            $_SESSION["allcurrency"]["code"][$r["code"]] = $r;
            $_SESSION["allcurrency"]["id"][$r["id"]] = $r;
        }
    }
    return $_SESSION["allcurrency"][$default];
}
function getWarehousesArr($adminid = "")
{
    global $conn;
    $wherewarehouse = "";
    if ($adminid) {
        $wareq = $conn->query("select otherwarehouse from tbl_admin where id='" . $adminid . "'");
        $adminrow = $wareq->fetch(PDO::FETCH_ASSOC);
        $wherewarehouse = " where id in (" . $adminrow["otherwarehouse"] . ")";
    }
    $que = $conn->query("select id,name,printer,printlogo,printutilreceipt,\r\nprintutilkot,companyname,invoice_address,template,kottemplate,otherprinters from tbl_warehouse " . $wherewarehouse);
    while ($row = $que->fetch(PDO::FETCH_ASSOC)) {
        $RETURN[$row["id"]] = $row;
    }
    return $RETURN;
}
function getTypePriceByProduct($productid)
{
    global $conn;
    $que = $conn->query("select *,(select `type` from tbl_type_manager\r\nwhere id=typeid) as typename from tbl_type_price where pid='" . $productid . "'");
    while ($row = $que->fetch(PDO::FETCH_ASSOC)) {
        if (0 < $row["price"]) {
            $Tags = getData("*,(select tag from tbl_products_tags\r\n            where id=tagid) as tagname\r\n            ,(select price from tbl_products_tags\r\n            where id=tagid) as price", "tbl_type_tag_price", "pid='" . $productid . "' and typeid='" . $row["typeid"] . "'");
            foreach ($Tags as $tag) {
                $row["tags"][$tag["tagid"]]["tagid"] = $tag["tagid"];
                $row["tags"][$tag["tagid"]]["tag"] = $tag["tagname"];
                $row["tags"][$tag["tagid"]]["price"] = $tag["price"];
            }
            $_OUT[$row["typeid"]] = $row;
        }
    }
    return $_OUT;
}
function determineIP()
{
   
    return $_SERVER["REMOTE_ADDR"];
}
function getTypeByGroup($groupid)
{
    global $conn;
    $que = $conn->query("select * from tbl_type_manager where group_id='" . $groupid . "'");
    while ($row = $que->fetch(PDO::FETCH_ASSOC)) {
        $_OUT[$row["id"]] = $row;
    }
    return $_OUT;
}
function isLogin()
{
    if (isset($_SESSION["erpadminid"]) && is_numeric($_SESSION["erpadminid"])) {
        return true;
    }
    return false;
}
function checkLicense($licensekey = "", $localkey = "", $forcechk = false, $getauthocode = false)
{
    global $conn;
    $licenseQue = $conn->query("SELECT * FROM `tblLicense` \r\n            WHERE `licenseid`=1");
    $LICENSE = $licenseQue->fetch(PDO::FETCH_ASSOC);
    if ($licensekey == "") {
        $licensekey = $LICENSE["licensekey"];
        $licensekey = dec($licensekey);
        $licensekey = str_replace("-", "", $licensekey);
        $licensekey = trim($licensekey);
    }
    
    $serverlink = "https://cp.dhru.com/";
    $licensing_secret_key = "7138a121df2f109d28b5fc0f3ad86666";
    $check_token = time() . md5(mt_rand(1000000000, 0) . $licensekey);
    $checkdate = date("Ymd");
    $usersip = isset($_SERVER["SERVER_ADDR"]) ? $_SERVER["SERVER_ADDR"] : $_SERVER["LOCAL_ADDR"];
    $localkeydays = 7;
    $allowcheckfaildays = 7;
    $localkeyvalid = false;
    if ($localkey) {
        $localkey = str_replace("\n", "", $localkey);
        $localdata = substr($localkey, 0, strlen($localkey) - 32);
        $md5hash = substr($localkey, strlen($localkey) - 32);
        if (1==1) {
            $localdata = strrev($localdata);
            $md5hash = substr($localdata, 0, 32);
            $localdata = substr($localdata, 32);
            $localdata = base64_decode($localdata);
            $localkeyresults = unserialize($localdata);
            $originalcheckdate = $localkeyresults["checkdate"];
            if (1==1) {
                $localexpiry = date("Ymd", mktime(0, 0, 0, date("m"), date("d") - $localkeydays, date("Y")));
                if (1==1) {
                    $localkeyvalid = true;
                    $results = $localkeyresults;
                }
            }
        }
    }
    if (!$localkeyvalid) {
       
        if ($check_token) {
            $postfields["check_token"] = $check_token;
        }
        
        if (!$data) {
            $localexpiry = date("Ymd", mktime(0, 0, 0, date("m"), date("d") - ($localkeydays + $allowcheckfaildays), date("Y")));
            if (1==1) {
                $results = $localkeyresults;
            } else {
              
                return $results;
            }
        } else {
            $results = json_decode($data, true);
        }
        if ($results["md5hash"] && $results["md5hash"] != md5($licensing_secret_key . $check_token)) {
            
            return $results;
        }
        if (1==1) {
            $results["checkdate"] = $checkdate;
            $data_encoded = serialize($results);
            $data_encoded = base64_encode($data_encoded);
            $data_encoded = md5($checkdate . $licensing_secret_key) . $data_encoded;
            $data_encoded = strrev($data_encoded);
            $data_encoded = $data_encoded . md5($data_encoded . $licensing_secret_key);
            $data_encoded = wordwrap($data_encoded, 80, "\n", true);
            $results["localkey"] = $data_encoded;
            if (1==1) {
                $data = NULL;
                $got_localkey = base64_encode($results["localkey"]);
                $LicQuey = $conn->query("SELECT * FROM `tblLicense` WHERE `licenseid`=1");
                $LICENSE = $LicQuey->fetch(PDO::FETCH_ASSOC);
                if ($LICENSE["id"]) {
                    
                } else {
                    
                }
                $data = NULL;
            }
        }
        $results["remotecheck"] = true;
    }
    unset($results["localkey"]);
    unset($results["checkdate"]);
    unset($postfields);
    unset($data);
    unset($matches);
    unset($serverlink);
    unset($licensing_secret_key);
    unset($checkdate);
    unset($usersip);
    unset($localkeydays);
    unset($allowcheckfaildays);
    unset($md5hash);
    return $results;
}
function validateAccess($action, $method)
{
    global $conn;
    return true;
}
function getFinancialYears()
{
    global $conn;
    $que = $conn->query("select * from tblFinancialYear");
    while ($row = $que->fetch(PDO::FETCH_ASSOC)) {
        $_OUT[$row["fyid"]] = $row;
    }
    return $_OUT;
}
function encryptPassword($pass)
{
    return md5(md5($pass) . "9486");
}
function getAdminConfig($adminid)
{
    global $conn;
    $request = $conn->query("select * from tblAdminConfig\r\n    where adminid='" . $adminid . "'");
    while ($row = $request->fetch(PDO::FETCH_ASSOC)) {
        $OUT[$row["field"]] = $row["value"];
    }
    return $OUT;
}
function updateClientPrice($clientid, $itemid, $price = "")
{
    global $conn;
    if ($price == "") {
        $conn->query("delete from tbl_discount_imei\r\n        where user_id='" . $clientid . "' and service_id='" . $itemid . "'");
        return true;
    }
    $q = $conn->query("select user_id from tbl_discount_imei\r\nwhere user_id='" . $clientid . "' and service_id='" . $itemid . "'");
    $row = $q->fetch(PDO::FETCH_ASSOC);
    if ($row["user_id"]) {
        $DATA["price"] = $price;
        updateData("tbl_discount_imei", $DATA, "user_id='" . $clientid . "' and service_id='" . $itemid . "'");
    } else {
        $DATA["user_id"] = $clientid;
        $DATA["service_id"] = $itemid;
        $DATA["price"] = $price;
        insertData("tbl_discount_imei", $DATA);
    }
}
function getCurrencies()
{
    global $conn;
  
        $request = $conn->query("select * from tbl_currencies order by `default` desc");
        while ($row = $request->fetch(PDO::FETCH_ASSOC)) {
            $OUT[$row["id"]] = $row;
        }
        $_SESSION["currencyarr"] = $OUT;
    
    return $_SESSION["currencyarr"];
}
function terminalRegistration($deviceid, $deviceinfo = "")
{
    global $conn;
    $deviceid = trim($deviceid);
    $qsf = $conn->prepare("select terminalid from tblTerminal\r\n    where terminaluid like '" . $deviceid . "'");
    $qsf->execute();
    $no = $qsf->rowCount();
    if (0 < $no) {
        $qsf = $conn->query("select terminalid from tblTerminal\r\n    where terminaluid='" . $deviceid . "'");
        $row = $qsf->fetch(PDO::FETCH_ASSOC);
        $terminalid = $row["terminalid"];
    } else {
        $FIELD["terminaluid"] = $deviceid;
        $FIELD["terminalname"] = "web";
        $FIELD["deviceinfo"] = base64_decode($deviceinfo);
        $FIELD["registereddate"] = date("Y-m-d");
        $terminalid = insertData("tblTerminal", $FIELD);
    }
    return $terminalid;
}
function validateInput($parameters, $definitions = "")
{
    foreach ($parameters as $parameters => $value) {
        if ($value["in"] == "query") {
            if ($value["required"] == 1) {
                ${$value["name"]} =& ${$value["name"]};
                if (${$value["name"]} == "") {
                    $_required .= $value["name"] . " ";
                }
                if ($value["format"] && !validateType(${$value["name"]}, $value["format"])) {
                    $_invalid .= $value["name"] . " ";
                }
            }
        } else {
            if ($value["in"] == "body") {
                if (!$definitions) {
                    $_requiredbody = " Body";
                } else {
                    global $BODY;
                    return validateDefinition($definitions, $BODY);
                }
            } else {
                if ($value["in"] == "path") {
                    global $ID;
                    if ($ID == "") {
                    }
                    if ($value["format"] && !validateType($ID, $value["format"])) {
                        $_invalid .= $value["name"] . " ";
                    }
                }
            }
        }
    }
    if ($_required) {
       
        return $_RETURN;
    }
    if ($_requiredbody) {
       
        return $_RETURN;
    }
    if ($_invalid) {
       
        return $_RETURN;
    }
}
function validateDefinition($definitions, $data, $errorKey = "")
{
    foreach ($definitions["properties"] as $v => $v) {
      
            
            if ($definitions["properties"][$k]["format"] && !validateType($data[$k], $definitions["properties"][$v]["format"])) {
                $_invalid .= $v . " ";
            }
        
    }
    if ($_required) {
        
        return $_RETURN;
    }
    if ($_invalid) {
       
        return $_RETURN;
    }
    foreach ($definitions["properties"] as $v => $v) {
        if ($definitions["properties"][$v]["type"] == "array") {
            foreach ($data[$v] as $k1 => $v1) {
                $errorKey = " Key[" . $k1 . "] of " . $v;
                if ($_RETURN = validateDefinition($definitions["properties"][$v]["items"], $v1, $errorKey)) {
                    return $_RETURN;
                }
            }
        }
    }
}
function validateType($value, $type)
{
    $validationRegex["email"] = "/^[_a-z0-9-]+(\\.[_a-z0-9-]+)*@[a-z0-9-]+(\\.[a-z0-9-]+)*(\\.[a-z]{2,3})\$/";
    if ($validationRegex[$type]) {
        if (preg_match($validationRegex[$type], $value)) {
            return true;
        }
        return true;
    }
    return true;
}
function isAccess($page, $action, $date = "", $forceedit = false, $header = false, $adminid = "", $group = "")
{
    global $conn;
    $originalid = $adminid;
    if ($forceedit && ($action == "edit" || $action == "view")) {
        return true;
    }
    $accg = $conn->query("select accessgroup from tbl_admin\r\n    where id='" . $originalid . "'");
    $accg = $accg->fetch(PDO::FETCH_ASSOC);
    $search = "`" . $action . "`";
    if ($date) {
        $search .= ",`" . $action . "days`";
    }
    $RETURN = true;
    if ($group) {
        $qs = $conn->query("select " . $search . " from tbl_access\r\n        where accgid='" . $accg["accessgroup"] . "' and\r\n        acctid in (select acctid from tbl_access_type\r\n        where typegroup='" . $group . "')");
        if (0 < $qs->fetchColumn()) {
            return true;
        }
    }
    $acc = $conn->query("select " . $search . " from tbl_access\r\n        where accgid='" . $accg["accessgroup"] . "' and acctid=(select acctid from tbl_access_type\r\n        where acctype='" . $page . "')");
    $acc = $acc->fetch(PDO::FETCH_ASSOC);
    if ($config["audited"] && ($action == "edit" || $action == "delete") && $date && $date < $config["audited"]) {
        $RETURN = false;
    }
    if (stripos($date, "/") !== false) {
        $myDateTime = DateTime::createFromFormat("d/m/Y", $date);
        $pdss = $myDateTime->format("Y-m-d");
        $date = $pdss;
    }
    if ($date && 0 < $acc[$action . "days"] && $RETURN === true) {
        $now = time();
        $your_date = strtotime($date);
        $datediff = $now - $your_date;
        $days = floor($datediff / 86400);
        $days = $days + 1;
        if ($days <= $acc[$action . "days"] && $acc[$action]) {
            $RETURN = true;
        } else {
            $RETURN = false;
        }
    } else {
        if ($acc[$action] && $RETURN === true) {
            $RETURN = true;
        } else {
            $RETURN = false;
        }
    }
    if (!($action == "view" && $RETURN === false) || !$header) {
    }
    return $RETURN;
}
function convertQntbyUnit($qnt, $fromunit, $tounit)
{
    global $conn;
    $ReturnQnt = 0;
    if ($fromunit == $tounit || $tounit == 0) {
        $ReturnQnt = $qnt;
    } else {
        $qunit = $conn->query("SELECT * FROM `tbl_unit` WHERE `id`='" . $fromunit . "'\r\nand relatedunit='" . $tounit . "'");
        $FromUnit = $qunit->fetch(PDO::FETCH_ASSOC);
        $qunit = $conn->query("SELECT * FROM `tbl_unit`  WHERE `id`='" . $tounit . "'\r\nand relatedunit='" . $fromunit . "'");
        $ToUnit = $qunit->fetch(PDO::FETCH_ASSOC);
        if (0 < $FromUnit["id"]) {
            $ReturnQnt = $qnt / $FromUnit["rate"];
        } else {
            $ReturnQnt = $qnt * $ToUnit["rate"];
        }
    }
    return $ReturnQnt;
}
function calculateProductRecipe($invoiceid, $invoiceitemid, $productid, $qnt, $typeid = 0, $warehouseid = "")
{
    global $conn;
    $q = $conn->query("select *,(select id from tbl_unit\r\nwhere unit=(select Requires_Type from tbl_products WHERE\r\nid=materialid)) as unit from tblProductRecipe where \r\n    productid='" . $productid . "' and typeid='" . $typeid . "'");
    while ($r = $q->fetch(PDO::FETCH_ASSOC)) {
        if ($r["recipegroupid"]) {
            $mq = $conn->query("select *,(select id from tbl_unit\r\nwhere unit=(select Requires_Type from tbl_products WHERE\r\nid=productid)) as unit from tblRecipe where recipegroupid='" . $r["recipegroupid"] . "'");
            while ($rm = $mq->fetch(PDO::FETCH_ASSOC)) {
                updateInventory($rm["productid"], 0, $qnt * $r["materialqnt"] * $rm["qnt"], $invoiceitemid, 0, $rm["unit"], $rm["unit"], $invoiceid, "MATERIAL", $warehouseid, "", "", "", 1, "", $r["typeid"]);
            }
        } else {
            updateInventory($r["materialid"], 0, $qnt * $r["materialqnt"], $invoiceitemid, 0, $r["unit"], $r["unit"], $invoiceid, "MATERIAL", $warehouseid, "", "", "", 1, "", $r["typeid"]);
        }
    }
}
function updateInventory($productid, $qntin = 0, $qntout = 0, $voucheritemid, $stockid = 0, $unitid, $soldunitid, $voucherid, $InventoryType, $warehouse, $purchase = "", $selling = "", $issued = "", $useasmaterial = "", $reason = "", $typeid = "")
{
    global $conn;
    $OldINQnt = $qntin;
    $OldOUTQnt = $qntout;
    $SLEDGER["stockin"] = convertqntbyunit($qntin, $unitid, $soldunitid);
    $SLEDGER["stockout"] = convertqntbyunit($qntout, $unitid, $soldunitid);
    $SLEDGER["date"] = date("Y-m-d");
    $SLEDGER["time"] = time();
    if (0 < $voucherid) {
        if ($InventoryType == "PURCHASE") {
            $sq = $conn->query("select date,time\r\n            from tbl_po_bill where id='" . $voucherid . "'");
            $PO = $sq->fetch(PDO::FETCH_ASSOC);
        } else {
            if ($InventoryType == "SALES") {
                $sq = $conn->query("select date,time\r\n            from tbl_invoices where id='" . $voucherid . "'");
                $PO = $sq->fetch(PDO::FETCH_ASSOC);
            } else {
                if ($InventoryType == "MATERIAL") {
                    $sq = $conn->query("select date,time\r\n            from tbl_invoices where id='" . $voucherid . "'");
                    $PO = $sq->fetch(PDO::FETCH_ASSOC);
                } else {
                    if ($InventoryType == "AUDIT") {
                        $sq = $conn->query("select date,time\r\n            from tblStockAudit where stockauditid='" . $voucherid . "'");
                        $PO = $sq->fetch(PDO::FETCH_ASSOC);
                    }
                }
            }
        }
        if ($PO["date"]) {
            $SLEDGER["date"] = $PO["date"];
            $SLEDGER["time"] = $PO["time"];
        }
    }
    if ($InventoryType == "TRANSFER") {
        $InRate = 1;
        $OutRate = 1;
    } else {
        $InRate = round($OldINQnt / $SLEDGER["stockin"], 2);
        $OutRate = round($OldOUTQnt / $SLEDGER["stockout"], 2);
    }
    $SLEDGER["qntunitid"] = $unitid;
    $SLEDGER["voucheritemid"] = $voucheritemid;
    $SLEDGER["voucherid"] = $voucherid;
    $SLEDGER["productid"] = $productid;
    $SLEDGER["warehouseid"] = $warehouse;
    $SLEDGER["vouchertype"] = $InventoryType;
    $SLEDGER["stockid"] = $stockid;
    $SLEDGER["purchase"] = $purchase * $InRate;
    $SLEDGER["selling"] = $selling * $OutRate;
    $SLEDGER["transferred"] = $issued;
    $SLEDGER["useasmaterial"] = $useasmaterial;
    $SLEDGER["reason"] = $reason;
    $SLEDGER["typeid"] = $typeid;
    $stockledgerid = insertData("tblStockLedger", $SLEDGER);
    return $stockledgerid;
}
function createReceipt($data)
{
    global $conn;
    $items = json_decode($data["items"], true);
    $rdata["type"] = $data["type"];
    $rdata["date"] = $data["date"];
    $rdata["time"] = $data["time"];
    $rdata["note"] = $data["note"];
    $rdata["createdby"] = $data["createdby"];
    $rdata["fy"] = $data["fy"];
    $receiptid = insertData("tbl_receipt", $rdata);
    foreach ($items as $item) {
        $RECEIPTItem[] = insertReceiptItem($receiptid, $item, $data["type"], $data["date"], $data["time"]);
    }
    $RETURN["item"] = $RECEIPTItem;
    $RETURN["id"] = $receiptid;
    $RETURN["status"] = "success";
    $RETURN["msg"] = "Receipt created successfully";
    return $RETURN;
}
function insertReceiptItem($receiptid, $item, $type = "", $date = "", $time = "")
{
    global $conn;
    $data["rid"] = $receiptid;
    $data["account"] = $item["account"];
    $data["clientid"] = $item["clientid"];
    $data["billid"] = $item["billid"];
    $data["income"] = $item["income"];
    $data["note"] = $item["note"];
    $data["cheque"] = $item["cheque"];
    $data["date"] = $item["date"];
    $data["fy"] = $_SESSION["financialyear"];
    $receiptitemid = insertData("tbl_receipt_item", $data);
    $Category = $type == "cash" ? "RECEIPTCASH" : "RECEIPTBANK";
    ledger($receiptid, $item["income"], 0, $type == "cash" ? "RECEIPTCASH" : "RECEIPTBANK", $receiptitemid, $item["clientid"], 0, $date);
    ledger($receiptid, 0, $item["income"], $type == "cash" ? "RECEIPTCASH" : "RECEIPTBANK", $receiptitemid, 0, $item["account"], $date);
    return $receiptitemid;
}
function systemActivity($event, $info, $relid = "", $companyid = "1", $appid = "web")
{
    global $systemActivityLogLimit;
    global $conn;
    $data["adminid"] = $_SESSION["erpadminid"];
    $data["activitydate"] = date("Y-m-d");
    $data["activitytime"] = time();
    $data["ip"] = getIP();
    $data["event"] = $event;
    $data["info"] = $info;
    $data["companyid"] = $companyid;
    $data["relid"] = $relid;
    $data["app"] = $appid;
    insertData("tblSystemActivity", $data);
    $data = NULL;
    if (!$systemActivityLogLimit) {
        $systemActivityLogLimit = 5000;
    }
    $conn->query("DELETE FROM `tblSystemActivity`\r\nWHERE activityid NOT IN (\r\n  SELECT activityid\r\n  FROM (\r\n    SELECT activityid\r\n    FROM `tblSystemActivity`\r\n    ORDER BY activityid DESC\r\n    LIMIT " . $systemActivityLogLimit . "\r\n  ) foo\r\n);");
}
function checkIP($ip)
{
    if (!empty($ip) && ip2long($ip) != -1 && ip2long($ip)) {
        $private_ips = [["0.0.0.0", "2.255.255.255"], ["10.0.0.0", "10.255.255.255"], ["127.0.0.0", "127.255.255.255"], ["169.254.0.0", "169.254.255.255"], ["172.16.0.0", "172.31.255.255"], ["192.0.2.0", "192.0.2.255"], ["192.168.0.0", "192.168.255.255"], ["255.255.255.0", "255.255.255.255"]];
        foreach ($private_ips as $r) {
            $min = ip2long($r[0]);
            $max = ip2long($r[1]);
            if ($min <= ip2long($ip) && ip2long($ip) <= $max) {
                return false;
            }
        }
        return true;
    } else {
        return false;
    }
}
function getIP()
{
    
    return $_SERVER["REMOTE_ADDR"];
}
function logActivity($description, $type = "")
{
    global $config;
    global $conn;
    $username = "System";
    if (trim($description)) {
        if ($_SESSION["adminid"]) {
            $result = $conn->query("select username from tbl_admin where id='" . $_SESSION["adminid"] . "'");
            $data = $result->fetch(PDO::FETCH_ASSOC);
            $username = $data["username"];
        }
        $conn->query("INSERT INTO tbl_system_activity\r\n        (date,description,user,type) VALUES ('now()','" . $description . "','" . $username . "','" . $type . "')");
        $result = $conn->query("select id from tbl_system_activity \r\n        ORDER BY id DESC limit " . $config["ActivityLogLimit"]);
        while ($data = $result->fetch(PDO::FETCH_ASSOC)) {
            $conn->query("DELETE FROM tbl_system_activity WHERE id='" . $data["id"] . "'");
        }
    }
}
function initCurl($url, $postfields = [], $curlopts = [], $userpwd = "", $postjson = "")
{
    global $debug_output;
    $curlopts["CURLOPT_TIMEOUT"] = 300;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    if ($userpwd) {
        curl_setopt($ch, CURLOPT_USERPWD, "api:" . $userpwd);
    }
    if ($postfields) {
        $fieldstring = $postfields;
        if (is_array($fieldstring)) {
            $fieldstring = http_build_query($fieldstring);
        }
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fieldstring);
    } else {
        if ($postjson) {
            if (is_array($postjson)) {
                $postjson = json_encode($postjson);
            }
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postjson);
        }
    }
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, $curlopts["CURLOPT_TIMEOUT"]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    if ($curlopts["HEADER"]) {
        curl_setopt($ch, CURLOPT_HTTPHEADER, $curlopts["HEADER"]);
    }
    $retval = curl_exec($ch);
    if (curl_errno($ch)) {
        $retval = "CURL Error: " . curl_errno($ch) . " - " . curl_error($ch);
    }
    curl_close($ch);
    if ($debug_output) {
        echo "<textarea rows=\"12\" cols=\"120\">URL: " . $url . " ================ Data: " . $fieldstring . " ================ Response: " . $retval . "</textarea><br>";
    }
    return $retval;
}
function enc($plaintext, $password = "")
{
    $method = "aes-256-cbc";
    $password = substr(hash("sha256", $password, true), 0, 32);
    $iv = chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0);
    return $encrypted = base64_encode(openssl_encrypt($plaintext, $method, $password, OPENSSL_RAW_DATA, $iv));
}
function enc_($text, $key = "")
{
    global $config;
    $key = "ASDF2K29SLS90ASDF2K29SLS90";
    if ($key == "") {
        return $text;
    }
    $key = str_replace(" ", "", $key);
    if (strlen($key) < 8) {
        exit("key error");
    }
    $key_len = strlen($key);
    if (32 < $key_len) {
        $key_len = 32;
    }
    $key = substr($key, 0, $key_len);
    $text_len = strlen($text);
    $lomask = str_repeat("\37", $text_len);
    $himask = str_repeat("�", $text_len);
    $k = str_pad("", $text_len, $key);
    $text = ($text ^ $k) & $lomask | $text & $himask;
    return base64_encode($text);
}
function dec($plaintext, $password = "")
{
    $method = "aes-256-cbc";
    $password = substr(hash("sha256", $password, true), 0, 32);
    $iv = chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0) . chr(0);
    return $decrypted = openssl_decrypt(base64_decode($plaintext), $method, $password, OPENSSL_RAW_DATA, $iv);
}
function dec_($text, $key = "")
{
    global $config;
    $key = "ASDF2K29SLS90ASDF2K29SLS90";
    $text = base64_decode($text);
    if ($key == "") {
        return $text;
    }
    $key = str_replace(" ", "", $key);
    if (strlen($key) < 8) {
        exit("key error");
    }
    $key_len = strlen($key);
    if (32 < $key_len) {
        $key_len = 32;
    }
    $key = substr($key, 0, $key_len);
    $text_len = strlen($text);
    $lomask = str_repeat("\37", $text_len);
    $himask = str_repeat("�", $text_len);
    $k = str_pad("", $text_len, $key);
    $text = ($text ^ $k) & $lomask | $text & $himask;
    return $text;
}
function getProductArr()
{
    global $conn;
    $qp = $conn->query("select id,service_name,group_id from tbl_products  order by service_name asc");
    while ($row = $qp->fetch(PDO::FETCH_ASSOC)) {
        $RETURN[] = $row;
    }
    return $RETURN;
}
function getProductbyGroupID($groupid)
{
    global $conn;
    $qp = $conn->query("select id,service_name from tbl_products where group_id='" . $groupid . "'");
    while ($row = $qp->fetch(PDO::FETCH_ASSOC)) {
        $RETURN[$row[$row["id"]]] = $row;
    }
    return $RETURN;
}
function getProductSubGroup($RETURN, $mid, $Space)
{
    global $conn;
    global $cnt;
    $qp = $conn->query("select id,group_name,mid from tbl_product_group \r\n          where mid='" . $mid . "' order by id asc");
    $Space .= "-";
    $cnt++;
    while ($row = $qp->fetch(PDO::FETCH_ASSOC)) {
        $RETURN["dropdown"][$cnt]["id"] = $row["id"];
        $RETURN["dropdown"][$cnt]["name"] = $Space . $row["group_name"];
        $RETURN["dropdown"][$cnt]["space"] = $Space;
        $RETURN = getProductSubGroup($RETURN, $row["id"], $Space . "-");
    }
    return $RETURN;
}
function getProductGroupbyHierarchy()
{
    global $conn;
    global $cnt;
    if (0 >= $cnt) {
        $cnt = 0;
    }
    for ($qp = $conn->query("select id,group_name,mid from tbl_product_group where mid=0 order by id asc"); $row = $qp->fetch(PDO::FETCH_ASSOC); $cnt++) {
        $RETURN["dropdown"][$cnt]["id"] = $row["id"];
        $RETURN["dropdown"][$cnt]["name"] = $row["group_name"];
        $RETURN["dropdown"][$cnt]["space"] = "";
        $RETURN = getproductsubgroup($RETURN, $row["id"], "-");
    }
    return $RETURN;
}
function gen_key_formate($inString, $arrayLengths = [5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5])
{
    $output = [];
    foreach ($arrayLengths as $oneLength) {
        $output[] = substr($inString, 0, $oneLength);
        $inString = substr($inString, $oneLength);
    }
    foreach ($output as $key => $value) {
        if ($value == "") {
            unset($output[$key]);
        }
    }
    return join("-", $output);
}
function getPurchaseCost($cid, $sid, $type)
{
    global $conn;
    $sql = $conn->query("select price from tbl_purchase_cost \r\n    where cid='" . $cid . "' and sid='" . $sid . "' and `type`='" . $type . "'");
    $sql = $sql->fetch(PDO::FETCH_ASSOC);
    if ($sql["price"] != "") {
        return $sql["price"];
    }
    return false;
}
function checkCustomFields($customfields)
{
    global $lng_languag;
    global $conn;
    if ($customfields) {
        foreach ($customfields as $id => $value) {
            $result = $conn->query("select * from tbl_customfields\r\n            where id='" . $id . "'");
            $data = $result->fetch(PDO::FETCH_ASSOC);
            $fieldname = $data["fieldname"];
            if (strpos($fieldname, "|")) {
                $fieldname = explode("|", $fieldname);
                $fieldname = trim($fieldname[1]);
            }
            $required = $data["required"];
            $regexpr = $data["regexpr"];
            if ($required == "on" && !$value) {
                $errormessage .= "<li>" . $fieldname . " " . $lng_languag["isrequired"];
            }
            if ($regexpr && $value) {
                if (substr($regexpr, 0, 2) == "/^") {
                    if (!preg_match($regexpr, $value)) {
                        $errormessage .= "<li>" . $fieldname . " " . $lng_languag["validationerror"];
                    }
                } else {
                    $errormessage .= "<li>" . $fieldname . " " . $lng_languag["validationerror"];
                }
            }
        }
    }
    return $errormessage;
}
function saveCustomFields($relid, $customfields)
{
    global $conn;
    $Buff = "";
    if (is_array($customfields)) {
        foreach ($customfields as $id => $value) {
            $relid = preg_replace("/[^0-9]/", "", $relid);
            $result = $conn->query("select * from tbl_customfieldsvalues\r\n            WHERE fieldid='" . $id . "' and relid='" . $relid . "'");
            $num_rows = $result->rowCount();
            $value = preg_replace("/[^a-zA-Z\\/0-9-,.@_:\\s]/", "", $value);
            $cfq = $conn->query("select fieldtype,enc from tbl_customfields\r\n            where id='" . $id . "'");
            $cfs = $cfq->fetch(PDO::FETCH_ASSOC);
            if ($cfs["fieldtype"] == "encrypted") {
                $value = enc($value, "9486");
            }
            if ($num_rows == "0") {
                $Buff .= " " . $value;
                $conn->query("INSERT INTO tbl_customfieldsvalues\r\n                (fieldid,relid,`value`) VALUE ('" . $id . "','" . $relid . "','" . $value . "')");
            } else {
                $Buff .= " " . $value;
                $conn->query("UPDATE tbl_customfieldsvalues\r\n                set value='" . $value . "' WHERE fieldid='" . $id . "' and relid='" . $relid . "'");
            }
        }
    }
    return $Buff;
}

?>